/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.impl.AssociationDefinitionModelImpl;
import systems.dmx.core.impl.AssociationModelImpl;
import systems.dmx.core.impl.AssociationRoleModelImpl;
import systems.dmx.core.impl.AssociationTypeModelImpl;
import systems.dmx.core.impl.ChildTopicsModelImpl;
import systems.dmx.core.impl.DMXObjectModelImpl;
import systems.dmx.core.impl.FacetValueModelImpl;
import systems.dmx.core.impl.PersistenceLayer;
import systems.dmx.core.impl.RelatedAssociationModelImpl;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.impl.RoleModelImpl;
import systems.dmx.core.impl.TopicDeletionModelImpl;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.impl.TopicReferenceModelImpl;
import systems.dmx.core.impl.TopicRoleModelImpl;
import systems.dmx.core.impl.TopicTypeModelImpl;
import systems.dmx.core.impl.TypeModelImpl;
import systems.dmx.core.impl.ViewAssocImpl;
import systems.dmx.core.impl.ViewConfigurationModelImpl;
import systems.dmx.core.impl.ViewPropertiesImpl;
import systems.dmx.core.impl.ViewTopicImpl;
import systems.dmx.core.model.AssociationDefinitionModel;
import systems.dmx.core.model.AssociationModel;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.RelatedTopicModel;
import systems.dmx.core.model.RoleModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicDeletionModel;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.model.TopicReferenceModel;
import systems.dmx.core.model.TopicRoleModel;
import systems.dmx.core.model.ViewConfigurationModel;
import systems.dmx.core.model.facets.FacetValueModel;
import systems.dmx.core.model.topicmaps.ViewAssoc;
import systems.dmx.core.model.topicmaps.ViewProperties;
import systems.dmx.core.model.topicmaps.ViewTopic;
import systems.dmx.core.service.ModelFactory;

public class ModelFactoryImpl
implements ModelFactory {
    private static final String TYPE_COMP_DEF = "dmx.core.composition_def";
    private static final String REF_ID_PREFIX = "ref_id:";
    private static final String REF_URI_PREFIX = "ref_uri:";
    private static final String DEL_ID_PREFIX = "del_id:";
    private static final String DEL_URI_PREFIX = "del_uri:";
    PersistenceLayer pl;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    public TopicModelImpl newTopicModel(long id, String uri, String typeUri, SimpleValue value, ChildTopicsModel childTopics) {
        return new TopicModelImpl(this.newDMXObjectModel(id, uri, typeUri, value, childTopics));
    }

    @Override
    public TopicModelImpl newTopicModel(ChildTopicsModel childTopics) {
        return this.newTopicModel(-1L, null, null, null, childTopics);
    }

    @Override
    public TopicModelImpl newTopicModel(String typeUri) {
        return this.newTopicModel(-1L, null, typeUri, null, null);
    }

    @Override
    public TopicModelImpl newTopicModel(String typeUri, SimpleValue value) {
        return this.newTopicModel(-1L, null, typeUri, value, null);
    }

    @Override
    public TopicModelImpl newTopicModel(String typeUri, ChildTopicsModel childTopics) {
        return this.newTopicModel(-1L, null, typeUri, null, childTopics);
    }

    @Override
    public TopicModelImpl newTopicModel(String uri, String typeUri) {
        return this.newTopicModel(-1L, uri, typeUri, null, null);
    }

    @Override
    public TopicModelImpl newTopicModel(String uri, String typeUri, SimpleValue value) {
        return this.newTopicModel(-1L, uri, typeUri, value, null);
    }

    @Override
    public TopicModelImpl newTopicModel(String uri, String typeUri, ChildTopicsModel childTopics) {
        return this.newTopicModel(-1L, uri, typeUri, null, childTopics);
    }

    @Override
    public TopicModelImpl newTopicModel(long id) {
        return this.newTopicModel(id, null, null, null, null);
    }

    @Override
    public TopicModelImpl newTopicModel(long id, ChildTopicsModel childTopics) {
        return this.newTopicModel(id, null, null, null, childTopics);
    }

    @Override
    public TopicModelImpl newTopicModel(TopicModel topic) {
        return new TopicModelImpl((TopicModelImpl)topic);
    }

    @Override
    public TopicModelImpl newTopicModel(JSONObject topic) {
        try {
            return new TopicModelImpl(this.newDMXObjectModel(topic));
        }
        catch (Exception e) {
            throw this.parsingFailed(topic, e, "TopicModelImpl");
        }
    }

    @Override
    public AssociationModelImpl newAssociationModel(long id, String uri, String typeUri, RoleModel roleModel1, RoleModel roleModel2, SimpleValue value, ChildTopicsModel childTopics) {
        return new AssociationModelImpl(this.newDMXObjectModel(id, uri, typeUri, value, childTopics), (RoleModelImpl)roleModel1, (RoleModelImpl)roleModel2);
    }

    @Override
    public AssociationModelImpl newAssociationModel(String typeUri, RoleModel roleModel1, RoleModel roleModel2) {
        return this.newAssociationModel(-1L, null, typeUri, roleModel1, roleModel2, null, null);
    }

    @Override
    public AssociationModelImpl newAssociationModel(String typeUri, RoleModel roleModel1, RoleModel roleModel2, ChildTopicsModel childTopics) {
        return this.newAssociationModel(-1L, null, typeUri, roleModel1, roleModel2, null, childTopics);
    }

    @Override
    public AssociationModelImpl newAssociationModel() {
        return this.newAssociationModel(-1L, null, null, null, null, null, null);
    }

    @Override
    public AssociationModelImpl newAssociationModel(ChildTopicsModel childTopics) {
        return this.newAssociationModel(null, childTopics);
    }

    @Override
    public AssociationModelImpl newAssociationModel(String typeUri, ChildTopicsModel childTopics) {
        return this.newAssociationModel(typeUri, null, null, childTopics);
    }

    @Override
    public AssociationModelImpl newAssociationModel(long id, String uri, String typeUri, RoleModel roleModel1, RoleModel roleModel2) {
        return this.newAssociationModel(id, uri, typeUri, roleModel1, roleModel2, null, null);
    }

    @Override
    public AssociationModelImpl newAssociationModel(AssociationModel assoc) {
        return new AssociationModelImpl((AssociationModelImpl)assoc);
    }

    @Override
    public AssociationModelImpl newAssociationModel(JSONObject assoc) {
        try {
            return new AssociationModelImpl(this.newDMXObjectModel(assoc), this.parseRole1(assoc), this.parseRole2(assoc));
        }
        catch (Exception e) {
            throw this.parsingFailed(assoc, e, "AssociationModelImpl");
        }
    }

    private RoleModelImpl parseRole1(JSONObject assoc) throws JSONException {
        return this.parseRole(assoc, "role1");
    }

    private RoleModelImpl parseRole2(JSONObject assoc) throws JSONException {
        return this.parseRole(assoc, "role2");
    }

    private RoleModelImpl parseRole(JSONObject assoc, String key) throws JSONException {
        return assoc.has(key) ? this._parseRole(assoc.getJSONObject(key)) : null;
    }

    private RoleModelImpl _parseRole(JSONObject roleModel) {
        if (roleModel.has("topicId") || roleModel.has("topicUri")) {
            return this.newTopicRoleModel(roleModel);
        }
        if (roleModel.has("assocId")) {
            return this.newAssociationRoleModel(roleModel);
        }
        throw new RuntimeException("One of \"topicId\"/\"topicUri\"/\"assocId\" is expected");
    }

    DMXObjectModelImpl newDMXObjectModel(long id, String uri, String typeUri, SimpleValue value, ChildTopicsModel childTopics) {
        return new DMXObjectModelImpl(id, uri, typeUri, value, (ChildTopicsModelImpl)childTopics, this.pl());
    }

    DMXObjectModelImpl newDMXObjectModel(JSONObject object) throws JSONException {
        return this.newDMXObjectModel(object.optLong("id", -1L), object.optString("uri", null), object.optString("typeUri", null), object.has("value") ? new SimpleValue(object.get("value")) : null, object.has("childs") ? this.newChildTopicsModel(object.getJSONObject("childs")) : null);
    }

    @Override
    public ChildTopicsModelImpl newChildTopicsModel() {
        return new ChildTopicsModelImpl(new HashMap<String, Object>(), this);
    }

    @Override
    public ChildTopicsModelImpl newChildTopicsModel(JSONObject values) {
        try {
            HashMap<String, Object> childTopics = new HashMap<String, Object>();
            Iterator i = values.keys();
            while (i.hasNext()) {
                String assocDefUri = (String)i.next();
                String childTypeUri = this.childTypeUri(assocDefUri);
                Object value = values.get(assocDefUri);
                if (!(value instanceof JSONArray)) {
                    childTopics.put(assocDefUri, this.createTopicModel(childTypeUri, value));
                    continue;
                }
                JSONArray valueArray = (JSONArray)value;
                ArrayList<RelatedTopicModel> topics = new ArrayList<RelatedTopicModel>();
                childTopics.put(assocDefUri, topics);
                for (int j = 0; j < valueArray.length(); ++j) {
                    topics.add(this.createTopicModel(childTypeUri, valueArray.get(j)));
                }
            }
            return new ChildTopicsModelImpl(childTopics, this);
        }
        catch (Exception e) {
            throw this.parsingFailed(values, e, "ChildTopicsModelImpl");
        }
    }

    @Override
    public String childTypeUri(String assocDefUri) {
        return assocDefUri.split("#")[0];
    }

    private RelatedTopicModel createTopicModel(String childTypeUri, Object value) throws JSONException {
        if (value instanceof JSONObject) {
            JSONObject val = (JSONObject)value;
            if (val.has("value") || val.has("childs")) {
                RelatedTopicModel topicRef;
                AssociationModelImpl relatingAssoc = null;
                if (val.has("assoc")) {
                    relatingAssoc = this.newAssociationModel(val.getJSONObject("assoc"));
                }
                if (val.has("value") && (topicRef = this.createReferenceModel(val.get("value"), relatingAssoc)) != null) {
                    if (topicRef instanceof TopicReferenceModelImpl && val.has("id")) {
                        ((TopicReferenceModelImpl)topicRef).originalId = val.getLong("id");
                    }
                    return topicRef;
                }
                this.initTypeUri(val, childTypeUri);
                TopicModelImpl topic = this.newTopicModel(val);
                if (relatingAssoc != null) {
                    return this.newRelatedTopicModel(topic, (AssociationModel)relatingAssoc);
                }
                return this.newRelatedTopicModel(topic);
            }
            return this.newRelatedTopicModel(this.newTopicModel(childTypeUri, (ChildTopicsModel)this.newChildTopicsModel(val)));
        }
        RelatedTopicModel topicRef = this.createReferenceModel(value, null);
        if (topicRef != null) {
            return topicRef;
        }
        return this.newRelatedTopicModel(this.newTopicModel(childTypeUri, new SimpleValue(value)));
    }

    private RelatedTopicModel createReferenceModel(Object value, AssociationModel relatingAssoc) {
        if (value instanceof String) {
            String val = (String)value;
            if (val.startsWith(REF_ID_PREFIX)) {
                long topicId = this.refTopicId(val);
                if (relatingAssoc != null) {
                    return this.newTopicReferenceModel(topicId, relatingAssoc);
                }
                return this.newTopicReferenceModel(topicId);
            }
            if (val.startsWith(REF_URI_PREFIX)) {
                String topicUri = this.refTopicUri(val);
                if (relatingAssoc != null) {
                    return this.newTopicReferenceModel(topicUri, relatingAssoc);
                }
                return this.newTopicReferenceModel(topicUri);
            }
            if (val.startsWith(DEL_ID_PREFIX)) {
                return this.newTopicDeletionModel(this.delTopicId(val));
            }
            if (val.startsWith(DEL_URI_PREFIX)) {
                return this.newTopicDeletionModel(this.delTopicUri(val));
            }
        }
        return null;
    }

    private void initTypeUri(JSONObject value, String childTypeUri) throws JSONException {
        if (!value.has("typeUri")) {
            value.put("typeUri", (Object)childTypeUri);
        } else {
            String typeUri = value.getString("typeUri");
            if (!typeUri.equals(childTypeUri)) {
                throw new IllegalArgumentException("A \"" + childTypeUri + "\" topic model has typeUri=\"" + typeUri + "\"");
            }
        }
    }

    private long refTopicId(String val) {
        return Long.parseLong(val.substring(REF_ID_PREFIX.length()));
    }

    private String refTopicUri(String val) {
        return val.substring(REF_URI_PREFIX.length());
    }

    private long delTopicId(String val) {
        return Long.parseLong(val.substring(DEL_ID_PREFIX.length()));
    }

    private String delTopicUri(String val) {
        return val.substring(DEL_URI_PREFIX.length());
    }

    @Override
    public TopicRoleModelImpl newTopicRoleModel(long topicId, String roleTypeUri) {
        return new TopicRoleModelImpl(topicId, roleTypeUri, this.pl());
    }

    @Override
    public TopicRoleModelImpl newTopicRoleModel(String topicUri, String roleTypeUri) {
        return new TopicRoleModelImpl(topicUri, roleTypeUri, this.pl());
    }

    @Override
    public TopicRoleModelImpl newTopicRoleModel(long topicId, String topicUri, String roleTypeUri) {
        return new TopicRoleModelImpl(topicId, topicUri, roleTypeUri, this.pl());
    }

    @Override
    public TopicRoleModelImpl newTopicRoleModel(JSONObject topicRoleModel) {
        try {
            long topicId = topicRoleModel.optLong("topicId", -1L);
            String topicUri = topicRoleModel.optString("topicUri", null);
            String roleTypeUri = topicRoleModel.getString("roleTypeUri");
            if (topicId == -1L && topicUri == null) {
                throw new IllegalArgumentException("Neiter \"topicId\" nor \"topicUri\" is set");
            }
            return this.newTopicRoleModel(topicId, topicUri, roleTypeUri);
        }
        catch (Exception e) {
            throw this.parsingFailed(topicRoleModel, e, "TopicRoleModelImpl");
        }
    }

    @Override
    public AssociationRoleModelImpl newAssociationRoleModel(long assocId, String roleTypeUri) {
        return new AssociationRoleModelImpl(assocId, roleTypeUri, this.pl());
    }

    @Override
    public AssociationRoleModelImpl newAssociationRoleModel(JSONObject assocRoleModel) {
        try {
            long assocId = assocRoleModel.getLong("assocId");
            String roleTypeUri = assocRoleModel.getString("roleTypeUri");
            return this.newAssociationRoleModel(assocId, roleTypeUri);
        }
        catch (Exception e) {
            throw this.parsingFailed(assocRoleModel, e, "AssociationRoleModelImpl");
        }
    }

    @Override
    public RelatedTopicModelImpl newRelatedTopicModel(long topicId) {
        return new RelatedTopicModelImpl(this.newTopicModel(topicId), this.newAssociationModel());
    }

    @Override
    public RelatedTopicModelImpl newRelatedTopicModel(long topicId, AssociationModel relatingAssoc) {
        return new RelatedTopicModelImpl(this.newTopicModel(topicId), (AssociationModelImpl)relatingAssoc);
    }

    @Override
    public RelatedTopicModelImpl newRelatedTopicModel(String topicUri) {
        return new RelatedTopicModelImpl(this.newTopicModel(topicUri, (String)null), this.newAssociationModel());
    }

    @Override
    public RelatedTopicModelImpl newRelatedTopicModel(String topicUri, AssociationModel relatingAssoc) {
        return new RelatedTopicModelImpl(this.newTopicModel(topicUri, (String)null), (AssociationModelImpl)relatingAssoc);
    }

    @Override
    public RelatedTopicModelImpl newRelatedTopicModel(String topicTypeUri, SimpleValue value) {
        return new RelatedTopicModelImpl(this.newTopicModel(topicTypeUri, value), this.newAssociationModel());
    }

    @Override
    public RelatedTopicModelImpl newRelatedTopicModel(String topicTypeUri, ChildTopicsModel childTopics) {
        return new RelatedTopicModelImpl(this.newTopicModel(topicTypeUri, childTopics), this.newAssociationModel());
    }

    @Override
    public RelatedTopicModelImpl newRelatedTopicModel(TopicModel topic) {
        return new RelatedTopicModelImpl((TopicModelImpl)topic, this.newAssociationModel());
    }

    @Override
    public RelatedTopicModelImpl newRelatedTopicModel(TopicModel topic, AssociationModel relatingAssoc) {
        return new RelatedTopicModelImpl((TopicModelImpl)topic, (AssociationModelImpl)relatingAssoc);
    }

    @Override
    public RelatedAssociationModelImpl newRelatedAssociationModel(AssociationModel assoc, AssociationModel relatingAssoc) {
        return new RelatedAssociationModelImpl((AssociationModelImpl)assoc, (AssociationModelImpl)relatingAssoc);
    }

    @Override
    public TopicReferenceModel newTopicReferenceModel(long topicId) {
        return new TopicReferenceModelImpl(this.newRelatedTopicModel(topicId));
    }

    @Override
    public TopicReferenceModel newTopicReferenceModel(long topicId, AssociationModel relatingAssoc) {
        return new TopicReferenceModelImpl(this.newRelatedTopicModel(topicId, relatingAssoc));
    }

    @Override
    public TopicReferenceModel newTopicReferenceModel(String topicUri) {
        return new TopicReferenceModelImpl(this.newRelatedTopicModel(topicUri));
    }

    @Override
    public TopicReferenceModel newTopicReferenceModel(String topicUri, AssociationModel relatingAssoc) {
        return new TopicReferenceModelImpl(this.newRelatedTopicModel(topicUri, relatingAssoc));
    }

    @Override
    public TopicReferenceModel newTopicReferenceModel(long topicId, ChildTopicsModel relatingAssocChildTopics) {
        return new TopicReferenceModelImpl(this.newRelatedTopicModel(topicId, (AssociationModel)this.newAssociationModel(relatingAssocChildTopics)));
    }

    @Override
    public TopicReferenceModel newTopicReferenceModel(String topicUri, ChildTopicsModel relatingAssocChildTopics) {
        return new TopicReferenceModelImpl(this.newRelatedTopicModel(topicUri, (AssociationModel)this.newAssociationModel(relatingAssocChildTopics)));
    }

    @Override
    public TopicReferenceModel newTopicReferenceModel(Object topicIdOrUri) {
        RelatedTopicModelImpl relTopic;
        if (topicIdOrUri instanceof Long) {
            relTopic = this.newRelatedTopicModel((Long)topicIdOrUri);
        } else if (topicIdOrUri instanceof String) {
            relTopic = this.newRelatedTopicModel((String)topicIdOrUri);
        } else {
            throw new IllegalArgumentException("Tried to build a TopicReferenceModel from a " + topicIdOrUri.getClass().getName() + " (expected are String or Long)");
        }
        return new TopicReferenceModelImpl(relTopic);
    }

    @Override
    public TopicDeletionModel newTopicDeletionModel(long topicId) {
        return new TopicDeletionModelImpl(this.newRelatedTopicModel(topicId));
    }

    @Override
    public TopicDeletionModel newTopicDeletionModel(String topicUri) {
        return new TopicDeletionModelImpl(this.newRelatedTopicModel(topicUri));
    }

    @Override
    public TopicTypeModelImpl newTopicTypeModel(TopicModel typeTopic, String dataTypeUri, List<AssociationDefinitionModel> assocDefs, ViewConfigurationModel viewConfig) {
        return new TopicTypeModelImpl(this.newTypeModel(typeTopic, dataTypeUri, assocDefs, (ViewConfigurationModelImpl)viewConfig));
    }

    @Override
    public TopicTypeModelImpl newTopicTypeModel(String uri, String value, String dataTypeUri) {
        return new TopicTypeModelImpl(this.newTypeModel(uri, "dmx.core.topic_type", new SimpleValue(value), dataTypeUri));
    }

    @Override
    public TopicTypeModelImpl newTopicTypeModel(JSONObject topicType) {
        try {
            return new TopicTypeModelImpl(this.newTypeModel(topicType.put("typeUri", (Object)"dmx.core.topic_type")));
        }
        catch (Exception e) {
            throw this.parsingFailed(topicType, e, "TopicTypeModelImpl");
        }
    }

    @Override
    public AssociationTypeModelImpl newAssociationTypeModel(TopicModel typeTopic, String dataTypeUri, List<AssociationDefinitionModel> assocDefs, ViewConfigurationModel viewConfig) {
        return new AssociationTypeModelImpl(this.newTypeModel(typeTopic, dataTypeUri, assocDefs, (ViewConfigurationModelImpl)viewConfig));
    }

    @Override
    public AssociationTypeModelImpl newAssociationTypeModel(String uri, String value, String dataTypeUri) {
        return new AssociationTypeModelImpl(this.newTypeModel(uri, "dmx.core.assoc_type", new SimpleValue(value), dataTypeUri));
    }

    @Override
    public AssociationTypeModelImpl newAssociationTypeModel(JSONObject assocType) {
        try {
            return new AssociationTypeModelImpl(this.newTypeModel(assocType.put("typeUri", (Object)"dmx.core.assoc_type")));
        }
        catch (Exception e) {
            throw this.parsingFailed(assocType, e, "AssociationTypeModelImpl");
        }
    }

    TypeModelImpl newTypeModel(TopicModel typeTopic, String dataTypeUri, List<AssociationDefinitionModel> assocDefs, ViewConfigurationModelImpl viewConfig) {
        return new TypeModelImpl((TopicModelImpl)typeTopic, dataTypeUri, assocDefs, viewConfig);
    }

    TypeModelImpl newTypeModel(String uri, String typeUri, SimpleValue value, String dataTypeUri) {
        return new TypeModelImpl(this.newTopicModel(uri, typeUri, value), dataTypeUri, new ArrayList<AssociationDefinitionModel>(), this.newViewConfigurationModel());
    }

    TypeModelImpl newTypeModel(JSONObject typeModel) throws JSONException {
        TopicModelImpl typeTopic = this.newTopicModel(typeModel);
        return new TypeModelImpl(typeTopic, typeModel.optString("dataTypeUri", null), this.parseAssocDefs(typeModel.optJSONArray("assocDefs"), typeTopic.getUri()), this.newViewConfigurationModel(typeModel.optJSONArray("viewConfigTopics")));
    }

    private List<AssociationDefinitionModel> parseAssocDefs(JSONArray assocDefs, String parentTypeUri) throws JSONException {
        ArrayList<AssociationDefinitionModel> _assocDefs = new ArrayList<AssociationDefinitionModel>();
        if (assocDefs != null) {
            for (int i = 0; i < assocDefs.length(); ++i) {
                JSONObject assocDef = assocDefs.getJSONObject(i).put("parentTypeUri", (Object)parentTypeUri);
                _assocDefs.add(this.newAssociationDefinitionModel(assocDef));
            }
        }
        return _assocDefs;
    }

    @Override
    public AssociationDefinitionModelImpl newAssociationDefinitionModel(String parentTypeUri, String childTypeUri, String childCardinalityUri) {
        return this.newAssociationDefinitionModel(-1L, null, null, false, false, parentTypeUri, childTypeUri, childCardinalityUri, null);
    }

    @Override
    public AssociationDefinitionModelImpl newAssociationDefinitionModel(String parentTypeUri, String childTypeUri, String childCardinalityUri, ViewConfigurationModel viewConfig) {
        return this.newAssociationDefinitionModel(-1L, null, null, false, false, parentTypeUri, childTypeUri, childCardinalityUri, viewConfig);
    }

    @Override
    public AssociationDefinitionModelImpl newAssociationDefinitionModel(String customAssocTypeUri, boolean isIdentityAttr, boolean includeInLabel, String parentTypeUri, String childTypeUri, String childCardinalityUri) {
        return this.newAssociationDefinitionModel(-1L, null, customAssocTypeUri, isIdentityAttr, includeInLabel, parentTypeUri, childTypeUri, childCardinalityUri, null);
    }

    @Override
    public AssociationDefinitionModelImpl newAssociationDefinitionModel(AssociationModel assoc, ViewConfigurationModel viewConfig) {
        return new AssociationDefinitionModelImpl((AssociationModelImpl)assoc, (ViewConfigurationModelImpl)viewConfig);
    }

    @Override
    public AssociationDefinitionModelImpl newAssociationDefinitionModel(JSONObject assocDef) {
        try {
            RoleModelImpl role1 = this.parseRole1(assocDef);
            RoleModelImpl role2 = this.parseRole2(assocDef);
            return new AssociationDefinitionModelImpl(this.newAssociationModel(assocDef.optLong("id", -1L), null, TYPE_COMP_DEF, role1 != null ? role1 : this.parentRole(assocDef.getString("parentTypeUri")), role2 != null ? role2 : this.childRole(assocDef.getString("childTypeUri")), null, this.childTopics(assocDef)), this.newViewConfigurationModel(assocDef.optJSONArray("viewConfigTopics")));
        }
        catch (Exception e) {
            throw this.parsingFailed(assocDef, e, "AssociationDefinitionModelImpl");
        }
    }

    AssociationDefinitionModelImpl newAssociationDefinitionModel(long id, String uri, String customAssocTypeUri, boolean isIdentityAttr, boolean includeInLabel, String parentTypeUri, String childTypeUri, String childCardinalityUri, ViewConfigurationModel viewConfig) {
        return new AssociationDefinitionModelImpl(this.newAssociationModel(id, uri, TYPE_COMP_DEF, this.parentRole(parentTypeUri), this.childRole(childTypeUri), null, this.childTopics(childCardinalityUri, customAssocTypeUri, isIdentityAttr, includeInLabel)), (ViewConfigurationModelImpl)viewConfig);
    }

    AssociationDefinitionModelImpl newAssociationDefinitionModel(ChildTopicsModel childTopics) {
        return new AssociationDefinitionModelImpl(this.newAssociationModel(TYPE_COMP_DEF, childTopics));
    }

    private TopicRoleModel parentRole(String parentTypeUri) {
        return this.newTopicRoleModel(parentTypeUri, "dmx.core.parent_type");
    }

    private TopicRoleModel childRole(String childTypeUri) {
        return this.newTopicRoleModel(childTypeUri, "dmx.core.child_type");
    }

    private ChildTopicsModel childTopics(JSONObject assocDef) throws JSONException {
        return this.childTopics(assocDef.getString("childCardinalityUri"), assocDef.isNull("customAssocTypeUri") ? null : assocDef.getString("customAssocTypeUri"), assocDef.optBoolean("isIdentityAttr"), assocDef.optBoolean("includeInLabel"));
    }

    private ChildTopicsModel childTopics(String cardinalityUri, String customAssocTypeUri, boolean isIdentityAttr, boolean includeInLabel) {
        ChildTopicsModel childTopics = this.newChildTopicsModel().putRef("dmx.core.cardinality", cardinalityUri).put("dmx.core.identity_attr", isIdentityAttr).put("dmx.core.include_in_label", includeInLabel);
        if (customAssocTypeUri != null) {
            if (customAssocTypeUri.startsWith(DEL_URI_PREFIX)) {
                childTopics.putDeletionRef("dmx.core.assoc_type#dmx.core.custom_assoc_type", this.delTopicUri(customAssocTypeUri));
            } else {
                childTopics.putRef("dmx.core.assoc_type#dmx.core.custom_assoc_type", customAssocTypeUri);
            }
        }
        return childTopics;
    }

    @Override
    public ViewConfigurationModelImpl newViewConfigurationModel() {
        return new ViewConfigurationModelImpl(new HashMap<String, TopicModelImpl>(), this.pl());
    }

    @Override
    public ViewConfigurationModelImpl newViewConfigurationModel(Iterable<? extends TopicModel> configTopics) {
        HashMap<String, TopicModelImpl> _configTopics = new HashMap<String, TopicModelImpl>();
        for (TopicModel topicModel : configTopics) {
            _configTopics.put(topicModel.getTypeUri(), (TopicModelImpl)topicModel);
        }
        return new ViewConfigurationModelImpl(_configTopics, this.pl());
    }

    @Override
    public ViewConfigurationModelImpl newViewConfigurationModel(JSONArray configTopics) {
        try {
            HashMap<String, TopicModelImpl> _configTopics = new HashMap<String, TopicModelImpl>();
            if (configTopics != null) {
                for (int i = 0; i < configTopics.length(); ++i) {
                    TopicModelImpl configTopic = this.newTopicModel(configTopics.getJSONObject(i));
                    _configTopics.put(configTopic.getTypeUri(), configTopic);
                }
            }
            return new ViewConfigurationModelImpl(_configTopics, this.pl());
        }
        catch (Exception e) {
            throw this.parsingFailed(configTopics, e, "ViewConfigurationModelImpl");
        }
    }

    @Override
    public ViewTopic newViewTopic(TopicModel topic, ViewProperties viewProps) {
        return new ViewTopicImpl((TopicModelImpl)topic, viewProps);
    }

    @Override
    public ViewAssoc newViewAssoc(AssociationModel assoc, ViewProperties viewProps) {
        return new ViewAssocImpl((AssociationModelImpl)assoc, viewProps);
    }

    @Override
    public ViewProperties newViewProperties() {
        return new ViewPropertiesImpl();
    }

    @Override
    public ViewProperties newViewProperties(int x, int y, boolean visibility, boolean pinned) {
        return new ViewPropertiesImpl(x, y, visibility, pinned);
    }

    @Override
    public ViewProperties newViewProperties(int x, int y) {
        return new ViewPropertiesImpl(x, y);
    }

    @Override
    public ViewProperties newViewProperties(boolean visibility) {
        return new ViewPropertiesImpl(visibility);
    }

    @Override
    public ViewProperties newViewProperties(JSONObject viewProps) {
        return new ViewPropertiesImpl(viewProps);
    }

    @Override
    public FacetValueModel newFacetValueModel(String childTypeUri) {
        return new FacetValueModelImpl(childTypeUri, (ModelFactory)this);
    }

    @Override
    public FacetValueModel newFacetValueModel(JSONObject facetValue) {
        try {
            ChildTopicsModelImpl childTopics = this.newChildTopicsModel(facetValue);
            if (childTopics.size() != 1) {
                throw new RuntimeException("There are " + childTopics.size() + " child topic entries (expected is 1)");
            }
            return new FacetValueModelImpl(childTopics);
        }
        catch (Exception e) {
            throw this.parsingFailed(facetValue, e, "FacetValueModelImpl");
        }
    }

    private RuntimeException parsingFailed(JSONObject o, Exception e, String className) {
        try {
            return new RuntimeException("JSON parsing failed, " + className + " " + o.toString(4), e);
        }
        catch (JSONException je) {
            return new RuntimeException("JSON parsing failed, " + className + " " + o, e);
        }
    }

    private RuntimeException parsingFailed(JSONArray a, Exception e, String className) {
        try {
            return new RuntimeException("JSON parsing failed, " + className + " " + a.toString(4), e);
        }
        catch (JSONException je) {
            return new RuntimeException("JSON parsing failed, " + className + " " + a, e);
        }
    }

    private PersistenceLayer pl() {
        if (this.pl == null) {
            throw new RuntimeException("Before using the ModelFactory a PersistenceLayer must be set");
        }
        return this.pl;
    }
}

