/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.model.topicmaps.ViewProps;
import systems.dmx.core.util.DMXUtils;

class ViewPropsImpl
implements ViewProps {
    private Map<String, Object> viewProps = new HashMap<String, Object>();

    ViewPropsImpl(JSONObject viewProps) {
        DMXUtils.toMap(viewProps, this.viewProps);
    }

    ViewPropsImpl() {
    }

    ViewPropsImpl(int x, int y, boolean visibility, boolean pinned) {
        this.initPos(x, y);
        this.initVisibility(visibility);
        this.initPinned(pinned);
    }

    ViewPropsImpl(int x, int y) {
        this.initPos(x, y);
    }

    ViewPropsImpl(boolean visibility) {
        this.initVisibility(visibility);
    }

    @Override
    public Object get(String propUri) {
        return this.viewProps.get(propUri);
    }

    @Override
    public ViewProps put(String propUri, Object value) {
        this.viewProps.put(propUri, value);
        return this;
    }

    @Override
    public int getInt(String propUri) {
        return (Integer)this.get(propUri);
    }

    @Override
    public boolean getBoolean(String propUri) {
        return (Boolean)this.get(propUri);
    }

    @Override
    public Iterator<String> iterator() {
        return this.viewProps.keySet().iterator();
    }

    @Override
    public JSONObject toJSON() {
        return new JSONObject(this.viewProps);
    }

    public String toString() {
        return this.viewProps.toString();
    }

    private void initPos(int x, int y) {
        this.put("dmx.topicmaps.x", x);
        this.put("dmx.topicmaps.y", y);
    }

    private void initVisibility(boolean visibility) {
        this.put("dmx.topicmaps.visibility", visibility);
    }

    private void initPinned(boolean pinned) {
        this.put("dmx.topicmaps.pinned", pinned);
    }
}

