/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.topicmaps;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import systems.dmx.core.Association;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedAssociation;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.model.AssociationModel;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.RoleModel;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.model.topicmaps.ViewAssoc;
import systems.dmx.core.model.topicmaps.ViewProps;
import systems.dmx.core.model.topicmaps.ViewTopic;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.CoreService;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.util.DMXUtils;
import systems.dmx.core.util.IdList;
import systems.dmx.topicmaps.ClusterCoords;
import systems.dmx.topicmaps.DefaultTopicmapType;
import systems.dmx.topicmaps.Messenger;
import systems.dmx.topicmaps.MessengerContext;
import systems.dmx.topicmaps.Topicmap;
import systems.dmx.topicmaps.TopicmapType;
import systems.dmx.topicmaps.TopicmapsService;
import systems.dmx.topicmaps.ViewmodelCustomizer;

@Path(value="/topicmap")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class TopicmapsPlugin
extends PluginActivator
implements TopicmapsService,
MessengerContext {
    private static final String TOPICMAP_CONTEXT = "dmx.topicmaps.topicmap_context";
    private static final String ROLE_TYPE_TOPICMAP = "dmx.core.default";
    private static final String ROLE_TYPE_CONTENT = "dmx.topicmaps.topicmap_content";
    private static final String PROP_X = "dmx.topicmaps.x";
    private static final String PROP_Y = "dmx.topicmaps.y";
    private static final String PROP_VISIBILITY = "dmx.topicmaps.visibility";
    private static final String PROP_PINNED = "dmx.topicmaps.pinned";
    private Map<String, TopicmapType> topicmapTypes = new HashMap<String, TopicmapType>();
    private List<ViewmodelCustomizer> viewmodelCustomizers = new ArrayList<ViewmodelCustomizer>();
    private Messenger me = new Messenger(this);
    @Context
    private HttpServletRequest request;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public TopicmapsPlugin() {
        this.registerTopicmapType(new DefaultTopicmapType());
    }

    @Override
    @POST
    @Transactional
    public Topic createTopicmap(@QueryParam(value="name") String name, @QueryParam(value="topicmap_type_uri") String topicmapTypeUri, @QueryParam(value="private") boolean isPrivate) {
        this.logger.info("Creating topicmap \"" + name + "\" (topicmapTypeUri=\"" + topicmapTypeUri + "\", isPrivate=" + isPrivate + ")");
        Topic topicmapTopic = this.dmx.createTopic(this.mf.newTopicModel("dmx.topicmaps.topicmap", this.mf.newChildTopicsModel().put("dmx.topicmaps.topicmap_name", (Object)name).put("dmx.topicmaps.topicmap_type_uri", (Object)topicmapTypeUri).put("dmx.topicmaps.topicmap_state", this.getTopicmapType(topicmapTypeUri).initialTopicmapState(this.mf)).put("dmx.topicmaps.private", (Object)isPrivate)));
        this.me.newTopicmap(topicmapTopic);
        return topicmapTopic;
    }

    @Override
    @GET
    @Path(value="/{id}")
    public Topicmap getTopicmap(@PathParam(value="id") long topicmapId, @QueryParam(value="include_childs") boolean includeChilds) {
        try {
            this.logger.info("Loading topicmap " + topicmapId + " (includeChilds=" + includeChilds + ")");
            Topic topicmapTopic = this.dmx.getTopic(topicmapId).loadChildTopics();
            Map<Long, ViewTopic> topics = this.fetchTopics(topicmapTopic, includeChilds);
            Map<Long, ViewAssoc> assocs = this.fetchAssociations(topicmapTopic);
            return new Topicmap(topicmapTopic.getModel(), topics, assocs);
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching topicmap " + topicmapId + " failed", e);
        }
    }

    @Override
    public boolean isTopicInTopicmap(long topicmapId, long topicId) {
        return this.fetchTopicMapcontext(topicmapId, topicId) != null;
    }

    @Override
    public boolean isAssociationInTopicmap(long topicmapId, long assocId) {
        return this.fetchAssociationMapcontext(topicmapId, assocId) != null;
    }

    @Override
    @GET
    @Path(value="/object/{id}")
    public List<RelatedTopic> getTopicmapTopics(@PathParam(value="id") long objectId) {
        try {
            ArrayList<RelatedTopic> topicmapTopics = new ArrayList<RelatedTopic>();
            DMXObject object = this.dmx.getObject(objectId);
            boolean isAssoc = object instanceof Association;
            for (RelatedTopic topic : object.getRelatedTopics((String)null, null, ROLE_TYPE_TOPICMAP, "dmx.topicmaps.topicmap")) {
                if (!isAssoc && !this.visibility(topic.getRelatingAssociation())) continue;
                topicmapTopics.add(topic);
            }
            return topicmapTopics;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching topicmap topics of topic/assoc " + objectId + " failed", e);
        }
    }

    @Override
    @POST
    @Path(value="/{id}/topic/{topic_id}")
    @Transactional
    public void addTopicToTopicmap(final @PathParam(value="id") long topicmapId, final @PathParam(value="topic_id") long topicId, final ViewProps viewProps) {
        try {
            this.dmx.getAccessControl().runWithoutWorkspaceAssignment((Callable)new Callable<Void>(){

                @Override
                public Void call() {
                    if (TopicmapsPlugin.this.isTopicInTopicmap(topicmapId, topicId)) {
                        throw new RuntimeException("Topic " + topicId + " already added to topicmap" + topicmapId);
                    }
                    TopicmapsPlugin.this.createTopicMapcontext(topicmapId, topicId, viewProps);
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Adding topic " + topicId + " to topicmap " + topicmapId + " failed (viewProps=" + viewProps + ")", e);
        }
    }

    @Override
    public void addTopicToTopicmap(long topicmapId, long topicId, int x, int y, boolean visibility) {
        this.addTopicToTopicmap(topicmapId, topicId, this.mf.newViewProps(x, y, visibility, false));
    }

    @Override
    @POST
    @Path(value="/{id}/association/{assoc_id}")
    @Transactional
    public void addAssociationToTopicmap(final @PathParam(value="id") long topicmapId, final @PathParam(value="assoc_id") long assocId, final ViewProps viewProps) {
        try {
            this.dmx.getAccessControl().runWithoutWorkspaceAssignment((Callable)new Callable<Void>(){

                @Override
                public Void call() {
                    if (TopicmapsPlugin.this.isAssociationInTopicmap(topicmapId, assocId)) {
                        throw new RuntimeException("Association " + assocId + " already added to topicmap " + topicmapId);
                    }
                    TopicmapsPlugin.this.createAssociationMapcontext(topicmapId, assocId, viewProps);
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Adding association " + assocId + " to topicmap " + topicmapId + " failed (viewProps=" + viewProps + ")", e);
        }
    }

    @Override
    @POST
    @Path(value="/{id}/topic/{topic_id}/association/{assoc_id}")
    @Transactional
    public void addRelatedTopicToTopicmap(final @PathParam(value="id") long topicmapId, final @PathParam(value="topic_id") long topicId, final @PathParam(value="assoc_id") long assocId, final ViewProps viewProps) {
        try {
            this.dmx.getAccessControl().runWithoutWorkspaceAssignment((Callable)new Callable<Void>(){

                @Override
                public Void call() {
                    Association topicMapcontext = TopicmapsPlugin.this.fetchTopicMapcontext(topicmapId, topicId);
                    if (topicMapcontext == null) {
                        TopicmapsPlugin.this.createTopicMapcontext(topicmapId, topicId, viewProps);
                    } else if (!TopicmapsPlugin.this.visibility(topicMapcontext)) {
                        TopicmapsPlugin.this.setTopicVisibility(topicmapId, topicId, true);
                    }
                    Association assocMapcontext = TopicmapsPlugin.this.fetchAssociationMapcontext(topicmapId, assocId);
                    if (assocMapcontext == null) {
                        TopicmapsPlugin.this.createAssociationMapcontext(topicmapId, assocId, TopicmapsPlugin.this.mf.newViewProps().put(TopicmapsPlugin.PROP_VISIBILITY, (Object)false).put(TopicmapsPlugin.PROP_PINNED, (Object)false));
                    } else if (!TopicmapsPlugin.this.visibility(assocMapcontext)) {
                        TopicmapsPlugin.this.setAssocVisibility(topicmapId, assocId, true);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Adding related topic " + topicId + " (assocId=" + assocId + ") to topicmap " + topicmapId + " failed (viewProps=" + viewProps + ")", e);
        }
    }

    @Override
    @PUT
    @Path(value="/{id}/topic/{topic_id}")
    @Transactional
    public void setTopicViewProps(@PathParam(value="id") long topicmapId, @PathParam(value="topic_id") long topicId, ViewProps viewProps) {
        this.storeTopicViewProps(topicmapId, topicId, viewProps);
    }

    @Override
    @PUT
    @Path(value="/{id}/association/{assoc_id}")
    @Transactional
    public void setAssociationViewProps(@PathParam(value="id") long topicmapId, @PathParam(value="assoc_id") long assocId, ViewProps viewProps) {
        this.storeAssociationViewProps(topicmapId, assocId, viewProps);
    }

    @Override
    @PUT
    @Path(value="/{id}/topic/{topic_id}/{x}/{y}")
    @Transactional
    public void setTopicPosition(@PathParam(value="id") long topicmapId, @PathParam(value="topic_id") long topicId, @PathParam(value="x") int x, @PathParam(value="y") int y) {
        try {
            this.storeTopicViewProps(topicmapId, topicId, this.mf.newViewProps(x, y));
            this.me.setTopicPosition(topicmapId, topicId, x, y);
        }
        catch (Exception e) {
            throw new RuntimeException("Setting position of topic " + topicId + " in topicmap " + topicmapId + " failed", e);
        }
    }

    @Override
    @PUT
    @Path(value="/{id}/topic/{topic_id}/{visibility}")
    @Transactional
    public void setTopicVisibility(@PathParam(value="id") long topicmapId, @PathParam(value="topic_id") long topicId, @PathParam(value="visibility") boolean visibility) {
        try {
            if (!visibility) {
                this.hideAssocsWithPlayer((DMXObject)this.dmx.getTopic(topicId), topicmapId);
            }
            this.storeTopicViewProps(topicmapId, topicId, this.mf.newViewProps(visibility));
            this.me.setTopicVisibility(topicmapId, topicId, visibility);
        }
        catch (Exception e) {
            throw new RuntimeException("Setting visibility of topic " + topicId + " in topicmap " + topicmapId + " failed", e);
        }
    }

    @Override
    @PUT
    @Path(value="/{id}/assoc/{assoc_id}/visibility/{visibility}")
    @Transactional
    public void setAssocVisibility(@PathParam(value="id") long topicmapId, @PathParam(value="assoc_id") long assocId, @PathParam(value="visibility") boolean visibility) {
        try {
            if (!visibility) {
                this.hideAssocsWithPlayer((DMXObject)this.dmx.getAssociation(assocId), topicmapId);
            }
            this.storeAssociationViewProps(topicmapId, assocId, this.mf.newViewProps(visibility));
            this.me.setAssocVisibility(topicmapId, assocId, visibility);
        }
        catch (Exception e) {
            throw new RuntimeException("Setting visibility of assoc " + assocId + " from topicmap " + topicmapId + " failed", e);
        }
    }

    @Override
    @PUT
    @Path(value="/{id}/topics/{topicIds}/visibility/false")
    @Transactional
    public void hideTopics(@PathParam(value="id") long topicmapId, @PathParam(value="topicIds") IdList topicIds) {
        this.hideMulti(topicmapId, topicIds, new IdList());
    }

    @Override
    @PUT
    @Path(value="/{id}/assocs/{assocIds}/visibility/false")
    @Transactional
    public void hideAssocs(@PathParam(value="id") long topicmapId, @PathParam(value="assocIds") IdList assocIds) {
        this.hideMulti(topicmapId, new IdList(), assocIds);
    }

    @Override
    @PUT
    @Path(value="/{id}/topics/{topicIds}/assocs/{assocIds}/visibility/false")
    @Transactional
    public void hideMulti(@PathParam(value="id") long topicmapId, @PathParam(value="topicIds") IdList topicIds, @PathParam(value="assocIds") IdList assocIds) {
        long id;
        this.logger.info("topicmapId=" + topicmapId + ", topicIds=" + topicIds + ", assocIds=" + assocIds);
        Iterator iterator = topicIds.iterator();
        while (iterator.hasNext()) {
            id = (Long)iterator.next();
            this.setTopicVisibility(topicmapId, id, false);
        }
        iterator = assocIds.iterator();
        while (iterator.hasNext()) {
            id = (Long)iterator.next();
            this.setAssocVisibility(topicmapId, id, false);
        }
    }

    @Override
    @PUT
    @Path(value="/{id}")
    @Transactional
    public void setClusterPosition(@PathParam(value="id") long topicmapId, ClusterCoords coords) {
        for (ClusterCoords.Entry entry : coords) {
            this.setTopicPosition(topicmapId, entry.topicId, entry.x, entry.y);
        }
    }

    @Override
    @PUT
    @Path(value="/{id}/translation/{x}/{y}")
    @Transactional
    public void setTopicmapTranslation(@PathParam(value="id") long topicmapId, @PathParam(value="x") int transX, @PathParam(value="y") int transY) {
        try {
            ChildTopicsModel topicmapState = this.mf.newChildTopicsModel().put("dmx.topicmaps.topicmap_state", this.mf.newChildTopicsModel().put("dmx.topicmaps.translation", this.mf.newChildTopicsModel().put("dmx.topicmaps.translation_x", (Object)transX).put("dmx.topicmaps.translation_y", (Object)transY)));
            this.dmx.updateTopic(this.mf.newTopicModel(topicmapId, topicmapState));
        }
        catch (Exception e) {
            throw new RuntimeException("Setting translation of topicmap " + topicmapId + " failed (transX=" + transX + ", transY=" + transY + ")", e);
        }
    }

    @Override
    public void registerTopicmapType(TopicmapType topicmapType) {
        this.logger.info("### Registering topicmap type \"" + topicmapType.getClass().getName() + "\"");
        this.topicmapTypes.put(topicmapType.getUri(), topicmapType);
    }

    @Override
    public void registerViewmodelCustomizer(ViewmodelCustomizer customizer) {
        this.logger.info("### Registering viewmodel customizer \"" + customizer.getClass().getName() + "\"");
        this.viewmodelCustomizers.add(customizer);
    }

    @Override
    public void unregisterViewmodelCustomizer(ViewmodelCustomizer customizer) {
        this.logger.info("### Unregistering viewmodel customizer \"" + customizer.getClass().getName() + "\"");
        if (!this.viewmodelCustomizers.remove(customizer)) {
            throw new RuntimeException("Unregistering viewmodel customizer failed (customizer=" + customizer + ")");
        }
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"text/html"})
    public InputStream getTopicmapInWebclient() {
        return this.invokeWebclient();
    }

    @GET
    @Path(value="/{id}/topic/{topic_id}")
    @Produces(value={"text/html"})
    public InputStream getTopicmapAndTopicInWebclient() {
        return this.invokeWebclient();
    }

    @Override
    public CoreService getCoreService() {
        return this.dmx;
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.request;
    }

    private Map<Long, ViewTopic> fetchTopics(Topic topicmapTopic, boolean includeChilds) {
        HashMap<Long, ViewTopic> topics = new HashMap<Long, ViewTopic>();
        List relTopics = topicmapTopic.getRelatedTopics(TOPICMAP_CONTEXT, ROLE_TYPE_TOPICMAP, ROLE_TYPE_CONTENT, null);
        if (includeChilds) {
            DMXUtils.loadChildTopics((List)relTopics);
        }
        for (RelatedTopic topic : relTopics) {
            topics.put(topic.getId(), this.buildViewTopic(topic));
        }
        return topics;
    }

    private Map<Long, ViewAssoc> fetchAssociations(Topic topicmapTopic) {
        HashMap<Long, ViewAssoc> assocs = new HashMap<Long, ViewAssoc>();
        List relAssocs = topicmapTopic.getRelatedAssociations(TOPICMAP_CONTEXT, ROLE_TYPE_TOPICMAP, ROLE_TYPE_CONTENT, null);
        for (RelatedAssociation assoc : relAssocs) {
            assocs.put(assoc.getId(), this.buildViewAssoc(assoc));
        }
        return assocs;
    }

    private ViewTopic buildViewTopic(RelatedTopic topic) {
        try {
            ViewProps viewProps = this.fetchTopicViewProps(topic.getRelatingAssociation());
            this.invokeViewmodelCustomizers(topic, viewProps);
            return this.mf.newViewTopic((TopicModel)topic.getModel(), viewProps);
        }
        catch (Exception e) {
            throw new RuntimeException("Creating viewmodel for topic " + topic.getId() + " failed", e);
        }
    }

    private ViewAssoc buildViewAssoc(RelatedAssociation assoc) {
        try {
            ViewProps viewProps = this.fetchAssocViewProps(assoc.getRelatingAssociation());
            return this.mf.newViewAssoc((AssociationModel)assoc.getModel(), viewProps);
        }
        catch (Exception e) {
            throw new RuntimeException("Creating viewmodel for association " + assoc.getId() + " failed", e);
        }
    }

    private ViewProps fetchTopicViewProps(Association topicmapContext) {
        return this.mf.newViewProps(((Integer)topicmapContext.getProperty(PROP_X)).intValue(), ((Integer)topicmapContext.getProperty(PROP_Y)).intValue(), this.visibility(topicmapContext), this.pinned(topicmapContext));
    }

    private ViewProps fetchAssocViewProps(Association topicmapContext) {
        return this.mf.newViewProps().put(PROP_VISIBILITY, (Object)this.visibility(topicmapContext)).put(PROP_PINNED, (Object)this.pinned(topicmapContext));
    }

    private boolean visibility(Association topicmapContext) {
        return (Boolean)topicmapContext.getProperty(PROP_VISIBILITY);
    }

    private boolean pinned(Association topicmapContext) {
        return (Boolean)topicmapContext.getProperty(PROP_PINNED);
    }

    private void storeTopicViewProps(long topicmapId, long topicId, ViewProps viewProps) {
        try {
            Association topicmapContext = this.fetchTopicMapcontext(topicmapId, topicId);
            if (topicmapContext == null) {
                throw new RuntimeException("Topic " + topicId + " is not contained in topicmap " + topicmapId);
            }
            this.storeViewProps(topicmapContext, viewProps);
        }
        catch (Exception e) {
            throw new RuntimeException("Storing view properties of topic " + topicId + " failed (viewProps=" + viewProps + ")", e);
        }
    }

    private void storeAssociationViewProps(long topicmapId, long assocId, ViewProps viewProps) {
        try {
            Association topicmapContext = this.fetchAssociationMapcontext(topicmapId, assocId);
            if (topicmapContext == null) {
                throw new RuntimeException("Association " + assocId + " is not contained in topicmap " + topicmapId);
            }
            this.storeViewProps(topicmapContext, viewProps);
        }
        catch (Exception e) {
            throw new RuntimeException("Storing view properties of association " + assocId + " failed (viewProps=" + viewProps + ")", e);
        }
    }

    private void storeViewProps(Association topicmapContext, ViewProps viewProps) {
        for (String propUri : viewProps) {
            topicmapContext.setProperty(propUri, viewProps.get(propUri), false);
        }
    }

    private Association fetchTopicMapcontext(long topicmapId, long topicId) {
        return this.dmx.getAssociation(TOPICMAP_CONTEXT, topicmapId, topicId, ROLE_TYPE_TOPICMAP, ROLE_TYPE_CONTENT);
    }

    private Association fetchAssociationMapcontext(long topicmapId, long assocId) {
        return this.dmx.getAssociationBetweenTopicAndAssociation(TOPICMAP_CONTEXT, topicmapId, assocId, ROLE_TYPE_TOPICMAP, ROLE_TYPE_CONTENT);
    }

    private void createTopicMapcontext(long topicmapId, long topicId, ViewProps viewProps) {
        Association topicMapcontext = this.dmx.createAssociation(this.mf.newAssociationModel(TOPICMAP_CONTEXT, (RoleModel)this.mf.newTopicRoleModel(topicmapId, ROLE_TYPE_TOPICMAP), (RoleModel)this.mf.newTopicRoleModel(topicId, ROLE_TYPE_CONTENT)));
        this.storeViewProps(topicMapcontext, viewProps);
        ViewTopic topic = this.mf.newViewTopic(this.dmx.getTopic(topicId).getModel(), viewProps);
        this.me.addTopicToTopicmap(topicmapId, topic);
    }

    private void createAssociationMapcontext(long topicmapId, long assocId, ViewProps viewProps) {
        Association assocMapcontext = this.dmx.createAssociation(this.mf.newAssociationModel(TOPICMAP_CONTEXT, (RoleModel)this.mf.newTopicRoleModel(topicmapId, ROLE_TYPE_TOPICMAP), (RoleModel)this.mf.newAssociationRoleModel(assocId, ROLE_TYPE_CONTENT)));
        this.storeViewProps(assocMapcontext, viewProps);
        ViewAssoc assoc = this.mf.newViewAssoc(this.dmx.getAssociation(assocId).getModel(), viewProps);
        this.me.addAssociationToTopicmap(topicmapId, assoc);
    }

    private void hideAssocsWithPlayer(DMXObject player, long topicmapId) {
        for (Association assoc : player.getAssociations()) {
            Association topicmapContext = this.fetchAssociationMapcontext(topicmapId, assoc.getId());
            if (topicmapContext == null) continue;
            this.storeViewProps(topicmapContext, this.mf.newViewProps(false));
            this.hideAssocsWithPlayer((DMXObject)assoc, topicmapId);
        }
    }

    private void deleteAssociationMapcontext(Association assocMapcontext) {
        this.dmx.getAccessControl().deleteAssociationMapcontext(assocMapcontext);
    }

    private void invokeViewmodelCustomizers(RelatedTopic topic, ViewProps viewProps) {
        for (ViewmodelCustomizer customizer : this.viewmodelCustomizers) {
            this.invokeViewmodelCustomizer(customizer, topic, viewProps);
        }
    }

    private void invokeViewmodelCustomizer(ViewmodelCustomizer customizer, RelatedTopic topic, ViewProps viewProps) {
        try {
            customizer.enrichViewProps(topic, viewProps);
        }
        catch (Exception e) {
            throw new RuntimeException("Invoking viewmodel customizer for topic " + topic.getId() + " failed (customizer=\"" + customizer.getClass().getName() + "\")", e);
        }
    }

    private TopicmapType getTopicmapType(String topicmapTypeUri) {
        TopicmapType topicmapType = this.topicmapTypes.get(topicmapTypeUri);
        if (topicmapType == null) {
            throw new RuntimeException("Topicmap type \"" + topicmapTypeUri + "\" not registered");
        }
        return topicmapType;
    }

    private InputStream invokeWebclient() {
        return this.dmx.getPlugin("systems.dmx.webclient").getStaticResource("/web/index.html");
    }
}

