/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.topicmaps;

import java.util.Map;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.JSONEnabled;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.model.topicmaps.ViewAssoc;
import systems.dmx.core.model.topicmaps.ViewProps;
import systems.dmx.core.model.topicmaps.ViewTopic;
import systems.dmx.core.util.DMXUtils;

public class Topicmap
implements JSONEnabled {
    private TopicModel topicmapTopic;
    private ViewProps viewProps;
    private Map<Long, ViewTopic> topics;
    private Map<Long, ViewAssoc> assocs;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    Topicmap(TopicModel topicmapTopic, ViewProps viewProps, Map<Long, ViewTopic> topics, Map<Long, ViewAssoc> assocs) {
        this.topicmapTopic = topicmapTopic;
        this.viewProps = viewProps;
        this.topics = topics;
        this.assocs = assocs;
    }

    public long getId() {
        return this.topicmapTopic.getId();
    }

    public Iterable<ViewTopic> getTopics() {
        return this.topics.values();
    }

    public Iterable<ViewAssoc> getAssociations() {
        return this.assocs.values();
    }

    public ViewTopic getTopic(long id) {
        return this.topics.get(id);
    }

    public ViewAssoc getAssociation(long id) {
        return this.assocs.get(id);
    }

    public JSONObject toJSON() {
        try {
            return new JSONObject().put("topic", (Object)this.topicmapTopic.toJSON()).put("viewProps", (Object)this.viewProps.toJSON()).put("topics", (Object)DMXUtils.toJSONArray(this.topics.values())).put("assocs", (Object)DMXUtils.toJSONArray(this.assocs.values()));
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed", e);
        }
    }

    public String toString() {
        return "topicmap " + this.getId();
    }
}

