/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.websocket.WebSocket;
import systems.dmx.core.impl.CoreEvent;
import systems.dmx.core.impl.WebSocketConnectionPool;
import systems.dmx.core.service.CoreService;

class WebSocketConnection
implements WebSocket,
WebSocket.OnTextMessage,
WebSocket.OnBinaryMessage {
    String pluginUri;
    String sessionId;
    private WebSocket.Connection connection;
    private WebSocketConnectionPool pool;
    private CoreService dmx;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    WebSocketConnection(String pluginUri, String sessionId, WebSocketConnectionPool pool, CoreService dmx) {
        this.pluginUri = pluginUri;
        this.sessionId = sessionId;
        this.pool = pool;
        this.dmx = dmx;
    }

    public void onOpen(WebSocket.Connection connection) {
        this.logger.info("Opening a WebSocket connection for plugin \"" + this.pluginUri + "\" (session " + this.sessionId + ")");
        this.connection = connection;
        this.pool.add(this);
    }

    public void onClose(int code, String message) {
        this.logger.info("Closing a WebSocket connection of plugin \"" + this.pluginUri + "\" (session " + this.sessionId + ")");
        this.pool.remove(this);
    }

    public void onMessage(String message) {
        try {
            this.dmx.dispatchEvent(this.pluginUri, CoreEvent.WEBSOCKET_TEXT_MESSAGE, message);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "An error occurred while dispatching a WebSocket message to plugin \"" + this.pluginUri + "\":", e);
        }
    }

    public void onMessage(byte[] data, int offset, int length) {
    }

    void sendMessage(String message) {
        try {
            this.connection.sendMessage(message);
        }
        catch (Exception e) {
            this.pool.remove(this);
            this.logger.log(Level.SEVERE, "Sending message via " + this + " failed -- connection removed", e);
        }
    }
}

