/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.List;
import java.util.logging.Logger;
import systems.dmx.core.impl.DMXObjectModelImpl;
import systems.dmx.core.impl.PersistenceLayer;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.CompDefModel;
import systems.dmx.core.model.DMXObjectModel;

class ChildTopicsFetcher {
    private PersistenceLayer pl;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    ChildTopicsFetcher(PersistenceLayer pl) {
        this.pl = pl;
    }

    void fetch(DMXObjectModel object, CompDefModel assocDef, boolean deep) {
        block7: {
            try {
                ChildTopicsModel childTopics = object.getChildTopicsModel();
                String cardinalityUri = assocDef.getChildCardinalityUri();
                String assocDefUri = assocDef.getAssocDefUri();
                if (cardinalityUri.equals("dmx.core.one")) {
                    RelatedTopicModelImpl childTopic = this.fetchChildTopic(object.getId(), assocDef);
                    if (childTopic != null) {
                        childTopics.put(assocDefUri, childTopic);
                        if (deep) {
                            this.fetchChildTopics(childTopic, deep);
                        }
                    }
                    break block7;
                }
                if (cardinalityUri.equals("dmx.core.many")) {
                    for (RelatedTopicModelImpl childTopic : this.fetchChildTopics(object.getId(), assocDef)) {
                        childTopics.add(assocDefUri, childTopic);
                        if (!deep) continue;
                        this.fetchChildTopics(childTopic, deep);
                    }
                    break block7;
                }
                throw new RuntimeException("\"" + cardinalityUri + "\" is an unexpected cardinality URI");
            }
            catch (Exception e) {
                throw new RuntimeException("Fetching the \"" + assocDef.getAssocDefUri() + "\" child topics of object " + object.getId() + " failed", e);
            }
        }
    }

    private void fetchChildTopics(DMXObjectModelImpl object, boolean deep) {
        for (CompDefModel compDefModel : object.getType().getAssocDefs()) {
            this.fetch(object, compDefModel, deep);
        }
    }

    private RelatedTopicModelImpl fetchChildTopic(long objectId, CompDefModel assocDef) {
        return this.pl.fetchRelatedTopic(objectId, assocDef.getInstanceLevelAssocTypeUri(), "dmx.core.parent", "dmx.core.child", assocDef.getChildTypeUri());
    }

    private List<RelatedTopicModelImpl> fetchChildTopics(long objectId, CompDefModel assocDef) {
        return this.pl.fetchRelatedTopics(objectId, assocDef.getInstanceLevelAssocTypeUri(), "dmx.core.parent", "dmx.core.child", assocDef.getChildTypeUri());
    }
}

