/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.JSONEnabled;
import systems.dmx.core.impl.AssociationModelImpl;
import systems.dmx.core.impl.CompDefModelImpl;
import systems.dmx.core.impl.DMXObjectModelImpl;
import systems.dmx.core.impl.DMXTypeImpl;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.impl.ViewConfigurationModelImpl;
import systems.dmx.core.model.AssociationModel;
import systems.dmx.core.model.CompDefModel;
import systems.dmx.core.model.DMXObjectModel;
import systems.dmx.core.model.TypeModel;
import systems.dmx.core.model.ViewConfigurationModel;
import systems.dmx.core.service.Directive;
import systems.dmx.core.service.Directives;
import systems.dmx.core.util.SequencedHashMap;

class TypeModelImpl
extends TopicModelImpl
implements TypeModel {
    String dataTypeUri;
    SequencedHashMap<String, CompDefModelImpl> compDefs;
    ViewConfigurationModelImpl viewConfig;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    TypeModelImpl(TopicModelImpl typeTopic, String dataTypeUri, List<CompDefModel> compDefs, ViewConfigurationModelImpl viewConfig) {
        super(typeTopic);
        this.dataTypeUri = dataTypeUri;
        this.compDefs = this.toMap(compDefs);
        this.viewConfig = viewConfig;
    }

    TypeModelImpl(TypeModelImpl type) {
        super(type);
        this.dataTypeUri = type.getDataTypeUri();
        this.compDefs = this.toMap(type.getCompDefs());
        this.viewConfig = type.getViewConfig();
    }

    @Override
    public String getDataTypeUri() {
        return this.dataTypeUri;
    }

    @Override
    public void setDataTypeUri(String dataTypeUri) {
        this.dataTypeUri = dataTypeUri;
    }

    public Collection<CompDefModelImpl> getCompDefs() {
        return this.compDefs.values();
    }

    @Override
    public CompDefModelImpl getCompDef(String compDefUri) {
        return this.getCompDefOrThrow(compDefUri);
    }

    @Override
    public boolean hasCompDef(String compDefUri) {
        return this._getCompDef(compDefUri) != null;
    }

    @Override
    public TypeModel addCompDef(CompDefModel compDef) {
        return this.addCompDefBefore(compDef, null);
    }

    @Override
    public TypeModel addCompDefBefore(CompDefModel compDef, String beforeCompDefUri) {
        try {
            String compDefUri = compDef.getCompDefUri();
            CompDefModelImpl existing = this._getCompDef(compDefUri);
            if (existing != null) {
                throw new RuntimeException("Type \"" + this.uri + "\" has a \"" + compDefUri + "\" assoc def already");
            }
            this.compDefs.putBefore(compDefUri, (CompDefModelImpl)compDef, beforeCompDefUri);
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException("Adding assoc def \"" + compDef.getCompDefUri() + "\" to type \"" + this.uri + "\" failed (compDef=" + compDef + ", beforeCompDefUri=\"" + beforeCompDefUri + "\")", e);
        }
    }

    @Override
    public CompDefModel removeCompDef(String compDefUri) {
        try {
            CompDefModel compDef = (CompDefModel)this.compDefs.remove(compDefUri);
            if (compDef == null) {
                throw new RuntimeException("Assoc def \"" + compDefUri + "\" not found in " + this.compDefs.keySet());
            }
            return compDef;
        }
        catch (Exception e) {
            throw new RuntimeException("Removing assoc def \"" + compDefUri + "\" from type \"" + this.uri + "\" failed", e);
        }
    }

    @Override
    public ViewConfigurationModelImpl getViewConfig() {
        return this.viewConfig;
    }

    @Override
    public Object getViewConfigValue(String configTypeUri, String childTypeUri) {
        return this.viewConfig.getConfigValue(configTypeUri, childTypeUri);
    }

    @Override
    public void setViewConfig(ViewConfigurationModel viewConfig) {
        this.viewConfig = (ViewConfigurationModelImpl)viewConfig;
    }

    @Override
    public Iterator<String> iterator() {
        return this.compDefs.keySet().iterator();
    }

    @Override
    public JSONObject toJSON() {
        try {
            return super.toJSON().put("dataTypeUri", (Object)this.dataTypeUri).put("compDefs", (Object)this.toJSONArray(this.compDefs.values())).put("viewConfigTopics", (Object)this.viewConfig.toJSONArray());
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed", e);
        }
    }

    @Override
    public TypeModelImpl clone() {
        try {
            TypeModelImpl model = (TypeModelImpl)super.clone();
            model.compDefs = (SequencedHashMap)model.compDefs.clone();
            return model;
        }
        catch (Exception e) {
            throw new RuntimeException("Cloning a TypeModel failed", e);
        }
    }

    @Override
    DMXTypeImpl instantiate() {
        throw new UnsupportedOperationException();
    }

    List<? extends DMXObjectModelImpl> getAllInstances() {
        throw new UnsupportedOperationException();
    }

    Directive getUpdateTypeDirective() {
        throw new UnsupportedOperationException();
    }

    Directive getDeleteTypeDirective() {
        throw new UnsupportedOperationException();
    }

    @Override
    void preUpdate(DMXObjectModel updateModel) {
        if (this.uriChange(updateModel.getUri(), this.uri)) {
            this.removeFromTypeCache();
        }
    }

    @Override
    void postUpdate(DMXObjectModel updateModel, DMXObjectModel oldObject) {
        if (this.uriChange(updateModel.getUri(), oldObject.getUri())) {
            this.putInTypeCache();
        }
        this.updateType((TypeModelImpl)updateModel);
        this.addUpdateTypeDirective();
    }

    @Override
    void preDelete() {
        String compDefUri;
        int size = this.getAllInstances().size();
        if (size > 0) {
            throw new RuntimeException(size + " \"" + this.value + "\" instances still exist");
        }
        while ((compDefUri = this.getFirstCompDefUri()) != null) {
            this._getCompDef(compDefUri).delete();
        }
    }

    @Override
    void postDelete() {
        super.postDelete();
        this.removeFromTypeCache();
    }

    final void updateDataTypeUri(String dataTypeUri) {
        this.setDataTypeUri(dataTypeUri);
        this.storeDataTypeUri();
    }

    final void _addCompDefBefore(CompDefModelImpl compDef, String beforeCompDefUri) {
        try {
            long lastCompDefId = this.lastCompDefId();
            this.addCompDefBefore(compDef, beforeCompDefUri);
            long beforeCompDefId = beforeCompDefUri != null ? this.getCompDef(beforeCompDefUri).getId() : -1L;
            long firstCompDefId = this.firstCompDefId();
            this.pl.typeStorage.addCompDefToSequence(this.id, compDef.id, beforeCompDefId, firstCompDefId, lastCompDefId);
        }
        catch (Exception e) {
            throw new RuntimeException("Adding assoc def \"" + compDef.getCompDefUri() + "\" to type \"" + this.uri + "\" failed (compDef=" + compDef + ", beforeCompDefUri=\"" + beforeCompDefUri + "\")", e);
        }
    }

    final void _removeCompDef(String compDefUri) {
        this.getCompDef(compDefUri).delete();
    }

    final void _addCompDef(AssociationModelImpl assoc) {
        CompDefModelImpl compDef = this.pl.typeStorage.newCompDefModel(assoc);
        this.pl.typeStorage.storeViewConfig(compDef);
        this._addCompDefBefore(compDef, null);
        this.addUpdateTypeDirective();
    }

    final void _updateCompDef(AssociationModel assoc, AssociationModel oldAssoc) {
        String oldCompDefUri;
        String[] assocDefUris = this.findCompDefUris(assoc.getId());
        CompDefModelImpl compDef = this.getCompDef(assocDefUris[0]);
        if (assoc == compDef) {
            oldCompDefUri = ((CompDefModel)oldAssoc).getCompDefUri();
        } else {
            oldCompDefUri = compDef.getCompDefUri();
            compDef.setTypeUri(assoc.getTypeUri());
            compDef.setSimpleValue(assoc.getSimpleValue());
            compDef.setChildTopicsModel(assoc.getChildTopicsModel());
        }
        if (!compDef.getCompDefUri().equals(oldCompDefUri)) {
            this.rehashCompDef(oldCompDefUri, assocDefUris[1]);
        }
        this.addUpdateTypeDirective();
    }

    final void _removeCompDefFromMemoryAndRebuildSequence(AssociationModel assoc) {
        String[] assocDefUris = this.findCompDefUris(assoc.getId());
        String compDefUri = this.getCompDef(assocDefUris[0]).getCompDefUri();
        this.removeCompDef(compDefUri);
        this.pl.typeStorage.rebuildSequence(this);
        this.addUpdateTypeDirective();
    }

    final List<String> getIdentityAttrs() {
        try {
            ArrayList<String> identityAttrs = new ArrayList<String>();
            for (String compDefUri : this) {
                if (!this.getCompDef(compDefUri).isIdentityAttr()) continue;
                identityAttrs.add(compDefUri);
            }
            return identityAttrs;
        }
        catch (Exception e) {
            throw new RuntimeException("Calculating the identity configuration for type \"" + this.uri + "\" failed", e);
        }
    }

    final List<String> getLabelCompDefUris() {
        List<String> labelConfig = this.getLabelConfig();
        if (labelConfig.size() > 0) {
            return labelConfig;
        }
        ArrayList<String> assocDefUris = new ArrayList<String>();
        Iterator<CompDefModelImpl> i = this.getCompDefs().iterator();
        if (i.hasNext()) {
            assocDefUris.add(((CompDefModel)i.next()).getCompDefUri());
        }
        return assocDefUris;
    }

    final List<String> getLabelConfig() {
        try {
            ArrayList<String> labelConfig = new ArrayList<String>();
            for (String compDefUri : this) {
                if (!this.getCompDef(compDefUri).includeInLabel()) continue;
                labelConfig.add(compDefUri);
            }
            return labelConfig;
        }
        catch (Exception e) {
            throw new RuntimeException("Calculating the label configuration for type \"" + this.uri + "\" failed", e);
        }
    }

    final <M extends TypeModelImpl> M filterReadableCompDefs() {
        try {
            Iterator<String> i = this.iterator();
            while (i.hasNext()) {
                String compDefUri = i.next();
                if (this._getCompDef(compDefUri).isReadable()) continue;
                i.remove();
            }
            return (M)this;
        }
        catch (Exception e) {
            throw new RuntimeException("Filtering readable assoc defs of type \"" + this.uri + "\" failed", e);
        }
    }

    private void addUpdateTypeDirective() {
        Directives.get().add(this.getUpdateTypeDirective(), this.instantiate());
    }

    private void updateType(TypeModelImpl updateModel) {
        this._updateDataTypeUri(updateModel.getDataTypeUri());
        this._updateCompDefs(updateModel.getCompDefs());
        this._updateSequence(updateModel.getCompDefs());
    }

    private void _updateDataTypeUri(String newDataTypeUri) {
        String dataTypeUri;
        if (newDataTypeUri != null && !(dataTypeUri = this.getDataTypeUri()).equals(newDataTypeUri)) {
            this.logger.info("### Changing data type URI: \"" + dataTypeUri + "\" -> \"" + newDataTypeUri + "\"");
            this.updateDataTypeUri(newDataTypeUri);
        }
    }

    private void _updateCompDefs(Collection<CompDefModelImpl> newCompDefs) {
        for (CompDefModelImpl compDef : newCompDefs) {
            String[] assocDefUris = this.findCompDefUris(compDef.getId());
            this.getCompDef(assocDefUris[0]).update(compDef);
        }
    }

    private void _updateSequence(Collection<CompDefModelImpl> newCompDefs) {
        try {
            this.logger.info("##### Updating sequence (" + newCompDefs.size() + "/" + this.getCompDefs().size() + " assoc defs)");
            this.rehashCompDefs(newCompDefs);
            this.pl.typeStorage.rebuildSequence(this);
        }
        catch (Exception e) {
            throw new RuntimeException("Updating the assoc def sequence failed", e);
        }
    }

    private void storeDataTypeUri() {
        this.getRelatedTopic("dmx.core.composition", "dmx.core.type", "dmx.core.default", "dmx.core.data_type").getRelatingAssociation().delete();
        this.pl.typeStorage.storeDataType(this.uri, this.dataTypeUri);
    }

    private String[] findCompDefUris(long assocDefId) {
        if (assocDefId == -1L) {
            throw new IllegalArgumentException("findCompDefUris() called with assocDefId=-1");
        }
        String[] assocDefUris = new String[2];
        Iterator<String> i = this.iterator();
        while (i.hasNext()) {
            String compDefUri = i.next();
            long _assocDefId = this.checkCompDefId(this._getCompDef(compDefUri));
            if (_assocDefId != assocDefId) continue;
            assocDefUris[0] = compDefUri;
            if (!i.hasNext()) break;
            assocDefUris[1] = i.next();
            break;
        }
        if (assocDefUris[0] == null) {
            throw new RuntimeException("Assoc def " + assocDefId + " not found in assoc defs of type \"" + this.uri + "\" (" + this.compDefs.keySet() + ")");
        }
        return assocDefUris;
    }

    private boolean hasSameCompDefSequence(Collection<? extends CompDefModel> compDefs) {
        Collection<CompDefModelImpl> _assocDefs = this.getCompDefs();
        if (compDefs.size() != _assocDefs.size()) {
            return false;
        }
        Iterator<? extends CompDefModel> i = compDefs.iterator();
        for (CompDefModel compDefModel : _assocDefs) {
            long _assocDefId;
            CompDefModel compDef = i.next();
            long assocDefId = this.checkCompDefId(compDef);
            if (assocDefId == (_assocDefId = this.checkCompDefId(compDefModel))) continue;
            return false;
        }
        return true;
    }

    private void rehashCompDefs(Collection<CompDefModelImpl> newCompDefs) {
        for (CompDefModel compDefModel : newCompDefs) {
            this.rehashCompDef(compDefModel.getCompDefUri(), null);
        }
    }

    private void rehashCompDef(String compDefUri, String beforeCompDefUri) {
        CompDefModel compDef = this.removeCompDef(compDefUri);
        this.logger.info("Rehashing assoc def \"" + compDefUri + "\" -> \"" + compDef.getCompDefUri() + "\" (put " + (beforeCompDefUri != null ? "before \"" + beforeCompDefUri + "\"" : "at end") + ")");
        this.addCompDefBefore(compDef, beforeCompDefUri);
    }

    private CompDefModelImpl getCompDefOrThrow(String compDefUri) {
        CompDefModelImpl compDef = this._getCompDef(compDefUri);
        if (compDef == null) {
            throw new RuntimeException("Assoc def \"" + compDefUri + "\" not found in " + this.compDefs.keySet());
        }
        return compDef;
    }

    private CompDefModelImpl _getCompDef(String compDefUri) {
        return (CompDefModelImpl)this.compDefs.get(compDefUri);
    }

    private long lastCompDefId() {
        long lastCompDefId = -1L;
        for (CompDefModel compDefModel : this.getCompDefs()) {
            lastCompDefId = compDefModel.getId();
        }
        return lastCompDefId;
    }

    private long firstCompDefId() {
        return this.getCompDefs().iterator().next().getId();
    }

    private String getFirstCompDefUri() {
        Iterator<String> i = this.iterator();
        return i.hasNext() ? i.next() : null;
    }

    private long checkCompDefId(CompDefModel compDef) {
        long assocDefId = compDef.getId();
        if (assocDefId == -1L) {
            throw new RuntimeException("The assoc def ID is uninitialized (-1): " + compDef);
        }
        return assocDefId;
    }

    private SequencedHashMap<String, CompDefModelImpl> toMap(Collection<? extends CompDefModel> compDefs) {
        SequencedHashMap<String, CompDefModelImpl> _assocDefs = new SequencedHashMap<String, CompDefModelImpl>();
        for (CompDefModel compDefModel : compDefs) {
            _assocDefs.put(compDefModel.getCompDefUri(), (CompDefModelImpl)compDefModel);
        }
        return _assocDefs;
    }

    private void putInTypeCache() {
        this.pl.typeStorage.putInTypeCache(this);
    }

    private void removeFromTypeCache() {
        this.pl.typeStorage.removeFromTypeCache(this.uri);
        Directive dir = this.getDeleteTypeDirective();
        Directives.get().add(dir, new JSONWrapper("uri", this.uri));
    }

    private JSONArray toJSONArray(Collection<? extends CompDefModel> compDefs) {
        JSONArray _assocDefs = new JSONArray();
        for (CompDefModel compDefModel : compDefs) {
            _assocDefs.put((Object)compDefModel.toJSON());
        }
        return _assocDefs;
    }

    private static final class JSONWrapper
    implements JSONEnabled {
        private JSONObject wrapped;

        private JSONWrapper(String key, Object value) {
            try {
                this.wrapped = new JSONObject();
                this.wrapped.put(key, value);
            }
            catch (Exception e) {
                throw new RuntimeException("Constructing a JSONWrapper failed", e);
            }
        }

        @Override
        public JSONObject toJSON() {
            return this.wrapped;
        }
    }
}

