/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.List;
import java.util.logging.Logger;
import systems.dmx.core.impl.DMXObjectModelImpl;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicModel;

class LabelCalculation {
    private static final String LABEL_CHILD_SEPARATOR = " ";
    private static final String LABEL_TOPIC_SEPARATOR = ", ";
    private DMXObjectModelImpl comp;
    private List<String> labelCompDefUris;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    LabelCalculation(DMXObjectModelImpl comp) {
        this.comp = comp;
        this.labelCompDefUris = comp.getType().getLabelCompDefUris();
    }

    void calculate() {
        try {
            StringBuilder builder = new StringBuilder();
            for (String compDefUri : this.labelCompDefUris) {
                this.comp.loadChildTopics(compDefUri, false);
                this.appendLabel(this.calculateChildLabel(compDefUri), builder, LABEL_CHILD_SEPARATOR);
            }
            this.comp._updateSimpleValue(new SimpleValue(builder.toString()));
        }
        catch (Exception e) {
            throw new RuntimeException("Calculating and updating label of " + this.comp.objectInfo() + " failed (assoc defs involved: " + this.labelCompDefUris + ")", e);
        }
    }

    private String calculateChildLabel(String compDefUri) {
        Object value = this.comp.getChildTopicsModel().get(compDefUri);
        if (value == null) {
            return "";
        }
        if (value instanceof TopicModel) {
            return ((TopicModel)value).getSimpleValue().toString();
        }
        if (value instanceof List) {
            StringBuilder builder = new StringBuilder();
            for (TopicModel childTopic : (List)value) {
                this.appendLabel(childTopic.getSimpleValue().toString(), builder, LABEL_TOPIC_SEPARATOR);
            }
            return builder.toString();
        }
        throw new RuntimeException("Unexpected value in a ChildTopicsModel: " + value);
    }

    private void appendLabel(String label, StringBuilder builder, String separator) {
        if (builder.length() > 0 && label.length() > 0) {
            builder.append(separator);
        }
        builder.append(label);
    }
}

