/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.files;

import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import systems.dmx.config.ConfigDefinition;
import systems.dmx.config.ConfigModificationRole;
import systems.dmx.config.ConfigService;
import systems.dmx.config.ConfigTarget;
import systems.dmx.core.Assoc;
import systems.dmx.core.DMXObject;
import systems.dmx.core.Topic;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.RoleModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Cookies;
import systems.dmx.core.service.DMXEvent;
import systems.dmx.core.service.EventListener;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.service.accesscontrol.AccessControl;
import systems.dmx.core.service.accesscontrol.Operation;
import systems.dmx.core.service.event.StaticResourceFilterListener;
import systems.dmx.core.util.DMXUtils;
import systems.dmx.core.util.JavaUtils;
import systems.dmx.files.DirectoryListing;
import systems.dmx.files.FileRepositoryException;
import systems.dmx.files.FilesService;
import systems.dmx.files.PathMapper;
import systems.dmx.files.ResourceInfo;
import systems.dmx.files.StoredFile;
import systems.dmx.files.UploadedFile;
import systems.dmx.files.event.CheckDiskQuotaListener;

@Path(value="/files")
@Produces(value={"application/json"})
public class FilesPlugin
extends PluginActivator
implements FilesService,
StaticResourceFilterListener,
PathMapper {
    public static final String FILE_REPOSITORY_PATH = System.getProperty("dmx.filerepo.path", "/");
    public static final boolean FILE_REPOSITORY_PER_WORKSPACE = Boolean.getBoolean("dmx.filerepo.per_workspace");
    public static final int DISK_QUOTA_MB = Integer.getInteger("dmx.filerepo.disk_quota", -1);
    private static final String FILE_REPOSITORY_URI = "/filerepo";
    private static final String WORKSPACE_DIRECTORY_PREFIX = "/workspace-";
    private static final Pattern PER_WORKSPACE_PATH_PATTERN = Pattern.compile("/workspace-(\\d+).*");
    public static DMXEvent CHECK_DISK_QUOTA = new DMXEvent(CheckDiskQuotaListener.class){

        public void dispatch(EventListener listener, Object ... params) {
            ((CheckDiskQuotaListener)listener).checkDiskQuota((String)params[0], (Long)params[1], (Long)params[2]);
        }
    };
    @Inject
    private ConfigService configService;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    @GET
    @Path(value="/file/{path}")
    @Transactional
    public Topic getFileTopic(@PathParam(value="path") String repoPath) {
        String operation = "Creating File topic for repository path \"" + repoPath + "\"";
        try {
            this.logger.info(operation);
            File file = this.absolutePath(repoPath);
            this.checkExistence(file);
            Topic fileTopic = this.fetchFileTopic(this.repoPath(file));
            if (fileTopic != null) {
                this.logger.info(operation + " SKIPPED -- already exists");
                return fileTopic.loadChildTopics();
            }
            return this.createFileTopic(file);
        }
        catch (FileRepositoryException e) {
            throw new WebApplicationException((Throwable)new RuntimeException(operation + " failed", e), e.getStatus());
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed", e);
        }
    }

    @Override
    @GET
    @Path(value="/folder/{path}")
    @Transactional
    public Topic getFolderTopic(@PathParam(value="path") String repoPath) {
        String operation = "Creating Folder topic for repository path \"" + repoPath + "\"";
        try {
            this.logger.info(operation);
            File file = this.absolutePath(repoPath);
            this.checkExistence(file);
            Topic folderTopic = this.fetchFolderTopic(this.repoPath(file));
            if (folderTopic != null) {
                this.logger.info(operation + " SKIPPED -- already exists");
                return folderTopic.loadChildTopics();
            }
            return this.createFolderTopic(file);
        }
        catch (FileRepositoryException e) {
            throw new WebApplicationException((Throwable)new RuntimeException(operation + " failed", e), e.getStatus());
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed", e);
        }
    }

    @Override
    @GET
    @Path(value="/parent/{id}/file/{path}")
    @Transactional
    public Topic getChildFileTopic(@PathParam(value="id") long folderTopicId, @PathParam(value="path") String repoPath) {
        Topic topic = this.getFileTopic(repoPath);
        this.createFolderAssociation(folderTopicId, topic);
        return topic;
    }

    @Override
    @GET
    @Path(value="/parent/{id}/folder/{path}")
    @Transactional
    public Topic getChildFolderTopic(@PathParam(value="id") long folderTopicId, @PathParam(value="path") String repoPath) {
        Topic topic = this.getFolderTopic(repoPath);
        this.createFolderAssociation(folderTopicId, topic);
        return topic;
    }

    @Override
    @POST
    @Path(value="/{path}")
    @Consumes(value={"multipart/form-data"})
    @Transactional
    public StoredFile storeFile(UploadedFile file, @PathParam(value="path") String repoPath) {
        String operation = "Storing " + file + " at repository path \"" + repoPath + "\"";
        try {
            this.logger.info(operation);
            File directory = this.absolutePath(repoPath);
            this.checkExistence(directory);
            File repoFile = this.unusedPath(directory, file);
            file.write(repoFile);
            Topic fileTopic = this.createFileTopic(repoFile);
            return new StoredFile(repoFile.getName(), this.repoPath(fileTopic), fileTopic.getId());
        }
        catch (FileRepositoryException e) {
            throw new WebApplicationException((Throwable)new RuntimeException(operation + " failed", e), e.getStatus());
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed", e);
        }
    }

    @Override
    public Topic createFile(InputStream in, String repoPath) {
        String operation = "Creating file (from input stream) at repository path \"" + repoPath + "\"";
        try {
            this.logger.info(operation);
            File file = this.absolutePath(repoPath);
            FileOutputStream out = new FileOutputStream(file);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            in.close();
            out.close();
            return this.getFileTopic(repoPath);
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed", e);
        }
    }

    @Override
    @POST
    @Path(value="/{path}/folder/{folder_name}")
    public void createFolder(@PathParam(value="folder_name") String folderName, @PathParam(value="path") String repoPath) {
        String operation = "Creating folder \"" + folderName + "\" at repository path \"" + repoPath + "\"";
        try {
            this.logger.info(operation);
            File directory = this.absolutePath(repoPath);
            this.checkExistence(directory);
            File repoFile = this.path(directory, folderName);
            if (repoFile.exists()) {
                throw new RuntimeException("File or directory \"" + repoFile + "\" already exists");
            }
            boolean success = repoFile.mkdir();
            if (!success) {
                throw new RuntimeException("File.mkdir() failed (file=\"" + repoFile + "\")");
            }
        }
        catch (FileRepositoryException e) {
            throw new WebApplicationException((Throwable)new RuntimeException(operation + " failed", e), e.getStatus());
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed", e);
        }
    }

    @Override
    @GET
    @Path(value="/{path}/info")
    public ResourceInfo getResourceInfo(@PathParam(value="path") String repoPath) {
        String operation = "Getting resource info for repository path \"" + repoPath + "\"";
        try {
            this.logger.info(operation);
            File file = this.absolutePath(repoPath);
            this.checkExistence(file);
            return new ResourceInfo(file);
        }
        catch (FileRepositoryException e) {
            throw new WebApplicationException((Throwable)new RuntimeException(operation + " failed", e), e.getStatus());
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed", e);
        }
    }

    @Override
    @GET
    @Path(value="/{path}")
    public DirectoryListing getDirectoryListing(@PathParam(value="path") String repoPath) {
        String operation = "Getting directory listing for repository path \"" + repoPath + "\"";
        try {
            this.logger.info(operation);
            File directory = this.absolutePath(repoPath);
            this.checkExistence(directory);
            return new DirectoryListing(directory, this);
        }
        catch (FileRepositoryException e) {
            throw new WebApplicationException((Throwable)new RuntimeException(operation + " failed", e), e.getStatus());
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed", e);
        }
    }

    @Override
    public String getRepositoryPath(URL url) {
        String operation = "Checking for file repository URL (\"" + url + "\")";
        try {
            if (!DMXUtils.isDMXURL((URL)url)) {
                this.logger.info(operation + " => null");
                return null;
            }
            String path = url.getPath();
            if (!path.startsWith(FILE_REPOSITORY_URI)) {
                this.logger.info(operation + " => null");
                return null;
            }
            String repoPath = path.substring(FILE_REPOSITORY_URI.length());
            this.logger.info(operation + " => \"" + repoPath + "\"");
            return repoPath;
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed", e);
        }
    }

    @Override
    public File getFile(String repoPath) {
        String operation = "Accessing the file/directory at repository path \"" + repoPath + "\"";
        try {
            this.logger.info(operation);
            File file = this.absolutePath(repoPath);
            this.checkExistence(file);
            return file;
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed", e);
        }
    }

    @Override
    public File getFile(long fileTopicId) {
        String operation = "Accessing the file/directory of File/Folder topic " + fileTopicId;
        try {
            this.logger.info(operation);
            String repoPath = this.repoPath(fileTopicId);
            File file = this.absolutePath(repoPath);
            this.checkExistence(file);
            return file;
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed", e);
        }
    }

    @Override
    public boolean fileExists(String repoPath) {
        String operation = "Checking existence of file/directory at repository path \"" + repoPath + "\"";
        try {
            this.logger.info(operation);
            File file = this.absolutePath(repoPath);
            return file.exists();
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed", e);
        }
    }

    @Override
    public String pathPrefix() {
        String operation = "Constructing the repository path prefix";
        try {
            return FILE_REPOSITORY_PER_WORKSPACE ? this._pathPrefix(this.getWorkspaceId()) : "";
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed", e);
        }
    }

    @Override
    public String pathPrefix(long workspaceId) {
        return FILE_REPOSITORY_PER_WORKSPACE ? this._pathPrefix(workspaceId) : "";
    }

    @Override
    @GET
    @Path(value="/open/{id}")
    public int openFile(@PathParam(value="id") long fileTopicId) {
        String operation = "Opening the file of File topic " + fileTopicId;
        try {
            this.logger.info(operation);
            String repoPath = this.repoPath(fileTopicId);
            File file = this.absolutePath(repoPath);
            this.checkExistence(file);
            this.logger.info("### Opening file \"" + file + "\"");
            Desktop.getDesktop().open(file);
            return 0;
        }
        catch (FileRepositoryException e) {
            throw new WebApplicationException((Throwable)new RuntimeException(operation + " failed", e), e.getStatus());
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed", e);
        }
    }

    public void preInstall() {
        this.configService.registerConfigDefinition(new ConfigDefinition(ConfigTarget.TYPE_INSTANCES, "dmx.accesscontrol.username", this.mf.newTopicModel("dmx.files.disk_quota", new SimpleValue(DISK_QUOTA_MB)), ConfigModificationRole.ADMIN));
    }

    public void init() {
        this.publishFileSystem(FILE_REPOSITORY_URI, FILE_REPOSITORY_PATH);
    }

    public void shutdown() {
        if (this.configService != null) {
            this.configService.unregisterConfigDefinition("dmx.files.disk_quota");
        } else {
            this.logger.warning("Config service is already gone");
        }
    }

    public void staticResourceFilter(HttpServletRequest request, HttpServletResponse response) {
        try {
            String repoPath = this.repoPath(request);
            if (repoPath != null) {
                this.logger.fine("### Checking access to repository path \"" + repoPath + "\"");
                File path = this.absolutePath(repoPath);
                this.checkExistence(path);
                this.checkAuthorization(this.repoPath(path), request);
                if (request.getParameter("download") != null) {
                    this.logger.info("### Downloading file \"" + path + "\"");
                    response.setHeader("Content-Disposition", "attachment;filename=" + path.getName());
                }
            }
        }
        catch (FileRepositoryException e) {
            throw new WebApplicationException((Throwable)e, e.getStatus());
        }
    }

    @Override
    public String repoPath(File path) {
        try {
            String repoPath = path.getPath();
            if (!repoPath.startsWith(FILE_REPOSITORY_PATH)) {
                throw new RuntimeException("Absolute path \"" + path + "\" is not a repository path");
            }
            if (!FILE_REPOSITORY_PATH.equals("/") && (repoPath = repoPath.substring(FILE_REPOSITORY_PATH.length())).equals("")) {
                repoPath = "/";
            }
            return repoPath;
        }
        catch (Exception e) {
            throw new RuntimeException("Mapping absolute path \"" + path + "\" to a repository path failed", e);
        }
    }

    private Topic fetchFileTopic(String repoPath) {
        return this.fetchFileOrFolderTopic(repoPath, "dmx.files.file");
    }

    private Topic fetchFolderTopic(String repoPath) {
        return this.fetchFileOrFolderTopic(repoPath, "dmx.files.folder");
    }

    private Topic fetchFileOrFolderTopic(String repoPath, String topicTypeUri) {
        Topic pathTopic = this.fetchPathTopic(repoPath);
        if (pathTopic != null) {
            return pathTopic.getRelatedTopic("dmx.core.composition", "dmx.core.child", "dmx.core.parent", topicTypeUri);
        }
        return null;
    }

    private Topic fetchPathTopic(String repoPath) {
        return this.dmx.getTopicByValue("dmx.files.path", new SimpleValue(repoPath));
    }

    private Topic createFileTopic(File path) throws Exception {
        ChildTopicsModel childTopics = this.mf.newChildTopicsModel().put("dmx.files.file_name", (Object)path.getName()).put("dmx.files.path", (Object)this.repoPath(path)).put("dmx.files.size", (Object)path.length());
        String mediaType = JavaUtils.getFileType((String)path.getName());
        if (mediaType != null) {
            childTopics.put("dmx.files.media_type", (Object)mediaType);
        }
        return this.createFileOrFolderTopic(this.mf.newTopicModel("dmx.files.file", childTopics));
    }

    private Topic createFolderTopic(File path) throws Exception {
        String folderName = null;
        String repoPath = this.repoPath(path);
        File repoPathFile = new File(repoPath);
        if (FILE_REPOSITORY_PER_WORKSPACE && repoPathFile.getParent().equals("/")) {
            String workspaceName;
            folderName = workspaceName = this.dmx.getTopic(this.getWorkspaceId(repoPath)).getSimpleValue().toString();
        }
        if (folderName == null) {
            folderName = repoPathFile.getName();
        }
        return this.createFileOrFolderTopic(this.mf.newTopicModel("dmx.files.folder", this.mf.newChildTopicsModel().put("dmx.files.folder_name", (Object)folderName).put("dmx.files.path", (Object)repoPath)));
    }

    private Topic createFileOrFolderTopic(final TopicModel model) throws Exception {
        Topic topic = (Topic)this.dmx.getAccessControl().runWithoutWorkspaceAssignment((Callable)new Callable<Topic>(){

            @Override
            public Topic call() {
                return FilesPlugin.this.dmx.createTopic(model);
            }
        });
        this.createWorkspaceAssignment((DMXObject)topic, this.repoPath(topic));
        return topic;
    }

    private void createFolderAssociation(final long folderTopicId, Topic topic) {
        try {
            boolean exists;
            final long topicId = topic.getId();
            boolean bl = exists = this.dmx.getAssociations(folderTopicId, topicId, "dmx.core.composition").size() > 0;
            if (!exists) {
                Assoc assoc = (Assoc)this.dmx.getAccessControl().runWithoutWorkspaceAssignment((Callable)new Callable<Assoc>(){

                    @Override
                    public Assoc call() {
                        return FilesPlugin.this.dmx.createAssociation(FilesPlugin.this.mf.newAssociationModel("dmx.core.composition", (RoleModel)FilesPlugin.this.mf.newTopicRoleModel(folderTopicId, "dmx.core.parent"), (RoleModel)FilesPlugin.this.mf.newTopicRoleModel(topicId, "dmx.core.child")));
                    }
                });
                this.createWorkspaceAssignment((DMXObject)assoc, this.repoPath(topic));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Creating association to Folder topic " + folderTopicId + " failed", e);
        }
    }

    private void createWorkspaceAssignment(DMXObject object, String repoPath) {
        try {
            AccessControl ac = this.dmx.getAccessControl();
            long workspaceId = FILE_REPOSITORY_PER_WORKSPACE ? this.getWorkspaceId(repoPath) : ac.getDMXWorkspaceId();
            ac.assignToWorkspace(object, workspaceId);
        }
        catch (Exception e) {
            throw new RuntimeException("Creating workspace assignment for File/Folder topic or folder association failed", e);
        }
    }

    private File absolutePath(String repoPath) throws FileRepositoryException {
        try {
            File repo = new File(FILE_REPOSITORY_PATH);
            if (!repo.exists()) {
                throw new RuntimeException("File repository \"" + repo + "\" does not exist");
            }
            String _repoPath = repoPath;
            if (FILE_REPOSITORY_PER_WORKSPACE) {
                String pathPrefix;
                if (repoPath.equals("/")) {
                    _repoPath = pathPrefix = this._pathPrefix(this.getWorkspaceId());
                } else {
                    pathPrefix = this._pathPrefix(this.getWorkspaceId(repoPath));
                }
                this.createWorkspaceFileRepository(new File(repo, pathPrefix));
            }
            repo = new File(repo, _repoPath);
            return this.checkPath(repo);
        }
        catch (FileRepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Mapping repository path \"" + repoPath + "\" to an absolute path failed", e);
        }
    }

    private File checkPath(File path) throws FileRepositoryException, IOException {
        path = path.getCanonicalFile();
        boolean pointsToRepository = path.getPath().startsWith(FILE_REPOSITORY_PATH);
        this.logger.fine("Checking path \"" + path + "\"\n  dmx.filerepo.path=\"" + FILE_REPOSITORY_PATH + "\" => " + (pointsToRepository ? "PATH OK" : "FORBIDDEN"));
        if (!pointsToRepository) {
            throw new FileRepositoryException("\"" + path + "\" does not point to file repository", Response.Status.FORBIDDEN);
        }
        return path;
    }

    private void checkExistence(File path) throws FileRepositoryException {
        boolean exists = path.exists();
        this.logger.fine("Checking existence of \"" + path + "\" => " + (exists ? "EXISTS" : "NOT FOUND"));
        if (!exists) {
            throw new FileRepositoryException("File or directory \"" + path + "\" does not exist", Response.Status.NOT_FOUND);
        }
    }

    private void checkAuthorization(String repoPath, HttpServletRequest request) throws FileRepositoryException {
        block5: {
            try {
                if (!FILE_REPOSITORY_PER_WORKSPACE) break block5;
                Topic fileTopic = this.fetchFileTopic(repoPath);
                if (fileTopic != null) {
                    String username = this.dmx.getAccessControl().getUsername(request);
                    long fileTopicId = fileTopic.getId();
                    if (!this.dmx.getAccessControl().hasPermission(username, Operation.READ, fileTopicId)) {
                        throw new FileRepositoryException(this.userInfo(username) + " has no READ permission for repository path \"" + repoPath + "\" (File topic ID=" + fileTopicId + ")", Response.Status.UNAUTHORIZED);
                    }
                    break block5;
                }
                throw new RuntimeException("Missing File topic for repository path \"" + repoPath + "\"");
            }
            catch (FileRepositoryException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Checking authorization for repository path \"" + repoPath + "\" failed", e);
            }
        }
    }

    private String userInfo(String username) {
        return "user " + (username != null ? "\"" + username + "\"" : "<anonymous>");
    }

    private File path(File directory, String fileName) {
        return new File(directory, fileName);
    }

    private File unusedPath(File directory, UploadedFile file) {
        return JavaUtils.findUnusedFile((File)this.path(directory, file.getName()));
    }

    private String repoPath(long fileTopicId) {
        return this.repoPath(this.dmx.getTopic(fileTopicId));
    }

    private String repoPath(Topic topic) {
        return topic.getChildTopics().getString("dmx.files.path");
    }

    private String repoPath(HttpServletRequest request) {
        String repoPath = null;
        String requestURI = request.getRequestURI();
        if (requestURI.startsWith(FILE_REPOSITORY_URI)) {
            repoPath = requestURI.substring(FILE_REPOSITORY_URI.length() + 1);
            repoPath = JavaUtils.decodeURIComponent((String)repoPath);
        }
        return repoPath;
    }

    private void createWorkspaceFileRepository(File repo) {
        block3: {
            try {
                if (repo.exists()) break block3;
                if (repo.mkdir()) {
                    this.logger.info("### Per-workspace file repository created: \"" + repo + "\"");
                    break block3;
                }
                throw new RuntimeException("Directory \"" + repo + "\" not created successfully");
            }
            catch (Exception e) {
                throw new RuntimeException("Creating per-workspace file repository failed", e);
            }
        }
    }

    private long getWorkspaceId() {
        Cookies cookies = Cookies.get();
        if (!cookies.has("dmx_workspace_id")) {
            throw new RuntimeException("If \"dmx.filerepo.per_workspace\" is set the request requires a \"dmx_workspace_id\" cookie");
        }
        return cookies.getLong("dmx_workspace_id");
    }

    private long getWorkspaceId(String repoPath) {
        Matcher m = PER_WORKSPACE_PATH_PATTERN.matcher(repoPath);
        if (!m.matches()) {
            throw new RuntimeException("No workspace recognized in repository path \"" + repoPath + "\"");
        }
        long workspaceId = Long.parseLong(m.group(1));
        return workspaceId;
    }

    private String _pathPrefix(long workspaceId) {
        return WORKSPACE_DIRECTORY_PREFIX + workspaceId;
    }
}

