/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.storage.neo4j;

import org.neo4j.graphdb.Node;
import systems.dmx.core.model.RoleModel;
import systems.dmx.core.service.ModelFactory;

enum NodeType {
    TOPIC{

        @Override
        RoleModel createRoleModel(Node node, String roleTypeUri, ModelFactory mf) {
            return mf.newTopicRoleModel(node.getId(), roleTypeUri);
        }

        @Override
        String error(Node node) {
            return "ID " + node.getId() + " refers to an Assoc when the caller expects a Topic";
        }
    }
    ,
    ASSOC{

        @Override
        RoleModel createRoleModel(Node node, String roleTypeUri, ModelFactory mf) {
            return mf.newAssociationRoleModel(node.getId(), roleTypeUri);
        }

        @Override
        String error(Node node) {
            return "ID " + node.getId() + " refers to a Topic when the caller expects an Assoc";
        }
    };


    abstract RoleModel createRoleModel(Node var1, String var2, ModelFactory var3);

    abstract String error(Node var1);

    static NodeType of(Node node) {
        String type = (String)node.getProperty("nodeType");
        return NodeType.valueOf(type.toUpperCase());
    }

    boolean isTypeOf(Node node) {
        return node.getProperty("nodeType", (Object)"").equals(this.stringify());
    }

    String stringify() {
        return this.name().toLowerCase();
    }
}

