/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.List;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.DMXObject;
import systems.dmx.core.impl.AssocModelImpl;
import systems.dmx.core.impl.ChildTopicsFetcher;
import systems.dmx.core.impl.ChildTopicsModelImpl;
import systems.dmx.core.impl.EventManager;
import systems.dmx.core.impl.ModelFactoryImpl;
import systems.dmx.core.impl.PersistenceLayer;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.impl.TypeModelImpl;
import systems.dmx.core.impl.ValueIntegrator;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.CompDefModel;
import systems.dmx.core.model.DMXObjectModel;
import systems.dmx.core.model.RoleModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.service.DMXEvent;
import systems.dmx.core.service.Directive;
import systems.dmx.core.service.Directives;

class DMXObjectModelImpl
implements DMXObjectModel {
    private static final String LABEL_CHILD_SEPARATOR = " ";
    private static final String LABEL_TOPIC_SEPARATOR = ", ";
    long id;
    String uri;
    String typeUri;
    SimpleValue value;
    ChildTopicsModelImpl childTopics;
    PersistenceLayer pl;
    EventManager em;
    ModelFactoryImpl mf;
    Logger logger = Logger.getLogger(this.getClass().getName());

    DMXObjectModelImpl(long id, String uri, String typeUri, SimpleValue value, ChildTopicsModelImpl childTopics, PersistenceLayer pl) {
        this.id = id;
        this.uri = uri;
        this.typeUri = typeUri;
        this.value = value;
        this.childTopics = childTopics != null ? childTopics : pl.mf.newChildTopicsModel();
        this.pl = pl;
        this.em = pl.em;
        this.mf = pl.mf;
    }

    DMXObjectModelImpl(DMXObjectModelImpl object) {
        this(object.getId(), object.getUri(), object.getTypeUri(), object.getSimpleValue(), object.getChildTopicsModel(), object.pl);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public void setUri(String uri) {
        this.uri = uri;
    }

    @Override
    public String getTypeUri() {
        return this.typeUri;
    }

    @Override
    public void setTypeUri(String typeUri) {
        this.typeUri = typeUri;
    }

    @Override
    public SimpleValue getSimpleValue() {
        return this.value;
    }

    @Override
    public void setSimpleValue(String value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    @Override
    public void setSimpleValue(int value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    @Override
    public void setSimpleValue(long value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    @Override
    public void setSimpleValue(boolean value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    @Override
    public void setSimpleValue(SimpleValue value) {
        this.value = value;
    }

    @Override
    public ChildTopicsModelImpl getChildTopicsModel() {
        return this.childTopics;
    }

    @Override
    public void setChildTopicsModel(ChildTopicsModel childTopics) {
        this.childTopics = (ChildTopicsModelImpl)childTopics;
    }

    @Override
    public void set(DMXObjectModel object) {
        this.setId(object.getId());
        this.setUri(object.getUri());
        this.setTypeUri(object.getTypeUri());
        this.setSimpleValue(object.getSimpleValue());
        this.setChildTopicsModel(object.getChildTopicsModel());
    }

    @Override
    public RoleModel createRoleModel(String roleTypeUri) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public JSONObject toJSON() {
        try {
            this.setDefaults();
            return new JSONObject().put("id", this.id).put("uri", (Object)this.uri).put("typeUri", (Object)this.typeUri).put("value", this.value.value()).put("childs", (Object)this.childTopics.toJSON());
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed", e);
        }
    }

    @Override
    public DMXObjectModel clone() {
        try {
            DMXObjectModel object = (DMXObjectModel)super.clone();
            object.setChildTopicsModel(this.childTopics.clone());
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException("Cloning a DMXObjectModel failed", e);
        }
    }

    public boolean equals(Object o) {
        return ((DMXObjectModel)o).getId() == this.id;
    }

    public int hashCode() {
        return Long.valueOf(this.id).hashCode();
    }

    public String toString() {
        try {
            return this.getClass().getSimpleName() + LABEL_CHILD_SEPARATOR + this.toJSON().toString(4);
        }
        catch (Exception e) {
            throw new RuntimeException("Prettyprinting failed", e);
        }
    }

    String className() {
        throw new UnsupportedOperationException();
    }

    DMXObject instantiate() {
        throw new UnsupportedOperationException();
    }

    DMXObjectModelImpl createModelWithChildTopics(ChildTopicsModel childTopics) {
        throw new UnsupportedOperationException();
    }

    TypeModelImpl getType() {
        throw new UnsupportedOperationException();
    }

    List<AssocModelImpl> getAssociations() {
        throw new UnsupportedOperationException();
    }

    RelatedTopicModelImpl getRelatedTopic(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        throw new UnsupportedOperationException();
    }

    List<RelatedTopicModelImpl> getRelatedTopics(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        throw new UnsupportedOperationException();
    }

    List<RelatedTopicModelImpl> getRelatedTopics(List assocTypeUris, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        throw new UnsupportedOperationException();
    }

    void storeUri() {
        throw new UnsupportedOperationException();
    }

    void storeTypeUri() {
        throw new UnsupportedOperationException();
    }

    void storeSimpleValue() {
        throw new UnsupportedOperationException();
    }

    void storeProperty(String propUri, Object propValue, boolean addToIndex) {
        throw new UnsupportedOperationException();
    }

    void removeProperty(String propUri) {
        throw new UnsupportedOperationException();
    }

    void _delete() {
        throw new UnsupportedOperationException();
    }

    void checkReadAccess() {
        throw new UnsupportedOperationException();
    }

    void checkWriteAccess() {
        throw new UnsupportedOperationException();
    }

    DMXEvent getPreUpdateEvent() {
        throw new UnsupportedOperationException();
    }

    DMXEvent getPostUpdateEvent() {
        throw new UnsupportedOperationException();
    }

    DMXEvent getPreDeleteEvent() {
        throw new UnsupportedOperationException();
    }

    DMXEvent getPostDeleteEvent() {
        throw new UnsupportedOperationException();
    }

    Directive getUpdateDirective() {
        throw new UnsupportedOperationException();
    }

    Directive getDeleteDirective() {
        throw new UnsupportedOperationException();
    }

    void preCreate() {
    }

    void postCreate() {
    }

    void preUpdate(DMXObjectModel updateModel) {
    }

    void postUpdate(DMXObjectModel updateModel, DMXObjectModel oldObject) {
    }

    void preDelete() {
    }

    void postDelete() {
    }

    final void updateChildTopics(ChildTopicsModel childTopics) {
        this.update(this.createModelWithChildTopics(childTopics));
    }

    final void updateChildTopics(ChildTopicsModel updateModel, CompDefModel compDef) {
        new ValueIntegrator(this.pl).integrate(this.createModelWithChildTopics(updateModel), this, compDef);
    }

    final void update(DMXObjectModelImpl updateModel) {
        try {
            this.logger.info("Updating " + this.objectInfo() + " (typeUri=\"" + this.typeUri + "\")");
            DMXObjectModel oldObject = this.clone();
            this.em.fireEvent(this.getPreUpdateEvent(), this.instantiate(), updateModel);
            this.preUpdate(updateModel);
            this._updateUri(updateModel.getUri());
            this._updateTypeUri(updateModel.getTypeUri());
            new ValueIntegrator(this.pl).integrate(updateModel, this, null);
            this.postUpdate(updateModel, oldObject);
            DMXObject object = this.instantiate();
            Directives.get().add(this.getUpdateDirective(), object);
            this.em.fireEvent(this.getPostUpdateEvent(), object, updateModel, oldObject);
        }
        catch (Exception e) {
            throw new RuntimeException("Updating " + this.objectInfo() + " failed (typeUri=\"" + this.typeUri + "\")", e);
        }
    }

    final void updateUri(String uri) {
        this.setUri(uri);
        this.storeUri();
    }

    final void updateTypeUri(String typeUri) {
        this.setTypeUri(typeUri);
        this.storeTypeUri();
    }

    final void updateSimpleValue(SimpleValue value) {
        if (value == null) {
            throw new IllegalArgumentException("Tried to set a null SimpleValue (" + this + ")");
        }
        this.setSimpleValue(value);
        this.storeSimpleValue();
    }

    final void delete() {
        try {
            if (this.id == -1L) {
                throw new RuntimeException("ID not initialzed in " + this);
            }
            this.em.fireEvent(this.getPreDeleteEvent(), this.instantiate());
            this.preDelete();
            for (AssocModelImpl assoc : this.getAssociations()) {
                assoc.delete();
            }
            this.logger.info("Deleting " + this.objectInfo() + " (typeUri=\"" + this.typeUri + "\")");
            this._delete();
            this.postDelete();
            Directives.get().add(this.getDeleteDirective(), this);
            this.em.fireEvent(this.getPostDeleteEvent(), this);
        }
        catch (IllegalStateException e) {
            if (e.getMessage().equals("Node[" + this.id + "] has been deleted in this tx")) {
                this.logger.info("### Assoc " + this.id + " has already been deleted in this transaction. This can happen while deleting a topic with associations A1 and A2 while A2 points to A1 (" + this + ")");
            }
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Deleting " + this.objectInfo() + " failed (typeUri=\"" + this.typeUri + "\")", e);
        }
    }

    final DMXObjectModel loadChildTopics(boolean deep) {
        for (CompDefModel compDefModel : this.getType().getCompDefs()) {
            this.loadChildTopics(compDefModel, deep);
        }
        return this;
    }

    final DMXObjectModel loadChildTopics(String compDefUri, boolean deep) {
        try {
            return this.loadChildTopics(this.getCompDef(compDefUri), deep);
        }
        catch (Exception e) {
            throw new RuntimeException("Loading \"" + compDefUri + "\" child topics of " + this.objectInfo() + " failed", e);
        }
    }

    final DMXObjectModel loadChildTopics(CompDefModel compDef, boolean deep) {
        String compDefUri = compDef.getCompDefUri();
        if (!this.childTopics.has(compDefUri)) {
            this.logger.fine("### Loading \"" + compDefUri + "\" child topics of " + this.objectInfo());
            new ChildTopicsFetcher(this.pl).fetch(this, compDef, deep);
        }
        return this;
    }

    final boolean uriChange(String newUri, String compareUri) {
        return newUri != null && !newUri.equals(compareUri);
    }

    final boolean isSimple() {
        String dataTypeUri = this.getType().getDataTypeUri();
        return dataTypeUri.equals("dmx.core.text") || dataTypeUri.equals("dmx.core.html") || dataTypeUri.equals("dmx.core.number") || dataTypeUri.equals("dmx.core.boolean");
    }

    final boolean isHtml() {
        return this.getType().getDataTypeUri().equals("dmx.core.html");
    }

    private void setDefaults() {
        if (this.getUri() == null) {
            this.setUri("");
        }
        if (this.getSimpleValue() == null) {
            this.setSimpleValue("");
        }
    }

    private void _updateUri(String newUri) {
        if (this.uriChange(newUri, this.uri)) {
            this.logger.fine("### Changing URI of " + this.objectInfo() + ": \"" + this.uri + "\" -> \"" + newUri + "\"");
            this.updateUri(newUri);
        }
    }

    private void _updateTypeUri(String newTypeUri) {
        if (newTypeUri != null && !newTypeUri.equals(this.typeUri)) {
            this.logger.fine("### Changing type URI of " + this.objectInfo() + ": \"" + this.typeUri + "\" -> \"" + newTypeUri + "\"");
            this.updateTypeUri(newTypeUri);
        }
    }

    final void _updateSimpleValue(SimpleValue newValue) {
        if (newValue != null && !newValue.equals(this.value)) {
            this.logger.fine("### Changing simple value of " + this.objectInfo() + ": \"" + this.value + "\" -> \"" + newValue + "\"");
            this.updateSimpleValue(newValue);
        }
    }

    private CompDefModel getCompDef(String compDefUri) {
        return this.getType().getCompDef(compDefUri);
    }

    String objectInfo() {
        return this.className() + LABEL_CHILD_SEPARATOR + this.id;
    }
}

