/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.Role;
import systems.dmx.core.impl.AssocModelImpl;
import systems.dmx.core.impl.PersistenceLayer;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.impl.RoleModelImpl;
import systems.dmx.core.impl.TopicRoleImpl;
import systems.dmx.core.model.AssocModel;
import systems.dmx.core.model.TopicRoleModel;

class TopicRoleModelImpl
extends RoleModelImpl
implements TopicRoleModel {
    String topicUri;

    TopicRoleModelImpl(long topicId, String roleTypeUri, PersistenceLayer pl) {
        this(topicId, null, roleTypeUri, pl);
    }

    TopicRoleModelImpl(String topicUri, String roleTypeUri, PersistenceLayer pl) {
        this(-1L, topicUri, roleTypeUri, pl);
    }

    TopicRoleModelImpl(long topicId, String topicUri, String roleTypeUri, PersistenceLayer pl) {
        super(topicId, roleTypeUri, pl);
        this.topicUri = topicUri;
    }

    @Override
    public String getTopicUri() {
        if (this.topicUri == null) {
            throw new IllegalStateException("Player URI is not set in " + this);
        }
        return this.topicUri;
    }

    @Override
    public boolean topicIdentifiedByUri() {
        return this.topicUri != null;
    }

    @Override
    public JSONObject toJSON() {
        try {
            return new JSONObject().put("topicId", this.playerId).put("topicUri", (Object)this.topicUri).put("roleTypeUri", (Object)this.roleTypeUri);
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed", e);
        }
    }

    @Override
    Role instantiate(AssocModelImpl assoc) {
        return new TopicRoleImpl(this, assoc);
    }

    @Override
    RelatedTopicModelImpl getPlayer(AssocModelImpl assoc) {
        return this.mf.newRelatedTopicModel(this.pl.fetchTopic(this.getPlayerId()), (AssocModel)assoc);
    }
}

