/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import systems.dmx.core.impl.AssocModelImpl;
import systems.dmx.core.impl.DMXObjectModelImpl;
import systems.dmx.core.impl.RelatedAssociationModelImpl;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.model.AssocModel;
import systems.dmx.core.model.RoleModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.storage.spi.DMXStorage;
import systems.dmx.core.storage.spi.DMXTransaction;

class StorageDecorator {
    private final DMXStorage storage;
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    StorageDecorator(DMXStorage storage) {
        this.storage = storage;
    }

    final TopicModelImpl fetchTopic(long topicId) {
        return (TopicModelImpl)this.storage.fetchTopic(topicId);
    }

    final TopicModelImpl fetchTopicByUri(String uri) {
        return this.fetchTopic("uri", new SimpleValue(uri));
    }

    final TopicModelImpl fetchTopic(String key, SimpleValue value) {
        return (TopicModelImpl)this.storage.fetchTopic(key, value.value());
    }

    final List<TopicModelImpl> fetchTopics(String key, SimpleValue value) {
        return this.storage.fetchTopics(key, value.value());
    }

    final List<TopicModelImpl> queryTopics(String key, SimpleValue value) {
        return this.storage.queryTopics(key, value.value());
    }

    final Iterator<TopicModelImpl> fetchAllTopics() {
        return this.storage.fetchAllTopics();
    }

    final void storeTopic(TopicModel model) {
        this.storage.storeTopic(model);
    }

    final void storeTopicUri(long topicId, String uri) {
        this.storage.storeTopicUri(topicId, uri);
    }

    final void storeTopicTypeUri(long topicId, String topicTypeUri) {
        this.storage.storeTopicTypeUri(topicId, topicTypeUri);
    }

    final void storeTopicValue(long topicId, SimpleValue value, String indexKey, boolean isHtmlValue) {
        this.storage.storeTopicValue(topicId, value, indexKey, isHtmlValue);
    }

    final void _deleteTopic(long topicId) {
        this.storage.deleteTopic(topicId);
    }

    final AssocModelImpl fetchAssociation(long assocId) {
        return (AssocModelImpl)this.storage.fetchAssociation(assocId);
    }

    final AssocModelImpl fetchAssociation(String key, SimpleValue value) {
        return (AssocModelImpl)this.storage.fetchAssociation(key, value.value());
    }

    final List<AssocModelImpl> fetchAssociations(String key, SimpleValue value) {
        return this.storage.fetchAssociations(key, value.value());
    }

    final AssocModelImpl fetchAssociation(String assocTypeUri, long topicId1, long topicId2, String roleTypeUri1, String roleTypeUri2) {
        List<AssocModelImpl> assocs = this.fetchAssociations(assocTypeUri, topicId1, topicId2, roleTypeUri1, roleTypeUri2);
        switch (assocs.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return assocs.get(0);
            }
        }
        throw new RuntimeException("Ambiguity: there are " + assocs.size() + " \"" + assocTypeUri + "\" associations (topicId1=" + topicId1 + ", topicId2=" + topicId2 + ", roleTypeUri1=\"" + roleTypeUri1 + "\", roleTypeUri2=\"" + roleTypeUri2 + "\")");
    }

    final List<AssocModelImpl> fetchAssociations(String assocTypeUri, long topicId1, long topicId2, String roleTypeUri1, String roleTypeUri2) {
        return this.storage.fetchAssociations(assocTypeUri, topicId1, topicId2, roleTypeUri1, roleTypeUri2);
    }

    final AssocModelImpl fetchAssociationBetweenTopicAndAssociation(String assocTypeUri, long topicId, long assocId, String topicRoleTypeUri, String assocRoleTypeUri) {
        List<AssocModelImpl> assocs = this.fetchAssociationsBetweenTopicAndAssociation(assocTypeUri, topicId, assocId, topicRoleTypeUri, assocRoleTypeUri);
        switch (assocs.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return assocs.get(0);
            }
        }
        throw new RuntimeException("Ambiguity: there are " + assocs.size() + " \"" + assocTypeUri + "\" associations (topicId=" + topicId + ", assocId=" + assocId + ", topicRoleTypeUri=\"" + topicRoleTypeUri + "\", assocRoleTypeUri=\"" + assocRoleTypeUri + "\")");
    }

    final List<AssocModelImpl> fetchAssociationsBetweenTopicAndAssociation(String assocTypeUri, long topicId, long assocId, String topicRoleTypeUri, String assocRoleTypeUri) {
        return this.storage.fetchAssociationsBetweenTopicAndAssociation(assocTypeUri, topicId, assocId, topicRoleTypeUri, assocRoleTypeUri);
    }

    final Iterator<AssocModelImpl> fetchAllAssociations() {
        return this.storage.fetchAllAssociations();
    }

    final List<RoleModel> fetchRoleModels(long assocId) {
        return this.storage.fetchRoleModels(assocId);
    }

    final void storeAssociation(AssocModel model) {
        this.storage.storeAssociation(model);
    }

    final void storeAssociationUri(long assocId, String uri) {
        this.storage.storeAssociationUri(assocId, uri);
    }

    final void storeAssociationTypeUri(long assocId, String assocTypeUri) {
        this.storage.storeAssociationTypeUri(assocId, assocTypeUri);
    }

    final void storeRoleTypeUri(long assocId, long playerId, String roleTypeUri) {
        this.storage.storeRoleTypeUri(assocId, playerId, roleTypeUri);
    }

    final void storeAssociationValue(long assocId, SimpleValue value, String indexKey, boolean isHtmlValue) {
        this.storage.storeAssociationValue(assocId, value, indexKey, isHtmlValue);
    }

    final void _deleteAssociation(long assocId) {
        this.storage.deleteAssociation(assocId);
    }

    final DMXObjectModelImpl fetchObject(long id) {
        return (DMXObjectModelImpl)this.storage.fetchObject(id);
    }

    final RelatedTopicModelImpl fetchTopicRelatedTopic(long topicId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        List<RelatedTopicModelImpl> topics = this.fetchTopicRelatedTopics(topicId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
        switch (topics.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return topics.iterator().next();
            }
        }
        throw new RuntimeException("Ambiguity: there are " + topics.size() + " related topics (topicId=" + topicId + ", assocTypeUri=\"" + assocTypeUri + "\", myRoleTypeUri=\"" + myRoleTypeUri + "\", othersRoleTypeUri=\"" + othersRoleTypeUri + "\", othersTopicTypeUri=\"" + othersTopicTypeUri + "\")");
    }

    final List<RelatedTopicModelImpl> fetchTopicRelatedTopics(long topicId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.storage.fetchTopicRelatedTopics(topicId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
    }

    final RelatedAssociationModelImpl fetchTopicRelatedAssociation(long topicId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        List<RelatedAssociationModelImpl> assocs = this.fetchTopicRelatedAssociations(topicId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
        switch (assocs.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return assocs.iterator().next();
            }
        }
        throw new RuntimeException("Ambiguity: there are " + assocs.size() + " related associations (topicId=" + topicId + ", assocTypeUri=\"" + assocTypeUri + "\", myRoleTypeUri=\"" + myRoleTypeUri + "\", othersRoleTypeUri=\"" + othersRoleTypeUri + "\", othersAssocTypeUri=\"" + othersAssocTypeUri + "\")");
    }

    final List<RelatedAssociationModelImpl> fetchTopicRelatedAssociations(long topicId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        return this.storage.fetchTopicRelatedAssociations(topicId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
    }

    final List<AssocModelImpl> fetchTopicAssociations(long topicId) {
        return this.storage.fetchTopicAssociations(topicId);
    }

    final RelatedTopicModelImpl fetchAssociationRelatedTopic(long assocId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        List<RelatedTopicModelImpl> topics = this.fetchAssociationRelatedTopics(assocId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
        switch (topics.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return topics.iterator().next();
            }
        }
        throw new RuntimeException("Ambiguity: there are " + topics.size() + " related topics (assocId=" + assocId + ", assocTypeUri=\"" + assocTypeUri + "\", myRoleTypeUri=\"" + myRoleTypeUri + "\", othersRoleTypeUri=\"" + othersRoleTypeUri + "\", othersTopicTypeUri=\"" + othersTopicTypeUri + "\")");
    }

    final List<RelatedTopicModelImpl> fetchAssociationRelatedTopics(long assocId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.storage.fetchAssociationRelatedTopics(assocId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
    }

    final RelatedAssociationModelImpl fetchAssociationRelatedAssociation(long assocId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        List<RelatedAssociationModelImpl> assocs = this.fetchAssociationRelatedAssociations(assocId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
        switch (assocs.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return assocs.iterator().next();
            }
        }
        throw new RuntimeException("Ambiguity: there are " + assocs.size() + " related associations (assocId=" + assocId + ", assocTypeUri=\"" + assocTypeUri + "\", myRoleTypeUri=\"" + myRoleTypeUri + "\", othersRoleTypeUri=\"" + othersRoleTypeUri + "\", othersAssocTypeUri=\"" + othersAssocTypeUri + "\"),\nresult=" + assocs);
    }

    final List<RelatedAssociationModelImpl> fetchAssociationRelatedAssociations(long assocId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        return this.storage.fetchAssociationRelatedAssociations(assocId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
    }

    final List<AssocModelImpl> fetchAssociationAssociations(long assocId) {
        return this.storage.fetchAssociationAssociations(assocId);
    }

    final RelatedTopicModelImpl fetchRelatedTopic(long objectId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        List<RelatedTopicModelImpl> topics = this.fetchRelatedTopics(objectId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
        switch (topics.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return topics.iterator().next();
            }
        }
        throw new RuntimeException("Ambiguity: there are " + topics.size() + " related topics (objectId=" + objectId + ", assocTypeUri=\"" + assocTypeUri + "\", myRoleTypeUri=\"" + myRoleTypeUri + "\", othersRoleTypeUri=\"" + othersRoleTypeUri + "\", othersTopicTypeUri=\"" + othersTopicTypeUri + "\")");
    }

    final List<RelatedTopicModelImpl> fetchRelatedTopics(long objectId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.storage.fetchRelatedTopics(objectId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
    }

    final Object fetchProperty(long id, String propUri) {
        return this.storage.fetchProperty(id, propUri);
    }

    final boolean hasProperty(long id, String propUri) {
        return this.storage.hasProperty(id, propUri);
    }

    final List<TopicModelImpl> fetchTopicsByProperty(String propUri, Object propValue) {
        return this.storage.fetchTopicsByProperty(propUri, propValue);
    }

    final List<TopicModelImpl> fetchTopicsByPropertyRange(String propUri, Number from, Number to) {
        return this.storage.fetchTopicsByPropertyRange(propUri, from, to);
    }

    final List<AssocModelImpl> fetchAssociationsByProperty(String propUri, Object propValue) {
        return this.storage.fetchAssociationsByProperty(propUri, propValue);
    }

    final List<AssocModelImpl> fetchAssociationsByPropertyRange(String propUri, Number from, Number to) {
        return this.storage.fetchAssociationsByPropertyRange(propUri, from, to);
    }

    final void storeTopicProperty(long topicId, String propUri, Object propValue, boolean addToIndex) {
        this.storage.storeTopicProperty(topicId, propUri, propValue, addToIndex);
    }

    final void storeAssociationProperty(long assocId, String propUri, Object propValue, boolean addToIndex) {
        this.storage.storeAssociationProperty(assocId, propUri, propValue, addToIndex);
    }

    final void indexTopicProperty(long topicId, String propUri, Object propValue) {
        this.storage.indexTopicProperty(topicId, propUri, propValue);
    }

    final void indexAssociationProperty(long assocId, String propUri, Object propValue) {
        this.storage.indexAssociationProperty(assocId, propUri, propValue);
    }

    final void removeTopicProperty(long topicId, String propUri) {
        this.storage.deleteTopicProperty(topicId, propUri);
    }

    final void removeAssociationProperty(long assocId, String propUri) {
        this.storage.deleteAssociationProperty(assocId, propUri);
    }

    final DMXTransaction beginTx() {
        return this.storage.beginTx();
    }

    final boolean init() {
        boolean isCleanInstall = this.storage.setupRootNode();
        if (isCleanInstall) {
            this.logger.info("Clean install detected -- Starting with a fresh DB");
            this.storeMigrationNr(0);
        }
        return isCleanInstall;
    }

    final void shutdown() {
        this.storage.shutdown();
    }

    final int fetchMigrationNr() {
        return (Integer)this.fetchProperty(0L, "core_migration_nr");
    }

    final void storeMigrationNr(int migrationNr) {
        this.storage.storeTopicProperty(0L, "core_migration_nr", migrationNr, false);
    }

    final Object getDatabaseVendorObject() {
        return this.storage.getDatabaseVendorObject();
    }

    final Object getDatabaseVendorObject(long objectId) {
        return this.storage.getDatabaseVendorObject(objectId);
    }
}

