/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.List;
import systems.dmx.core.impl.AssocModelImpl;
import systems.dmx.core.impl.AssocTypeImpl;
import systems.dmx.core.impl.TypeModelImpl;
import systems.dmx.core.model.AssociationTypeModel;
import systems.dmx.core.model.CompDefModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.service.Directive;

public class AssociationTypeModelImpl
extends TypeModelImpl
implements AssociationTypeModel {
    AssociationTypeModelImpl(TypeModelImpl type) {
        super(type);
        if (type.dataTypeUri.equals("dmx.core.value") || type.dataTypeUri.equals("dmx.core.identity")) {
            throw new IllegalArgumentException("\"" + type.dataTypeUri + "\" is an illegal data type for an assoc type. Use \"dmx.core.composite\" instead. " + type);
        }
    }

    @Override
    public AssociationTypeModel addCompDef(CompDefModel compDef) {
        return (AssociationTypeModel)super.addCompDef(compDef);
    }

    @Override
    public AssociationTypeModelImpl clone() {
        try {
            return (AssociationTypeModelImpl)super.clone();
        }
        catch (Exception e) {
            throw new RuntimeException("Cloning a AssociationTypeModel failed", e);
        }
    }

    @Override
    String className() {
        return "association type";
    }

    @Override
    AssocTypeImpl instantiate() {
        AssociationTypeModelImpl type = (AssociationTypeModelImpl)this.clone().filterReadableCompDefs();
        return new AssocTypeImpl(type, this.pl);
    }

    List<AssocModelImpl> getAllInstances() {
        return this.pl.fetchAssociations("typeUri", new SimpleValue(this.uri));
    }

    @Override
    Directive getUpdateTypeDirective() {
        return Directive.UPDATE_ASSOCIATION_TYPE;
    }

    @Override
    Directive getDeleteTypeDirective() {
        return Directive.DELETE_ASSOCIATION_TYPE;
    }
}

