/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.List;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import systems.dmx.core.Assoc;
import systems.dmx.core.AssocType;
import systems.dmx.core.DMXObject;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.impl.AccessControlImpl;
import systems.dmx.core.impl.AssocImpl;
import systems.dmx.core.impl.AssocModelImpl;
import systems.dmx.core.impl.AssocTypeImpl;
import systems.dmx.core.impl.AssociationTypeModelImpl;
import systems.dmx.core.impl.DMXObjectModelImpl;
import systems.dmx.core.impl.EventManager;
import systems.dmx.core.impl.MigrationManager;
import systems.dmx.core.impl.ModelFactoryImpl;
import systems.dmx.core.impl.PersistenceLayer;
import systems.dmx.core.impl.PluginImpl;
import systems.dmx.core.impl.PluginManager;
import systems.dmx.core.impl.TopicImpl;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.impl.TopicTypeImpl;
import systems.dmx.core.impl.TopicTypeModelImpl;
import systems.dmx.core.impl.WebPublishingService;
import systems.dmx.core.impl.WebSocketsServiceImpl;
import systems.dmx.core.model.AssocModel;
import systems.dmx.core.model.AssociationTypeModel;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.model.TopicTypeModel;
import systems.dmx.core.service.CoreService;
import systems.dmx.core.service.DMXEvent;
import systems.dmx.core.service.ModelFactory;
import systems.dmx.core.service.PluginInfo;
import systems.dmx.core.service.accesscontrol.AccessControl;
import systems.dmx.core.storage.spi.DMXTransaction;

public class CoreServiceImpl
implements CoreService {
    BundleContext bundleContext;
    PersistenceLayer pl;
    EventManager em;
    ModelFactoryImpl mf;
    MigrationManager migrationManager;
    PluginManager pluginManager;
    AccessControl accessControl;
    WebSocketsServiceImpl wsService;
    WebPublishingService wpService;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public CoreServiceImpl(PersistenceLayer pl, BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.pl = pl;
        this.em = pl.em;
        this.mf = pl.mf;
        this.migrationManager = new MigrationManager(this);
        this.pluginManager = new PluginManager(this);
        this.accessControl = new AccessControlImpl(pl);
        this.wsService = new WebSocketsServiceImpl(this);
        this.wpService = new WebPublishingService(pl, this.wsService);
        this.setupDB();
    }

    @Override
    public Topic getTopic(long topicId) {
        return this.pl.getTopic(topicId);
    }

    @Override
    public TopicImpl getTopicByUri(String uri) {
        return this.pl.getTopicByUri(uri);
    }

    @Override
    public Topic getTopicByValue(String key, SimpleValue value) {
        return this.pl.getTopicByValue(key, value);
    }

    @Override
    public List<Topic> getTopicsByValue(String key, SimpleValue value) {
        return this.pl.getTopicsByValue(key, value);
    }

    @Override
    public List<Topic> getTopicsByType(String topicTypeUri) {
        return this.pl.getTopicsByType(topicTypeUri);
    }

    @Override
    public List<Topic> searchTopics(String searchTerm, String fieldUri) {
        return this.pl.searchTopics(searchTerm, fieldUri);
    }

    @Override
    public Iterable<Topic> getAllTopics() {
        return this.pl.getAllTopics();
    }

    @Override
    public TopicImpl createTopic(TopicModel model) {
        return this.pl.createTopic((TopicModelImpl)model);
    }

    @Override
    public void updateTopic(TopicModel updateModel) {
        this.pl.updateTopic((TopicModelImpl)updateModel);
    }

    @Override
    public void deleteTopic(long topicId) {
        this.pl.deleteTopic(topicId);
    }

    @Override
    public Assoc getAssociation(long assocId) {
        return this.pl.getAssociation(assocId);
    }

    @Override
    public Assoc getAssociationByValue(String key, SimpleValue value) {
        return this.pl.getAssociationByValue(key, value);
    }

    @Override
    public List<Assoc> getAssociationsByValue(String key, SimpleValue value) {
        return this.pl.getAssociationsByValue(key, value);
    }

    @Override
    public Assoc getAssociation(String assocTypeUri, long topic1Id, long topic2Id, String roleTypeUri1, String roleTypeUri2) {
        return this.pl.getAssociation(assocTypeUri, topic1Id, topic2Id, roleTypeUri1, roleTypeUri2);
    }

    @Override
    public Assoc getAssociationBetweenTopicAndAssociation(String assocTypeUri, long topicId, long assocId, String topicRoleTypeUri, String assocRoleTypeUri) {
        return this.pl.getAssociationBetweenTopicAndAssociation(assocTypeUri, topicId, assocId, topicRoleTypeUri, assocRoleTypeUri);
    }

    @Override
    public List<Assoc> getAssociationsByType(String assocTypeUri) {
        return this.pl.getAssociationsByType(assocTypeUri);
    }

    @Override
    public List<Assoc> getAssociations(long topic1Id, long topic2Id) {
        return this.pl.getAssociations(topic1Id, topic2Id);
    }

    @Override
    public List<Assoc> getAssociations(long topic1Id, long topic2Id, String assocTypeUri) {
        return this.pl.getAssociations(assocTypeUri, topic1Id, topic2Id);
    }

    @Override
    public Iterable<Assoc> getAllAssociations() {
        return this.pl.getAllAssociations();
    }

    @Override
    public List<PlayerModel> getRoleModels(long assocId) {
        return this.pl.getRoleModels(assocId);
    }

    @Override
    public AssocImpl createAssociation(AssocModel model) {
        return this.pl.createAssociation((AssocModelImpl)model);
    }

    @Override
    public void updateAssociation(AssocModel updateModel) {
        this.pl.updateAssociation((AssocModelImpl)updateModel);
    }

    @Override
    public void deleteAssociation(long assocId) {
        this.pl.deleteAssociation(assocId);
    }

    @Override
    public TopicTypeImpl getTopicType(String uri) {
        return this.pl.getTopicType(uri);
    }

    @Override
    public TopicTypeImpl getTopicTypeImplicitly(long topicId) {
        return this.pl.getTopicTypeImplicitly(topicId);
    }

    @Override
    public List<TopicType> getAllTopicTypes() {
        return this.pl.getAllTopicTypes();
    }

    @Override
    public TopicTypeImpl createTopicType(TopicTypeModel model) {
        return this.pl.createTopicType((TopicTypeModelImpl)model);
    }

    @Override
    public void updateTopicType(TopicTypeModel updateModel) {
        this.pl.updateTopicType((TopicTypeModelImpl)updateModel);
    }

    @Override
    public void deleteTopicType(String topicTypeUri) {
        this.pl.deleteTopicType(topicTypeUri);
    }

    @Override
    public AssocTypeImpl getAssociationType(String uri) {
        return this.pl.getAssociationType(uri);
    }

    @Override
    public AssocTypeImpl getAssociationTypeImplicitly(long assocId) {
        return this.pl.getAssociationTypeImplicitly(assocId);
    }

    @Override
    public List<AssocType> getAllAssociationTypes() {
        return this.pl.getAllAssociationTypes();
    }

    @Override
    public AssocTypeImpl createAssociationType(AssociationTypeModel model) {
        return this.pl.createAssociationType((AssociationTypeModelImpl)model);
    }

    @Override
    public void updateAssociationType(AssociationTypeModel updateModel) {
        this.pl.updateAssociationType((AssociationTypeModelImpl)updateModel);
    }

    @Override
    public void deleteAssociationType(String assocTypeUri) {
        this.pl.deleteAssociationType(assocTypeUri);
    }

    @Override
    public Topic createRoleType(TopicModel model) {
        return this.pl.createRoleType((TopicModelImpl)model);
    }

    @Override
    public DMXObject getObject(long id) {
        return this.pl.getObject(id);
    }

    @Override
    public PluginImpl getPlugin(String pluginUri) {
        return this.pluginManager.getPlugin(pluginUri);
    }

    @Override
    public List<PluginInfo> getPluginInfo() {
        return this.pluginManager.getPluginInfo();
    }

    @Override
    public void fireEvent(DMXEvent event, Object ... params) {
        this.em.fireEvent(event, params);
    }

    @Override
    public void dispatchEvent(String pluginUri, DMXEvent event, Object ... params) {
        this.em.dispatchEvent(this.getPlugin(pluginUri), event, params);
    }

    @Override
    public Object getProperty(long id, String propUri) {
        return this.pl.fetchProperty(id, propUri);
    }

    @Override
    public boolean hasProperty(long id, String propUri) {
        return this.pl.hasProperty(id, propUri);
    }

    @Override
    public List<Topic> getTopicsByProperty(String propUri, Object propValue) {
        return this.pl.getTopicsByProperty(propUri, propValue);
    }

    @Override
    public List<Topic> getTopicsByPropertyRange(String propUri, Number from, Number to) {
        return this.pl.getTopicsByPropertyRange(propUri, from, to);
    }

    @Override
    public List<Assoc> getAssociationsByProperty(String propUri, Object propValue) {
        return this.pl.getAssociationsByProperty(propUri, propValue);
    }

    @Override
    public List<Assoc> getAssociationsByPropertyRange(String propUri, Number from, Number to) {
        return this.pl.getAssociationsByPropertyRange(propUri, from, to);
    }

    @Override
    public void addTopicPropertyIndex(String propUri) {
        int topics = 0;
        int added = 0;
        this.logger.info("########## Adding topic property index for \"" + propUri + "\"");
        for (Topic topic : this.getAllTopics()) {
            if (topic.hasProperty(propUri)) {
                Object value = topic.getProperty(propUri);
                this.pl.indexTopicProperty(topic.getId(), propUri, value);
                ++added;
            }
            ++topics;
        }
        this.logger.info("########## Adding topic property index complete\n    Topics processed: " + topics + "\n    added to index: " + added);
    }

    @Override
    public void addAssociationPropertyIndex(String propUri) {
        int assocs = 0;
        int added = 0;
        this.logger.info("########## Adding association property index for \"" + propUri + "\"");
        for (Assoc assoc : this.getAllAssociations()) {
            if (assoc.hasProperty(propUri)) {
                Object value = assoc.getProperty(propUri);
                this.pl.indexAssociationProperty(assoc.getId(), propUri, value);
                ++added;
            }
            ++assocs;
        }
        this.logger.info("########## Adding association property complete\n    Associations processed: " + assocs + "\n    added to index: " + added);
    }

    @Override
    public DMXTransaction beginTx() {
        return this.pl.beginTx();
    }

    @Override
    public ModelFactory getModelFactory() {
        return this.mf;
    }

    @Override
    public AccessControl getAccessControl() {
        return this.accessControl;
    }

    @Override
    public WebSocketsServiceImpl getWebSocketsService() {
        return this.wsService;
    }

    @Override
    public Object getDatabaseVendorObject() {
        return this.pl.getDatabaseVendorObject();
    }

    public void shutdown() {
        this.wsService.shutdown();
    }

    Assoc createAssociation(String typeUri, PlayerModel roleModel1, PlayerModel roleModel2) {
        return this.createAssociation(this.mf.newAssociationModel(typeUri, roleModel1, roleModel2));
    }

    private void setupDB() {
        DMXTransaction tx = this.beginTx();
        try {
            this.logger.info("----- Setting up the database -----");
            boolean isCleanInstall = this.pl.init();
            if (isCleanInstall) {
                this.setupBootstrapContent();
            }
            this.migrationManager.runCoreMigrations(isCleanInstall);
            tx.success();
            tx.finish();
            this.logger.info("----- Setting up the database complete -----");
        }
        catch (Exception e) {
            this.logger.warning("ROLLBACK!");
            tx.finish();
            this.pl.shutdown();
            throw new RuntimeException("Setting up the database failed", e);
        }
    }

    private void setupBootstrapContent() {
        try {
            TopicModelImpl t = this.mf.newTopicModel("dmx.core.topic_type", "dmx.core.meta_type", new SimpleValue("Topic Type"));
            TopicModelImpl a = this.mf.newTopicModel("dmx.core.assoc_type", "dmx.core.meta_type", new SimpleValue("Association Type"));
            this._createTopic(t);
            this._createTopic(a);
            TopicTypeModelImpl dataType = this.mf.newTopicTypeModel("dmx.core.data_type", "Data Type", "dmx.core.text");
            this._createTopic(dataType);
            TopicModelImpl text = this.mf.newTopicModel("dmx.core.text", "dmx.core.data_type", new SimpleValue("Text"));
            this._createTopic(text);
            AssociationTypeModelImpl composition = this.mf.newAssociationTypeModel("dmx.core.composition", "Composition", "dmx.core.text");
            this._createTopic(composition);
            AssociationTypeModelImpl instn = this.mf.newAssociationTypeModel("dmx.core.instantiation", "Instantiation", "dmx.core.text");
            this._createTopic(instn);
            this.pl.createTopicInstantiation(t.getId(), t.getTypeUri());
            this.pl.createTopicInstantiation(a.getId(), a.getTypeUri());
            this.pl.createTopicInstantiation(dataType.getId(), dataType.getTypeUri());
            this.pl.createTopicInstantiation(text.getId(), text.getTypeUri());
            this.pl.createTopicInstantiation(((DMXObjectModelImpl)composition).getId(), ((DMXObjectModelImpl)composition).getTypeUri());
            this.pl.createTopicInstantiation(((DMXObjectModelImpl)instn).getId(), ((DMXObjectModelImpl)instn).getTypeUri());
            this._associateDataType("dmx.core.meta_type", "dmx.core.text");
            this._associateDataType("dmx.core.topic_type", "dmx.core.text");
            this._associateDataType("dmx.core.assoc_type", "dmx.core.text");
            this._associateDataType("dmx.core.data_type", "dmx.core.text");
            this._associateDataType("dmx.core.composition", "dmx.core.text");
            this._associateDataType("dmx.core.instantiation", "dmx.core.text");
        }
        catch (Exception e) {
            throw new RuntimeException("Setting up the bootstrap content failed", e);
        }
    }

    private void _createTopic(TopicModelImpl model) {
        this.pl.storeTopic(model);
        this.pl.storeTopicValue(model.id, model.value, model.typeUri, false);
    }

    private void _associateDataType(String typeUri, String dataTypeUri) {
        AssocModelImpl assoc = this.mf.newAssociationModel("dmx.core.composition", this.mf.newTopicRoleModel(typeUri, "dmx.core.type"), this.mf.newTopicRoleModel(dataTypeUri, "dmx.core.default"));
        this.pl.storeAssociation(assoc);
        this.pl.storeAssociationValue(assoc.id, assoc.value, assoc.typeUri, false);
    }
}

