/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.List;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.impl.AssocImpl;
import systems.dmx.core.impl.AssocTypeModelImpl;
import systems.dmx.core.impl.CoreEvent;
import systems.dmx.core.impl.DMXObjectModelImpl;
import systems.dmx.core.impl.PlayerModelImpl;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.impl.TopicPlayerModelImpl;
import systems.dmx.core.impl.TypeModelImpl;
import systems.dmx.core.model.AssocModel;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.DMXObjectModel;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.TopicPlayerModel;
import systems.dmx.core.service.DMXEvent;
import systems.dmx.core.service.Directive;
import systems.dmx.core.util.DMXUtils;

class AssocModelImpl
extends DMXObjectModelImpl
implements AssocModel {
    PlayerModelImpl roleModel1;
    PlayerModelImpl roleModel2;

    AssocModelImpl(DMXObjectModelImpl object, PlayerModelImpl roleModel1, PlayerModelImpl roleModel2) {
        super(object);
        this.roleModel1 = roleModel1;
        this.roleModel2 = roleModel2;
    }

    AssocModelImpl(AssocModelImpl assoc) {
        super(assoc);
        this.roleModel1 = assoc.roleModel1;
        this.roleModel2 = assoc.roleModel2;
    }

    @Override
    public PlayerModelImpl getRoleModel1() {
        return this.roleModel1;
    }

    @Override
    public PlayerModelImpl getRoleModel2() {
        return this.roleModel2;
    }

    @Override
    public void setRoleModel1(PlayerModel roleModel1) {
        this.roleModel1 = (PlayerModelImpl)roleModel1;
    }

    @Override
    public void setRoleModel2(PlayerModel roleModel2) {
        this.roleModel2 = (PlayerModelImpl)roleModel2;
    }

    @Override
    public PlayerModelImpl getRoleModel(String roleTypeUri) {
        boolean rm1 = this.roleModel1.getRoleTypeUri().equals(roleTypeUri);
        boolean rm2 = this.roleModel2.getRoleTypeUri().equals(roleTypeUri);
        if (rm1 && rm2) {
            throw new RuntimeException("Ambiguous getRoleModel() call: both players occupy role \"" + roleTypeUri + "\" (" + this + ")");
        }
        return rm1 ? this.roleModel1 : (rm2 ? this.roleModel2 : null);
    }

    @Override
    public boolean hasSameRoleTypeUris() {
        return this.roleModel1.getRoleTypeUri().equals(this.roleModel2.getRoleTypeUri());
    }

    @Override
    public boolean matches(String roleTypeUri1, long playerId1, String roleTypeUri2, long playerId2) {
        if (roleTypeUri1.equals(roleTypeUri2)) {
            throw new IllegalArgumentException("matches() was called with 2 identical role type URIs (\"" + roleTypeUri1 + "\")");
        }
        if (!this.hasSameRoleTypeUris()) {
            PlayerModelImpl r1 = this.getRoleModel(roleTypeUri1);
            PlayerModelImpl r2 = this.getRoleModel(roleTypeUri2);
            if (r1 != null && r1.getPlayerId() == playerId1 && r2 != null && r2.getPlayerId() == playerId2) {
                return true;
            }
        }
        return false;
    }

    @Override
    public long getOtherPlayerId(long id) {
        long id1 = this.roleModel1.getPlayerId();
        long id2 = this.roleModel2.getPlayerId();
        if (id1 == id) {
            return id2;
        }
        if (id2 == id) {
            return id1;
        }
        throw new IllegalArgumentException("ID " + id + " doesn't refer to a player in " + this);
    }

    @Override
    public PlayerModel createRoleModel(String roleTypeUri) {
        return this.mf.newAssociationRoleModel(this.id, roleTypeUri);
    }

    @Override
    public JSONObject toJSON() {
        try {
            return super.toJSON().put("role1", this.roleModel1 != null ? this.roleModel1.toJSON() : null).put("role2", this.roleModel2 != null ? this.roleModel2.toJSON() : null);
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed", e);
        }
    }

    @Override
    public AssocModel clone() {
        try {
            AssocModel model = (AssocModel)super.clone();
            model.setRoleModel1(this.roleModel1.clone());
            model.setRoleModel2(this.roleModel2.clone());
            return model;
        }
        catch (Exception e) {
            throw new RuntimeException("Cloning an AssocModel failed", e);
        }
    }

    @Override
    String className() {
        return "association";
    }

    @Override
    AssocImpl instantiate() {
        return new AssocImpl(this, this.pl);
    }

    @Override
    AssocModelImpl createModelWithChildTopics(ChildTopicsModel childTopics) {
        return this.mf.newAssociationModel(this.typeUri, childTopics);
    }

    @Override
    final AssocTypeModelImpl getType() {
        return this.pl.typeStorage.getAssociationType(this.typeUri);
    }

    @Override
    final List<AssocModelImpl> getAssociations() {
        return this.pl.fetchAssociationAssociations(this.id);
    }

    @Override
    final RelatedTopicModelImpl getRelatedTopic(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.pl.fetchAssociationRelatedTopic(this.id, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
    }

    @Override
    final List<RelatedTopicModelImpl> getRelatedTopics(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.pl.fetchAssociationRelatedTopics(this.id, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
    }

    @Override
    final void storeUri() {
        this.pl.storeAssociationUri(this.id, this.uri);
    }

    @Override
    final void storeTypeUri() {
        this.reassignInstantiation();
        this.pl.storeAssociationTypeUri(this.id, this.typeUri);
    }

    @Override
    final void storeSimpleValue() {
        this.pl.storeAssociationValue(this.id, this.value, this.typeUri, this.isHtml());
    }

    @Override
    final void storeProperty(String propUri, Object propValue, boolean addToIndex) {
        this.pl.storeAssociationProperty(this.id, propUri, propValue, addToIndex);
    }

    @Override
    final void removeProperty(String propUri) {
        this.pl.removeAssociationProperty(this.id, propUri);
    }

    @Override
    final void _delete() {
        this.pl._deleteAssociation(this.id);
    }

    @Override
    final void checkReadAccess() {
        this.pl.checkAssociationReadAccess(this.id);
    }

    @Override
    final void checkWriteAccess() {
        this.pl.checkAssociationWriteAccess(this.id);
    }

    @Override
    final DMXEvent getPreUpdateEvent() {
        return CoreEvent.PRE_UPDATE_ASSOCIATION;
    }

    @Override
    final DMXEvent getPostUpdateEvent() {
        return CoreEvent.POST_UPDATE_ASSOCIATION;
    }

    @Override
    final DMXEvent getPreDeleteEvent() {
        return CoreEvent.PRE_DELETE_ASSOCIATION;
    }

    @Override
    final DMXEvent getPostDeleteEvent() {
        return CoreEvent.POST_DELETE_ASSOCIATION;
    }

    @Override
    final Directive getUpdateDirective() {
        return Directive.UPDATE_ASSOCIATION;
    }

    @Override
    final Directive getDeleteDirective() {
        return Directive.DELETE_ASSOCIATION;
    }

    @Override
    void preCreate() {
        if (DMXUtils.associationAutoTyping(this, "dmx.core.topic_type", "dmx.core.topic_type", "dmx.core.composition_def", "dmx.core.child_type", "dmx.core.parent_type") != null || DMXUtils.associationAutoTyping(this, "dmx.core.topic_type", "dmx.core.assoc_type", "dmx.core.composition_def", "dmx.core.child_type", "dmx.core.parent_type") != null) {
            this.childTopics.putRef("dmx.core.cardinality", "dmx.core.one");
        }
        this.duplicateCheck();
    }

    @Override
    void postCreate() {
        if (this.isCompDef(this)) {
            this.createCompDef();
        }
    }

    @Override
    void postUpdate(DMXObjectModel updateModel, DMXObjectModel oldObject) {
        this.updateRoles((AssocModel)updateModel);
        this.duplicateCheck();
        if (this.isCompDef(this)) {
            if (this.isCompDef((AssocModel)oldObject)) {
                this.updateCompDef((AssocModel)oldObject);
            } else {
                this.createCompDef();
            }
        } else if (this.isCompDef((AssocModel)oldObject)) {
            this.removeCompDef();
        }
    }

    @Override
    void preDelete() {
        if (this.isCompDef(this)) {
            this.removeCompDef();
        }
    }

    DMXObjectModelImpl getPlayer(String roleTypeUri) {
        PlayerModelImpl role = this.getRoleModel(roleTypeUri);
        return role != null ? role.getPlayer(this) : null;
    }

    TopicModelImpl getTopicByType(String topicTypeUri) {
        TopicModelImpl topic1 = this.filterTopic(this.roleModel1, topicTypeUri);
        TopicModelImpl topic2 = this.filterTopic(this.roleModel2, topicTypeUri);
        if (topic1 != null && topic2 != null) {
            throw new RuntimeException("Ambiguous getTopicByType() call: both topics are of type \"" + topicTypeUri + "\" (" + this + ")");
        }
        return topic1 != null ? topic1 : (topic2 != null ? topic2 : null);
    }

    void updateRoleTypeUri(PlayerModelImpl role, String roleTypeUri) {
        role.setRoleTypeUri(roleTypeUri);
        this.pl.storeRoleTypeUri(this.id, role.playerId, role.roleTypeUri);
    }

    private void duplicateCheck() {
        if (!(this.roleModel1 instanceof TopicPlayerModel) || !(this.roleModel2 instanceof TopicPlayerModel)) {
            return;
        }
        for (AssocModelImpl assoc : this.pl._getAssociations(this.typeUri, this.roleModel1.playerId, this.roleModel2.playerId, this.roleModel1.roleTypeUri, this.roleModel2.roleTypeUri)) {
            if (assoc.id == this.id || !assoc.value.equals(this.value)) continue;
            throw new RuntimeException("Duplicate: such an association exists already (ID=" + assoc.id + ", typeUri=\"" + this.typeUri + "\", value=\"" + this.value + "\")");
        }
    }

    private void updateRoles(AssocModel updateModel) {
        this.updateRole(updateModel.getRoleModel1(), 1);
        this.updateRole(updateModel.getRoleModel2(), 2);
    }

    private void updateRole(PlayerModel updateModel, int nr) {
        try {
            if (updateModel != null) {
                PlayerModelImpl role = this.getRole(updateModel);
                String newRoleTypeUri = updateModel.getRoleTypeUri();
                String roleTypeUri = role.getRoleTypeUri();
                if (!roleTypeUri.equals(newRoleTypeUri)) {
                    this.logger.info("### Changing role type " + nr + " of association " + this.id + ": \"" + roleTypeUri + "\" -> \"" + newRoleTypeUri + "\"");
                    this.updateRoleTypeUri(role, newRoleTypeUri);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Updating role " + nr + " of association " + this.id + " failed, updateModel=" + updateModel, e);
        }
    }

    private PlayerModelImpl getRole(PlayerModel roleModel) {
        if (this.roleModel1.refsSameObject(roleModel)) {
            return this.roleModel1;
        }
        if (this.roleModel2.refsSameObject(roleModel)) {
            return this.roleModel2;
        }
        throw new RuntimeException(roleModel + " is not part of " + this);
    }

    private TopicModelImpl filterTopic(PlayerModelImpl role, String topicTypeUri) {
        RelatedTopicModelImpl topic;
        if (role instanceof TopicPlayerModel && (topic = ((TopicPlayerModelImpl)role).getPlayer(this)).getTypeUri().equals(topicTypeUri)) {
            return topic;
        }
        return null;
    }

    private void reassignInstantiation() {
        this.fetchInstantiation().delete();
        this.pl.createAssociationInstantiation(this.id, this.typeUri);
    }

    private AssocModelImpl fetchInstantiation() {
        RelatedTopicModelImpl assocType = this.getRelatedTopic("dmx.core.instantiation", "dmx.core.instance", "dmx.core.type", "dmx.core.assoc_type");
        if (assocType == null) {
            throw new RuntimeException("Assoc " + this.id + " is not associated to an association type");
        }
        return assocType.getRelatingAssociation();
    }

    private void createCompDef() {
        TypeModelImpl parentType = this.fetchParentType();
        this.logger.info("##### Adding comp def " + this.id + " to type \"" + parentType.getUri() + "\"");
        parentType._addCompDef(this);
    }

    private void updateCompDef(AssocModel oldAssoc) {
        TypeModelImpl parentType = this.fetchParentType();
        this.logger.info("##### Updating comp def " + this.id + " of type \"" + parentType.getUri() + "\"");
        parentType._updateCompDef(this, oldAssoc);
    }

    private void removeCompDef() {
        TypeModelImpl parentType = this.fetchParentType();
        this.logger.info("##### Removing comp def " + this.id + " from type \"" + parentType.getUri() + "\"");
        parentType._removeCompDefFromMemoryAndRebuildSequence(this);
    }

    private boolean isCompDef(AssocModel assoc) {
        String typeUri = assoc.getTypeUri();
        if (!typeUri.equals("dmx.core.composition_def")) {
            return false;
        }
        if (assoc.hasSameRoleTypeUris()) {
            return false;
        }
        return assoc.getRoleModel("dmx.core.parent_type") != null && assoc.getRoleModel("dmx.core.child_type") != null;
    }

    private TypeModelImpl fetchParentType() {
        return this.pl.typeStorage.fetchParentType(this);
    }
}

