/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.webclient;

import java.awt.Desktop;
import java.net.URI;
import java.util.logging.Logger;
import systems.dmx.core.AssocType;
import systems.dmx.core.DMXType;
import systems.dmx.core.JSONEnabled;
import systems.dmx.core.RelatedAssoc;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.ViewConfiguration;
import systems.dmx.core.model.AssocTypeModel;
import systems.dmx.core.model.CompDefModel;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.model.TopicTypeModel;
import systems.dmx.core.model.TypeModel;
import systems.dmx.core.model.ViewConfigurationModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Directive;
import systems.dmx.core.service.Directives;
import systems.dmx.core.service.event.AllPluginsActiveListener;
import systems.dmx.core.service.event.IntroduceAssocTypeListener;
import systems.dmx.core.service.event.IntroduceTopicTypeListener;
import systems.dmx.core.service.event.PostUpdateTopicListener;
import systems.dmx.core.service.event.PreCreateAssocTypeListener;
import systems.dmx.core.service.event.PreCreateTopicTypeListener;

public class WebclientPlugin
extends PluginActivator
implements AllPluginsActiveListener,
IntroduceTopicTypeListener,
IntroduceAssocTypeListener,
PreCreateTopicTypeListener,
PreCreateAssocTypeListener,
PostUpdateTopicListener {
    private static final String VIEW_CONFIG_LABEL = "View Configuration";
    private boolean hasWebclientLaunched = false;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void allPluginsActive() {
        String webclientUrl = this.getWebclientUrl();
        if (this.hasWebclientLaunched) {
            this.logger.info("### Launching webclient (url=\"" + webclientUrl + "\") SKIPPED -- already launched");
            return;
        }
        try {
            this.logger.info("### Launching webclient (url=\"" + webclientUrl + "\")");
            Desktop.getDesktop().browse(new URI(webclientUrl));
            this.hasWebclientLaunched = true;
        }
        catch (Exception e) {
            this.logger.warning("### Launching webclient failed (" + e + ")");
            this.logger.warning("### To launch it manually: " + webclientUrl);
        }
    }

    public void preCreateTopicType(TopicTypeModel model) {
        this.addDefaultViewConfig((TypeModel)model);
    }

    public void preCreateAssocType(AssocTypeModel model) {
        this.addDefaultViewConfig((TypeModel)model);
    }

    public void postUpdateTopic(Topic topic, TopicModel updateModel, TopicModel oldTopic) {
        if (topic.getTypeUri().equals("dmx.webclient.view_config")) {
            this.setDefaultConfigTopicLabel(topic);
            this.updateTypeCacheAndAddDirective(topic);
        }
    }

    public void introduceTopicType(TopicType topicType) {
        this.setViewConfigLabel((DMXType)topicType);
    }

    public void introduceAssocType(AssocType assocType) {
        this.setViewConfigLabel((DMXType)assocType);
    }

    private void updateTypeCacheAndAddDirective(Topic viewConfigTopic) {
        String typeUri;
        RelatedTopic type = viewConfigTopic.getRelatedTopic("dmx.core.composition", "dmx.core.child", "dmx.core.parent", null);
        long compDefId = -1L;
        if (type == null) {
            RelatedAssoc compDef = viewConfigTopic.getRelatedAssociation("dmx.core.composition", "dmx.core.child", "dmx.core.parent", "dmx.core.composition_def");
            if (compDef == null) {
                throw new RuntimeException("Orphaned view config topic: " + viewConfigTopic);
            }
            type = (Topic)compDef.getPlayer("dmx.core.parent_type");
            compDefId = compDef.getId();
        }
        if ((typeUri = type.getTypeUri()).equals("dmx.core.topic_type") || typeUri.equals("dmx.core.meta_type")) {
            this._updateTypeCacheAndAddDirective((DMXType)this.dmx.getTopicType(type.getUri()), compDefId, viewConfigTopic, Directive.UPDATE_TOPIC_TYPE);
        } else if (typeUri.equals("dmx.core.assoc_type")) {
            this._updateTypeCacheAndAddDirective((DMXType)this.dmx.getAssocType(type.getUri()), compDefId, viewConfigTopic, Directive.UPDATE_ASSOCIATION_TYPE);
        } else {
            throw new RuntimeException("View config " + viewConfigTopic.getId() + " is associated unexpectedly, type=" + type + ", compDefId=" + compDefId + ", viewConfigTopic=" + viewConfigTopic);
        }
    }

    private void _updateTypeCacheAndAddDirective(DMXType type, long compDefId, Topic viewConfigTopic, Directive dir) {
        this.logger.info("### Updating view config of type \"" + type.getUri() + "\" (compDefId=" + compDefId + ")");
        this.updateTypeCache(type.getModel(), compDefId, viewConfigTopic.getModel());
        Directives.get().add(dir, (JSONEnabled)type);
    }

    private void updateTypeCache(TypeModel type, long compDefId, TopicModel viewConfigTopic) {
        ViewConfigurationModel vcm = compDefId == -1L ? type.getViewConfig() : this.getCompDef(type, compDefId).getViewConfig();
        vcm.updateConfigTopic(viewConfigTopic);
    }

    private void setViewConfigLabel(DMXType type) {
        this.setViewConfigLabel(type.getViewConfig());
        for (String compDefUri : type) {
            this.setViewConfigLabel(type.getCompDef(compDefUri).getViewConfig());
        }
    }

    private void setViewConfigLabel(ViewConfiguration viewConfig) {
        for (Topic configTopic : viewConfig.getConfigTopics()) {
            this.setDefaultConfigTopicLabel(configTopic);
        }
    }

    private void setDefaultConfigTopicLabel(Topic viewConfigTopic) {
        viewConfigTopic.setSimpleValue(VIEW_CONFIG_LABEL);
    }

    private void addDefaultViewConfig(TypeModel typeModel) {
        this.addDefaultViewConfigTopic(typeModel.getViewConfig());
        for (String compDefUri : typeModel) {
            this.addDefaultViewConfigTopic(typeModel.getCompDef(compDefUri).getViewConfig());
        }
    }

    private void addDefaultViewConfigTopic(ViewConfigurationModel viewConfig) {
        if (viewConfig.getConfigTopic("dmx.webclient.view_config") == null) {
            viewConfig.addConfigTopic(this.mf.newTopicModel("dmx.webclient.view_config"));
        }
    }

    private String getWebclientUrl() {
        String port;
        String protocol;
        boolean isHttpsEnabled = Boolean.getBoolean("org.apache.felix.https.enable");
        if (isHttpsEnabled) {
            protocol = "https";
            port = System.getProperty("org.osgi.service.http.port.secure");
        } else {
            protocol = "http";
            port = System.getProperty("org.osgi.service.http.port");
        }
        return protocol + "://localhost:" + port + "/systems.dmx.webclient/";
    }

    private CompDefModel getCompDef(TypeModel type, long compDefId) {
        for (CompDefModel compDef : type.getCompDefs()) {
            if (compDef.getId() != compDefId) continue;
            return compDef;
        }
        throw new RuntimeException("Comp def " + compDefId + " not found in type \"" + type.getUri() + "\"");
    }
}

