/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import systems.dmx.core.Player;
import systems.dmx.core.impl.AssocModelImpl;
import systems.dmx.core.impl.DMXObjectModelImpl;
import systems.dmx.core.impl.ModelFactoryImpl;
import systems.dmx.core.impl.PersistenceLayer;
import systems.dmx.core.model.PlayerModel;

abstract class PlayerModelImpl
implements PlayerModel {
    long playerId = -1L;
    String roleTypeUri;
    PersistenceLayer pl;
    ModelFactoryImpl mf;

    PlayerModelImpl() {
    }

    PlayerModelImpl(long playerId, String roleTypeUri, PersistenceLayer pl) {
        this.setPlayerId(playerId);
        this.setRoleTypeUri(roleTypeUri);
        this.pl = pl;
        this.mf = pl.mf;
    }

    @Override
    public long getPlayerId() {
        if (this.playerId == -1L) {
            throw new IllegalStateException("Player ID is not set in " + this);
        }
        return this.playerId;
    }

    @Override
    public final String getRoleTypeUri() {
        return this.roleTypeUri;
    }

    @Override
    public void setPlayerId(long playerId) {
        this.playerId = playerId;
    }

    @Override
    public final void setRoleTypeUri(String roleTypeUri) {
        if (roleTypeUri == null) {
            throw new IllegalArgumentException("\"roleTypeUri\" must not be null");
        }
        this.roleTypeUri = roleTypeUri;
    }

    @Override
    public boolean refsSameObject(PlayerModel model) {
        return this.getPlayerId() == model.getPlayerId();
    }

    @Override
    public PlayerModel clone() {
        try {
            return (PlayerModel)super.clone();
        }
        catch (Exception e) {
            throw new RuntimeException("Cloning a PlayerModel failed", e);
        }
    }

    public String toString() {
        try {
            return this.getClass().getSimpleName() + " " + this.toJSON().toString(4);
        }
        catch (Exception e) {
            throw new RuntimeException("Prettyprinting failed", e);
        }
    }

    abstract Player instantiate(AssocModelImpl var1);

    abstract DMXObjectModelImpl getPlayer(AssocModelImpl var1);
}

