/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.contacts;

import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import systems.dmx.contacts.ContactsService;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.model.AssocModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.event.PreCreateAssocListener;
import systems.dmx.core.util.DMXUtils;

@Path(value="/contacts")
@Produces(value={"application/json"})
public class ContactsPlugin
extends PluginActivator
implements ContactsService,
PreCreateAssocListener {
    @Override
    @GET
    @Path(value="/person/{id}/organizations")
    public List<RelatedTopic> getOrganizations(@PathParam(value="id") long personId) {
        return this.dmx.getTopic(personId).getRelatedTopics("dmx.contacts.organization_involvement", "dmx.core.default", "dmx.core.default", "dmx.contacts.organization");
    }

    @Override
    @GET
    @Path(value="/organization/{id}/persons")
    public List<RelatedTopic> getPersons(@PathParam(value="id") long organizationId) {
        return this.dmx.getTopic(organizationId).getRelatedTopics("dmx.contacts.organization_involvement", "dmx.core.default", "dmx.core.default", "dmx.contacts.person");
    }

    public void preCreateAssociation(AssocModel assoc) {
        DMXUtils.associationAutoTyping((AssocModel)assoc, (String)"dmx.contacts.person", (String)"dmx.contacts.organization", (String)"dmx.contacts.organization_involvement", (String)"dmx.core.default", (String)"dmx.core.default");
    }
}

