/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.webservice;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.Assoc;
import systems.dmx.core.AssocType;
import systems.dmx.core.DMXObject;
import systems.dmx.core.JSONEnabled;
import systems.dmx.core.RelatedAssoc;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.model.AssocModel;
import systems.dmx.core.model.AssocTypeModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.model.TopicTypeModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.DirectivesResponse;
import systems.dmx.core.service.PluginInfo;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.util.IdList;

@Path(value="/core")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class WebservicePlugin
extends PluginActivator {
    @Context
    private HttpServletRequest request;
    private Messenger me = new Messenger("systems.dmx.webclient");
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    @GET
    @Path(value="/topic/{id}")
    public Topic getTopic(@PathParam(value="id") long topicId) {
        return this.dmx.getTopic(topicId);
    }

    @GET
    @Path(value="/topic/by_uri/{uri}")
    public Topic getTopicByUri(@PathParam(value="uri") String uri) {
        return this.dmx.getTopicByUri(uri);
    }

    @GET
    @Path(value="/topic/by_value/{key}/{value}")
    public Topic getTopicByValue(@PathParam(value="key") String key, @PathParam(value="value") SimpleValue value) {
        return this.dmx.getTopicByValue(key, value);
    }

    @GET
    @Path(value="/topic/multi/by_value/{key}/{value}")
    public List<Topic> getTopicsByValue(@PathParam(value="key") String key, @PathParam(value="value") SimpleValue value) {
        return this.dmx.getTopicsByValue(key, value);
    }

    @GET
    @Path(value="/topic/by_type/{topic_type_uri}")
    public List<Topic> getTopicsByType(@PathParam(value="topic_type_uri") String topicTypeUri) {
        return this.dmx.getTopicsByType(topicTypeUri);
    }

    @GET
    @Path(value="/topic")
    public List<Topic> searchTopics(@QueryParam(value="search") String searchTerm, @QueryParam(value="field") String fieldUri) {
        return this.dmx.searchTopics(searchTerm, fieldUri);
    }

    @POST
    @Path(value="/topic")
    @Transactional
    public DirectivesResponse createTopic(TopicModel model) {
        return new DirectivesResponse((DMXObject)this.dmx.createTopic(model));
    }

    @PUT
    @Path(value="/topic/{id}")
    @Transactional
    public DirectivesResponse updateTopic(@PathParam(value="id") long topicId, TopicModel model) {
        if (model.getId() != -1L && topicId != model.getId()) {
            throw new RuntimeException("ID mismatch in update request");
        }
        model.setId(topicId);
        this.dmx.updateTopic(model);
        return new DirectivesResponse();
    }

    @DELETE
    @Path(value="/topic/{id}")
    @Transactional
    public DirectivesResponse deleteTopic(@PathParam(value="id") long topicId) {
        this.dmx.deleteTopic(topicId);
        return new DirectivesResponse();
    }

    @GET
    @Path(value="/association/{id}")
    public Assoc getAssoc(@PathParam(value="id") long assocId) {
        return this.dmx.getAssoc(assocId);
    }

    @GET
    @Path(value="/assoc/by_value/{key}/{value}")
    public Assoc getAssocByValue(@PathParam(value="key") String key, @PathParam(value="value") SimpleValue value) {
        return this.dmx.getAssocByValue(key, value);
    }

    @GET
    @Path(value="/assoc/multi/by_value/{key}/{value}")
    public List<Assoc> getAssocsByValue(@PathParam(value="key") String key, @PathParam(value="value") SimpleValue value) {
        return this.dmx.getAssocsByValue(key, value);
    }

    @GET
    @Path(value="/association/{assoc_type_uri}/{topic1_id}/{topic2_id}/{role_type1_uri}/{role_type2_uri}")
    public Assoc getAssoc(@PathParam(value="assoc_type_uri") String assocTypeUri, @PathParam(value="topic1_id") long topic1Id, @PathParam(value="topic2_id") long topic2Id, @PathParam(value="role_type1_uri") String roleTypeUri1, @PathParam(value="role_type2_uri") String roleTypeUri2) {
        return this.dmx.getAssoc(assocTypeUri, topic1Id, topic2Id, roleTypeUri1, roleTypeUri2);
    }

    @GET
    @Path(value="/association/multiple/{topic1_id}/{topic2_id}")
    public List<Assoc> getAssocs(@PathParam(value="topic1_id") long topic1Id, @PathParam(value="topic2_id") long topic2Id) {
        return this.dmx.getAssocs(topic1Id, topic2Id);
    }

    @GET
    @Path(value="/association/multiple/{topic1_id}/{topic2_id}/{assoc_type_uri}")
    public List<Assoc> getAssocs(@PathParam(value="topic1_id") long topic1Id, @PathParam(value="topic2_id") long topic2Id, @PathParam(value="assoc_type_uri") String assocTypeUri) {
        return this.dmx.getAssocs(topic1Id, topic2Id, assocTypeUri);
    }

    @POST
    @Path(value="/association")
    @Transactional
    public DirectivesResponse createAssoc(AssocModel model) {
        return new DirectivesResponse((DMXObject)this.dmx.createAssoc(model));
    }

    @PUT
    @Path(value="/association/{id}")
    @Transactional
    public DirectivesResponse updateAssociation(@PathParam(value="id") long assocId, AssocModel model) {
        if (model.getId() != -1L && assocId != model.getId()) {
            throw new RuntimeException("ID mismatch in update request");
        }
        model.setId(assocId);
        this.dmx.updateAssociation(model);
        return new DirectivesResponse();
    }

    @DELETE
    @Path(value="/association/{id}")
    @Transactional
    public DirectivesResponse deleteAssociation(@PathParam(value="id") long assocId) {
        this.dmx.deleteAssociation(assocId);
        return new DirectivesResponse();
    }

    @GET
    @Path(value="/topictype/{uri}")
    public TopicType getTopicType(@PathParam(value="uri") String uri) {
        return this.dmx.getTopicType(uri);
    }

    @GET
    @Path(value="/topictype/topic/{id}")
    public TopicType getTopicTypeImplicitly(@PathParam(value="id") long topicId) {
        return this.dmx.getTopicTypeImplicitly(topicId);
    }

    @GET
    @Path(value="/topictype/all")
    public List<TopicType> getAllTopicTypes() {
        return this.dmx.getAllTopicTypes();
    }

    @POST
    @Path(value="/topictype")
    @Transactional
    public TopicType createTopicType(TopicTypeModel model) {
        TopicType topicType = this.dmx.createTopicType(model);
        this.me.newTopicType(topicType);
        return topicType;
    }

    @PUT
    @Path(value="/topictype")
    @Transactional
    public DirectivesResponse updateTopicType(TopicTypeModel model) {
        this.dmx.updateTopicType(model);
        return new DirectivesResponse();
    }

    @DELETE
    @Path(value="/topictype/{uri}")
    @Transactional
    public DirectivesResponse deleteTopicType(@PathParam(value="uri") String uri) {
        this.dmx.deleteTopicType(uri);
        return new DirectivesResponse();
    }

    @GET
    @Path(value="/assoctype/{uri}")
    public AssocType getAssocType(@PathParam(value="uri") String uri) {
        return this.dmx.getAssocType(uri);
    }

    @GET
    @Path(value="/assoctype/assoc/{id}")
    public AssocType getAssocTypeImplicitly(@PathParam(value="id") long assocId) {
        return this.dmx.getAssocTypeImplicitly(assocId);
    }

    @GET
    @Path(value="/assoctype/all")
    public List<AssocType> getAllAssocTypes() {
        return this.dmx.getAllAssocTypes();
    }

    @POST
    @Path(value="/assoctype")
    @Transactional
    public AssocType createAssocType(AssocTypeModel model) {
        AssocType assocType = this.dmx.createAssocType(model);
        this.me.newAssocType(assocType);
        return assocType;
    }

    @PUT
    @Path(value="/assoctype")
    @Transactional
    public DirectivesResponse updateAssocType(AssocTypeModel model) {
        this.dmx.updateAssocType(model);
        return new DirectivesResponse();
    }

    @DELETE
    @Path(value="/assoctype/{uri}")
    @Transactional
    public DirectivesResponse deleteAssocType(@PathParam(value="uri") String uri) {
        this.dmx.deleteAssocType(uri);
        return new DirectivesResponse();
    }

    @POST
    @Path(value="/roletype")
    @Transactional
    public Topic createRoleType(TopicModel model) {
        Topic roleType = this.dmx.createRoleType(model);
        this.me.newRoleType(roleType);
        return roleType;
    }

    @GET
    @Path(value="/plugin")
    public List<PluginInfo> getPluginInfo() {
        return this.dmx.getPluginInfo();
    }

    @GET
    @Path(value="/topic/{id}/related_topics")
    public List<RelatedTopic> getTopicRelatedTopics(@PathParam(value="id") long topicId, @QueryParam(value="assoc_type_uri") String assocTypeUri, @QueryParam(value="my_role_type_uri") String myRoleTypeUri, @QueryParam(value="others_role_type_uri") String othersRoleTypeUri, @QueryParam(value="others_topic_type_uri") String othersTopicTypeUri) {
        Topic topic = this.dmx.getTopic(topicId);
        return this.getRelatedTopics((DMXObject)topic, "topic", assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
    }

    @GET
    @Path(value="/topic/{id}/related_assocs")
    public List<RelatedAssoc> getTopicRelatedAssociations(@PathParam(value="id") long topicId, @QueryParam(value="assoc_type_uri") String assocTypeUri, @QueryParam(value="my_role_type_uri") String myRoleTypeUri, @QueryParam(value="others_role_type_uri") String othersRoleTypeUri, @QueryParam(value="others_assoc_type_uri") String othersAssocTypeUri) {
        Topic topic = this.dmx.getTopic(topicId);
        return this.getRelatedAssociations((DMXObject)topic, "topic", assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
    }

    @GET
    @Path(value="/association/{id}/related_topics")
    public List<RelatedTopic> getAssocRelatedTopics(@PathParam(value="id") long assocId, @QueryParam(value="assoc_type_uri") String assocTypeUri, @QueryParam(value="my_role_type_uri") String myRoleTypeUri, @QueryParam(value="others_role_type_uri") String othersRoleTypeUri, @QueryParam(value="others_topic_type_uri") String othersTopicTypeUri) {
        Assoc assoc = this.dmx.getAssoc(assocId);
        return this.getRelatedTopics((DMXObject)assoc, "association", assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
    }

    @GET
    @Path(value="/association/{id}/related_assocs")
    public List<RelatedAssoc> getAssocRelatedAssociations(@PathParam(value="id") long assocId, @QueryParam(value="assoc_type_uri") String assocTypeUri, @QueryParam(value="my_role_type_uri") String myRoleTypeUri, @QueryParam(value="others_role_type_uri") String othersRoleTypeUri, @QueryParam(value="others_assoc_type_uri") String othersAssocTypeUri) {
        Assoc assoc = this.dmx.getAssoc(assocId);
        return this.getRelatedAssociations((DMXObject)assoc, "association", assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
    }

    @DELETE
    @Path(value="/topics/{topicIds}")
    @Transactional
    public DirectivesResponse deleteTopics(@PathParam(value="topicIds") IdList topicIds) {
        return this.deleteMulti(topicIds, new IdList());
    }

    @DELETE
    @Path(value="/assocs/{assocIds}")
    @Transactional
    public DirectivesResponse deleteAssocs(@PathParam(value="assocIds") IdList assocIds) {
        return this.deleteMulti(new IdList(), assocIds);
    }

    @DELETE
    @Path(value="/topics/{topicIds}/assocs/{assocIds}")
    @Transactional
    public DirectivesResponse deleteMulti(@PathParam(value="topicIds") IdList topicIds, @PathParam(value="assocIds") IdList assocIds) {
        long id;
        this.logger.info("topicIds=" + topicIds + ", assocIds=" + assocIds);
        Iterator iterator = topicIds.iterator();
        while (iterator.hasNext()) {
            id = (Long)iterator.next();
            this.deleteAnyTopic(id);
        }
        iterator = assocIds.iterator();
        while (iterator.hasNext()) {
            id = (Long)iterator.next();
            this.dmx.deleteAssociation(id);
        }
        return new DirectivesResponse();
    }

    @GET
    @Path(value="/websockets")
    public JSONEnabled getWebSocketsConfig() {
        return new JSONEnabled(){

            public JSONObject toJSON() {
                try {
                    return new JSONObject().put("dmx.websockets.url", (Object)WebservicePlugin.this.dmx.getWebSocketsService().getWebSocketsURL());
                }
                catch (JSONException e) {
                    throw new RuntimeException("Serializing the WebSockets configuration failed", e);
                }
            }
        };
    }

    private List<RelatedTopic> getRelatedTopics(DMXObject object, String objectInfo, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        String operation = "Fetching related topics of " + objectInfo + " " + object.getId();
        String paramInfo = "(assocTypeUri=\"" + assocTypeUri + "\", myRoleTypeUri=\"" + myRoleTypeUri + "\", othersRoleTypeUri=\"" + othersRoleTypeUri + "\", othersTopicTypeUri=\"" + othersTopicTypeUri + "\")";
        try {
            this.logger.fine(operation + " " + paramInfo);
            return object.getRelatedTopics(assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed " + paramInfo, e);
        }
    }

    private List<RelatedAssoc> getRelatedAssociations(DMXObject object, String objectInfo, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        String operation = "Fetching related associations of " + objectInfo + " " + object.getId();
        String paramInfo = "(assocTypeUri=\"" + assocTypeUri + "\", myRoleTypeUri=\"" + myRoleTypeUri + "\", othersRoleTypeUri=\"" + othersRoleTypeUri + "\", othersAssocTypeUri=\"" + othersAssocTypeUri + "\")";
        try {
            this.logger.fine(operation + " " + paramInfo);
            return object.getRelatedAssociations(assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed " + paramInfo, e);
        }
    }

    private void deleteAnyTopic(long id) {
        Topic t = this.dmx.getTopic(id);
        String typeUri = t.getTypeUri();
        if (typeUri.equals("dmx.core.topic_type")) {
            this.dmx.deleteTopicType(t.getUri());
        } else if (typeUri.equals("dmx.core.assoc_type")) {
            this.dmx.deleteAssocType(t.getUri());
        } else {
            this.dmx.deleteTopic(id);
        }
    }

    private class Messenger {
        private String pluginUri;

        private Messenger(String pluginUri) {
            this.pluginUri = pluginUri;
        }

        private void newTopicType(TopicType topicType) {
            this.newType((Topic)topicType, "topicType", "newTopicType");
        }

        private void newAssocType(AssocType assocType) {
            this.newType((Topic)assocType, "assocType", "newAssocType");
        }

        private void newRoleType(Topic roleType) {
            this.newType(roleType, "roleType", "newRoleType");
        }

        private void newType(Topic type, String argName, String messageType) {
            try {
                this.messageToAllButOne(new JSONObject().put("type", (Object)messageType).put("args", (Object)new JSONObject().put(argName, (Object)type.toJSON())));
            }
            catch (Exception e) {
                WebservicePlugin.this.logger.log(Level.WARNING, "Error while sending a \"" + messageType + "\" message:", e);
            }
        }

        private void messageToAllButOne(JSONObject message) {
            WebservicePlugin.this.dmx.getWebSocketsService().messageToAllButOne(WebservicePlugin.this.request, this.pluginUri, message.toString());
        }
    }
}

