/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.List;
import java.util.logging.Logger;
import systems.dmx.core.Assoc;
import systems.dmx.core.DMXObject;
import systems.dmx.core.Player;
import systems.dmx.core.RelatedAssoc;
import systems.dmx.core.RelatedObject;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicPlayer;
import systems.dmx.core.impl.AssocModelImpl;
import systems.dmx.core.impl.DMXObjectImpl;
import systems.dmx.core.impl.DMXObjectModelImpl;
import systems.dmx.core.impl.PersistenceLayer;
import systems.dmx.core.impl.RelatedAssocModelImpl;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.model.AssocModel;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.TopicPlayerModel;

class AssocImpl
extends DMXObjectImpl
implements Assoc {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    AssocImpl(AssocModelImpl model, PersistenceLayer pl) {
        super(model, pl);
    }

    @Override
    public final Player getRole1() {
        return this.getModel().getRoleModel1().instantiate(this.getModel());
    }

    @Override
    public final Player getRole2() {
        return this.getModel().getRoleModel2().instantiate(this.getModel());
    }

    @Override
    public final DMXObject getPlayer1() {
        return this.getRole1().getPlayer();
    }

    @Override
    public final DMXObject getPlayer2() {
        return this.getRole2().getPlayer();
    }

    @Override
    public final Player getRole(String roleTypeUri) {
        return this.getModel().getRoleModel(roleTypeUri).instantiate(this.getModel());
    }

    @Override
    public final boolean hasSameRoleTypeUris() {
        return this.getModel().hasSameRoleTypeUris();
    }

    @Override
    public final boolean matches(String roleTypeUri1, long playerId1, String roleTypeUri2, long playerId2) {
        return this.getModel().matches(roleTypeUri1, playerId1, roleTypeUri2, playerId2);
    }

    @Override
    public final long getOtherPlayerId(long id) {
        return this.getModel().getOtherPlayerId(id);
    }

    @Override
    public final RelatedObject getPlayer(String roleTypeUri) {
        DMXObjectModelImpl object = this.getModel().getPlayer(roleTypeUri);
        return object != null ? (RelatedObject)object.instantiate() : null;
    }

    @Override
    public final Topic getTopicByType(String topicTypeUri) {
        TopicModelImpl topic = this.getModel().getTopicByType(topicTypeUri);
        return topic != null ? topic.instantiate() : null;
    }

    @Override
    public final Player getRole(PlayerModel roleModel) {
        if (this.getRole1().getModel().refsSameObject(roleModel)) {
            return this.getRole1();
        }
        if (this.getRole2().getModel().refsSameObject(roleModel)) {
            return this.getRole2();
        }
        throw new RuntimeException("Player is not part of association (role=" + roleModel + ", association=" + this);
    }

    @Override
    public final boolean isPlayer(TopicPlayerModel roleModel) {
        return this.filterRole(this.getRole1(), roleModel) != null || this.filterRole(this.getRole2(), roleModel) != null;
    }

    @Override
    public final void update(AssocModel updateModel) {
        this.pl.updateAssociation(this.getModel(), (AssocModelImpl)updateModel);
    }

    @Override
    public final void delete() {
        this.pl.deleteAssociation(this.getModel());
    }

    @Override
    public final Assoc loadChildTopics() {
        super.loadChildTopics();
        return this;
    }

    @Override
    public final Assoc loadChildTopics(String compDefUri) {
        super.loadChildTopics(compDefUri);
        return this;
    }

    @Override
    public AssocModelImpl getModel() {
        return (AssocModelImpl)this.model;
    }

    @Override
    public final RelatedAssoc getRelatedAssociation(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        RelatedAssocModelImpl assoc = this.pl.getAssocRelatedAssociation(this.getId(), assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
        return assoc != null ? assoc.instantiate() : null;
    }

    @Override
    public final List<RelatedAssoc> getRelatedAssociations(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        return this.pl.instantiate(this.pl.getAssocRelatedAssociations(this.getId(), assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri));
    }

    @Override
    public final Assoc getAssoc(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, long othersTopicId) {
        return this.pl.getAssocBetweenTopicAndAssociation(assocTypeUri, othersTopicId, this.getId(), othersRoleTypeUri, myRoleTypeUri);
    }

    @Override
    public final List<Assoc> getAssocs() {
        return this.pl.instantiate(this.pl.getAssocAssociations(this.getId()));
    }

    private final TopicPlayer filterRole(Player role, TopicPlayerModel roleModel) {
        return role instanceof TopicPlayer && role.getRoleTypeUri().equals(roleModel.getRoleTypeUri()) && role.getPlayerId() == roleModel.getPlayerId() ? (TopicPlayer)role : null;
    }
}

