/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.List;
import java.util.logging.Logger;
import systems.dmx.core.Assoc;
import systems.dmx.core.RelatedAssoc;
import systems.dmx.core.Topic;
import systems.dmx.core.impl.DMXObjectImpl;
import systems.dmx.core.impl.PersistenceLayer;
import systems.dmx.core.impl.RelatedAssocModelImpl;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.model.TopicModel;

class TopicImpl
extends DMXObjectImpl
implements Topic {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    TopicImpl(TopicModelImpl model, PersistenceLayer pl) {
        super(model, pl);
    }

    @Override
    public final void update(TopicModel updateModel) {
        this.pl.updateTopic(this.getModel(), (TopicModelImpl)updateModel);
    }

    @Override
    public final void delete() {
        this.pl.deleteTopic(this.getModel());
    }

    @Override
    public final Topic findChildTopic(String topicTypeUri) {
        TopicModelImpl topic = this.getModel().findChildTopic(topicTypeUri);
        return topic != null ? topic.instantiate() : null;
    }

    @Override
    public final Topic loadChildTopics() {
        super.loadChildTopics();
        return this;
    }

    @Override
    public final Topic loadChildTopics(String compDefUri) {
        super.loadChildTopics(compDefUri);
        return this;
    }

    @Override
    public TopicModelImpl getModel() {
        return (TopicModelImpl)this.model;
    }

    @Override
    public final RelatedAssoc getRelatedAssociation(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        RelatedAssocModelImpl assoc = this.pl.getTopicRelatedAssociation(this.getId(), assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
        return assoc != null ? assoc.instantiate() : null;
    }

    @Override
    public final List<RelatedAssoc> getRelatedAssociations(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        return this.pl.instantiate(this.pl.getTopicRelatedAssociations(this.getId(), assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri));
    }

    @Override
    public final Assoc getAssoc(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, long othersTopicId) {
        return this.pl.getAssoc(assocTypeUri, this.getId(), othersTopicId, myRoleTypeUri, othersRoleTypeUri);
    }

    @Override
    public final List<Assoc> getAssocs() {
        return this.pl.instantiate(this.pl.getTopicAssociations(this.getId()));
    }
}

