/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Properties;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONTokener;
import systems.dmx.core.impl.CoreServiceImpl;
import systems.dmx.core.impl.PluginImpl;
import systems.dmx.core.service.Migration;
import systems.dmx.core.service.ModelFactory;
import systems.dmx.core.util.JavaUtils;

class MigrationManager {
    private static final String CORE_MIGRATIONS_PACKAGE = "systems.dmx.core.migrations";
    private static final int CORE_MODEL_VERSION = 3;
    private CoreServiceImpl dmx;
    private ModelFactory mf;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    MigrationManager(CoreServiceImpl dmx) {
        this.dmx = dmx;
        this.mf = dmx.mf;
    }

    void runPluginMigrations(PluginImpl plugin, boolean isCleanInstall) {
        int installedModelVersion = plugin.getPluginTopic().getChildTopics().getTopic("dmx.core.plugin_migration_nr").getSimpleValue().intValue();
        int requiredModelVersion = Integer.parseInt(plugin.getConfigProperty("dmx.plugin.model_version", "0"));
        int migrationsToRun = requiredModelVersion - installedModelVersion;
        if (migrationsToRun == 0) {
            this.logger.info("Running migrations for " + plugin + " SKIPPED -- installed model is up-to-date (version " + installedModelVersion + ")");
            return;
        }
        this.logger.info("Running " + migrationsToRun + " migrations for " + plugin + " (installed model: version " + installedModelVersion + ", required model: version " + requiredModelVersion + ")");
        for (int i = installedModelVersion + 1; i <= requiredModelVersion; ++i) {
            this.runMigration(i, plugin, isCleanInstall);
        }
    }

    void runCoreMigrations(boolean isCleanInstall) {
        int requiredModelVersion = 3;
        int installedModelVersion = this.dmx.pl.fetchMigrationNr();
        int migrationsToRun = requiredModelVersion - installedModelVersion;
        if (migrationsToRun == 0) {
            this.logger.info("Running core migrations SKIPPED -- installed model is up-to-date (version " + installedModelVersion + ")");
            return;
        }
        this.logger.info("Running " + migrationsToRun + " core migrations (installed model: version " + installedModelVersion + ", required model: version " + requiredModelVersion + ")");
        for (int i = installedModelVersion + 1; i <= requiredModelVersion; ++i) {
            this.runMigration(i, null, isCleanInstall);
        }
    }

    private void runMigration(int migrationNr, PluginImpl plugin, boolean isCleanInstall) {
        MigrationInfo mi = null;
        try {
            mi = new MigrationInfo(migrationNr, plugin);
            if (!mi.success) {
                throw mi.exception;
            }
            mi.checkValidity();
            this._runMigration(mi, isCleanInstall);
            this.updateVersionNumber(mi);
        }
        catch (Exception e) {
            throw new RuntimeException("Running " + mi.migrationInfo + " failed", e);
        }
    }

    private void _runMigration(MigrationInfo mi, boolean isCleanInstall) throws Exception {
        String runInfo = " (runMode=" + mi.runMode + ", isCleanInstall=" + isCleanInstall + ")";
        if (mi.runMode.equals(MigrationRunMode.CLEAN_INSTALL.name()) == isCleanInstall || mi.runMode.equals(MigrationRunMode.ALWAYS.name())) {
            this.logger.info("Running " + mi.migrationInfo + runInfo);
            if (mi.isDeclarative) {
                this.readMigrationFile(mi.migrationIn, mi.migrationFile);
            } else {
                Migration migration = (Migration)mi.migrationClass.newInstance();
                this.injectServices(migration, mi.migrationInfo, mi.plugin);
                migration.setCoreService(this.dmx);
                this.logger.info("Running " + mi.migrationType + " migration class " + mi.migrationClassName);
                migration.run();
            }
        } else {
            this.logger.info("Running " + mi.migrationInfo + " SKIPPED" + runInfo);
        }
    }

    private void updateVersionNumber(MigrationInfo mi) {
        try {
            this.logger.info("Updating installed model: version " + mi.migrationNr);
            if (mi.migrationType.equals("core")) {
                this.dmx.pl.storeMigrationNr(mi.migrationNr);
            } else {
                mi.plugin.setMigrationNr(mi.migrationNr);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Updating the model version number to " + mi.migrationNr + " failed", e);
        }
    }

    private void injectServices(Migration migration, String migrationInfo, PluginImpl plugin) {
        try {
            for (Field field : PluginImpl.getInjectableFields(migration.getClass())) {
                Class<?> serviceInterface = field.getType();
                Object service = serviceInterface.getName().equals(plugin.getProvidedServiceInterface()) ? plugin.getContext() : plugin.getInjectedService(serviceInterface);
                this.logger.info("Injecting service " + serviceInterface.getName() + " into " + migrationInfo);
                field.set(migration, service);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Injecting services into " + migrationInfo + " failed", e);
        }
    }

    private void readMigrationFile(InputStream in, String migrationFileName) {
        block4: {
            try {
                this.logger.info("Reading migration file \"" + migrationFileName + "\"");
                String fileContent = JavaUtils.readText(in);
                Object value = new JSONTokener(fileContent).nextValue();
                if (value instanceof JSONObject) {
                    this.readEntities((JSONObject)value);
                    break block4;
                }
                if (value instanceof JSONArray) {
                    this.readEntities((JSONArray)value);
                    break block4;
                }
                throw new RuntimeException("Invalid file content");
            }
            catch (Exception e) {
                throw new RuntimeException("Reading migration file \"" + migrationFileName + "\" failed", e);
            }
        }
    }

    private void readEntities(JSONArray entities) throws JSONException {
        for (int i = 0; i < entities.length(); ++i) {
            this.readEntities(entities.getJSONObject(i));
        }
    }

    private void readEntities(JSONObject entities) throws JSONException {
        JSONArray assocs;
        JSONArray topics;
        JSONArray assocTypes;
        JSONArray topicTypes = entities.optJSONArray("topic_types");
        if (topicTypes != null) {
            this.createTopicTypes(topicTypes);
        }
        if ((assocTypes = entities.optJSONArray("assoc_types")) != null) {
            this.createAssocTypes(assocTypes);
        }
        if ((topics = entities.optJSONArray("topics")) != null) {
            this.createTopics(topics);
        }
        if ((assocs = entities.optJSONArray("associations")) != null) {
            this.createAssociations(assocs);
        }
    }

    private void createTopicTypes(JSONArray topicTypes) throws JSONException {
        for (int i = 0; i < topicTypes.length(); ++i) {
            this.dmx.createTopicType(this.mf.newTopicTypeModel(topicTypes.getJSONObject(i)));
        }
    }

    private void createAssocTypes(JSONArray assocTypes) throws JSONException {
        for (int i = 0; i < assocTypes.length(); ++i) {
            this.dmx.createAssocType(this.mf.newAssocTypeModel(assocTypes.getJSONObject(i)));
        }
    }

    private void createTopics(JSONArray topics) throws JSONException {
        for (int i = 0; i < topics.length(); ++i) {
            this.dmx.createTopic(this.mf.newTopicModel(topics.getJSONObject(i)));
        }
    }

    private void createAssociations(JSONArray assocs) throws JSONException {
        for (int i = 0; i < assocs.length(); ++i) {
            this.dmx.createAssoc(this.mf.newAssocModel(assocs.getJSONObject(i)));
        }
    }

    private class MigrationInfo {
        int migrationNr;
        PluginImpl plugin;
        String migrationType;
        String migrationInfo;
        String runMode;
        boolean isDeclarative;
        boolean isImperative;
        String migrationFile;
        InputStream migrationIn;
        String migrationClassName;
        Class migrationClass;
        boolean success;
        Exception exception;

        MigrationInfo(int migrationNr, PluginImpl plugin) {
            try {
                InputStream configIn;
                this.migrationNr = migrationNr;
                this.plugin = plugin;
                String configFile = this.migrationConfigFile();
                this.migrationFile = this.migrationFile();
                String string = this.migrationType = plugin != null ? "plugin" : "core";
                if (this.migrationType.equals("core")) {
                    this.migrationInfo = "core migration " + migrationNr;
                    configIn = this.getClass().getResourceAsStream(configFile);
                    this.migrationIn = this.getClass().getResourceAsStream(this.migrationFile);
                    this.migrationClassName = this.coreMigrationClassName();
                    this.migrationClass = this.loadClass(this.migrationClassName);
                } else {
                    this.migrationInfo = "migration " + migrationNr + " of " + plugin;
                    configIn = this.getStaticResourceOrNull(configFile);
                    this.migrationIn = this.getStaticResourceOrNull(this.migrationFile);
                    this.migrationClassName = plugin.getMigrationClassName(migrationNr);
                    if (this.migrationClassName != null) {
                        this.migrationClass = plugin.loadClass(this.migrationClassName);
                    }
                }
                this.isDeclarative = this.migrationIn != null;
                this.isImperative = this.migrationClass != null;
                this.readMigrationConfigFile(configIn, configFile);
                this.success = true;
            }
            catch (Exception e) {
                this.exception = e;
            }
        }

        private void checkValidity() {
            if (!this.isDeclarative && !this.isImperative) {
                String message = "Neither a migration file (" + this.migrationFile + ") nor a migration class ";
                if (this.migrationClassName != null) {
                    throw new RuntimeException(message + "(" + this.migrationClassName + ") is found");
                }
                throw new RuntimeException(message + "is found. Note: a possible migration class can't be located (plugin package is unknown). Consider setting \"dmx.plugin.main_package\" in plugin.properties");
            }
            if (this.isDeclarative && this.isImperative) {
                throw new RuntimeException("Ambiguity: a migration file (" + this.migrationFile + ") AND a migration class (" + this.migrationClassName + ") are found. Consider using two different migration numbers.");
            }
        }

        private void readMigrationConfigFile(InputStream in, String configFile) {
            try {
                Properties migrationConfig = new Properties();
                if (in != null) {
                    MigrationManager.this.logger.info("Reading migration config file \"" + configFile + "\"");
                    migrationConfig.load(in);
                } else {
                    MigrationManager.this.logger.info("Reading migration config file \"" + configFile + "\" SKIPPED -- file does not exist");
                }
                this.runMode = migrationConfig.getProperty("migrationRunMode", MigrationRunMode.ALWAYS.name());
                MigrationRunMode.valueOf(this.runMode);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Reading migration config file \"" + configFile + "\" failed: \"" + this.runMode + "\" is an invalid value for \"migrationRunMode\"", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Reading migration config file \"" + configFile + "\" failed", e);
            }
        }

        private String migrationFile() {
            return "/migrations/migration" + this.migrationNr + ".json";
        }

        private String migrationConfigFile() {
            return "/migrations/migration" + this.migrationNr + ".properties";
        }

        private String coreMigrationClassName() {
            return "systems.dmx.core.migrations.Migration" + this.migrationNr;
        }

        private InputStream getStaticResourceOrNull(String resourceName) {
            if (this.plugin.hasStaticResource(resourceName)) {
                return this.plugin.getStaticResource(resourceName);
            }
            return null;
        }

        private Class loadClass(String className) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
    }

    private static enum MigrationRunMode {
        CLEAN_INSTALL,
        UPDATE,
        ALWAYS;

    }
}

