/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.events;

import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.model.AssocModel;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.event.PreCreateAssoc;
import systems.dmx.core.util.DMXUtils;
import systems.dmx.events.EventsService;
import systems.dmx.timestamps.TimestampsService;

@Path(value="/event")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class EventsPlugin
extends PluginActivator
implements EventsService,
PreCreateAssoc {
    @Inject
    private TimestampsService timestampsService;
    private static final Logger logger = Logger.getLogger(EventsPlugin.class.getName());

    @Override
    @GET
    @Path(value="/person/{id}")
    public List<RelatedTopic> getEvents(@PathParam(value="id") long personId) {
        return this.dmx.getTopic(personId).getRelatedTopics("dmx.events.event_involvement", "dmx.core.default", "dmx.core.default", "dmx.events.event");
    }

    @Override
    @GET
    @Path(value="/{id}/persons")
    public List<RelatedTopic> getPersons(@PathParam(value="id") long eventId) {
        return this.dmx.getTopic(eventId).getRelatedTopics("dmx.events.event_involvement", "dmx.core.default", "dmx.core.default", "dmx.contacts.person");
    }

    public void preCreateAssoc(AssocModel assoc) {
        DMXUtils.associationAutoTyping((AssocModel)assoc, (String)"dmx.events.event", (String)"dmx.contacts.person", (String)"dmx.events.event_involvement", (String)"dmx.core.default", (String)"dmx.core.default");
        DMXUtils.associationAutoTyping((AssocModel)assoc, (String)"dmx.events.event", (String)"dmx.contacts.organization", (String)"dmx.events.event_involvement", (String)"dmx.core.default", (String)"dmx.core.default");
        PlayerModel[] roles = DMXUtils.associationAutoTyping((AssocModel)assoc, (String)"dmx.events.event", (String)"dmx.contacts.address", (String)"dmx.core.composition", (String)"dmx.core.parent", (String)"dmx.core.child");
        if (roles != null) {
            long eventId = roles[0].getPlayerId();
            Topic event = this.dmx.getTopic(eventId);
            event.getChildTopics().getTopic("dmx.contacts.address").getRelatingAssoc().delete();
            this.timestampsService.setModified((DMXObject)event);
        }
    }
}

