/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.Player;
import systems.dmx.core.impl.AssocModelImpl;
import systems.dmx.core.impl.PersistenceLayer;
import systems.dmx.core.impl.PlayerModelImpl;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.impl.TopicPlayerImpl;
import systems.dmx.core.model.AssocModel;
import systems.dmx.core.model.TopicPlayerModel;

class TopicPlayerModelImpl
extends PlayerModelImpl
implements TopicPlayerModel {
    String topicUri;

    TopicPlayerModelImpl(long topicId, String roleTypeUri, PersistenceLayer pl) {
        this(topicId, null, roleTypeUri, pl);
    }

    TopicPlayerModelImpl(String topicUri, String roleTypeUri, PersistenceLayer pl) {
        this(-1L, topicUri, roleTypeUri, pl);
    }

    TopicPlayerModelImpl(long topicId, String topicUri, String roleTypeUri, PersistenceLayer pl) {
        super(topicId, roleTypeUri, pl);
        this.topicUri = topicUri;
    }

    @Override
    public String getTopicUri() {
        if (this.topicUri == null) {
            throw new IllegalStateException("Player URI is not set in " + this);
        }
        return this.topicUri;
    }

    @Override
    public boolean topicIdentifiedByUri() {
        return this.topicUri != null;
    }

    @Override
    public JSONObject toJSON() {
        try {
            return new JSONObject().put("topicId", this.id).put("topicUri", (Object)this.topicUri).put("roleTypeUri", (Object)this.roleTypeUri);
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed", e);
        }
    }

    @Override
    Player instantiate(AssocModelImpl assoc) {
        return new TopicPlayerImpl(this, assoc);
    }

    @Override
    RelatedTopicModelImpl getDMXObject(AssocModelImpl assoc) {
        return this.mf.newRelatedTopicModel(this.pl.fetchTopic(this.getId()), (AssocModel)assoc);
    }
}

