/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.AssocType;
import systems.dmx.core.DMXObject;
import systems.dmx.core.Identifiable;
import systems.dmx.core.JSONEnabled;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.model.AssocModel;
import systems.dmx.core.model.DMXObjectModel;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.TopicPlayerModel;
import systems.dmx.core.osgi.CoreActivator;
import systems.dmx.core.service.CoreService;

public class DMXUtils {
    private static final Logger logger = Logger.getLogger(DMXUtils.class.getName());
    private static final String DM4_HOST_URL = System.getProperty("dmx.host.url");

    public static boolean isDMXURL(URL url) {
        try {
            return url.toString().startsWith(DM4_HOST_URL);
        }
        catch (Exception e) {
            throw new RuntimeException("Checking for DMX URL failed (url=\"" + url + "\")", e);
        }
    }

    public static List<Long> idList(Iterable<? extends Identifiable> items) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Identifiable identifiable : items) {
            ids.add(identifiable.getId());
        }
        return ids;
    }

    public static <M> List<M> toModelList(Iterable<? extends DMXObject> objects) {
        ArrayList<DMXObjectModel> modelList = new ArrayList<DMXObjectModel>();
        for (DMXObject dMXObject : objects) {
            modelList.add(dMXObject.getModel());
        }
        return modelList;
    }

    public static String topicNames(Iterable<? extends Topic> topics) {
        StringBuilder names = new StringBuilder();
        Iterator<? extends Topic> i = topics.iterator();
        while (i.hasNext()) {
            Topic topic = i.next();
            names.append('\"').append(topic.getSimpleValue()).append('\"');
            if (!i.hasNext()) continue;
            names.append(", ");
        }
        return names.toString();
    }

    public static <T extends DMXObject> List<T> loadChildTopics(List<T> objects) {
        for (DMXObject object : objects) {
            object.loadChildTopics();
        }
        return objects;
    }

    public static Map toMap(JSONObject o) {
        return DMXUtils.toMap(o, new HashMap());
    }

    public static Map toMap(JSONObject o, Map map) {
        try {
            Iterator i = o.keys();
            while (i.hasNext()) {
                String key = (String)i.next();
                map.put(key, o.get(key));
            }
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException("Converting JSONObject to Map failed", e);
        }
    }

    public static List toList(JSONArray o) {
        try {
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < o.length(); ++i) {
                list.add(o.get(i));
            }
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException("Converting JSONArray to List failed", e);
        }
    }

    public static JSONArray toJSONArray(Iterable<? extends JSONEnabled> items) {
        JSONArray array = new JSONArray();
        for (JSONEnabled jSONEnabled : items) {
            array.put((Object)jSONEnabled.toJSON());
        }
        return array;
    }

    public static List<Topic> getParentTopics(Topic topic) {
        ArrayList<Topic> parentTopics = new ArrayList<Topic>();
        List<RelatedTopic> _parentTopics = topic.getRelatedTopics(null, "dmx.core.child", "dmx.core.parent", null);
        if (_parentTopics.isEmpty()) {
            parentTopics.add(topic);
        } else {
            for (Topic topic2 : _parentTopics) {
                parentTopics.addAll(DMXUtils.getParentTopics(topic2));
            }
        }
        return parentTopics;
    }

    public static PlayerModel[] associationAutoTyping(AssocModel assoc, String topicTypeUri1, String topicTypeUri2, String assocTypeUri, String roleTypeUri1, String roleTypeUri2) {
        if (!assoc.getTypeUri().equals("dmx.core.association")) {
            return null;
        }
        PlayerModel[] roles = DMXUtils.getRoleModels(assoc, topicTypeUri1, topicTypeUri2);
        if (roles != null) {
            logger.info("### Auto typing association into \"" + assocTypeUri + "\" (\"" + topicTypeUri1 + "\" <-> \"" + topicTypeUri2 + "\")");
            assoc.setTypeUri(assocTypeUri);
            DMXUtils.setAssocValue(assoc);
            roles[0].setRoleTypeUri(roleTypeUri1);
            roles[1].setRoleTypeUri(roleTypeUri2);
        }
        return roles;
    }

    public static PlayerModel[] getRoleModels(AssocModel assoc, String topicTypeUri1, String topicTypeUri2) {
        PlayerModel r1 = assoc.getPlayer1();
        PlayerModel r2 = assoc.getPlayer2();
        if (!(r1 instanceof TopicPlayerModel) || !(r2 instanceof TopicPlayerModel)) {
            return null;
        }
        CoreService dmx = CoreActivator.getCoreService();
        String t1 = (String)dmx.getProperty(r1.getId(), "typeUri");
        String t2 = (String)dmx.getProperty(r2.getId(), "typeUri");
        PlayerModel roleModel1 = DMXUtils.getPlayer(r1, r2, t1, t2, topicTypeUri1, 1);
        PlayerModel roleModel2 = DMXUtils.getPlayer(r1, r2, t1, t2, topicTypeUri2, 2);
        if (roleModel1 != null && roleModel2 != null && roleModel1 != roleModel2) {
            return new PlayerModel[]{roleModel1, roleModel2};
        }
        return null;
    }

    private static PlayerModel getPlayer(PlayerModel r1, PlayerModel r2, String t1, String t2, String topicTypeUri, int nr) {
        boolean m1 = t1.equals(topicTypeUri);
        boolean m2 = t2.equals(topicTypeUri);
        if (m1 && m2) {
            return nr == 1 ? r1 : r2;
        }
        return m1 ? r1 : (m2 ? r2 : null);
    }

    private static void setAssocValue(AssocModel assoc) {
        AssocType assocType = CoreActivator.getCoreService().getAssocType(assoc.getTypeUri());
        assoc.setSimpleValue(assocType.getSimpleValue());
    }

    static {
        logger.info("Host setting:\ndmx.host.url=\"" + DM4_HOST_URL + "\"");
    }
}

