/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.impl.AssocModelImpl;
import systems.dmx.core.impl.CompDefImpl;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.impl.TypeModelImpl;
import systems.dmx.core.impl.ViewConfigurationModelImpl;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.CompDefModel;
import systems.dmx.core.model.TopicPlayerModel;
import systems.dmx.core.model.ViewConfigurationModel;

class CompDefModelImpl
extends AssocModelImpl
implements CompDefModel {
    ViewConfigurationModelImpl viewConfig;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    CompDefModelImpl(AssocModelImpl assoc) {
        this(assoc, null);
    }

    CompDefModelImpl(AssocModelImpl assoc, ViewConfigurationModelImpl viewConfig) {
        super(assoc);
        this.viewConfig = viewConfig != null ? viewConfig : this.mf.newViewConfigurationModel();
    }

    @Override
    public String getCompDefUri() {
        String customAssocTypeUri = this.getCustomAssocTypeUri();
        return this.getChildTypeUri() + (customAssocTypeUri != null ? "#" + customAssocTypeUri : "");
    }

    @Override
    public String getCustomAssocTypeUri() {
        TopicModelImpl customAssocType = this.getCustomAssocType();
        return customAssocType != null ? customAssocType.getUri() : null;
    }

    @Override
    public String getInstanceLevelAssocTypeUri() {
        String customAssocTypeUri = this.getCustomAssocTypeUri();
        return customAssocTypeUri != null ? customAssocTypeUri : this.defaultInstanceLevelAssocTypeUri();
    }

    @Override
    public String getParentTypeUri() {
        return ((TopicPlayerModel)((Object)this.getPlayerByRole("dmx.core.parent_type"))).getTopicUri();
    }

    @Override
    public String getChildTypeUri() {
        return ((TopicPlayerModel)((Object)this.getPlayerByRole("dmx.core.child_type"))).getTopicUri();
    }

    @Override
    public String getChildCardinalityUri() {
        return this._getCardinalityUri();
    }

    @Override
    public ViewConfigurationModelImpl getViewConfig() {
        return this.viewConfig;
    }

    @Override
    public void setChildCardinalityUri(String childCardinalityUri) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setViewConfig(ViewConfigurationModel viewConfig) {
        this.viewConfig = (ViewConfigurationModelImpl)viewConfig;
    }

    @Override
    public JSONObject toJSON() {
        try {
            return super.toJSON().put("viewConfigTopics", (Object)this.viewConfig.toJSONArray());
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed", e);
        }
    }

    @Override
    String className() {
        return "comp def";
    }

    @Override
    CompDefImpl instantiate() {
        return new CompDefImpl(this, this.pl);
    }

    @Override
    CompDefModelImpl createModelWithChildTopics(ChildTopicsModel childTopics) {
        return this.mf.newCompDefModel(childTopics);
    }

    @Override
    void postCreate() {
    }

    final String _getCardinalityUri() {
        RelatedTopicModelImpl cardinality = this.getChildTopicsModel().getTopicOrNull("dmx.core.cardinality");
        if (cardinality == null) {
            throw new RuntimeException("Comp def \"" + this.getCompDefUri() + "\" has no \"Cardinality\" topic");
        }
        return cardinality.uri;
    }

    final boolean isIdentityAttr() {
        RelatedTopicModelImpl isIdentityAttr = this.getChildTopicsModel().getTopicOrNull("dmx.core.identity_attr");
        if (isIdentityAttr == null) {
            return false;
        }
        return isIdentityAttr.getSimpleValue().booleanValue();
    }

    final boolean includeInLabel() {
        RelatedTopicModelImpl includeInLabel = this.getChildTopicsModel().getTopicOrNull("dmx.core.include_in_label");
        if (includeInLabel == null) {
            return false;
        }
        return includeInLabel.getSimpleValue().booleanValue();
    }

    boolean isReadable() {
        try {
            if (!this.pl.hasReadAccess(this)) {
                this.logger.info("### Comp def \"" + this.getCompDefUri() + "\" not READable");
                return false;
            }
            TopicModelImpl assocType = this.getCustomAssocType();
            if (assocType != null && !this.pl.hasReadAccess(assocType)) {
                this.logger.info("### Comp def \"" + this.getCompDefUri() + "\" not READable (custom assoc type not READable)");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException("Checking comp def READability failed (" + this + ")", e);
        }
    }

    TypeModelImpl getParentType() {
        return this.pl.typeStorage.getType(this.getParentTypeUri());
    }

    TypeModelImpl getChildType() {
        return this.pl.typeStorage.getType(this.getChildTypeUri());
    }

    private TopicModelImpl getCustomAssocType() {
        return this.getChildTopicsModel().getTopicOrNull("dmx.core.assoc_type#dmx.core.custom_assoc_type");
    }

    private String defaultInstanceLevelAssocTypeUri() {
        if (this.typeUri.equals("dmx.core.composition_def")) {
            return "dmx.core.composition";
        }
        throw new RuntimeException("Unexpected association type URI: \"" + this.typeUri + "\"");
    }
}

