/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.List;
import java.util.logging.Logger;
import systems.dmx.core.Assoc;
import systems.dmx.core.DMXObject;
import systems.dmx.core.Player;
import systems.dmx.core.RelatedAssoc;
import systems.dmx.core.RelatedObject;
import systems.dmx.core.TopicPlayer;
import systems.dmx.core.impl.AssocModelImpl;
import systems.dmx.core.impl.DMXObjectImpl;
import systems.dmx.core.impl.DMXObjectModelImpl;
import systems.dmx.core.impl.PersistenceLayer;
import systems.dmx.core.impl.RelatedAssocModelImpl;
import systems.dmx.core.model.AssocModel;
import systems.dmx.core.model.TopicPlayerModel;

class AssocImpl
extends DMXObjectImpl
implements Assoc {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    AssocImpl(AssocModelImpl model, PersistenceLayer pl) {
        super(model, pl);
    }

    @Override
    public final Player getPlayer1() {
        return this.getModel().getPlayer1().instantiate(this.getModel());
    }

    @Override
    public final Player getPlayer2() {
        return this.getModel().getPlayer2().instantiate(this.getModel());
    }

    @Override
    public final DMXObject getDMXObject1() {
        return this.getPlayer1().getDMXObject();
    }

    @Override
    public final DMXObject getDMXObject2() {
        return this.getPlayer2().getDMXObject();
    }

    @Override
    public final RelatedObject getDMXObjectByRole(String roleTypeUri) {
        DMXObjectModelImpl object = this.getModel().getDMXObjectByRole(roleTypeUri);
        return object != null ? (RelatedObject)object.instantiate() : null;
    }

    @Override
    public final DMXObject getDMXObjectByType(String topicTypeUri) {
        DMXObjectModelImpl object = this.getModel().getDMXObjectByType(topicTypeUri);
        return object != null ? object.instantiate() : null;
    }

    @Override
    public final Player getPlayerByRole(String roleTypeUri) {
        return this.getModel().getPlayerByRole(roleTypeUri).instantiate(this.getModel());
    }

    @Override
    public final boolean hasSameRoleTypeUris() {
        return this.getModel().hasSameRoleTypeUris();
    }

    @Override
    public final boolean matches(String roleTypeUri1, long playerId1, String roleTypeUri2, long playerId2) {
        return this.getModel().matches(roleTypeUri1, playerId1, roleTypeUri2, playerId2);
    }

    @Override
    public final long getOtherPlayerId(long id) {
        return this.getModel().getOtherPlayerId(id);
    }

    @Override
    public final boolean isPlayer(TopicPlayerModel roleModel) {
        return this.filterRole(this.getPlayer1(), roleModel) != null || this.filterRole(this.getPlayer2(), roleModel) != null;
    }

    @Override
    public final void update(AssocModel updateModel) {
        this.pl.updateAssoc(this.getModel(), (AssocModelImpl)updateModel);
    }

    @Override
    public final void delete() {
        this.pl.deleteAssoc(this.getModel());
    }

    @Override
    public final Assoc loadChildTopics() {
        super.loadChildTopics();
        return this;
    }

    @Override
    public final Assoc loadChildTopics(String compDefUri) {
        super.loadChildTopics(compDefUri);
        return this;
    }

    @Override
    public AssocModelImpl getModel() {
        return (AssocModelImpl)this.model;
    }

    @Override
    public final RelatedAssoc getRelatedAssoc(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        RelatedAssocModelImpl assoc = this.pl.getAssocRelatedAssoc(this.getId(), assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
        return assoc != null ? assoc.instantiate() : null;
    }

    @Override
    public final List<RelatedAssoc> getRelatedAssocs(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        return this.pl.instantiate(this.pl.getAssocRelatedAssocs(this.getId(), assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri));
    }

    @Override
    public final Assoc getAssoc(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, long othersTopicId) {
        return this.pl.getAssocBetweenTopicAndAssoc(assocTypeUri, othersTopicId, this.getId(), othersRoleTypeUri, myRoleTypeUri);
    }

    @Override
    public final List<Assoc> getAssocs() {
        return this.pl.instantiate(this.pl.getAssocAssocs(this.getId()));
    }

    private final TopicPlayer filterRole(Player role, TopicPlayerModel roleModel) {
        return role instanceof TopicPlayer && role.getRoleTypeUri().equals(roleModel.getRoleTypeUri()) && role.getId() == roleModel.getId() ? (TopicPlayer)role : null;
    }
}

