/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import systems.dmx.core.Assoc;
import systems.dmx.core.AssocType;
import systems.dmx.core.DMXObject;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.impl.AssocImpl;
import systems.dmx.core.impl.AssocIterable;
import systems.dmx.core.impl.AssocModelImpl;
import systems.dmx.core.impl.AssocTypeImpl;
import systems.dmx.core.impl.AssocTypeModelImpl;
import systems.dmx.core.impl.CoreEvent;
import systems.dmx.core.impl.DMXObjectModelImpl;
import systems.dmx.core.impl.EventManager;
import systems.dmx.core.impl.ModelFactoryImpl;
import systems.dmx.core.impl.RelatedAssocModelImpl;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.impl.StorageDecorator;
import systems.dmx.core.impl.TopicImpl;
import systems.dmx.core.impl.TopicIterable;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.impl.TopicTypeImpl;
import systems.dmx.core.impl.TopicTypeModelImpl;
import systems.dmx.core.impl.TypeModelImpl;
import systems.dmx.core.impl.TypeStorage;
import systems.dmx.core.impl.ValueIntegrator;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.service.accesscontrol.AccessControlException;
import systems.dmx.core.storage.spi.DMXStorage;

public final class PersistenceLayer
extends StorageDecorator {
    private static final String URI_PREFIX_TOPIC_TYPE = "domain.project.topic_type_";
    private static final String URI_PREFIX_ASSOCIATION_TYPE = "domain.project.assoc_type_";
    private static final String URI_PREFIX_ROLE_TYPE = "domain.project.role_type_";
    TypeStorage typeStorage;
    EventManager em;
    ModelFactoryImpl mf;
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public PersistenceLayer(DMXStorage storage) {
        super(storage);
        this.em = new EventManager();
        this.mf = (ModelFactoryImpl)storage.getModelFactory();
        this.typeStorage = new TypeStorage(this);
        this.mf.pl = this;
        this.bootstrapTypeCache();
    }

    Topic getTopic(long topicId) {
        try {
            return (Topic)this.checkReadAccessAndInstantiate(this.fetchTopic(topicId));
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching topic " + topicId + " failed", e);
        }
    }

    TopicImpl getTopicByUri(String uri) {
        try {
            TopicModelImpl topic = this.fetchTopicByUri(uri);
            return topic != null ? (TopicImpl)this.checkReadAccessAndInstantiate(topic) : null;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching topic by URI failed (uri=\"" + uri + "\")", e);
        }
    }

    TopicImpl getTopicByValue(String key, SimpleValue value) {
        try {
            TopicModelImpl topic = this.fetchTopic(key, value);
            return topic != null ? (TopicImpl)this.checkReadAccessAndInstantiate(topic) : null;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching topic failed (key=\"" + key + "\", value=\"" + value + "\")", e);
        }
    }

    List<Topic> getTopicsByValue(String key, SimpleValue value) {
        try {
            return this.checkReadAccessAndInstantiate(this.fetchTopics(key, value));
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching topics failed (key=\"" + key + "\", value=\"" + value + "\")", e);
        }
    }

    List<Topic> getTopicsByType(String topicTypeUri) {
        try {
            return this.checkReadAccessAndInstantiate(this._getTopicType(topicTypeUri).getAllInstances());
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching topics by type failed (topicTypeUri=\"" + topicTypeUri + "\")", e);
        }
    }

    List<Topic> searchTopics(String searchTerm, String fieldUri) {
        try {
            return this.checkReadAccessAndInstantiate(this.queryTopics(fieldUri, new SimpleValue(searchTerm)));
        }
        catch (Exception e) {
            throw new RuntimeException("Searching topics failed (searchTerm=\"" + searchTerm + "\", fieldUri=\"" + fieldUri + "\")", e);
        }
    }

    Iterable<Topic> getAllTopics() {
        return new TopicIterable(this);
    }

    TopicImpl createTopic(TopicModelImpl model) {
        try {
            return ((TopicModelImpl)this.updateValues(model, null)).instantiate();
        }
        catch (Exception e) {
            throw new RuntimeException("Creating topic failed, model=" + model, e);
        }
    }

    TopicImpl createSingleTopic(TopicModelImpl model, boolean firePostCreate) {
        return this.createSingleTopic(model, null, firePostCreate);
    }

    private TopicImpl createSingleTopic(TopicModelImpl model, String uriPrefix, boolean firePostCreate) {
        try {
            this.em.fireEvent(CoreEvent.PRE_CREATE_TOPIC, model);
            model.preCreate();
            this.storeTopic(model);
            if (model.getType().isSimple()) {
                model.storeSimpleValue();
            }
            this.createTopicInstantiation(model.getId(), model.getTypeUri());
            if (uriPrefix != null && model.getUri().equals("")) {
                model.updateUri(uriPrefix + model.getId());
            }
            model.postCreate();
            TopicImpl topic = model.instantiate();
            if (firePostCreate) {
                this.em.fireEvent(CoreEvent.POST_CREATE_TOPIC, topic);
            }
            return topic;
        }
        catch (Exception e) {
            throw new RuntimeException("Creating single topic failed, model=" + model + ", uriPrefix=\"" + uriPrefix + "\"", e);
        }
    }

    void updateTopic(TopicModelImpl updateModel) {
        try {
            this.updateTopic(this.fetchTopic(updateModel.getId()), updateModel);
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching and updating topic " + updateModel.getId() + " failed", e);
        }
    }

    void updateTopic(TopicModelImpl topic, TopicModelImpl updateModel) {
        try {
            topic.checkWriteAccess();
            topic.update(updateModel);
        }
        catch (Exception e) {
            throw new RuntimeException("Updating topic " + topic.getId() + " failed", e);
        }
    }

    void deleteTopic(long topicId) {
        try {
            this.deleteTopic(this.fetchTopic(topicId));
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching and deleting topic " + topicId + " failed", e);
        }
    }

    void deleteTopic(TopicModelImpl topic) {
        try {
            topic.checkWriteAccess();
            topic.delete();
        }
        catch (Exception e) {
            throw new RuntimeException("Deleting topic " + topic.getId() + " failed", e);
        }
    }

    Assoc getAssoc(long assocId) {
        try {
            return (Assoc)this.checkReadAccessAndInstantiate(this.fetchAssoc(assocId));
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching association " + assocId + " failed", e);
        }
    }

    Assoc getAssocByValue(String key, SimpleValue value) {
        try {
            AssocModelImpl assoc = this.fetchAssoc(key, value);
            return assoc != null ? (Assoc)this.checkReadAccessAndInstantiate(assoc) : null;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching association failed (key=\"" + key + "\", value=\"" + value + "\")", e);
        }
    }

    List<Assoc> getAssocsByValue(String key, SimpleValue value) {
        try {
            return this.checkReadAccessAndInstantiate(this.fetchAssocs(key, value));
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching associations failed (key=\"" + key + "\", value=\"" + value + "\")", e);
        }
    }

    AssocImpl getAssoc(String assocTypeUri, long topic1Id, long topic2Id, String roleTypeUri1, String roleTypeUri2) {
        String info = "assocTypeUri=\"" + assocTypeUri + "\", topic1Id=" + topic1Id + ", topic2Id=" + topic2Id + ", roleTypeUri1=\"" + roleTypeUri1 + "\", roleTypeUri2=\"" + roleTypeUri2 + "\"";
        try {
            AssocModelImpl assoc = this.fetchAssoc(assocTypeUri, topic1Id, topic2Id, roleTypeUri1, roleTypeUri2);
            return assoc != null ? (AssocImpl)this.checkReadAccessAndInstantiate(assoc) : null;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching association failed (" + info + ")", e);
        }
    }

    Assoc getAssocBetweenTopicAndAssoc(String assocTypeUri, long topicId, long assocId, String topicRoleTypeUri, String assocRoleTypeUri) {
        String info = "assocTypeUri=\"" + assocTypeUri + "\", topicId=" + topicId + ", assocId=" + assocId + ", topicRoleTypeUri=\"" + topicRoleTypeUri + "\", assocRoleTypeUri=\"" + assocRoleTypeUri + "\"";
        this.logger.info(info);
        try {
            AssocModelImpl assoc = this.fetchAssocBetweenTopicAndAssoc(assocTypeUri, topicId, assocId, topicRoleTypeUri, assocRoleTypeUri);
            return assoc != null ? (Assoc)this.checkReadAccessAndInstantiate(assoc) : null;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching association failed (" + info + ")", e);
        }
    }

    List<Assoc> getAssocsByType(String assocTypeUri) {
        try {
            return this.checkReadAccessAndInstantiate(this._getAssocType(assocTypeUri).getAllInstances());
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching associations by type failed (assocTypeUri=\"" + assocTypeUri + "\")", e);
        }
    }

    List<Assoc> getAssocs(long topic1Id, long topic2Id) {
        return this.getAssocs(null, topic1Id, topic2Id);
    }

    List<Assoc> getAssocs(String assocTypeUri, long topic1Id, long topic2Id) {
        return this.getAssocs(assocTypeUri, topic1Id, topic2Id, null, null);
    }

    List<Assoc> getAssocs(String assocTypeUri, long topic1Id, long topic2Id, String roleTypeUri1, String roleTypeUri2) {
        return this.instantiate(this._getAssocs(assocTypeUri, topic1Id, topic2Id, roleTypeUri1, roleTypeUri2));
    }

    Iterable<AssocModelImpl> _getAssocs(String assocTypeUri, long topic1Id, long topic2Id, String roleTypeUri1, String roleTypeUri2) {
        this.logger.fine("assocTypeUri=\"" + assocTypeUri + "\", topic1Id=" + topic1Id + ", topic2Id=" + topic2Id + ", roleTypeUri1=\"" + roleTypeUri1 + "\", roleTypeUri2=\"" + roleTypeUri2 + "\"");
        try {
            return this.filterReadables(this.fetchAssocs(assocTypeUri, topic1Id, topic2Id, roleTypeUri1, roleTypeUri2));
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching associations between topics " + topic1Id + " and " + topic2Id + " failed (assocTypeUri=\"" + assocTypeUri + "\", roleTypeUri1=\"" + roleTypeUri1 + "\", roleTypeUri2=\"" + roleTypeUri2 + "\")", e);
        }
    }

    Iterable<Assoc> getAllAssocs() {
        return new AssocIterable(this);
    }

    List<PlayerModel> getRoleModels(long assocId) {
        return this.fetchRoleModels(assocId);
    }

    AssocImpl createAssoc(String typeUri, PlayerModel player1, PlayerModel player2) {
        return this.createAssoc(this.mf.newAssocModel(typeUri, player1, player2));
    }

    AssocImpl createAssoc(AssocModelImpl model) {
        try {
            this.em.fireEvent(CoreEvent.PRE_CREATE_ASSOCIATION, model);
            model.preCreate();
            this.storeAssoc(model);
            AssocModelImpl _model = this.updateValues(model, null);
            this.createAssocInstantiation(_model.getId(), _model.getTypeUri());
            AssocImpl assoc = _model.instantiate();
            model.value = _model.value;
            model.postCreate();
            this.em.fireEvent(CoreEvent.POST_CREATE_ASSOCIATION, assoc);
            return assoc;
        }
        catch (Exception e) {
            throw new RuntimeException("Creating association failed, model=" + model, e);
        }
    }

    void updateAssoc(AssocModelImpl updateModel) {
        try {
            AssocModelImpl model = this.fetchAssoc(updateModel.getId());
            this.updateAssoc(model, updateModel);
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching and updating association " + updateModel.getId() + " failed", e);
        }
    }

    void updateAssoc(AssocModelImpl assoc, AssocModelImpl updateModel) {
        try {
            assoc.checkWriteAccess();
            assoc.update(updateModel);
        }
        catch (Exception e) {
            throw new RuntimeException("Updating association " + assoc.getId() + " failed, assoc=" + assoc + ", updateModel=" + updateModel, e);
        }
    }

    void deleteAssoc(long assocId) {
        try {
            this.deleteAssoc(this.fetchAssoc(assocId));
        }
        catch (IllegalStateException e) {
            if (e.getMessage().equals("Node[" + assocId + "] has been deleted in this tx")) {
                this.logger.info("### Assoc " + assocId + " has already been deleted in this transaction. This can happen while delete-multi.");
            }
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching and deleting association " + assocId + " failed", e);
        }
    }

    void deleteAssoc(AssocModelImpl assoc) {
        try {
            assoc.checkWriteAccess();
            assoc.delete();
        }
        catch (Exception e) {
            throw new RuntimeException("Deleting association " + assoc.getId() + " failed", e);
        }
    }

    void createTopicInstantiation(long topicId, String topicTypeUri) {
        try {
            AssocModelImpl assoc = this.mf.newAssocModel("dmx.core.instantiation", this.mf.newTopicPlayerModel(topicTypeUri, "dmx.core.type"), this.mf.newTopicPlayerModel(topicId, "dmx.core.instance"));
            this.storeAssoc(assoc);
            this.storeAssocValue(assoc.id, assoc.value, assoc.typeUri, false);
            this.createAssocInstantiation(assoc.id, assoc.typeUri);
        }
        catch (Exception e) {
            throw new RuntimeException("Associating topic " + topicId + " with topic type \"" + topicTypeUri + "\" failed", e);
        }
    }

    void createAssocInstantiation(long assocId, String assocTypeUri) {
        try {
            AssocModelImpl assoc = this.mf.newAssocModel("dmx.core.instantiation", this.mf.newTopicPlayerModel(assocTypeUri, "dmx.core.type"), this.mf.newAssocPlayerModel(assocId, "dmx.core.instance"));
            this.storeAssoc(assoc);
            this.storeAssocValue(assoc.id, assoc.value, assoc.typeUri, false);
        }
        catch (Exception e) {
            throw new RuntimeException("Associating association " + assocId + " with association type \"" + assocTypeUri + "\" failed", e);
        }
    }

    TopicTypeImpl getTopicType(String uri) {
        return (TopicTypeImpl)this.checkReadAccessAndInstantiate(this._getTopicType(uri));
    }

    TopicTypeImpl getTopicTypeImplicitly(long topicId) {
        this.checkTopicReadAccess(topicId);
        return this._getTopicType(this.typeUri(topicId)).instantiate();
    }

    AssocTypeImpl getAssocType(String uri) {
        return (AssocTypeImpl)this.checkReadAccessAndInstantiate(this._getAssocType(uri));
    }

    AssocTypeImpl getAssocTypeImplicitly(long assocId) {
        this.checkAssocReadAccess(assocId);
        return this._getAssocType(this.typeUri(assocId)).instantiate();
    }

    List<TopicType> getAllTopicTypes() {
        try {
            ArrayList<TopicType> topicTypes = new ArrayList<TopicType>();
            for (String uri : this.getTopicTypeUris()) {
                topicTypes.add(this._getTopicType(uri).instantiate());
            }
            return topicTypes;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching all topic types failed", e);
        }
    }

    List<AssocType> getAllAssocTypes() {
        try {
            ArrayList<AssocType> assocTypes = new ArrayList<AssocType>();
            for (String uri : this.getAssocTypeUris()) {
                assocTypes.add(this._getAssocType(uri).instantiate());
            }
            return assocTypes;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching all association types failed", e);
        }
    }

    TopicTypeImpl createTopicType(TopicTypeModelImpl model) {
        try {
            this.em.fireEvent(CoreEvent.PRE_CREATE_TOPIC_TYPE, model);
            this.createType(model, URI_PREFIX_TOPIC_TYPE);
            TopicTypeImpl topicType = model.instantiate();
            this.em.fireEvent(CoreEvent.INTRODUCE_TOPIC_TYPE, topicType);
            return topicType;
        }
        catch (Exception e) {
            throw new RuntimeException("Creating topic type \"" + model.getUri() + "\" failed", e);
        }
    }

    AssocTypeImpl createAssocType(AssocTypeModelImpl model) {
        try {
            this.em.fireEvent(CoreEvent.PRE_CREATE_ASSOCIATION_TYPE, model);
            this.createType(model, URI_PREFIX_ASSOCIATION_TYPE);
            AssocTypeImpl assocType = model.instantiate();
            this.em.fireEvent(CoreEvent.INTRODUCE_ASSOCIATION_TYPE, assocType);
            return assocType;
        }
        catch (Exception e) {
            throw new RuntimeException("Creating association type \"" + model.getUri() + "\" failed", e);
        }
    }

    void updateTopicType(TopicTypeModelImpl updateModel) {
        try {
            TopicModelImpl topic = this.fetchTopic(updateModel.getId());
            topic.checkWriteAccess();
            this._getTopicType(topic.getUri()).update(updateModel);
        }
        catch (Exception e) {
            throw new RuntimeException("Updating topic type failed, updateModel=" + updateModel, e);
        }
    }

    void updateAssocType(AssocTypeModelImpl updateModel) {
        try {
            TopicModelImpl topic = this.fetchTopic(updateModel.getId());
            topic.checkWriteAccess();
            this._getAssocType(topic.getUri()).update(updateModel);
        }
        catch (Exception e) {
            throw new RuntimeException("Updating association type failed, updateModel=" + updateModel, e);
        }
    }

    void deleteTopicType(String topicTypeUri) {
        try {
            TopicTypeModelImpl type = this._getTopicType(topicTypeUri);
            type.checkWriteAccess();
            type.delete();
        }
        catch (Exception e) {
            throw new RuntimeException("Deleting topic type \"" + topicTypeUri + "\" failed", e);
        }
    }

    void deleteAssocType(String assocTypeUri) {
        try {
            AssocTypeModelImpl type = this._getAssocType(assocTypeUri);
            type.checkWriteAccess();
            type.delete();
        }
        catch (Exception e) {
            throw new RuntimeException("Deleting association type \"" + assocTypeUri + "\" failed", e);
        }
    }

    Topic createRoleType(TopicModelImpl model) {
        String typeUri = model.getTypeUri();
        if (typeUri == null) {
            model.setTypeUri("dmx.core.role_type");
        } else if (!typeUri.equals("dmx.core.role_type")) {
            throw new IllegalArgumentException("A role type is supposed to be of type \"dmx.core.role_type\" (found: \"" + typeUri + "\")");
        }
        return this.createSingleTopic(model, URI_PREFIX_ROLE_TYPE, true);
    }

    TopicTypeModelImpl _getTopicType(String uri) {
        return this.typeStorage.getTopicType(uri);
    }

    AssocTypeModelImpl _getAssocType(String uri) {
        return this.typeStorage.getAssocType(uri);
    }

    DMXObject getObject(long id) {
        return (DMXObject)this.checkReadAccessAndInstantiate(this.fetchObject(id));
    }

    List<RelatedTopicModelImpl> getTopicRelatedTopics(long topicId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.filterReadables(this.fetchTopicRelatedTopics(topicId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri));
    }

    RelatedAssocModelImpl getTopicRelatedAssoc(long topicId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        RelatedAssocModelImpl assoc = this.fetchTopicRelatedAssoc(topicId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
        return assoc != null ? this.checkReadAccess(assoc) : null;
    }

    List<RelatedAssocModelImpl> getTopicRelatedAssocs(long topicId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        return this.filterReadables(this.fetchTopicRelatedAssocs(topicId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri));
    }

    List<AssocModelImpl> getTopicAssocs(long topicId) {
        return this.filterReadables(this.fetchTopicAssocs(topicId));
    }

    List<RelatedTopicModelImpl> getAssocRelatedTopics(long assocId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.filterReadables(this.fetchAssocRelatedTopics(assocId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri));
    }

    RelatedAssocModelImpl getAssocRelatedAssoc(long assocId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        RelatedAssocModelImpl assoc = this.fetchAssocRelatedAssoc(assocId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
        return assoc != null ? this.checkReadAccess(assoc) : null;
    }

    List<RelatedAssocModelImpl> getAssocRelatedAssocs(long assocId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        return this.filterReadables(this.fetchAssocRelatedAssocs(assocId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri));
    }

    List<AssocModelImpl> getAssocAssocs(long assocId) {
        return this.filterReadables(this.fetchAssocAssocs(assocId));
    }

    RelatedTopicModelImpl getRelatedTopic(long objectId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        RelatedTopicModelImpl topic = this.fetchRelatedTopic(objectId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
        return topic != null ? this.checkReadAccess(topic) : null;
    }

    List<RelatedTopicModelImpl> getRelatedTopics(long objectId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.filterReadables(this.fetchRelatedTopics(objectId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri));
    }

    List<Topic> getTopicsByProperty(String propUri, Object propValue) {
        return this.checkReadAccessAndInstantiate(this.fetchTopicsByProperty(propUri, propValue));
    }

    List<Topic> getTopicsByPropertyRange(String propUri, Number from, Number to) {
        return this.checkReadAccessAndInstantiate(this.fetchTopicsByPropertyRange(propUri, from, to));
    }

    List<Assoc> getAssocsByProperty(String propUri, Object propValue) {
        return this.checkReadAccessAndInstantiate(this.fetchAssocsByProperty(propUri, propValue));
    }

    List<Assoc> getAssocsByPropertyRange(String propUri, Number from, Number to) {
        return this.checkReadAccessAndInstantiate(this.fetchAssocsByPropertyRange(propUri, from, to));
    }

    <O> O checkReadAccessAndInstantiate(DMXObjectModelImpl model) {
        return (O)this.checkReadAccess(model).instantiate();
    }

    <O> List<O> checkReadAccessAndInstantiate(List<? extends DMXObjectModelImpl> models) {
        return this.instantiate(this.filterReadables(models));
    }

    private <M extends DMXObjectModelImpl> List<M> filterReadables(List<M> models) {
        Iterator<M> i = models.iterator();
        while (i.hasNext()) {
            if (this.hasReadAccess((DMXObjectModelImpl)i.next())) continue;
            i.remove();
        }
        return models;
    }

    boolean hasReadAccess(DMXObjectModelImpl model) {
        try {
            this.checkReadAccess(model);
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    <M extends DMXObjectModelImpl> M checkReadAccess(M model) {
        model.checkReadAccess();
        return model;
    }

    void checkTopicReadAccess(long topicId) {
        this.em.fireEvent(CoreEvent.CHECK_TOPIC_READ_ACCESS, topicId);
    }

    void checkAssocReadAccess(long assocId) {
        this.em.fireEvent(CoreEvent.CHECK_ASSOCIATION_READ_ACCESS, assocId);
    }

    void checkTopicWriteAccess(long topicId) {
        this.em.fireEvent(CoreEvent.CHECK_TOPIC_WRITE_ACCESS, topicId);
    }

    void checkAssocWriteAccess(long assocId) {
        this.em.fireEvent(CoreEvent.CHECK_ASSOCIATION_WRITE_ACCESS, assocId);
    }

    <O> List<O> instantiate(Iterable<? extends DMXObjectModelImpl> models) {
        ArrayList<DMXObject> objects = new ArrayList<DMXObject>();
        for (DMXObjectModelImpl dMXObjectModelImpl : models) {
            objects.add(dMXObjectModelImpl.instantiate());
        }
        return objects;
    }

    private List<String> getTopicTypeUris() {
        try {
            ArrayList<String> topicTypeUris = new ArrayList<String>();
            topicTypeUris.add("dmx.core.topic_type");
            topicTypeUris.add("dmx.core.assoc_type");
            topicTypeUris.add("dmx.core.meta_type");
            for (TopicModel topicModel : this.filterReadables(this.fetchTopics("typeUri", new SimpleValue("dmx.core.topic_type")))) {
                topicTypeUris.add(topicModel.getUri());
            }
            return topicTypeUris;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching list of topic type URIs failed", e);
        }
    }

    private List<String> getAssocTypeUris() {
        try {
            ArrayList<String> assocTypeUris = new ArrayList<String>();
            for (TopicModel topicModel : this.filterReadables(this.fetchTopics("typeUri", new SimpleValue("dmx.core.assoc_type")))) {
                assocTypeUris.add(topicModel.getUri());
            }
            return assocTypeUris;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching list of association type URIs failed", e);
        }
    }

    private void createType(TypeModelImpl model, String uriPrefix) {
        TopicModelImpl typeTopic = this.mf.newTopicModel(model);
        this.createSingleTopic(typeTopic, uriPrefix, true);
        model.id = typeTopic.id;
        model.uri = typeTopic.uri;
        this.typeStorage.storeType(model);
    }

    private String typeUri(long objectId) {
        return (String)this.fetchProperty(objectId, "typeUri");
    }

    private void bootstrapTypeCache() {
        TopicTypeModelImpl metaMetaType = this.mf.newTopicTypeModel("dmx.core.meta_meta_type", "Meta Meta Type", "dmx.core.text");
        metaMetaType.setTypeUri("dmx.core.meta_meta_meta_type");
        this.typeStorage.putInTypeCache(metaMetaType);
    }

    private <M extends DMXObjectModelImpl> M updateValues(M updateModel, M targetObject) {
        Object value = new ValueIntegrator((PersistenceLayer)this).integrate(updateModel, targetObject, null).value;
        if (value == null) {
            throw new RuntimeException("ValueIntegrator yields no result");
        }
        return value;
    }
}

