/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import systems.dmx.core.impl.AssocModelImpl;
import systems.dmx.core.impl.AssocTypeModelImpl;
import systems.dmx.core.impl.ChildTopicsModelImpl;
import systems.dmx.core.impl.CompDefModelImpl;
import systems.dmx.core.impl.DMXObjectModelImpl;
import systems.dmx.core.impl.ModelFactoryImpl;
import systems.dmx.core.impl.PersistenceLayer;
import systems.dmx.core.impl.RelatedAssocModelImpl;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.impl.TopicImpl;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.impl.TopicPlayerModelImpl;
import systems.dmx.core.impl.TopicTypeModelImpl;
import systems.dmx.core.impl.TypeModelImpl;
import systems.dmx.core.impl.ViewConfigurationModelImpl;
import systems.dmx.core.model.AssocModel;
import systems.dmx.core.model.AssocTypeModel;
import systems.dmx.core.model.CompDefModel;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.RelatedTopicModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.model.TopicTypeModel;
import systems.dmx.core.model.ViewConfigurationModel;
import systems.dmx.core.util.DMXUtils;

class TypeStorage {
    private Map<String, TypeModelImpl> typeCache = new HashMap<String, TypeModelImpl>();
    private EndlessRecursionDetection endlessRecursionDetection = new EndlessRecursionDetection();
    private PersistenceLayer pl;
    private ModelFactoryImpl mf;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    TypeStorage(PersistenceLayer pl) {
        this.pl = pl;
        this.mf = pl.mf;
    }

    TopicTypeModelImpl getTopicType(String topicTypeUri) {
        TopicTypeModelImpl topicType = (TopicTypeModelImpl)this.getTypeIfExists(topicTypeUri);
        return topicType != null ? topicType : this.fetchTopicType(topicTypeUri);
    }

    AssocTypeModelImpl getAssocType(String assocTypeUri) {
        AssocTypeModelImpl assocType = (AssocTypeModelImpl)this.getTypeIfExists(assocTypeUri);
        return assocType != null ? assocType : this.fetchAssocType(assocTypeUri);
    }

    void putInTypeCache(TypeModelImpl type) {
        this.typeCache.put(type.uri, type);
    }

    void removeFromTypeCache(String typeUri) {
        this.logger.info("### Removing type \"" + typeUri + "\" from type cache");
        if (this.typeCache.remove(typeUri) == null) {
            throw new RuntimeException("Type \"" + typeUri + "\" not found in type cache");
        }
    }

    TypeModelImpl getType(String typeUri) {
        TypeModelImpl type = this.getTypeIfExists(typeUri);
        if (type == null) {
            throw new RuntimeException("Type \"" + typeUri + "\" not found in type cache");
        }
        return type;
    }

    private TypeModelImpl getTypeIfExists(String typeUri) {
        return this.typeCache.get(typeUri);
    }

    private TopicTypeModelImpl fetchTopicType(String topicTypeUri) {
        try {
            this.logger.info("Fetching topic type \"" + topicTypeUri + "\"");
            this.endlessRecursionDetection.check(topicTypeUri);
            TopicModelImpl typeTopic = this.pl.fetchTopic("uri", new SimpleValue(topicTypeUri));
            this.checkTopicType(topicTypeUri, typeTopic);
            long typeId = typeTopic.getId();
            String dataTypeUri = this.fetchDataTypeTopic(typeId, topicTypeUri, "topic type").getUri();
            List<CompDefModel> compDefs = this.fetchCompDefs(typeTopic);
            TopicTypeModel topicType = this.mf.newTopicTypeModel((TopicModel)typeTopic, dataTypeUri, (List)compDefs, (ViewConfigurationModel)null);
            this.putInTypeCache((TypeModelImpl)((Object)topicType));
            ((TypeModelImpl)((Object)topicType)).setViewConfig(this.fetchViewConfigOfType(typeTopic));
            this.fetchViewConfigOfCompDefs(compDefs);
            TopicTypeModel topicTypeModel = topicType;
            return topicTypeModel;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching topic type \"" + topicTypeUri + "\" failed", e);
        }
        finally {
            this.endlessRecursionDetection.reset(topicTypeUri);
        }
    }

    private AssocTypeModelImpl fetchAssocType(String assocTypeUri) {
        try {
            this.logger.info("Fetching association type \"" + assocTypeUri + "\"");
            this.endlessRecursionDetection.check(assocTypeUri);
            TopicModelImpl typeTopic = this.pl.fetchTopic("uri", new SimpleValue(assocTypeUri));
            this.checkAssocType(assocTypeUri, typeTopic);
            long typeId = typeTopic.getId();
            String dataTypeUri = this.fetchDataTypeTopic(typeId, assocTypeUri, "association type").getUri();
            List<CompDefModel> compDefs = this.fetchCompDefs(typeTopic);
            AssocTypeModel assocType = this.mf.newAssocTypeModel((TopicModel)typeTopic, dataTypeUri, (List)compDefs, (ViewConfigurationModel)null);
            this.putInTypeCache((TypeModelImpl)((Object)assocType));
            ((AssocTypeModelImpl)assocType).setViewConfig(this.fetchViewConfigOfType(typeTopic));
            this.fetchViewConfigOfCompDefs(compDefs);
            AssocTypeModel assocTypeModel = assocType;
            return assocTypeModel;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching association type \"" + assocTypeUri + "\" failed", e);
        }
        finally {
            this.endlessRecursionDetection.reset(assocTypeUri);
        }
    }

    private void checkTopicType(String topicTypeUri, TopicModel typeTopic) {
        if (typeTopic == null) {
            throw new RuntimeException("Topic type \"" + topicTypeUri + "\" not found in DB");
        }
        if (!(typeTopic.getTypeUri().equals("dmx.core.topic_type") || typeTopic.getTypeUri().equals("dmx.core.meta_type") || typeTopic.getTypeUri().equals("dmx.core.meta_meta_type"))) {
            throw new RuntimeException("URI \"" + topicTypeUri + "\" refers to a \"" + typeTopic.getTypeUri() + "\" when the caller expects a \"dmx.core.topic_type\"");
        }
    }

    private void checkAssocType(String assocTypeUri, TopicModel typeTopic) {
        if (typeTopic == null) {
            throw new RuntimeException("Assoc type \"" + assocTypeUri + "\" not found in DB");
        }
        if (!typeTopic.getTypeUri().equals("dmx.core.assoc_type")) {
            throw new RuntimeException("URI \"" + assocTypeUri + "\" refers to a \"" + typeTopic.getTypeUri() + "\" when the caller expects a \"dmx.core.assoc_type\"");
        }
    }

    void storeType(TypeModelImpl type) {
        this.putInTypeCache(type);
        this.storeDataType(type.getUri(), type.getDataTypeUri());
        this.storeCompDefs(type.getId(), type.getCompDefs());
        this.storeViewConfig(type);
    }

    private RelatedTopicModel fetchDataTypeTopic(long typeId, String typeUri, String className) {
        try {
            RelatedTopicModelImpl dataType = this.pl.fetchTopicRelatedTopic(typeId, "dmx.core.composition", "dmx.core.type", "dmx.core.default", "dmx.core.data_type");
            if (dataType == null) {
                throw new RuntimeException("No data type topic associated to " + className + " \"" + typeUri + "\"");
            }
            return dataType;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching data type topic of " + className + " \"" + typeUri + "\" failed", e);
        }
    }

    void storeDataType(String typeUri, String dataTypeUri) {
        try {
            this.pl.createAssoc("dmx.core.composition", this.mf.newTopicPlayerModel(typeUri, "dmx.core.type"), this.mf.newTopicPlayerModel(dataTypeUri, "dmx.core.default"));
        }
        catch (Exception e) {
            throw new RuntimeException("Associating type \"" + typeUri + "\" with data type \"" + dataTypeUri + "\" failed", e);
        }
    }

    private List<CompDefModel> fetchCompDefs(TopicModelImpl typeTopic) {
        Map<Long, CompDefModel> compDefs = this.fetchCompDefsUnsorted(typeTopic);
        List<RelatedAssocModelImpl> sequence = this.fetchSequence(typeTopic);
        if (compDefs.size() != sequence.size()) {
            throw new RuntimeException("DB inconsistency: type \"" + typeTopic.getUri() + "\" has " + compDefs.size() + " comp defs but in sequence are " + sequence.size());
        }
        return this.sortCompDefs(compDefs, DMXUtils.idList(sequence));
    }

    private Map<Long, CompDefModel> fetchCompDefsUnsorted(TopicModelImpl typeTopic) {
        HashMap<Long, CompDefModel> compDefs = new HashMap<Long, CompDefModel>();
        List<RelatedTopicModelImpl> childTypes = typeTopic.getRelatedTopics("dmx.core.composition_def", "dmx.core.parent_type", "dmx.core.child_type", null);
        for (RelatedTopicModelImpl childType : childTypes) {
            CompDefModel compDef = this.fetchCompDef(childType.getRelatingAssoc(), typeTopic.getUri(), childType.getUri());
            compDefs.put(compDef.getId(), compDef);
        }
        return compDefs;
    }

    CompDefModelImpl newCompDefModel(AssocModelImpl assoc) {
        return this.mf.newCompDefModel(this.addPlayerUris(assoc, this.fetchParentTypeTopic((AssocModelImpl)assoc).uri, this.fetchChildTypeTopic((AssocModelImpl)assoc).uri), this.mf.newViewConfigurationModel().addConfigTopic(this.mf.newTopicModel("dmx.webclient.view_config", new SimpleValue("View Configuration"))));
    }

    private CompDefModel fetchCompDef(AssocModelImpl assoc, String parentTypeUri, String childTypeUri) {
        try {
            RelatedTopicModel includeInLabel;
            RelatedTopicModel isIdentityAttr;
            this.addPlayerUris(assoc, parentTypeUri, childTypeUri);
            ChildTopicsModelImpl childTopics = assoc.getChildTopicsModel();
            childTopics.put("dmx.core.cardinality", this.fetchCardinality(assoc));
            RelatedTopicModel customAssocType = this.fetchCustomAssocType(assoc);
            if (customAssocType != null) {
                childTopics.put("dmx.core.assoc_type#dmx.core.custom_assoc_type", customAssocType);
            }
            if ((isIdentityAttr = this.fetchIsIdentityAttr(assoc)) != null) {
                childTopics.put("dmx.core.identity_attr", isIdentityAttr);
            }
            if ((includeInLabel = this.fetchIncludeInLabel(assoc)) != null) {
                childTopics.put("dmx.core.include_in_label", includeInLabel);
            }
            return this.mf.newCompDefModel(assoc, null);
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching comp def failed (parentTypeUri=\"" + parentTypeUri + "\", childTypeUri=\"" + childTypeUri + "\", " + assoc + ")", e);
        }
    }

    private RelatedTopicModel fetchCustomAssocType(AssocModelImpl assoc) {
        return assoc.getRelatedTopic("dmx.core.custom_assoc_type", "dmx.core.parent", "dmx.core.child", "dmx.core.assoc_type");
    }

    private RelatedTopicModel fetchIsIdentityAttr(AssocModelImpl assoc) {
        return assoc.getRelatedTopic("dmx.core.composition", "dmx.core.parent", "dmx.core.child", "dmx.core.identity_attr");
    }

    private RelatedTopicModel fetchIncludeInLabel(AssocModelImpl assoc) {
        return assoc.getRelatedTopic("dmx.core.composition", "dmx.core.parent", "dmx.core.child", "dmx.core.include_in_label");
    }

    private AssocModel addPlayerUris(AssocModel assoc, String parentTypeUri, String childTypeUri) {
        ((TopicPlayerModelImpl)assoc.getPlayerByRole((String)"dmx.core.parent_type")).topicUri = parentTypeUri;
        ((TopicPlayerModelImpl)assoc.getPlayerByRole((String)"dmx.core.child_type")).topicUri = childTypeUri;
        return assoc;
    }

    private CompDefModelImpl addPlayerIds(CompDefModelImpl compDef) {
        compDef.getPlayerByRole((String)"dmx.core.parent_type").id = compDef.getParentType().id;
        compDef.getPlayerByRole((String)"dmx.core.child_type").id = compDef.getChildType().id;
        return compDef;
    }

    private List<CompDefModel> sortCompDefs(Map<Long, CompDefModel> compDefs, List<Long> sequence) {
        ArrayList<CompDefModel> sortedCompDefs = new ArrayList<CompDefModel>();
        for (long compDefId : sequence) {
            CompDefModel compDef = compDefs.get(compDefId);
            if (compDef == null) {
                throw new RuntimeException("DB inconsistency: ID " + compDefId + " is in sequence but not in the type's comp defs");
            }
            sortedCompDefs.add(compDef);
        }
        return sortedCompDefs;
    }

    private void storeCompDefs(long typeId, Collection<CompDefModelImpl> compDefs) {
        for (CompDefModelImpl compDef : compDefs) {
            this.storeCompDef(compDef);
        }
        this.storeSequence(typeId, compDefs);
    }

    void storeCompDef(CompDefModelImpl compDef) {
        try {
            this.pl.createAssoc(this.addPlayerIds(compDef));
            this.storeViewConfig(compDef);
        }
        catch (Exception e) {
            throw new RuntimeException("Storing comp def \"" + compDef.getCompDefUri() + "\" failed (parent type \"" + compDef.getParentTypeUri() + "\")", e);
        }
    }

    private TopicModelImpl fetchParentTypeTopic(AssocModelImpl assoc) {
        TopicModelImpl parentType = (TopicModelImpl)assoc.getDMXObjectByRole("dmx.core.parent_type");
        if (parentType == null) {
            throw new RuntimeException("DB inconsistency: topic role \"dmx.core.parent_type\" is missing in " + assoc);
        }
        return parentType;
    }

    private TopicModelImpl fetchChildTypeTopic(AssocModelImpl assoc) {
        TopicModelImpl childType = (TopicModelImpl)assoc.getDMXObjectByRole("dmx.core.child_type");
        if (childType == null) {
            throw new RuntimeException("DB inconsistency: topic role \"dmx.core.child_type\" is missing in " + assoc);
        }
        return childType;
    }

    TypeModelImpl fetchParentType(AssocModelImpl assoc) {
        TopicModelImpl type = this.fetchParentTypeTopic(assoc);
        if (type.typeUri.equals("dmx.core.topic_type")) {
            return this.getTopicType(type.uri);
        }
        if (type.typeUri.equals("dmx.core.assoc_type")) {
            return this.getAssocType(type.uri);
        }
        throw new RuntimeException("DB inconsistency: the \"dmx.core.parent_type\" player is not a type but of type \"" + type.typeUri + "\" in " + assoc);
    }

    private RelatedTopicModelImpl fetchCardinality(AssocModelImpl assoc) {
        RelatedTopicModelImpl cardinality = this.fetchCardinalityIfExists(assoc);
        if (cardinality == null) {
            throw new RuntimeException("DB inconsistency: comp def " + assoc.id + " has no cardinality");
        }
        return cardinality;
    }

    private RelatedTopicModelImpl fetchCardinalityIfExists(AssocModelImpl assoc) {
        return assoc.getRelatedTopic("dmx.core.composition", "dmx.core.parent", "dmx.core.child", "dmx.core.cardinality");
    }

    private RelatedTopicModel defaultCardinality(AssocModelImpl assoc) {
        RelatedTopicModelImpl cardinality = this.fetchCardinalityIfExists(assoc);
        if (cardinality != null) {
            return cardinality;
        }
        return this.mf.newRelatedTopicModel(this.pl.fetchTopic("uri", new SimpleValue("dmx.core.one")));
    }

    private List<RelatedAssocModelImpl> fetchSequence(TopicModel typeTopic) {
        try {
            ArrayList<RelatedAssocModelImpl> sequence = new ArrayList<RelatedAssocModelImpl>();
            RelatedAssocModelImpl compDef = this.fetchSequenceStart(typeTopic.getId());
            if (compDef != null) {
                sequence.add(compDef);
                while ((compDef = this.fetchSuccessor(compDef.getId())) != null) {
                    sequence.add(compDef);
                }
            }
            return sequence;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching sequence for type \"" + typeTopic.getUri() + "\" failed", e);
        }
    }

    private RelatedAssocModelImpl fetchSequenceStart(long typeId) {
        return this.pl.fetchTopicRelatedAssoc(typeId, "dmx.core.composition", "dmx.core.type", "dmx.core.sequence_start", null);
    }

    private RelatedAssocModelImpl fetchSuccessor(long compDefId) {
        return this.pl.fetchAssocRelatedAssoc(compDefId, "dmx.core.sequence", "dmx.core.predecessor", "dmx.core.successor", null);
    }

    private RelatedAssocModelImpl fetchPredecessor(long compDefId) {
        return this.pl.fetchAssocRelatedAssoc(compDefId, "dmx.core.sequence", "dmx.core.successor", "dmx.core.predecessor", null);
    }

    private void storeSequence(long typeId, Collection<CompDefModelImpl> compDefs) {
        this.logger.fine("### Storing " + compDefs.size() + " sequence segments for type " + typeId);
        long predCompDefId = -1L;
        for (CompDefModel compDefModel : compDefs) {
            this.addCompDefToSequence(typeId, compDefModel.getId(), -1L, -1L, predCompDefId);
            predCompDefId = compDefModel.getId();
        }
    }

    void addCompDefToSequence(long typeId, long compDefId, long beforeCompDefId, long firstCompDefId, long lastCompDefId) {
        if (beforeCompDefId == -1L) {
            this.appendToSequence(typeId, compDefId, lastCompDefId);
        } else if (firstCompDefId == compDefId) {
            this.insertAtSequenceStart(typeId, compDefId);
        } else {
            this.insertIntoSequence(compDefId, beforeCompDefId);
        }
    }

    private void appendToSequence(long typeId, long compDefId, long predCompDefId) {
        if (predCompDefId == -1L) {
            this.storeSequenceStart(typeId, compDefId);
        } else {
            this.storeSequenceSegment(predCompDefId, compDefId);
        }
    }

    private void insertAtSequenceStart(long typeId, long compDefId) {
        RelatedAssocModelImpl compDef = this.fetchSequenceStart(typeId);
        compDef.getRelatingAssoc().delete();
        this.storeSequenceStart(typeId, compDefId);
        this.storeSequenceSegment(compDefId, compDef.getId());
    }

    private void insertIntoSequence(long compDefId, long beforeCompDefId) {
        RelatedAssocModelImpl compDef = this.fetchPredecessor(beforeCompDefId);
        compDef.getRelatingAssoc().delete();
        this.storeSequenceSegment(compDef.getId(), compDefId);
        this.storeSequenceSegment(compDefId, beforeCompDefId);
    }

    private void storeSequenceStart(long typeId, long compDefId) {
        this.pl.createAssoc("dmx.core.composition", this.mf.newTopicPlayerModel(typeId, "dmx.core.type"), this.mf.newAssocPlayerModel(compDefId, "dmx.core.sequence_start"));
    }

    private void storeSequenceSegment(long predCompDefId, long succCompDefId) {
        this.pl.createAssoc("dmx.core.sequence", this.mf.newAssocPlayerModel(predCompDefId, "dmx.core.predecessor"), this.mf.newAssocPlayerModel(succCompDefId, "dmx.core.successor"));
    }

    void rebuildSequence(TypeModelImpl type) {
        this.deleteSequence(type);
        this.storeSequence(type.getId(), type.getCompDefs());
    }

    private void deleteSequence(TopicModel typeTopic) {
        List<RelatedAssocModelImpl> sequence = this.fetchSequence(typeTopic);
        this.logger.info("### Deleting " + sequence.size() + " sequence segments of type \"" + typeTopic.getUri() + "\"");
        for (RelatedAssocModelImpl assoc : sequence) {
            assoc.getRelatingAssoc().delete();
        }
    }

    private void fetchViewConfigOfCompDefs(List<CompDefModel> compDefs) {
        for (CompDefModel compDef : compDefs) {
            compDef.setViewConfig(this.fetchViewConfigOfCompDef(compDef));
        }
    }

    private ViewConfigurationModel fetchViewConfigOfType(TopicModel typeTopic) {
        try {
            return this.viewConfigModel(this.pl.fetchTopicRelatedTopics(typeTopic.getId(), "dmx.core.composition", "dmx.core.parent", "dmx.core.child", "dmx.webclient.view_config"));
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching view config of type \"" + typeTopic.getUri() + "\" failed", e);
        }
    }

    private ViewConfigurationModel fetchViewConfigOfCompDef(AssocModel compDef) {
        try {
            return this.viewConfigModel(this.pl.fetchAssocRelatedTopics(compDef.getId(), "dmx.core.composition", "dmx.core.parent", "dmx.core.child", "dmx.webclient.view_config"));
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching view config of comp def " + compDef.getId() + " failed", e);
        }
    }

    private ViewConfigurationModel viewConfigModel(Iterable<? extends TopicModelImpl> configTopics) {
        this.loadChildTopics(configTopics);
        return this.mf.newViewConfigurationModel(configTopics);
    }

    private void storeViewConfig(TypeModelImpl type) {
        ViewConfigurationModelImpl viewConfig = type.viewConfig;
        TopicModel configTopic = this._storeViewConfig(this.newTypeRole(type.id), viewConfig);
        if (configTopic != null) {
            viewConfig.updateConfigTopic(configTopic);
        }
    }

    void storeViewConfig(CompDefModelImpl compDef) {
        ViewConfigurationModelImpl viewConfig = compDef.viewConfig;
        TopicModel configTopic = this._storeViewConfig(this.newCompDefRole(compDef.id), viewConfig);
        if (configTopic != null) {
            viewConfig.updateConfigTopic(configTopic);
        }
    }

    private TopicModel _storeViewConfig(PlayerModel configurable, ViewConfigurationModelImpl viewConfig) {
        try {
            TopicModel topic = null;
            for (TopicModelImpl configTopic : viewConfig.getConfigTopics()) {
                if (topic != null) {
                    throw new RuntimeException("DM5 does not support more than one view config topic per configurable");
                }
                topic = this.storeViewConfigTopic(configurable, configTopic);
            }
            return topic;
        }
        catch (Exception e) {
            throw new RuntimeException("Storing view configuration failed (configurable=" + configurable + ", viewConfig=" + viewConfig + ")", e);
        }
    }

    TopicModel storeViewConfigTopic(PlayerModel configurable, TopicModelImpl configTopic) {
        TopicImpl topic = this.pl.createTopic(configTopic);
        this.pl.createAssoc("dmx.core.composition", configurable, this.mf.newTopicPlayerModel(configTopic.id, "dmx.core.child"));
        return topic.getModel();
    }

    private void loadChildTopics(Iterable<? extends DMXObjectModelImpl> objects) {
        for (DMXObjectModelImpl dMXObjectModelImpl : objects) {
            dMXObjectModelImpl.loadChildTopics(true);
        }
    }

    PlayerModel newTypeRole(long typeId) {
        return this.mf.newTopicPlayerModel(typeId, "dmx.core.parent");
    }

    PlayerModel newCompDefRole(long compDefId) {
        return this.mf.newAssocPlayerModel(compDefId, "dmx.core.parent");
    }

    private static final class EndlessRecursionDetection {
        private Map<String, Boolean> loadInProgress = new HashMap<String, Boolean>();

        private EndlessRecursionDetection() {
        }

        private void check(String typeUri) {
            if (this.loadInProgress.get(typeUri) != null) {
                throw new RuntimeException("Endless recursion detected while loading type \"" + typeUri + "\"");
            }
            this.loadInProgress.put(typeUri, true);
        }

        private void reset(String typeUri) {
            this.loadInProgress.remove(typeUri);
        }
    }
}

