/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import systems.dmx.core.Assoc;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.impl.AssocImpl;
import systems.dmx.core.impl.AssocModelImpl;
import systems.dmx.core.impl.ModelFactoryImpl;
import systems.dmx.core.impl.PersistenceLayer;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.service.accesscontrol.AccessControl;
import systems.dmx.core.service.accesscontrol.Credentials;
import systems.dmx.core.service.accesscontrol.Operation;
import systems.dmx.core.service.accesscontrol.SharingMode;
import systems.dmx.core.util.ContextTracker;

class AccessControlImpl
implements AccessControl {
    private static final String TYPE_MEMBERSHIP = "dmx.accesscontrol.membership";
    private static final String TYPE_USERNAME = "dmx.accesscontrol.username";
    private static final String TOPICMAP_CONTEXT = "dmx.topicmaps.topicmap_context";
    private static final String TYPE_EMAIL_ADDRESS = "dmx.contacts.email_address";
    private static final String ASSOC_TYPE_USER_MAILBOX = "org.deepamehta.signup.user_mailbox";
    private static final String ASSOC_TYPE_CONFIGURATION = "dmx.config.configuration";
    private static final String ROLE_TYPE_CONFIGURABLE = "dmx.config.configurable";
    private static final String ROLE_TYPE_DEFAULT = "dmx.core.default";
    private static final String PROP_CREATOR = "dmx.accesscontrol.creator";
    private static final String PROP_OWNER = "dmx.accesscontrol.owner";
    private static final String PROP_WORKSPACE_ID = "dmx.workspaces.workspace_id";
    private static final String DMX_WORKSPACE_URI = "dmx.workspaces.dmx";
    private static final String ADMINISTRATION_WORKSPACE_URI = "dmx.workspaces.administration";
    private static final String SYSTEM_WORKSPACE_URI = "dmx.workspaces.system";
    private long systemWorkspaceId = -1L;
    private ContextTracker contextTracker = new ContextTracker();
    private PersistenceLayer pl;
    private ModelFactoryImpl mf;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    AccessControlImpl(PersistenceLayer pl) {
        this.pl = pl;
        this.mf = pl.mf;
    }

    @Override
    public boolean hasPermission(String username, Operation operation, long objectId) {
        String typeUri = null;
        try {
            long workspaceId;
            typeUri = this.getTypeUri(objectId);
            if (typeUri.equals("dmx.topicmaps.topicmap") && this.isTopicmapPrivate(objectId)) {
                return this.isCreator(username, objectId);
            }
            if (typeUri.equals("dmx.workspaces.workspace")) {
                workspaceId = objectId;
            } else {
                workspaceId = this.getAssignedWorkspaceId(objectId);
                if (workspaceId == -1L) {
                    return this.permissionIfNoWorkspaceIsAssigned(operation, objectId, typeUri);
                }
            }
            return this._hasPermission(username, operation, workspaceId);
        }
        catch (Exception e) {
            throw new RuntimeException("Checking permission for object " + objectId + " failed (typeUri=\"" + typeUri + "\", " + this.userInfo(username) + ", operation=" + (Object)((Object)operation) + ")", e);
        }
    }

    @Override
    public boolean hasReadPermission(String username, long workspaceId) {
        SharingMode sharingMode = this.getSharingMode(workspaceId);
        switch (sharingMode) {
            case PRIVATE: {
                return this.isOwner(username, workspaceId);
            }
            case CONFIDENTIAL: {
                return this.isOwner(username, workspaceId) || this.isMember(username, workspaceId);
            }
            case COLLABORATIVE: {
                return this.isOwner(username, workspaceId) || this.isMember(username, workspaceId);
            }
            case PUBLIC: {
                return workspaceId != this.getSystemWorkspaceId() || username != null;
            }
            case COMMON: {
                return true;
            }
        }
        throw new RuntimeException((Object)((Object)sharingMode) + " is an unsupported sharing mode");
    }

    @Override
    public boolean hasWritePermission(String username, long workspaceId) {
        SharingMode sharingMode = this.getSharingMode(workspaceId);
        switch (sharingMode) {
            case PRIVATE: {
                return this.isOwner(username, workspaceId);
            }
            case CONFIDENTIAL: {
                return this.isOwner(username, workspaceId);
            }
            case COLLABORATIVE: {
                return this.isOwner(username, workspaceId) || this.isMember(username, workspaceId);
            }
            case PUBLIC: {
                return this.isOwner(username, workspaceId) || this.isMember(username, workspaceId);
            }
            case COMMON: {
                return true;
            }
        }
        throw new RuntimeException((Object)((Object)sharingMode) + " is an unsupported sharing mode");
    }

    @Override
    public Topic checkCredentials(Credentials cred) {
        TopicModelImpl usernameTopic = null;
        try {
            usernameTopic = this._getUsernameTopic(cred.username);
            if (usernameTopic == null) {
                return null;
            }
            if (!this.matches(usernameTopic, cred.password)) {
                return null;
            }
            return usernameTopic.instantiate();
        }
        catch (Exception e) {
            throw new RuntimeException("Checking credentials for user \"" + cred.username + "\" failed (usernameTopic=" + usernameTopic + ")", e);
        }
    }

    @Override
    public void changePassword(Credentials cred) {
        try {
            this.logger.info("##### Changing password for user \"" + cred.username + "\"");
            TopicModelImpl userAccount = this._getUserAccount(this._getUsernameTopicOrThrow(cred.username));
            userAccount.update(this.mf.newTopicModel(this.mf.newChildTopicsModel().put("dmx.accesscontrol.password", cred.password)));
        }
        catch (Exception e) {
            throw new RuntimeException("Changing password for user \"" + cred.username + "\" failed", e);
        }
    }

    @Override
    public Topic getUsernameTopic(String username) {
        TopicModelImpl usernameTopic = this._getUsernameTopic(username);
        return usernameTopic != null ? usernameTopic.instantiate() : null;
    }

    @Override
    public Topic getPrivateWorkspace(String username) {
        try {
            for (TopicModelImpl workspace : this.fetchTopicsByOwner(username, "dmx.workspaces.workspace")) {
                if (this.getSharingMode(workspace.getId()) != SharingMode.PRIVATE) continue;
                return workspace.instantiate();
            }
            throw new RuntimeException("User \"" + username + "\" has no private workspace");
        }
        catch (Exception e) {
            throw new RuntimeException("Private workspace of user \"" + username + "\" can't be determined", e);
        }
    }

    @Override
    public boolean isMember(String username, long workspaceId) {
        try {
            if (username == null) {
                return false;
            }
            AssocModelImpl membership = this.pl.fetchAssoc(TYPE_MEMBERSHIP, this._getUsernameTopicOrThrow(username).getId(), workspaceId, ROLE_TYPE_DEFAULT, ROLE_TYPE_DEFAULT);
            return membership != null;
        }
        catch (Exception e) {
            throw new RuntimeException("Checking membership of user \"" + username + "\" and workspace " + workspaceId + " failed", e);
        }
    }

    @Override
    public String getCreator(long objectId) {
        return this.pl.hasProperty(objectId, PROP_CREATOR) ? (String)this.pl.fetchProperty(objectId, PROP_CREATOR) : null;
    }

    @Override
    public String getUsername(HttpServletRequest request) {
        try {
            HttpSession session = request.getSession(false);
            if (session == null) {
                return null;
            }
            return this.username(session);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    @Override
    public Topic getUsernameTopic(HttpServletRequest request) {
        String username = this.getUsername(request);
        if (username == null) {
            return null;
        }
        return this._getUsernameTopicOrThrow(username).instantiate();
    }

    @Override
    public String username(HttpSession session) {
        return (String)session.getAttribute("username");
    }

    @Override
    public Topic getWorkspace(String uri) {
        TopicModelImpl workspace = this.fetchTopic("uri", uri);
        if (workspace == null) {
            throw new RuntimeException("Workspace \"" + uri + "\" does not exist");
        }
        return workspace.instantiate();
    }

    @Override
    public long getDMXWorkspaceId() {
        return this.getWorkspace(DMX_WORKSPACE_URI).getId();
    }

    @Override
    public long getAdministrationWorkspaceId() {
        return this.getWorkspace(ADMINISTRATION_WORKSPACE_URI).getId();
    }

    @Override
    public long getSystemWorkspaceId() {
        if (this.systemWorkspaceId == -1L) {
            TopicModelImpl workspace = this.fetchTopic("uri", SYSTEM_WORKSPACE_URI);
            if (workspace == null) {
                throw new RuntimeException("The System workspace does not exist");
            }
            this.systemWorkspaceId = workspace.getId();
        }
        return this.systemWorkspaceId;
    }

    @Override
    public long getAssignedWorkspaceId(long objectId) {
        try {
            long workspaceId = -1L;
            if (this.pl.hasProperty(objectId, PROP_WORKSPACE_ID)) {
                workspaceId = (Long)this.pl.fetchProperty(objectId, PROP_WORKSPACE_ID);
                this.checkWorkspaceId(workspaceId);
            }
            return workspaceId;
        }
        catch (Exception e) {
            throw new RuntimeException("Workspace assignment of object " + objectId + " can't be determined", e);
        }
    }

    @Override
    public void assignToWorkspace(DMXObject object, long workspaceId) {
        try {
            this.pl.createAssoc("dmx.workspaces.workspace_assignment", object.getModel().createPlayerModel("dmx.core.parent"), this.mf.newTopicPlayerModel(workspaceId, "dmx.core.child"));
            object.setProperty(PROP_WORKSPACE_ID, workspaceId, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Assigning " + object + " to workspace " + workspaceId + " failed", e);
        }
    }

    @Override
    public <V> V runWithoutWorkspaceAssignment(Callable<V> callable) throws Exception {
        return this.contextTracker.run(callable);
    }

    @Override
    public boolean workspaceAssignmentIsSuppressed() {
        return this.contextTracker.runsInTrackedContext();
    }

    @Override
    public void deleteAssocMapcontext(Assoc assoc) {
        if (!assoc.getTypeUri().equals(TOPICMAP_CONTEXT)) {
            throw new RuntimeException("Assoc " + assoc.getId() + " not eligible for privileged deletion (" + assoc + ")");
        }
        ((AssocImpl)assoc).getModel().delete();
    }

    @Override
    public RelatedTopic getConfigTopic(String configTypeUri, long topicId) {
        try {
            RelatedTopicModelImpl configTopic = this.pl.fetchTopicRelatedTopic(topicId, ASSOC_TYPE_CONFIGURATION, ROLE_TYPE_CONFIGURABLE, ROLE_TYPE_DEFAULT, configTypeUri);
            if (configTopic == null) {
                throw new RuntimeException("The \"" + configTypeUri + "\" configuration topic for topic " + topicId + " is missing");
            }
            return configTopic.instantiate();
        }
        catch (Exception e) {
            throw new RuntimeException("Getting the \"" + configTypeUri + "\" configuration topic for topic " + topicId + " failed", e);
        }
    }

    @Override
    public String getUsername(String emailAddress) {
        try {
            String username = this._getUsername(emailAddress);
            if (username == null) {
                throw new RuntimeException("No username is assigned to email address \"" + emailAddress + "\"");
            }
            return username;
        }
        catch (Exception e) {
            throw new RuntimeException("Getting the username for email address \"" + emailAddress + "\" failed", e);
        }
    }

    @Override
    public String getEmailAddress(String username) {
        try {
            String emailAddress = this._getEmailAddress(username);
            if (emailAddress == null) {
                throw new RuntimeException("No email address is assigned to username \"" + username + "\"");
            }
            return emailAddress;
        }
        catch (Exception e) {
            throw new RuntimeException("Getting the email address for username \"" + username + "\" failed", e);
        }
    }

    @Override
    public boolean emailAddressExists(String emailAddress) {
        return this._getUsername(emailAddress) != null;
    }

    private boolean matches(TopicModel usernameTopic, String password) {
        String _password = this.getPasswordTopic(usernameTopic).getSimpleValue().toString();
        return _password.equals(password);
    }

    private TopicModel getPasswordTopic(TopicModel usernameTopic) {
        return this._getPasswordTopic(this._getUserAccount(usernameTopic));
    }

    private TopicModelImpl _getUserAccount(TopicModel usernameTopic) {
        RelatedTopicModelImpl userAccount = this.pl.fetchTopicRelatedTopic(usernameTopic.getId(), "dmx.core.composition", "dmx.core.child", "dmx.core.parent", "dmx.accesscontrol.user_account");
        if (userAccount == null) {
            throw new RuntimeException("Data inconsistency: there is no User Account topic for username \"" + usernameTopic.getSimpleValue() + "\" (usernameTopic=" + usernameTopic + ")");
        }
        return userAccount;
    }

    private TopicModel _getPasswordTopic(TopicModel userAccount) {
        RelatedTopicModelImpl password = this.pl.fetchTopicRelatedTopic(userAccount.getId(), "dmx.core.composition", "dmx.core.parent", "dmx.core.child", "dmx.accesscontrol.password");
        if (password == null) {
            throw new RuntimeException("Data inconsistency: there is no Password topic for User Account \"" + userAccount.getSimpleValue() + "\" (userAccount=" + userAccount + ")");
        }
        return password;
    }

    private boolean permissionIfNoWorkspaceIsAssigned(Operation operation, long objectId, String typeUri) {
        switch (operation) {
            case READ: {
                this.logger.fine("Object " + objectId + " (typeUri=\"" + typeUri + "\") is not assigned to any workspace -- READ permission is granted");
                return true;
            }
            case WRITE: {
                this.logger.warning("Object " + objectId + " (typeUri=\"" + typeUri + "\") is not assigned to any workspace -- WRITE permission is refused");
                return false;
            }
        }
        throw new RuntimeException((Object)((Object)operation) + " is an unsupported operation");
    }

    private boolean _hasPermission(String username, Operation operation, long workspaceId) {
        switch (operation) {
            case READ: {
                return this.hasReadPermission(username, workspaceId);
            }
            case WRITE: {
                return this.hasWritePermission(username, workspaceId);
            }
        }
        throw new RuntimeException((Object)((Object)operation) + " is an unsupported operation");
    }

    private boolean isOwner(String username, long workspaceId) {
        try {
            if (username == null) {
                return false;
            }
            return this.getOwner(workspaceId).equals(username);
        }
        catch (Exception e) {
            throw new RuntimeException("Checking ownership of workspace " + workspaceId + " and user \"" + username + "\" failed", e);
        }
    }

    private SharingMode getSharingMode(long workspaceId) {
        RelatedTopicModelImpl sharingMode = this.pl.fetchTopicRelatedTopic(workspaceId, "dmx.core.composition", "dmx.core.parent", "dmx.core.child", "dmx.workspaces.sharing_mode");
        if (sharingMode == null) {
            throw new RuntimeException("No sharing mode is assigned to workspace " + workspaceId);
        }
        return SharingMode.fromString(sharingMode.getUri());
    }

    private void checkWorkspaceId(long workspaceId) {
        String typeUri = this.getTypeUri(workspaceId);
        if (!typeUri.equals("dmx.workspaces.workspace")) {
            throw new RuntimeException("Object " + workspaceId + " is not a workspace (but of type \"" + typeUri + "\")");
        }
    }

    private boolean isTopicmapPrivate(long topicmapId) {
        RelatedTopicModelImpl privateFlag = this.pl.fetchTopicRelatedTopic(topicmapId, "dmx.core.composition", "dmx.core.parent", "dmx.core.child", "dmx.topicmaps.private");
        if (privateFlag == null) {
            return false;
        }
        return privateFlag.getSimpleValue().booleanValue();
    }

    private boolean isCreator(String username, long objectId) {
        return username != null ? username.equals(this.getCreator(objectId)) : false;
    }

    private String getOwner(long workspaceId) {
        if (!this.pl.hasProperty(workspaceId, PROP_OWNER)) {
            throw new RuntimeException("No owner is assigned to workspace " + workspaceId);
        }
        return (String)this.pl.fetchProperty(workspaceId, PROP_OWNER);
    }

    private String getTypeUri(long objectId) {
        return (String)this.pl.fetchProperty(objectId, "typeUri");
    }

    private TopicModelImpl _getUsernameTopic(String username) {
        return this.fetchTopic(TYPE_USERNAME, username);
    }

    private TopicModelImpl _getUsernameTopicOrThrow(String username) {
        TopicModelImpl usernameTopic = this._getUsernameTopic(username);
        if (usernameTopic == null) {
            throw new RuntimeException("User \"" + username + "\" does not exist");
        }
        return usernameTopic;
    }

    private String _getUsername(String emailAddress) {
        String username = null;
        for (TopicModelImpl emailAddressTopic : this.queryTopics(TYPE_EMAIL_ADDRESS, emailAddress)) {
            RelatedTopicModelImpl usernameTopic = emailAddressTopic.getRelatedTopic(ASSOC_TYPE_USER_MAILBOX, "dmx.core.child", "dmx.core.parent", TYPE_USERNAME);
            if (usernameTopic == null) continue;
            if (username != null) {
                throw new RuntimeException("Ambiguity: the Username assignment for email address \"" + emailAddress + "\" is not unique");
            }
            username = usernameTopic.getSimpleValue().toString();
        }
        return username;
    }

    private String _getEmailAddress(String username) {
        RelatedTopicModelImpl emailAddress = this._getUsernameTopicOrThrow(username).getRelatedTopic(ASSOC_TYPE_USER_MAILBOX, "dmx.core.parent", "dmx.core.child", TYPE_EMAIL_ADDRESS);
        return emailAddress != null ? emailAddress.getSimpleValue().toString() : null;
    }

    private TopicModelImpl fetchTopic(String key, Object value) {
        return this.pl.fetchTopic(key, new SimpleValue(value));
    }

    private List<TopicModelImpl> queryTopics(String key, Object value) {
        return this.pl.queryTopics(key, new SimpleValue(value));
    }

    private List<TopicModelImpl> fetchTopicsByOwner(String username, String typeUri) {
        ArrayList<TopicModelImpl> topics = new ArrayList<TopicModelImpl>();
        for (TopicModelImpl topic : this.pl.fetchTopicsByProperty(PROP_OWNER, username)) {
            if (!topic.getTypeUri().equals(typeUri)) continue;
            topics.add(topic);
        }
        return topics;
    }

    private String userInfo(String username) {
        return "user " + (username != null ? "\"" + username + "\"" : "<anonymous>");
    }
}

