/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.List;
import systems.dmx.core.impl.AssocModelImpl;
import systems.dmx.core.impl.CoreEvent;
import systems.dmx.core.impl.DMXObjectModelImpl;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.impl.TopicImpl;
import systems.dmx.core.impl.TopicTypeModelImpl;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.CompDefModel;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.service.DMXEvent;
import systems.dmx.core.service.Directive;

class TopicModelImpl
extends DMXObjectModelImpl
implements TopicModel {
    TopicModelImpl(DMXObjectModelImpl object) {
        super(object);
    }

    @Override
    public PlayerModel createPlayerModel(String roleTypeUri) {
        return this.mf.newTopicPlayerModel(this.id, roleTypeUri);
    }

    @Override
    public TopicModel clone() {
        try {
            return (TopicModel)super.clone();
        }
        catch (Exception e) {
            throw new RuntimeException("Cloning a TopicModel failed", e);
        }
    }

    @Override
    String className() {
        return "topic";
    }

    @Override
    TopicImpl instantiate() {
        return new TopicImpl(this, this.pl);
    }

    @Override
    final TopicModelImpl createModelWithChildTopics(ChildTopicsModel childTopics) {
        return this.mf.newTopicModel(this.typeUri, childTopics);
    }

    @Override
    final TopicTypeModelImpl getType() {
        return this.pl.typeStorage.getTopicType(this.typeUri);
    }

    @Override
    final List<AssocModelImpl> getAssocs() {
        return this.pl.fetchTopicAssocs(this.id);
    }

    @Override
    final RelatedTopicModelImpl getRelatedTopic(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.pl.fetchTopicRelatedTopic(this.id, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
    }

    @Override
    final List<RelatedTopicModelImpl> getRelatedTopics(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.pl.fetchTopicRelatedTopics(this.id, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
    }

    @Override
    final void storeUri() {
        this.pl.storeTopicUri(this.id, this.uri);
    }

    @Override
    final void storeTypeUri() {
        this.reassignInstantiation();
        this.pl.storeTopicTypeUri(this.id, this.typeUri);
    }

    @Override
    final void storeSimpleValue() {
        this.pl.storeTopicValue(this.id, this.value, this.typeUri, this.isHtml());
    }

    @Override
    final void storeProperty(String propUri, Object propValue, boolean addToIndex) {
        this.pl.storeTopicProperty(this.id, propUri, propValue, addToIndex);
    }

    @Override
    final void removeProperty(String propUri) {
        this.pl.removeTopicProperty(this.id, propUri);
    }

    @Override
    final void _delete() {
        this.pl._deleteTopic(this.id);
    }

    @Override
    final <M extends DMXObjectModelImpl> M checkReadAccess() {
        this.pl.checkTopicReadAccess(this.id);
        return (M)this;
    }

    @Override
    final void checkWriteAccess() {
        this.pl.checkTopicWriteAccess(this.id);
    }

    @Override
    final DMXEvent getPreUpdateEvent() {
        return CoreEvent.PRE_UPDATE_TOPIC;
    }

    @Override
    final DMXEvent getPostUpdateEvent() {
        return CoreEvent.POST_UPDATE_TOPIC;
    }

    @Override
    final DMXEvent getPreDeleteEvent() {
        return CoreEvent.PRE_DELETE_TOPIC;
    }

    @Override
    final DMXEvent getPostDeleteEvent() {
        return CoreEvent.POST_DELETE_TOPIC;
    }

    @Override
    final Directive getUpdateDirective() {
        return Directive.UPDATE_TOPIC;
    }

    @Override
    final Directive getDeleteDirective() {
        return Directive.DELETE_TOPIC;
    }

    @Override
    void preDelete() {
        if (this.typeUri.equals("dmx.core.topic_type") || this.typeUri.equals("dmx.core.assoc_type")) {
            throw new RuntimeException("Tried to delete a type with a generic delete-topic call. Use a delete-type call instead.");
        }
    }

    TopicModelImpl findChildTopic(String topicTypeUri) {
        try {
            if (this.typeUri.equals(topicTypeUri)) {
                return this;
            }
            for (CompDefModel compDefModel : this.getType().getCompDefs()) {
                String compDefUri = compDefModel.getCompDefUri();
                String cardinalityUri = compDefModel.getChildCardinalityUri();
                TopicModelImpl childTopic = null;
                if (cardinalityUri.equals("dmx.core.one")) {
                    childTopic = this.childTopics.getTopicOrNull(compDefUri);
                } else if (cardinalityUri.equals("dmx.core.many")) {
                    List<RelatedTopicModelImpl> _childTopics = this.childTopics.getTopicsOrNull(compDefUri);
                    if (_childTopics != null && !_childTopics.isEmpty()) {
                        childTopic = _childTopics.get(0);
                    }
                } else {
                    throw new RuntimeException("\"" + cardinalityUri + "\" is an unexpected cardinality URI");
                }
                if (childTopic == null || (childTopic = childTopic.findChildTopic(topicTypeUri)) == null) continue;
                return childTopic;
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Searching topic " + this.id + " for \"" + topicTypeUri + "\" failed", e);
        }
    }

    private void reassignInstantiation() {
        this.fetchInstantiation().delete();
        this.pl.createTopicInstantiation(this.id, this.typeUri);
    }

    private AssocModelImpl fetchInstantiation() {
        RelatedTopicModelImpl topicType = this.getRelatedTopic("dmx.core.instantiation", "dmx.core.instance", "dmx.core.type", "dmx.core.topic_type");
        if (topicType == null) {
            throw new RuntimeException("Topic " + this.id + " is not associated to a topic type");
        }
        return topicType.getRelatingAssoc();
    }
}

