/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.List;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import systems.dmx.core.Assoc;
import systems.dmx.core.AssocType;
import systems.dmx.core.DMXObject;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.impl.AssocImpl;
import systems.dmx.core.impl.AssocModelImpl;
import systems.dmx.core.impl.AssocTypeImpl;
import systems.dmx.core.impl.AssocTypeModelImpl;
import systems.dmx.core.impl.DMXObjectModelImpl;
import systems.dmx.core.impl.EventManager;
import systems.dmx.core.impl.MigrationManager;
import systems.dmx.core.impl.ModelFactoryImpl;
import systems.dmx.core.impl.PersistenceLayer;
import systems.dmx.core.impl.PluginImpl;
import systems.dmx.core.impl.PluginManager;
import systems.dmx.core.impl.PrivilegedAccessImpl;
import systems.dmx.core.impl.TopicImpl;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.impl.TopicTypeImpl;
import systems.dmx.core.impl.TopicTypeModelImpl;
import systems.dmx.core.impl.WebPublishingService;
import systems.dmx.core.impl.WebSocketsServiceImpl;
import systems.dmx.core.model.AssocModel;
import systems.dmx.core.model.AssocTypeModel;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.model.TopicTypeModel;
import systems.dmx.core.service.CoreService;
import systems.dmx.core.service.DMXEvent;
import systems.dmx.core.service.ModelFactory;
import systems.dmx.core.service.PluginInfo;
import systems.dmx.core.service.accesscontrol.PrivilegedAccess;
import systems.dmx.core.storage.spi.DMXTransaction;

public class CoreServiceImpl
implements CoreService {
    BundleContext bundleContext;
    PersistenceLayer pl;
    EventManager em;
    ModelFactoryImpl mf;
    PrivilegedAccess ac;
    MigrationManager migrationManager;
    PluginManager pluginManager;
    WebSocketsServiceImpl wsService;
    WebPublishingService wpService;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public CoreServiceImpl(PersistenceLayer pl, BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.pl = pl;
        this.em = pl.em;
        this.mf = pl.mf;
        this.ac = new PrivilegedAccessImpl(pl);
        this.migrationManager = new MigrationManager(this);
        this.pluginManager = new PluginManager(this);
        this.wsService = new WebSocketsServiceImpl(this);
        this.wpService = new WebPublishingService(pl, this.wsService);
        this.setupDB();
    }

    @Override
    public Topic getTopic(long topicId) {
        return this.pl.getTopic(topicId);
    }

    @Override
    public TopicImpl getTopicByUri(String uri) {
        return this.pl.getTopicByUri(uri);
    }

    @Override
    public Topic getTopicByValue(String key, SimpleValue value) {
        return this.pl.getTopicByValue(key, value);
    }

    @Override
    public List<Topic> getTopicsByValue(String key, SimpleValue value) {
        return this.pl.getTopicsByValue(key, value);
    }

    @Override
    public List<Topic> getTopicsByType(String topicTypeUri) {
        return this.pl.getTopicsByType(topicTypeUri);
    }

    @Override
    public List<Topic> searchTopics(String searchTerm, String fieldUri) {
        return this.pl.searchTopics(searchTerm, fieldUri);
    }

    @Override
    public Iterable<Topic> getAllTopics() {
        return this.pl.getAllTopics();
    }

    @Override
    public TopicImpl createTopic(TopicModel model) {
        return this.pl.createTopic((TopicModelImpl)model);
    }

    @Override
    public void updateTopic(TopicModel updateModel) {
        this.pl.updateTopic((TopicModelImpl)updateModel);
    }

    @Override
    public void deleteTopic(long topicId) {
        this.pl.deleteTopic(topicId);
    }

    @Override
    public Assoc getAssoc(long assocId) {
        return this.pl.getAssoc(assocId);
    }

    @Override
    public Assoc getAssocByValue(String key, SimpleValue value) {
        return this.pl.getAssocByValue(key, value);
    }

    @Override
    public List<Assoc> getAssocsByValue(String key, SimpleValue value) {
        return this.pl.getAssocsByValue(key, value);
    }

    @Override
    public Assoc getAssoc(String assocTypeUri, long topic1Id, long topic2Id, String roleTypeUri1, String roleTypeUri2) {
        return this.pl.getAssoc(assocTypeUri, topic1Id, topic2Id, roleTypeUri1, roleTypeUri2);
    }

    @Override
    public Assoc getAssocBetweenTopicAndAssoc(String assocTypeUri, long topicId, long assocId, String topicRoleTypeUri, String assocRoleTypeUri) {
        return this.pl.getAssocBetweenTopicAndAssoc(assocTypeUri, topicId, assocId, topicRoleTypeUri, assocRoleTypeUri);
    }

    @Override
    public List<Assoc> getAssocsByType(String assocTypeUri) {
        return this.pl.getAssocsByType(assocTypeUri);
    }

    @Override
    public List<Assoc> getAssocs(long topic1Id, long topic2Id) {
        return this.pl.getAssocs(topic1Id, topic2Id);
    }

    @Override
    public List<Assoc> getAssocs(long topic1Id, long topic2Id, String assocTypeUri) {
        return this.pl.getAssocs(assocTypeUri, topic1Id, topic2Id);
    }

    @Override
    public Iterable<Assoc> getAllAssocs() {
        return this.pl.getAllAssocs();
    }

    @Override
    public List<PlayerModel> getPlayerModels(long assocId) {
        return this.pl.getPlayerModels(assocId);
    }

    @Override
    public AssocImpl createAssoc(AssocModel model) {
        return this.pl.createAssoc((AssocModelImpl)model);
    }

    @Override
    public void updateAssoc(AssocModel updateModel) {
        this.pl.updateAssoc((AssocModelImpl)updateModel);
    }

    @Override
    public void deleteAssoc(long assocId) {
        this.pl.deleteAssoc(assocId);
    }

    @Override
    public TopicTypeImpl getTopicType(String uri) {
        return this.pl.getTopicType(uri);
    }

    @Override
    public TopicTypeImpl getTopicTypeImplicitly(long topicId) {
        return this.pl.getTopicTypeImplicitly(topicId);
    }

    @Override
    public List<TopicType> getAllTopicTypes() {
        return this.pl.getAllTopicTypes();
    }

    @Override
    public TopicTypeImpl createTopicType(TopicTypeModel model) {
        return this.pl.createTopicType((TopicTypeModelImpl)model);
    }

    @Override
    public void updateTopicType(TopicTypeModel updateModel) {
        this.pl.updateTopicType((TopicTypeModelImpl)updateModel);
    }

    @Override
    public void deleteTopicType(String topicTypeUri) {
        this.pl.deleteTopicType(topicTypeUri);
    }

    @Override
    public AssocTypeImpl getAssocType(String uri) {
        return this.pl.getAssocType(uri);
    }

    @Override
    public AssocTypeImpl getAssocTypeImplicitly(long assocId) {
        return this.pl.getAssocTypeImplicitly(assocId);
    }

    @Override
    public List<AssocType> getAllAssocTypes() {
        return this.pl.getAllAssocTypes();
    }

    @Override
    public AssocTypeImpl createAssocType(AssocTypeModel model) {
        return this.pl.createAssocType((AssocTypeModelImpl)model);
    }

    @Override
    public void updateAssocType(AssocTypeModel updateModel) {
        this.pl.updateAssocType((AssocTypeModelImpl)updateModel);
    }

    @Override
    public void deleteAssocType(String assocTypeUri) {
        this.pl.deleteAssocType(assocTypeUri);
    }

    @Override
    public Topic createRoleType(TopicModel model) {
        return this.pl.createRoleType((TopicModelImpl)model);
    }

    @Override
    public DMXObject getObject(long id) {
        return this.pl.getObject(id);
    }

    @Override
    public PluginImpl getPlugin(String pluginUri) {
        return this.pluginManager.getPlugin(pluginUri);
    }

    @Override
    public List<PluginInfo> getPluginInfo() {
        return this.pluginManager.getPluginInfo();
    }

    @Override
    public void fireEvent(DMXEvent event, Object ... params) {
        this.em.fireEvent(event, params);
    }

    @Override
    public void dispatchEvent(String pluginUri, DMXEvent event, Object ... params) {
        this.em.dispatchEvent(this.getPlugin(pluginUri), event, params);
    }

    @Override
    public Object getProperty(long id, String propUri) {
        return this.pl.fetchProperty(id, propUri);
    }

    @Override
    public boolean hasProperty(long id, String propUri) {
        return this.pl.hasProperty(id, propUri);
    }

    @Override
    public List<Topic> getTopicsByProperty(String propUri, Object propValue) {
        return this.pl.getTopicsByProperty(propUri, propValue);
    }

    @Override
    public List<Topic> getTopicsByPropertyRange(String propUri, Number from, Number to) {
        return this.pl.getTopicsByPropertyRange(propUri, from, to);
    }

    @Override
    public List<Assoc> getAssocsByProperty(String propUri, Object propValue) {
        return this.pl.getAssocsByProperty(propUri, propValue);
    }

    @Override
    public List<Assoc> getAssocsByPropertyRange(String propUri, Number from, Number to) {
        return this.pl.getAssocsByPropertyRange(propUri, from, to);
    }

    @Override
    public void addTopicPropertyIndex(String propUri) {
        int topics = 0;
        int added = 0;
        this.logger.info("########## Adding topic property index for \"" + propUri + "\"");
        for (Topic topic : this.getAllTopics()) {
            if (topic.hasProperty(propUri)) {
                Object value = topic.getProperty(propUri);
                this.pl.indexTopicProperty(topic.getId(), propUri, value);
                ++added;
            }
            ++topics;
        }
        this.logger.info("########## Adding topic property index complete\n    Topics processed: " + topics + "\n    added to index: " + added);
    }

    @Override
    public void addAssocPropertyIndex(String propUri) {
        int assocs = 0;
        int added = 0;
        this.logger.info("########## Adding association property index for \"" + propUri + "\"");
        for (Assoc assoc : this.getAllAssocs()) {
            if (assoc.hasProperty(propUri)) {
                Object value = assoc.getProperty(propUri);
                this.pl.indexAssocProperty(assoc.getId(), propUri, value);
                ++added;
            }
            ++assocs;
        }
        this.logger.info("########## Adding association property complete\n    Associations processed: " + assocs + "\n    added to index: " + added);
    }

    @Override
    public DMXTransaction beginTx() {
        return this.pl.beginTx();
    }

    @Override
    public ModelFactory getModelFactory() {
        return this.mf;
    }

    @Override
    public PrivilegedAccess getPrivilegedAccess() {
        return this.ac;
    }

    @Override
    public WebSocketsServiceImpl getWebSocketsService() {
        return this.wsService;
    }

    @Override
    public Object getDatabaseVendorObject() {
        return this.pl.getDatabaseVendorObject();
    }

    public void shutdown() {
        this.wsService.shutdown();
    }

    Assoc createAssoc(String typeUri, PlayerModel player1, PlayerModel player2) {
        return this.createAssoc(this.mf.newAssocModel(typeUri, player1, player2));
    }

    private void setupDB() {
        DMXTransaction tx = this.beginTx();
        try {
            this.logger.info("----- Setting up the database -----");
            boolean isCleanInstall = this.pl.init();
            if (isCleanInstall) {
                this.setupBootstrapContent();
            }
            this.migrationManager.runCoreMigrations(isCleanInstall);
            tx.success();
            tx.finish();
            this.logger.info("----- Setting up the database complete -----");
        }
        catch (Exception e) {
            this.logger.warning("ROLLBACK!");
            tx.finish();
            this.pl.shutdown();
            throw new RuntimeException("Setting up the database failed", e);
        }
    }

    private void setupBootstrapContent() {
        try {
            TopicModelImpl t = this.mf.newTopicModel("dmx.core.topic_type", "dmx.core.meta_type", new SimpleValue("Topic Type"));
            TopicModelImpl a = this.mf.newTopicModel("dmx.core.assoc_type", "dmx.core.meta_type", new SimpleValue("Association Type"));
            this._createTopic(t);
            this._createTopic(a);
            TopicTypeModelImpl dataType = this.mf.newTopicTypeModel("dmx.core.data_type", "Data Type", "dmx.core.text");
            this._createTopic(dataType);
            TopicModelImpl text = this.mf.newTopicModel("dmx.core.text", "dmx.core.data_type", new SimpleValue("Text"));
            this._createTopic(text);
            AssocTypeModelImpl composition = this.mf.newAssocTypeModel("dmx.core.composition", "Composition", "dmx.core.text");
            this._createTopic(composition);
            AssocTypeModelImpl instn = this.mf.newAssocTypeModel("dmx.core.instantiation", "Instantiation", "dmx.core.text");
            this._createTopic(instn);
            this.pl.createTopicInstantiation(t.getId(), t.getTypeUri());
            this.pl.createTopicInstantiation(a.getId(), a.getTypeUri());
            this.pl.createTopicInstantiation(dataType.getId(), dataType.getTypeUri());
            this.pl.createTopicInstantiation(text.getId(), text.getTypeUri());
            this.pl.createTopicInstantiation(((DMXObjectModelImpl)composition).getId(), ((DMXObjectModelImpl)composition).getTypeUri());
            this.pl.createTopicInstantiation(((DMXObjectModelImpl)instn).getId(), ((DMXObjectModelImpl)instn).getTypeUri());
            this._associateDataType("dmx.core.meta_type", "dmx.core.text");
            this._associateDataType("dmx.core.topic_type", "dmx.core.text");
            this._associateDataType("dmx.core.assoc_type", "dmx.core.text");
            this._associateDataType("dmx.core.data_type", "dmx.core.text");
            this._associateDataType("dmx.core.composition", "dmx.core.text");
            this._associateDataType("dmx.core.instantiation", "dmx.core.text");
        }
        catch (Exception e) {
            throw new RuntimeException("Setting up the bootstrap content failed", e);
        }
    }

    private void _createTopic(TopicModelImpl model) {
        this.pl.storeTopic(model);
        this.pl.storeTopicValue(model.id, model.value, model.typeUri, false);
    }

    private void _associateDataType(String typeUri, String dataTypeUri) {
        AssocModelImpl assoc = this.mf.newAssocModel("dmx.core.composition", this.mf.newTopicPlayerModel(typeUri, "dmx.core.type"), this.mf.newTopicPlayerModel(dataTypeUri, "dmx.core.default"));
        this.pl.storeAssoc(assoc);
        this.pl.storeAssocValue(assoc.id, assoc.value, assoc.typeUri, false);
    }
}

