/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import systems.dmx.core.Topic;
import systems.dmx.core.ViewConfiguration;
import systems.dmx.core.impl.ModelFactoryImpl;
import systems.dmx.core.impl.PersistenceLayer;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.impl.ViewConfigurationModelImpl;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.model.ViewConfigurationModel;

class ViewConfigurationImpl
implements ViewConfiguration {
    private ViewConfigurationModelImpl model;
    private PlayerModel configurable;
    private PersistenceLayer pl;
    private ModelFactoryImpl mf;

    ViewConfigurationImpl(PlayerModel configurable, ViewConfigurationModelImpl model, PersistenceLayer pl) {
        this.configurable = configurable;
        this.model = model;
        this.pl = pl;
        this.mf = pl.mf;
    }

    @Override
    public Iterable<Topic> getConfigTopics() {
        return this.pl.instantiate(this.model.getConfigTopics());
    }

    @Override
    public Topic getConfigTopic(String configTypeUri) {
        TopicModelImpl configTopic = this.model.getConfigTopic(configTypeUri);
        return configTopic != null ? configTopic.instantiate() : null;
    }

    @Override
    public Topic addConfigTopic(TopicModel configTopic) {
        TopicModelImpl _configTopic = (TopicModelImpl)configTopic;
        this._addConfigTopic(_configTopic);
        return _configTopic.instantiate();
    }

    @Override
    public ViewConfiguration setConfigValue(String configTypeUri, String childTypeUri, Object value) {
        this._setConfigValue(configTypeUri, this.mf.newChildTopicsModel().put(childTypeUri, value));
        return this;
    }

    @Override
    public ViewConfiguration setConfigValueRef(String configTypeUri, String childTypeUri, Object topicIdOrUri) {
        this._setConfigValue(configTypeUri, this.mf.newChildTopicsModel().put(childTypeUri, this.mf.newTopicReferenceModel(topicIdOrUri)));
        return this;
    }

    @Override
    public ViewConfigurationModel getModel() {
        return this.model;
    }

    private void _setConfigValue(String configTypeUri, ChildTopicsModel children) {
        TopicModelImpl configTopic = this.model.getConfigTopic(configTypeUri);
        if (configTopic == null) {
            configTopic = this.mf.newTopicModel(configTypeUri, children);
            this._addConfigTopic(configTopic);
        } else {
            configTopic.updateChildTopics(children);
        }
    }

    private void _addConfigTopic(TopicModelImpl configTopic) {
        this.model.addConfigTopic(configTopic);
        this.pl.typeStorage.storeViewConfigTopic(this.configurable, configTopic);
    }
}

