/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.JSONEnabled;
import systems.dmx.core.impl.AssocModelImpl;
import systems.dmx.core.impl.ChildTopicsModelImpl;
import systems.dmx.core.impl.CoreEvent;
import systems.dmx.core.impl.DMXObjectModelImpl;
import systems.dmx.core.impl.LabelCalculation;
import systems.dmx.core.impl.ModelFactoryImpl;
import systems.dmx.core.impl.PersistenceLayer;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.impl.TopicImpl;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.impl.TopicReferenceModelImpl;
import systems.dmx.core.impl.TypeModelImpl;
import systems.dmx.core.model.AssocModel;
import systems.dmx.core.model.CompDefModel;
import systems.dmx.core.model.DMXObjectModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicDeletionModel;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.model.TopicReferenceModel;
import systems.dmx.core.model.TypeModel;
import systems.dmx.core.util.DMXUtils;

class ValueIntegrator {
    private DMXObjectModelImpl newValues;
    private DMXObjectModelImpl targetObject;
    private CompDefModel compDef;
    private TypeModelImpl type;
    private boolean isAssoc;
    private boolean isType;
    private boolean isFacetUpdate;
    private List<String> emptyValues = new ArrayList<String>();
    private PersistenceLayer pl;
    private ModelFactoryImpl mf;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    ValueIntegrator(PersistenceLayer pl) {
        this.pl = pl;
        this.mf = pl.mf;
    }

    <M extends DMXObjectModelImpl> UnifiedValue<M> integrate(M newValues, M targetObject, CompDefModel compDef) {
        try {
            this.newValues = newValues;
            this.targetObject = targetObject;
            this.compDef = compDef;
            this.isAssoc = newValues instanceof AssocModel;
            this.isType = newValues instanceof TypeModel;
            boolean bl = this.isFacetUpdate = compDef != null;
            if (newValues instanceof TopicReferenceModel) {
                return this.unifyRef();
            }
            if (newValues instanceof TopicDeletionModel) {
                return new UnifiedValue(this, null);
            }
            if (newValues.getTypeUri() == null) {
                throw new IllegalArgumentException("Tried to integrate values whose typeUri is not set, newValues=" + newValues + ", targetObject=" + targetObject);
            }
            this.type = newValues.getType();
            DMXObjectModelImpl _value = !this.isFacetUpdate && newValues.isSimple() ? this.integrateSimple() : this.integrateComposite();
            UnifiedValue value = new UnifiedValue(this, _value);
            this.idTransfer(_value);
            return value;
        }
        catch (Exception e) {
            throw new RuntimeException("Value integration failed, newValues=" + newValues + ", targetObject=" + targetObject + ", compDef=" + compDef, e);
        }
    }

    private UnifiedValue unifyRef() {
        TopicReferenceModelImpl ref = (TopicReferenceModelImpl)this.newValues;
        if (!ref.isEmptyRef()) {
            TopicModelImpl object = ref.resolve();
            this.logger.fine("Referencing " + object);
            return new UnifiedValue(this, object, ref.originalId);
        }
        return new UnifiedValue(this, null);
    }

    private void idTransfer(DMXObjectModelImpl value) {
        if (value != null) {
            if (value.id == -1L) {
                throw new RuntimeException("ID of unification result is not initialized: " + value);
            }
            this.newValues.id = value.id;
        }
    }

    private DMXObjectModelImpl integrateSimple() {
        if (this.isAssoc || this.isType) {
            return this.storeAssocSimpleValue();
        }
        if (this.newValues.getSimpleValue().toString().isEmpty()) {
            return null;
        }
        return this.unifySimple();
    }

    private DMXObjectModelImpl storeAssocSimpleValue() {
        if (this.targetObject != null) {
            this.targetObject._updateSimpleValue(this.newValues.getSimpleValue());
            return this.targetObject;
        }
        this.newValues.storeSimpleValue();
        return this.newValues;
    }

    private TopicModelImpl unifySimple() {
        SimpleValue newValue = this.newValues.getSimpleValue();
        TopicModelImpl topic = this.pl.fetchTopic(this.type.getUri(), newValue);
        if (topic != null && topic.isReadable()) {
            this.logger.fine("Reusing simple value " + topic.id + " \"" + newValue + "\" (typeUri=\"" + this.type.uri + "\")");
        } else {
            topic = this.createSimpleTopic();
            this.logger.fine("### Creating simple value " + topic.id + " \"" + newValue + "\" (typeUri=\"" + this.type.uri + "\")");
        }
        return topic;
    }

    private DMXObjectModelImpl integrateComposite() {
        HashMap<String, Object> childValues = new HashMap<String, Object>();
        ChildTopicsModelImpl _childTopics = this.newValues.getChildTopicsModel();
        for (String compDefUri : this.compDefUris()) {
            Object newChildValue = this.isOne(compDefUri) ? _childTopics.getTopicOrNull(compDefUri) : _childTopics.getTopicsOrNull(compDefUri);
            if (newChildValue == null) continue;
            Object childTopic = this.integrateChildValue(newChildValue, compDefUri);
            if (this.isOne(compDefUri) && ((UnifiedValue)childTopic).value == null) {
                this.emptyValues.add(compDefUri);
                continue;
            }
            childValues.put(compDefUri, childTopic);
        }
        DMXObjectModelImpl value = this.unifyComposite(childValues);
        if (!this.isFacetUpdate) {
            if (value != null) {
                new LabelCalculation(value).calculate();
            } else if (this.isAssoc) {
                this.storeAssocSimpleValue();
            }
        }
        return value;
    }

    private Iterable<String> compDefUris() {
        return !this.isFacetUpdate ? this.type : Arrays.asList(this.compDef.getCompDefUri());
    }

    private Object integrateChildValue(Object childValue, String compDefUri) {
        if (this.isOne(compDefUri)) {
            return new ValueIntegrator(this.pl).integrate((RelatedTopicModelImpl)childValue, null, null);
        }
        ArrayList<UnifiedValue<Object>> values = new ArrayList<UnifiedValue<Object>>();
        for (RelatedTopicModelImpl value : (List)childValue) {
            values.add(new ValueIntegrator(this.pl).integrate(value, null, null));
        }
        return values;
    }

    private DMXObjectModelImpl unifyComposite(Map<String, Object> childValues) {
        if (this.isValueType() && !this.isFacetUpdate) {
            return !childValues.isEmpty() ? this.unifyChildTopics(childValues, this.type) : null;
        }
        DMXObjectModelImpl parent = this.identifyParent(childValues);
        return parent != null ? this.updateAssignments(parent, childValues) : null;
    }

    private DMXObjectModelImpl identifyParent(Map<String, Object> childValues) {
        if (this.targetObject != null) {
            return this.targetObject;
        }
        if (this.isAssoc) {
            if (this.newValues.id == -1L) {
                throw new RuntimeException("newValues has no ID set");
            }
            AssocModelImpl _newValues = (AssocModelImpl)this.newValues;
            return this.mf.newAssocModel(this.newValues.id, this.newValues.uri, this.newValues.typeUri, _newValues.player1, _newValues.player2);
        }
        List<String> identityCompDefUris = this.type.getIdentityAttrs();
        if (identityCompDefUris.size() > 0) {
            return !childValues.isEmpty() ? this.unifyChildTopics(this.identityChildTopics(childValues, identityCompDefUris), identityCompDefUris) : null;
        }
        TopicModelImpl parent = this.createSimpleTopic();
        this.logger.fine("### Creating composite (w/o identity attrs) " + parent.id + " (typeUri=\"" + this.type.uri + "\")");
        return parent;
    }

    private Map<String, Object> identityChildTopics(Map<String, Object> childValues, List<String> identityCompDefUris) {
        try {
            HashMap<String, Object> identityChildTopics = new HashMap<String, Object>();
            for (String compDefUri : identityCompDefUris) {
                if (!this.isOne(compDefUri)) {
                    throw new RuntimeException("Cardinality \"many\" identity attributes not supported");
                }
                UnifiedValue childTopic = (UnifiedValue)childValues.get(compDefUri);
                if (childTopic == null) {
                    throw new RuntimeException("Identity value \"" + compDefUri + "\" is missing in " + childValues.keySet() + " (childTopic=null)");
                }
                if (childTopic.value == null) {
                    throw new RuntimeException("Identity value \"" + compDefUri + "\" is missing in " + childValues.keySet() + " (childTopic.value=null)");
                }
                identityChildTopics.put(compDefUri, childTopic);
            }
            return identityChildTopics;
        }
        catch (Exception e) {
            throw new RuntimeException("Selecting identity children " + identityCompDefUris + " failed, childValues=" + childValues, e);
        }
    }

    private DMXObjectModelImpl updateAssignments(DMXObjectModelImpl parent, Map<String, Object> childValues) {
        if (!parent.getTypeUri().equals(this.type.getUri())) {
            throw new RuntimeException("Type mismatch: newValues type=\"" + this.type.getUri() + "\", parent type=\"" + parent.getTypeUri() + "\"");
        }
        for (String compDefUri : this.compDefUris()) {
            parent.loadChildTopics(this.compDef(compDefUri), true);
            Object childTopic = childValues.get(compDefUri);
            if (this.isOne(compDefUri)) {
                TopicModel _childTopic = childTopic != null ? ((UnifiedValue)childTopic).value : null;
                this.updateAssignmentsOne(parent, _childTopic, compDefUri);
                continue;
            }
            if (childTopic == null) continue;
            this.updateAssignmentsMany(parent, (List)childTopic, compDefUri);
        }
        return parent;
    }

    private void updateAssignmentsOne(DMXObjectModelImpl parent, TopicModel childTopic, String compDefUri) {
        try {
            ChildTopicsModelImpl oldChildTopics = parent.getChildTopicsModel();
            RelatedTopicModelImpl oldValue = oldChildTopics.getTopicOrNull(compDefUri);
            if (oldValue != null && oldValue.id == -1L) {
                throw new RuntimeException("Old value's ID is not initialized, oldValue=" + oldValue);
            }
            boolean newValueIsEmpty = this.isEmptyValue(compDefUri);
            boolean deleted = false;
            if (oldValue != null && (newValueIsEmpty || childTopic != null && !oldValue.equals(childTopic))) {
                oldValue.getRelatingAssoc().delete();
                if (newValueIsEmpty) {
                    this.logger.fine("### Deleting assignment (compDefUri=\"" + compDefUri + "\") from composite " + parent.id + " (typeUri=\"" + this.type.uri + "\")");
                    oldChildTopics.remove(compDefUri);
                }
                deleted = true;
            }
            AssocModelImpl assoc = null;
            if (!(childTopic == null || oldValue != null && oldValue.equals(childTopic))) {
                assoc = this.createChildAssoc(parent, childTopic, compDefUri, deleted);
                oldChildTopics.put(compDefUri, this.mf.newRelatedTopicModel(childTopic, (AssocModel)assoc));
            }
            if (assoc == null && oldValue != null && !deleted) {
                assoc = oldValue.getRelatingAssoc();
            }
            if (assoc != null) {
                RelatedTopicModelImpl newChildValue = this.newValues.getChildTopicsModel().getTopicOrNull(compDefUri);
                this.updateRelatingAssoc(assoc, compDefUri, newChildValue);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Updating assigment failed, parent=" + parent + ", childTopic=" + childTopic + ", compDefUri=\"" + compDefUri + "\"", e);
        }
    }

    private void updateAssignmentsMany(DMXObjectModelImpl parent, List<UnifiedValue> childValues, String compDefUri) {
        ChildTopicsModelImpl oldChildTopics = parent.getChildTopicsModel();
        List<RelatedTopicModelImpl> oldValues = oldChildTopics.getTopicsOrNull(compDefUri);
        for (UnifiedValue childValue : childValues) {
            TopicModel childTopic = (TopicModel)childValue.value;
            long originalId = childValue.originalId;
            long newId = childTopic != null ? childTopic.getId() : -1L;
            RelatedTopicModelImpl oldValue = null;
            if (originalId != -1L) {
                if (oldValues == null) {
                    throw new RuntimeException("Tried to replace original topic " + originalId + " when there are no old topics (null)");
                }
                oldValue = this.findTopic(oldValues, originalId);
            }
            boolean deleted = false;
            if (originalId != -1L && (newId == -1L || originalId != newId)) {
                if (newId == -1L) {
                    this.logger.fine("### Deleting assignment (compDefUri=\"" + compDefUri + "\") from composite " + parent.id + " (typeUri=\"" + this.type.uri + "\")");
                }
                deleted = true;
                oldValue.getRelatingAssoc().delete();
                this.removeTopic(oldValues, originalId);
            }
            AssocModelImpl assoc = null;
            if (newId != -1L && (originalId == -1L || originalId != newId)) {
                assoc = this.createChildAssoc(parent, childTopic, compDefUri, deleted);
                oldChildTopics.add(compDefUri, this.mf.newRelatedTopicModel(childTopic, (AssocModel)assoc));
            }
            if (assoc == null && oldValue != null && !deleted) {
                assoc = oldValue.getRelatingAssoc();
            }
            if (assoc == null) continue;
            RelatedTopicModelImpl newValues = (RelatedTopicModelImpl)childValue._newValues;
            this.updateRelatingAssoc(assoc, compDefUri, newValues);
        }
    }

    private void updateRelatingAssoc(AssocModelImpl assoc, String compDefUri, RelatedTopicModelImpl newValues) {
        try {
            if (newValues != null) {
                AssocModelImpl _newValues = newValues.getRelatingAssoc();
                _newValues.setPlayer1(null);
                _newValues.setPlayer2(null);
                if (_newValues.typeUri != null) {
                    assoc.update(_newValues);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Updating relating assoc " + assoc.id + " failed, compDefUri=\"" + compDefUri + "\", assoc=" + assoc, e);
        }
    }

    private DMXObjectModelImpl unifyChildTopics(Map<String, Object> childValues, Iterable<String> compDefUris) {
        List<? extends TopicModelImpl> candidates = this.parentCandidates(childValues);
        for (String compDefUri : compDefUris) {
            if (this.isOne(compDefUri)) {
                UnifiedValue value = (UnifiedValue)childValues.get(compDefUri);
                this.eliminateParentCandidates(candidates, value != null ? (TopicModelImpl)value.value : null, compDefUri);
            } else {
                List values = (List)childValues.get(compDefUri);
                this.eliminateParentCandidates(candidates, values, compDefUri);
            }
            if (!candidates.isEmpty()) continue;
            break;
        }
        switch (candidates.size()) {
            case 0: {
                return this.createCompositeTopic(childValues);
            }
            case 1: {
                DMXObjectModelImpl comp = candidates.get(0);
                return comp;
            }
        }
        throw new RuntimeException("ValueIntegrator ambiguity: there are " + candidates.size() + " parents (typeUri=\"" + this.type.uri + "\", " + DMXUtils.idList(candidates) + ") which have the same " + childValues.values().size() + " child topics " + childValues.values());
    }

    private List<? extends TopicModelImpl> parentCandidates(Map<String, Object> childValues) {
        String compDefUri = childValues.keySet().iterator().next();
        if (!this.type.getUri().equals(this.compDef(compDefUri).getParentTypeUri())) {
            throw new RuntimeException("Type mismatch: type=\"" + this.type.getUri() + "\", comp def's parent type=\"" + this.compDef(compDefUri).getParentTypeUri() + "\"");
        }
        Object childTopic = this.isOne(compDefUri) ? ((UnifiedValue)childValues.get((Object)compDefUri)).value : ((UnifiedValue)((List)childValues.get((Object)compDefUri)).get((int)0)).value;
        return this.pl.getTopicRelatedTopics(childTopic.getId(), this.compDef(compDefUri).getInstanceLevelAssocTypeUri(), "dmx.core.child", "dmx.core.parent", this.type.getUri());
    }

    private void eliminateParentCandidates(List<? extends TopicModelImpl> candidates, TopicModelImpl childTopic, String compDefUri) {
        CompDefModel compDef = this.compDef(compDefUri);
        Iterator<? extends TopicModelImpl> i = candidates.iterator();
        while (i.hasNext()) {
            TopicModelImpl parent = i.next();
            String assocTypeUri = compDef.getInstanceLevelAssocTypeUri();
            if (childTopic != null) {
                AssocModelImpl assoc = this.pl.getAssoc(assocTypeUri, parent.id, childTopic.id, "dmx.core.parent", "dmx.core.child");
                if (assoc != null) {
                    parent.getChildTopicsModel().put(compDefUri, this.mf.newRelatedTopicModel(childTopic, (AssocModel)assoc));
                    continue;
                }
                i.remove();
                continue;
            }
            if (this.pl.getTopicRelatedTopics(parent.id, assocTypeUri, "dmx.core.parent", "dmx.core.child", compDef.getChildTypeUri()).isEmpty()) continue;
            i.remove();
        }
    }

    private void eliminateParentCandidates(List<? extends TopicModelImpl> candidates, List<UnifiedValue> childValues, String compDefUri) {
        Iterator<? extends TopicModelImpl> i = candidates.iterator();
        while (i.hasNext()) {
            TopicModelImpl parent = i.next();
            parent.loadChildTopics(compDefUri, false);
            List<RelatedTopicModelImpl> childTopics = parent.getChildTopicsModel().getTopics(compDefUri);
            if (ValueIntegrator.matches(childTopics, childValues)) continue;
            i.remove();
        }
    }

    private TopicModelImpl createCompositeTopic(Map<String, Object> childValues) {
        TopicModelImpl model = this.mf.newTopicModel(this.newValues.uri, this.newValues.typeUri, this.newValues.value);
        ChildTopicsModelImpl childTopics = model.getChildTopicsModel();
        TopicImpl topic = this.pl.createSingleTopic(model, false);
        this.logger.info("### Creating composite " + model.id + " (typeUri=\"" + this.type.uri + "\")");
        for (String compDefUri : childValues.keySet()) {
            if (this.isOne(compDefUri)) {
                TopicModel childTopic = (TopicModel)((UnifiedValue)childValues.get((Object)compDefUri)).value;
                AssocModelImpl assoc = this.createChildAssoc(model, childTopic, compDefUri);
                childTopics.put(compDefUri, this.mf.newRelatedTopicModel(childTopic, (AssocModel)assoc));
                continue;
            }
            for (UnifiedValue value : (List)childValues.get(compDefUri)) {
                TopicModel childTopic = (TopicModel)value.value;
                AssocModelImpl assoc = this.createChildAssoc(model, childTopic, compDefUri);
                childTopics.add(compDefUri, this.mf.newRelatedTopicModel(childTopic, (AssocModel)assoc));
            }
        }
        this.pl.em.fireEvent(CoreEvent.POST_CREATE_TOPIC, topic);
        return model;
    }

    private TopicModelImpl createSimpleTopic() {
        if (this.isAssoc) {
            throw new RuntimeException("Tried to create a topic from an assoc model");
        }
        TopicModelImpl model = this.mf.newTopicModel(this.newValues.uri, this.newValues.typeUri, this.newValues.value);
        this.pl.createSingleTopic(model, true);
        return model;
    }

    private AssocModelImpl createChildAssoc(DMXObjectModel parent, DMXObjectModel child, String compDefUri) {
        return this.createChildAssoc(parent, child, compDefUri, false);
    }

    private AssocModelImpl createChildAssoc(DMXObjectModel parent, DMXObjectModel child, String compDefUri, boolean deleted) {
        this.logger.fine("### " + (deleted ? "Reassigning" : "Assigning") + " child " + child.getId() + " (compDefUri=\"" + compDefUri + "\") to composite " + parent.getId() + " (typeUri=\"" + this.type.uri + "\")");
        return this.pl.createAssoc(this.compDef(compDefUri).getInstanceLevelAssocTypeUri(), parent.createPlayerModel("dmx.core.parent"), child.createPlayerModel("dmx.core.child")).getModel();
    }

    private RelatedTopicModelImpl findTopic(List<RelatedTopicModelImpl> topics, long topicId) {
        for (RelatedTopicModelImpl topic : topics) {
            if (topic.id != topicId) continue;
            return topic;
        }
        throw new RuntimeException("Topic " + topicId + " not found in " + topics);
    }

    private void removeTopic(List<RelatedTopicModelImpl> topics, long topicId) {
        Iterator<RelatedTopicModelImpl> i = topics.iterator();
        while (i.hasNext()) {
            RelatedTopicModelImpl topic = i.next();
            if (topic.id != topicId) continue;
            i.remove();
            return;
        }
        throw new RuntimeException("Topic " + topicId + " not found in " + topics);
    }

    private static boolean matches(List<? extends TopicModel> topics, List<UnifiedValue> values) {
        int valueCount = 0;
        for (UnifiedValue value : values) {
            if (value.value == null) continue;
            if (!topics.contains(value)) {
                return false;
            }
            ++valueCount;
        }
        return topics.size() == valueCount;
    }

    private CompDefModel compDef(String compDefUri) {
        if (!this.isFacetUpdate) {
            return this.type.getCompDef(compDefUri);
        }
        if (!compDefUri.equals(this.compDef.getCompDefUri())) {
            throw new RuntimeException("URI mismatch: compDefUri=\"" + compDefUri + "\", facet compDefUri=\"" + this.compDef.getCompDefUri() + "\"");
        }
        return this.compDef;
    }

    private boolean isOne(String compDefUri) {
        return this.compDef(compDefUri).getChildCardinalityUri().equals("dmx.core.one");
    }

    private boolean isValueType() {
        return this.type.getDataTypeUri().equals("dmx.core.value");
    }

    private boolean isEmptyValue(String compDefUri) {
        return this.emptyValues.contains(compDefUri);
    }

    class UnifiedValue<M extends DMXObjectModelImpl>
    implements JSONEnabled {
        M value;
        DMXObjectModelImpl _newValues;
        long originalId;
        final /* synthetic */ ValueIntegrator this$0;

        private UnifiedValue(M value) {
            this.this$0 = this$0;
            this.value = value;
            this._newValues = ((ValueIntegrator)this$0).newValues;
            this.originalId = ((ValueIntegrator)this$0).newValues.id;
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private UnifiedValue(M originalId, long l) {
            void value;
            this.this$0 = (ValueIntegrator)this$0;
            this.value = value;
            this._newValues = ((ValueIntegrator)this$0).newValues;
            this.originalId = (long)originalId;
        }

        @Override
        public JSONObject toJSON() {
            try {
                return new JSONObject().put("value", this.value != null ? ((DMXObjectModelImpl)this.value).toJSON() : null).put("originalId", this.originalId);
            }
            catch (Exception e) {
                throw new RuntimeException("Serialization failed", e);
            }
        }

        public boolean equals(Object o) {
            return ((DMXObjectModelImpl)o).id == ((DMXObjectModelImpl)this.value).id;
        }

        public String toString() {
            try {
                return this.getClass().getSimpleName() + " " + this.toJSON().toString(4);
            }
            catch (Exception e) {
                throw new RuntimeException("Prettyprinting failed", e);
            }
        }
    }
}

