/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.Iterator;
import systems.dmx.core.impl.DMXObjectModelImpl;

class ReadableIterable<M extends DMXObjectModelImpl>
implements Iterable<M> {
    private Iterator<M> objects;
    private Iterator<M> i;
    private M next;

    ReadableIterable(Iterator<M> objects) {
        this.objects = objects;
        this.i = new Iterator(){

            @Override
            public boolean hasNext() {
                ReadableIterable.this.findNext();
                return ReadableIterable.this.next != null;
            }

            public M next() {
                return ReadableIterable.this.next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterator<M> iterator() {
        return this.i;
    }

    private void findNext() {
        this.next = null;
        while (this.objects.hasNext() && this.next == null) {
            DMXObjectModelImpl model = (DMXObjectModelImpl)this.objects.next();
            if (!model.isReadable()) continue;
            this.next = model;
        }
    }
}

