/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.osgi;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;
import systems.dmx.core.impl.AccessLayer;
import systems.dmx.core.impl.CoreServiceImpl;
import systems.dmx.core.impl.ModelFactoryImpl;
import systems.dmx.core.service.CoreService;
import systems.dmx.core.service.ModelFactory;
import systems.dmx.core.storage.spi.DMXStorage;

public class CoreActivator
implements BundleActivator {
    private static BundleContext bundleContext;
    private DMXStorage storageService;
    private static HttpService httpService;
    private ServiceTracker storageServiceTracker;
    private ServiceTracker httpServiceTracker;
    private CoreServiceImpl dmx;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public void start(BundleContext bundleContext) {
        try {
            this.logger.info("========== Starting \"DMX Core\" ==========");
            CoreActivator.bundleContext = bundleContext;
            this.registerModelFactory();
            this.storageServiceTracker = this.createServiceTracker(DMXStorage.class);
            this.storageServiceTracker.open();
            this.httpServiceTracker = this.createServiceTracker(HttpService.class);
            this.httpServiceTracker.open();
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "An error occurred while starting \"DMX Core\":", e);
        }
    }

    public void stop(BundleContext bundleContext) {
        try {
            this.logger.info("========== Stopping \"DMX Core\" ==========");
            this.storageServiceTracker.close();
            this.httpServiceTracker.close();
            if (this.dmx != null) {
                this.dmx.shutdown();
            }
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "An error occurred while stopping \"DMX Core\":", e);
        }
    }

    public static CoreService getCoreService() {
        return CoreActivator.getService(CoreService.class);
    }

    public static ModelFactory getModelFactory() {
        return CoreActivator.getService(ModelFactory.class);
    }

    public static HttpService getHttpService() {
        return httpService;
    }

    public static <S> S getService(Class<S> clazz) {
        Object serviceObject = bundleContext.getService(bundleContext.getServiceReference(clazz));
        if (serviceObject == null) {
            throw new RuntimeException("Service \"" + clazz.getName() + "\" is not available");
        }
        return (S)serviceObject;
    }

    private void registerModelFactory() {
        this.logger.info("Registering ModelFactory service at OSGi framework");
        bundleContext.registerService(ModelFactory.class.getName(), (Object)new ModelFactoryImpl(), null);
    }

    private ServiceTracker createServiceTracker(final Class serviceInterface) {
        return new ServiceTracker(bundleContext, serviceInterface.getName(), null){

            public Object addingService(ServiceReference serviceRef) {
                Object service = null;
                try {
                    service = super.addingService(serviceRef);
                    CoreActivator.this.addService(service);
                }
                catch (Throwable e) {
                    CoreActivator.this.logger.log(Level.SEVERE, "An error occurred while adding service " + serviceInterface.getName() + " to \"DMX Core\":", e);
                }
                return service;
            }

            public void removedService(ServiceReference ref, Object service) {
                try {
                    CoreActivator.this.removeService(service);
                    super.removedService(ref, service);
                }
                catch (Throwable e) {
                    CoreActivator.this.logger.log(Level.SEVERE, "An error occurred while removing service " + serviceInterface.getName() + " from \"DMX Core\":", e);
                }
            }
        };
    }

    private void addService(Object service) {
        if (service instanceof DMXStorage) {
            this.logger.info("Adding storage service to DMX Core");
            this.storageService = (DMXStorage)service;
            this.checkRequirementsForActivation();
        } else if (service instanceof HttpService) {
            this.logger.info("Adding HTTP service to DMX Core");
            httpService = (HttpService)service;
            this.checkRequirementsForActivation();
        }
    }

    private void removeService(Object service) {
        if (service == this.storageService) {
            this.logger.info("Removing storage service from DMX Core");
            this.storageService = null;
        } else if (service == httpService) {
            this.logger.info("Removing HTTP service from DMX Core");
            httpService = null;
        }
    }

    private void checkRequirementsForActivation() {
        if (this.storageService != null && httpService != null) {
            this.dmx = new CoreServiceImpl(new AccessLayer(this.storageService), bundleContext);
            this.logger.info("Registering DMX core service at OSGi framework");
            bundleContext.registerService(CoreService.class.getName(), (Object)this.dmx, null);
        }
    }
}

