/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.List;
import java.util.logging.Logger;
import systems.dmx.core.impl.AssocModelImpl;
import systems.dmx.core.impl.DMXObjectModelImpl;
import systems.dmx.core.impl.RelatedAssocModelImpl;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.model.AssocModel;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.storage.spi.DMXStorage;
import systems.dmx.core.storage.spi.DMXTransaction;

class StorageDecorator {
    private final DMXStorage storage;
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    StorageDecorator(DMXStorage storage) {
        this.storage = storage;
    }

    final TopicModelImpl fetchTopic(long topicId) {
        return (TopicModelImpl)this.storage.fetchTopic(topicId);
    }

    final TopicModelImpl fetchTopicByUri(String uri) {
        return this.fetchTopic("uri", new SimpleValue(uri));
    }

    final TopicModelImpl fetchTopic(String key, SimpleValue value) {
        return (TopicModelImpl)this.storage.fetchTopic(key, value.value());
    }

    final List<TopicModelImpl> fetchTopics(String key, SimpleValue value) {
        return this.storage.fetchTopics(key, value.value());
    }

    final List<TopicModelImpl> queryTopics(String key, SimpleValue value) {
        return this.storage.queryTopics(key, value.value());
    }

    final Iterable<TopicModelImpl> fetchAllTopics() {
        return this.storage.fetchAllTopics();
    }

    final void storeTopic(TopicModel model) {
        this.storage.storeTopic(model);
    }

    final void storeTopicUri(long topicId, String uri) {
        this.storage.storeTopicUri(topicId, uri);
    }

    final void storeTopicTypeUri(long topicId, String topicTypeUri) {
        this.storage.storeTopicTypeUri(topicId, topicTypeUri);
    }

    final void storeTopicValue(long topicId, SimpleValue value, String indexKey, boolean isHtmlValue) {
        this.storage.storeTopicValue(topicId, value, indexKey, isHtmlValue);
    }

    final void _deleteTopic(long topicId) {
        this.storage.deleteTopic(topicId);
    }

    final AssocModelImpl fetchAssoc(long assocId) {
        return (AssocModelImpl)this.storage.fetchAssoc(assocId);
    }

    final AssocModelImpl fetchAssoc(String key, SimpleValue value) {
        return (AssocModelImpl)this.storage.fetchAssoc(key, value.value());
    }

    final List<AssocModelImpl> fetchAssocs(String key, SimpleValue value) {
        return this.storage.fetchAssocs(key, value.value());
    }

    final AssocModelImpl fetchAssoc(String assocTypeUri, long topicId1, long topicId2, String roleTypeUri1, String roleTypeUri2) {
        List<AssocModelImpl> assocs = this.fetchAssocs(assocTypeUri, topicId1, topicId2, roleTypeUri1, roleTypeUri2);
        switch (assocs.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return assocs.get(0);
            }
        }
        throw new RuntimeException("Ambiguity: there are " + assocs.size() + " \"" + assocTypeUri + "\" associations (topicId1=" + topicId1 + ", topicId2=" + topicId2 + ", roleTypeUri1=\"" + roleTypeUri1 + "\", roleTypeUri2=\"" + roleTypeUri2 + "\")");
    }

    final List<AssocModelImpl> fetchAssocs(String assocTypeUri, long topicId1, long topicId2, String roleTypeUri1, String roleTypeUri2) {
        return this.storage.fetchAssocs(assocTypeUri, topicId1, topicId2, roleTypeUri1, roleTypeUri2);
    }

    final AssocModelImpl fetchAssocBetweenTopicAndAssoc(String assocTypeUri, long topicId, long assocId, String topicRoleTypeUri, String assocRoleTypeUri) {
        List<AssocModelImpl> assocs = this.fetchAssocsBetweenTopicAndAssoc(assocTypeUri, topicId, assocId, topicRoleTypeUri, assocRoleTypeUri);
        switch (assocs.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return assocs.get(0);
            }
        }
        throw new RuntimeException("Ambiguity: there are " + assocs.size() + " \"" + assocTypeUri + "\" associations (topicId=" + topicId + ", assocId=" + assocId + ", topicRoleTypeUri=\"" + topicRoleTypeUri + "\", assocRoleTypeUri=\"" + assocRoleTypeUri + "\")");
    }

    final List<AssocModelImpl> fetchAssocsBetweenTopicAndAssoc(String assocTypeUri, long topicId, long assocId, String topicRoleTypeUri, String assocRoleTypeUri) {
        return this.storage.fetchAssocsBetweenTopicAndAssoc(assocTypeUri, topicId, assocId, topicRoleTypeUri, assocRoleTypeUri);
    }

    final Iterable<AssocModelImpl> fetchAllAssocs() {
        return this.storage.fetchAllAssocs();
    }

    final List<PlayerModel> fetchPlayerModels(long assocId) {
        return this.storage.fetchPlayerModels(assocId);
    }

    final void storeAssoc(AssocModel model) {
        this.storage.storeAssoc(model);
    }

    final void storeAssocUri(long assocId, String uri) {
        this.storage.storeAssocUri(assocId, uri);
    }

    final void storeAssocTypeUri(long assocId, String assocTypeUri) {
        this.storage.storeAssocTypeUri(assocId, assocTypeUri);
    }

    final void storeRoleTypeUri(long assocId, long playerId, String roleTypeUri) {
        this.storage.storeRoleTypeUri(assocId, playerId, roleTypeUri);
    }

    final void storeAssocValue(long assocId, SimpleValue value, String indexKey, boolean isHtmlValue) {
        this.storage.storeAssocValue(assocId, value, indexKey, isHtmlValue);
    }

    final void _deleteAssoc(long assocId) {
        this.storage.deleteAssoc(assocId);
    }

    final DMXObjectModelImpl fetchObject(long id) {
        return (DMXObjectModelImpl)this.storage.fetchObject(id);
    }

    final RelatedTopicModelImpl fetchTopicRelatedTopic(long topicId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        List<RelatedTopicModelImpl> topics = this.fetchTopicRelatedTopics(topicId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
        switch (topics.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return topics.iterator().next();
            }
        }
        throw new RuntimeException("Ambiguity: there are " + topics.size() + " related topics (topicId=" + topicId + ", assocTypeUri=\"" + assocTypeUri + "\", myRoleTypeUri=\"" + myRoleTypeUri + "\", othersRoleTypeUri=\"" + othersRoleTypeUri + "\", othersTopicTypeUri=\"" + othersTopicTypeUri + "\")");
    }

    final List<RelatedTopicModelImpl> fetchTopicRelatedTopics(long topicId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.storage.fetchTopicRelatedTopics(topicId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
    }

    final RelatedAssocModelImpl fetchTopicRelatedAssoc(long topicId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        List<RelatedAssocModelImpl> assocs = this.fetchTopicRelatedAssocs(topicId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
        switch (assocs.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return assocs.iterator().next();
            }
        }
        throw new RuntimeException("Ambiguity: there are " + assocs.size() + " related associations (topicId=" + topicId + ", assocTypeUri=\"" + assocTypeUri + "\", myRoleTypeUri=\"" + myRoleTypeUri + "\", othersRoleTypeUri=\"" + othersRoleTypeUri + "\", othersAssocTypeUri=\"" + othersAssocTypeUri + "\")");
    }

    final List<RelatedAssocModelImpl> fetchTopicRelatedAssocs(long topicId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        return this.storage.fetchTopicRelatedAssocs(topicId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
    }

    final List<AssocModelImpl> fetchTopicAssocs(long topicId) {
        return this.storage.fetchTopicAssocs(topicId);
    }

    final RelatedTopicModelImpl fetchAssocRelatedTopic(long assocId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        List<RelatedTopicModelImpl> topics = this.fetchAssocRelatedTopics(assocId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
        switch (topics.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return topics.iterator().next();
            }
        }
        throw new RuntimeException("Ambiguity: there are " + topics.size() + " related topics (assocId=" + assocId + ", assocTypeUri=\"" + assocTypeUri + "\", myRoleTypeUri=\"" + myRoleTypeUri + "\", othersRoleTypeUri=\"" + othersRoleTypeUri + "\", othersTopicTypeUri=\"" + othersTopicTypeUri + "\")");
    }

    final List<RelatedTopicModelImpl> fetchAssocRelatedTopics(long assocId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.storage.fetchAssocRelatedTopics(assocId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
    }

    final RelatedAssocModelImpl fetchAssocRelatedAssoc(long assocId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        List<RelatedAssocModelImpl> assocs = this.fetchAssocRelatedAssocs(assocId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
        switch (assocs.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return assocs.iterator().next();
            }
        }
        throw new RuntimeException("Ambiguity: there are " + assocs.size() + " related associations (assocId=" + assocId + ", assocTypeUri=\"" + assocTypeUri + "\", myRoleTypeUri=\"" + myRoleTypeUri + "\", othersRoleTypeUri=\"" + othersRoleTypeUri + "\", othersAssocTypeUri=\"" + othersAssocTypeUri + "\"),\nresult=" + assocs);
    }

    final List<RelatedAssocModelImpl> fetchAssocRelatedAssocs(long assocId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        return this.storage.fetchAssocRelatedAssocs(assocId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
    }

    final List<AssocModelImpl> fetchAssocAssocs(long assocId) {
        return this.storage.fetchAssocAssocs(assocId);
    }

    final RelatedTopicModelImpl fetchRelatedTopic(long objectId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        List<RelatedTopicModelImpl> topics = this.fetchRelatedTopics(objectId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
        switch (topics.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return topics.iterator().next();
            }
        }
        throw new RuntimeException("Ambiguity: there are " + topics.size() + " related topics (objectId=" + objectId + ", assocTypeUri=\"" + assocTypeUri + "\", myRoleTypeUri=\"" + myRoleTypeUri + "\", othersRoleTypeUri=\"" + othersRoleTypeUri + "\", othersTopicTypeUri=\"" + othersTopicTypeUri + "\")");
    }

    final List<RelatedTopicModelImpl> fetchRelatedTopics(long objectId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.storage.fetchRelatedTopics(objectId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
    }

    final Object fetchProperty(long id, String propUri) {
        return this.storage.fetchProperty(id, propUri);
    }

    final boolean hasProperty(long id, String propUri) {
        return this.storage.hasProperty(id, propUri);
    }

    final List<TopicModelImpl> fetchTopicsByProperty(String propUri, Object propValue) {
        return this.storage.fetchTopicsByProperty(propUri, propValue);
    }

    final List<TopicModelImpl> fetchTopicsByPropertyRange(String propUri, Number from, Number to) {
        return this.storage.fetchTopicsByPropertyRange(propUri, from, to);
    }

    final List<AssocModelImpl> fetchAssocsByProperty(String propUri, Object propValue) {
        return this.storage.fetchAssocsByProperty(propUri, propValue);
    }

    final List<AssocModelImpl> fetchAssocsByPropertyRange(String propUri, Number from, Number to) {
        return this.storage.fetchAssocsByPropertyRange(propUri, from, to);
    }

    final void storeTopicProperty(long topicId, String propUri, Object propValue, boolean addToIndex) {
        this.storage.storeTopicProperty(topicId, propUri, propValue, addToIndex);
    }

    final void storeAssocProperty(long assocId, String propUri, Object propValue, boolean addToIndex) {
        this.storage.storeAssocProperty(assocId, propUri, propValue, addToIndex);
    }

    final void indexTopicProperty(long topicId, String propUri, Object propValue) {
        this.storage.indexTopicProperty(topicId, propUri, propValue);
    }

    final void indexAssocProperty(long assocId, String propUri, Object propValue) {
        this.storage.indexAssocProperty(assocId, propUri, propValue);
    }

    final void removeTopicProperty(long topicId, String propUri) {
        this.storage.deleteTopicProperty(topicId, propUri);
    }

    final void removeAssocProperty(long assocId, String propUri) {
        this.storage.deleteAssocProperty(assocId, propUri);
    }

    final DMXTransaction beginTx() {
        return this.storage.beginTx();
    }

    final boolean init() {
        boolean isCleanInstall = this.storage.setupRootNode();
        if (isCleanInstall) {
            this.logger.info("Clean install detected -- Starting with a fresh DB");
            this.storeMigrationNr(0);
        }
        return isCleanInstall;
    }

    final void shutdown() {
        this.storage.shutdown();
    }

    final int fetchMigrationNr() {
        return (Integer)this.fetchProperty(0L, "core_migration_nr");
    }

    final void storeMigrationNr(int migrationNr) {
        this.storage.storeTopicProperty(0L, "core_migration_nr", migrationNr, false);
    }

    final Object getDatabaseVendorObject() {
        return this.storage.getDatabaseVendorObject();
    }

    final Object getDatabaseVendorObject(long objectId) {
        return this.storage.getDatabaseVendorObject(objectId);
    }
}

