/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import systems.dmx.core.impl.WebSocketConnection;

class WebSocketConnectionPool {
    private Map<String, Map<String, WebSocketConnection>> pool = new ConcurrentHashMap<String, Map<String, WebSocketConnection>>();
    private Logger logger = Logger.getLogger(this.getClass().getName());

    WebSocketConnectionPool() {
    }

    Collection<WebSocketConnection> getConnections(String pluginUri) {
        Map<String, WebSocketConnection> connections = this.pool.get(pluginUri);
        return connections != null ? connections.values() : null;
    }

    WebSocketConnection getConnection(String pluginUri, String clientId) {
        Map<String, WebSocketConnection> connections = this.pool.get(pluginUri);
        if (connections == null) {
            this.logger.warning("No WebSocket connection open for plugin \"" + pluginUri + "\"");
            return null;
        }
        WebSocketConnection connection = connections.get(clientId);
        if (connection == null) {
            this.logger.warning("No WebSocket connection open for client \"" + clientId + "\" (plugin \"" + pluginUri + "\")");
        }
        return connection;
    }

    void add(WebSocketConnection connection) {
        String pluginUri = connection.pluginUri;
        Map<String, WebSocketConnection> connections = this.pool.get(pluginUri);
        if (connections == null) {
            connections = new ConcurrentHashMap<String, WebSocketConnection>();
            this.pool.put(pluginUri, connections);
        }
        connections.put(connection.clientId, connection);
    }

    void remove(WebSocketConnection connection) {
        String pluginUri = connection.pluginUri;
        boolean removed = this.getConnections(pluginUri).remove(connection);
        if (!removed) {
            throw new RuntimeException("Removing a connection of plugin \"" + pluginUri + "\" failed");
        }
    }
}

