/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.Map;
import org.codehaus.jettison.json.JSONArray;
import systems.dmx.core.impl.AccessLayer;
import systems.dmx.core.impl.ModelFactoryImpl;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.model.TopicReferenceModel;
import systems.dmx.core.model.ViewConfigurationModel;

class ViewConfigurationModelImpl
implements ViewConfigurationModel {
    private Map<String, TopicModelImpl> configTopics;
    private ModelFactoryImpl mf;

    ViewConfigurationModelImpl(Map<String, TopicModelImpl> configTopics, AccessLayer al) {
        this.configTopics = configTopics;
        this.mf = al.mf;
    }

    public Iterable<TopicModelImpl> getConfigTopics() {
        return this.configTopics.values();
    }

    @Override
    public TopicModelImpl getConfigTopic(String configTypeUri) {
        return this.configTopics.get(configTypeUri);
    }

    @Override
    public ViewConfigurationModel addConfigTopic(TopicModel configTopic) {
        String configTypeUri = configTopic.getTypeUri();
        if (this.getConfigTopic(configTypeUri) != null) {
            throw new RuntimeException("There is already a view configuration topic of type \"" + configTypeUri + "\"");
        }
        this.putConfigTopic(configTopic);
        return this;
    }

    @Override
    public void updateConfigTopic(TopicModel configTopic) {
        String configTypeUri = configTopic.getTypeUri();
        if (this.getConfigTopic(configTypeUri) == null) {
            throw new RuntimeException("There is no view configuration topic of type \"" + configTypeUri + "\"");
        }
        this.putConfigTopic(configTopic);
    }

    @Override
    public ViewConfigurationModel setConfigValue(String configTypeUri, String childTypeUri, Object value) {
        TopicModelImpl configTopic = this.getConfigTopic(configTypeUri);
        if (configTopic == null) {
            this.addConfigTopic(this.mf.newTopicModel(configTypeUri, this.mf.newChildTopicsModel().put(childTypeUri, value)));
        } else {
            configTopic.getChildTopicsModel().put(childTypeUri, value);
        }
        return this;
    }

    @Override
    public ViewConfigurationModel setConfigValueRef(String configTypeUri, String childTypeUri, Object topicIdOrUri) {
        TopicModelImpl configTopic = this.getConfigTopic(configTypeUri);
        TopicReferenceModel valueRef = this.mf.newTopicReferenceModel(topicIdOrUri);
        if (configTopic == null) {
            this.addConfigTopic(this.mf.newTopicModel(configTypeUri, this.mf.newChildTopicsModel().put(childTypeUri, valueRef)));
        } else {
            configTopic.getChildTopicsModel().put(childTypeUri, valueRef);
        }
        return this;
    }

    @Override
    public Object getConfigValue(String configTypeUri, String childTypeUri) {
        TopicModelImpl configTopic = this.getConfigTopic(configTypeUri);
        if (configTopic == null) {
            return null;
        }
        return configTopic.getChildTopicsModel().getObject(childTypeUri, null);
    }

    @Override
    public JSONArray toJSONArray() {
        try {
            JSONArray configTopics = new JSONArray();
            for (TopicModel topicModel : this.getConfigTopics()) {
                configTopics.put((Object)topicModel.toJSON());
            }
            return configTopics;
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed", e);
        }
    }

    public String toString() {
        return "view configuration " + this.configTopics;
    }

    public void putConfigTopic(TopicModel configTopic) {
        this.configTopics.put(configTopic.getTypeUri(), (TopicModelImpl)configTopic);
    }
}

