/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.topicmaps;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import systems.dmx.core.Assoc;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedAssoc;
import systems.dmx.core.RelatedObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.model.AssocModel;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.model.topicmaps.ViewAssoc;
import systems.dmx.core.model.topicmaps.ViewProps;
import systems.dmx.core.model.topicmaps.ViewTopic;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.CoreService;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.util.DMXUtils;
import systems.dmx.core.util.IdList;
import systems.dmx.topicmaps.DefaultTopicmapType;
import systems.dmx.topicmaps.Messenger;
import systems.dmx.topicmaps.MessengerContext;
import systems.dmx.topicmaps.TopicCoords;
import systems.dmx.topicmaps.Topicmap;
import systems.dmx.topicmaps.TopicmapType;
import systems.dmx.topicmaps.TopicmapsConstants;
import systems.dmx.topicmaps.TopicmapsService;
import systems.dmx.topicmaps.ViewmodelCustomizer;

@Path(value="/topicmap")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class TopicmapsPlugin
extends PluginActivator
implements TopicmapsService,
TopicmapsConstants,
MessengerContext {
    private Map<String, TopicmapType> topicmapTypes = new HashMap<String, TopicmapType>();
    private List<ViewmodelCustomizer> viewmodelCustomizers = new ArrayList<ViewmodelCustomizer>();
    private Messenger me = new Messenger(this);
    @Context
    private HttpServletRequest request;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public TopicmapsPlugin() {
        this.registerTopicmapType(new DefaultTopicmapType());
    }

    @Override
    @POST
    @Transactional
    public Topic createTopicmap(@QueryParam(value="name") String name, @QueryParam(value="topicmap_type_uri") String topicmapTypeUri, ViewProps viewProps) {
        try {
            this.logger.info("Creating topicmap \"" + name + "\", topicmapTypeUri=\"" + topicmapTypeUri + "\", viewProps=" + viewProps);
            Topic topicmapTopic = this.dmx.createTopic(this.mf.newTopicModel("dmx.topicmaps.topicmap", this.mf.newChildTopicsModel().set("dmx.topicmaps.topicmap_name", (Object)name).set("dmx.topicmaps.topicmap_type_uri", (Object)topicmapTypeUri)));
            this.getTopicmapType(topicmapTypeUri).initTopicmapState(topicmapTopic, viewProps, this.dmx);
            this.me.newTopicmap(topicmapTopic);
            return topicmapTopic;
        }
        catch (Exception e) {
            throw new RuntimeException("Creating topicmap \"" + name + "\" failed, topicmapTypeUri=\"" + topicmapTypeUri + "\", viewProps=" + viewProps, e);
        }
    }

    @Override
    @GET
    @Path(value="/{id}")
    public Topicmap getTopicmap(@PathParam(value="id") long topicmapId, @QueryParam(value="children") boolean includeChildren) {
        try {
            this.logger.info("Fetching topicmap " + topicmapId + ", includeChildren=" + includeChildren);
            Topic topicmapTopic = this.dmx.getTopic(topicmapId).loadChildTopics();
            return new Topicmap(topicmapTopic.getModel(), this.fetchTopicmapViewProps(topicmapTopic), this.fetchTopics(topicmapTopic, includeChildren), this.fetchAssocs(topicmapTopic));
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching topicmap " + topicmapId + " failed", e);
        }
    }

    @Override
    public Assoc getTopicMapcontext(long topicmapId, long topicId) {
        return this.dmx.getAssoc("dmx.topicmaps.topicmap_context", topicmapId, topicId, "dmx.core.default", "dmx.topicmaps.topicmap_content");
    }

    @Override
    public Assoc getAssocMapcontext(long topicmapId, long assocId) {
        return this.dmx.getAssocBetweenTopicAndAssoc("dmx.topicmaps.topicmap_context", topicmapId, assocId, "dmx.core.default", "dmx.topicmaps.topicmap_content");
    }

    @Override
    @GET
    @Path(value="/object/{id}")
    public List<RelatedTopic> getTopicmapTopics(@PathParam(value="id") long objectId) {
        try {
            ArrayList<RelatedTopic> topicmapTopics = new ArrayList<RelatedTopic>();
            for (RelatedTopic topic : this.dmx.getObject(objectId).getRelatedTopics("dmx.topicmaps.topicmap_context", "dmx.topicmaps.topicmap_content", "dmx.core.default", "dmx.topicmaps.topicmap")) {
                if (!this.visibility(topic.getRelatingAssoc())) continue;
                topicmapTopics.add(topic);
            }
            return topicmapTopics;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching topicmap topics of topic/assoc " + objectId + " failed", e);
        }
    }

    @Override
    public void addTopicToTopicmap(long topicmapId, long topicId, int x, int y, boolean visibility) {
        this.addTopicToTopicmap(topicmapId, topicId, this.mf.newViewProps(x, y, visibility, false));
    }

    @Override
    @POST
    @Path(value="/{id}/topic/{topic_id}")
    @Transactional
    public void addTopicToTopicmap(final @PathParam(value="id") long topicmapId, final @PathParam(value="topic_id") long topicId, final ViewProps viewProps) {
        try {
            this.dmx.getPrivilegedAccess().runWithoutWorkspaceAssignment((Callable)new Callable<Void>(){

                @Override
                public Void call() {
                    if (TopicmapsPlugin.this.getTopicMapcontext(topicmapId, topicId) != null) {
                        throw new RuntimeException("Topic " + topicId + " already added to topicmap" + topicmapId);
                    }
                    TopicmapsPlugin.this.createTopicMapcontext(topicmapId, topicId, viewProps);
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Adding topic " + topicId + " to topicmap " + topicmapId + " failed, viewProps=" + viewProps, e);
        }
    }

    @Override
    @POST
    @Path(value="/{id}/association/{assoc_id}")
    @Transactional
    public void addAssocToTopicmap(final @PathParam(value="id") long topicmapId, final @PathParam(value="assoc_id") long assocId, final ViewProps viewProps) {
        try {
            this.dmx.getPrivilegedAccess().runWithoutWorkspaceAssignment((Callable)new Callable<Void>(){

                @Override
                public Void call() {
                    if (TopicmapsPlugin.this.getAssocMapcontext(topicmapId, assocId) != null) {
                        throw new RuntimeException("Assoc " + assocId + " already added to topicmap " + topicmapId);
                    }
                    TopicmapsPlugin.this.createAssocMapcontext(topicmapId, assocId, viewProps);
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Adding association " + assocId + " to topicmap " + topicmapId + " failed, viewProps=" + viewProps, e);
        }
    }

    @Override
    @POST
    @Path(value="/{id}/topic/{topic_id}/association/{assoc_id}")
    @Transactional
    public void addRelatedTopicToTopicmap(final @PathParam(value="id") long topicmapId, final @PathParam(value="topic_id") long topicId, final @PathParam(value="assoc_id") long assocId, final ViewProps viewProps) {
        try {
            this.dmx.getPrivilegedAccess().runWithoutWorkspaceAssignment((Callable)new Callable<Void>(){

                @Override
                public Void call() {
                    Assoc topicMapcontext = TopicmapsPlugin.this.getTopicMapcontext(topicmapId, topicId);
                    if (topicMapcontext == null) {
                        TopicmapsPlugin.this.createTopicMapcontext(topicmapId, topicId, viewProps);
                    } else if (!TopicmapsPlugin.this.visibility(topicMapcontext)) {
                        TopicmapsPlugin.this._setTopicVisibility(topicmapId, topicId, true, topicMapcontext);
                    }
                    Assoc assocMapcontext = TopicmapsPlugin.this.getAssocMapcontext(topicmapId, assocId);
                    if (assocMapcontext == null) {
                        TopicmapsPlugin.this.createAssocMapcontext(topicmapId, assocId, TopicmapsPlugin.this.mf.newViewProps(true, false));
                    } else if (!TopicmapsPlugin.this.visibility(assocMapcontext)) {
                        TopicmapsPlugin.this._setAssocVisibility(topicmapId, assocId, true, assocMapcontext);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Adding related topic " + topicId + " (assocId=" + assocId + ") to topicmap " + topicmapId + " failed, viewProps=" + viewProps, e);
        }
    }

    @Override
    @PUT
    @Path(value="/{id}/topic/{topic_id}")
    @Transactional
    public void setTopicViewProps(@PathParam(value="id") long topicmapId, @PathParam(value="topic_id") long topicId, ViewProps viewProps) {
        this.storeTopicViewProps(topicmapId, topicId, viewProps);
    }

    @Override
    @PUT
    @Path(value="/{id}/association/{assoc_id}")
    @Transactional
    public void setAssocViewProps(@PathParam(value="id") long topicmapId, @PathParam(value="assoc_id") long assocId, ViewProps viewProps) {
        this.storeAssocViewProps(topicmapId, assocId, viewProps);
    }

    @Override
    @PUT
    @Path(value="/{id}/topic/{topic_id}/{x}/{y}")
    @Transactional
    public void setTopicPosition(@PathParam(value="id") long topicmapId, @PathParam(value="topic_id") long topicId, @PathParam(value="x") int x, @PathParam(value="y") int y) {
        try {
            this.storeTopicViewProps(topicmapId, topicId, this.mf.newViewProps(x, y));
            this.me.setTopicPosition(topicmapId, topicId, x, y);
        }
        catch (Exception e) {
            throw new RuntimeException("Setting position of topic " + topicId + " in topicmap " + topicmapId + " failed", e);
        }
    }

    @Override
    @PUT
    @Path(value="/{id}")
    @Transactional
    public void setTopicPositions(@PathParam(value="id") long topicmapId, TopicCoords coords) {
        for (TopicCoords.Entry entry : coords) {
            this.setTopicPosition(topicmapId, entry.topicId, entry.x, entry.y);
        }
    }

    @Override
    @PUT
    @Path(value="/{id}/topic/{topic_id}/{visibility}")
    @Transactional
    public void setTopicVisibility(@PathParam(value="id") long topicmapId, @PathParam(value="topic_id") long topicId, @PathParam(value="visibility") boolean visibility) {
        try {
            this._setTopicVisibility(topicmapId, topicId, visibility, this.fetchTopicMapcontext(topicmapId, topicId));
        }
        catch (Exception e) {
            throw new RuntimeException("Setting visibility of topic " + topicId + " in topicmap " + topicmapId + " failed", e);
        }
    }

    @Override
    @PUT
    @Path(value="/{id}/assoc/{assoc_id}/visibility/{visibility}")
    @Transactional
    public void setAssocVisibility(@PathParam(value="id") long topicmapId, @PathParam(value="assoc_id") long assocId, @PathParam(value="visibility") boolean visibility) {
        try {
            Assoc assocMapcontext = this.getAssocMapcontext(topicmapId, assocId);
            if (assocMapcontext != null) {
                this._setAssocVisibility(topicmapId, assocId, visibility, assocMapcontext);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Setting visibility of assoc " + assocId + " in topicmap " + topicmapId + " failed", e);
        }
    }

    @Override
    @PUT
    @Path(value="/{id}/topics/{topicIds}/visibility/false")
    @Transactional
    public void hideTopics(@PathParam(value="id") long topicmapId, @PathParam(value="topicIds") IdList topicIds) {
        this.hideMulti(topicmapId, topicIds, new IdList());
    }

    @Override
    @PUT
    @Path(value="/{id}/assocs/{assocIds}/visibility/false")
    @Transactional
    public void hideAssocs(@PathParam(value="id") long topicmapId, @PathParam(value="assocIds") IdList assocIds) {
        this.hideMulti(topicmapId, new IdList(), assocIds);
    }

    @Override
    @PUT
    @Path(value="/{id}/topics/{topicIds}/assocs/{assocIds}/visibility/false")
    @Transactional
    public void hideMulti(@PathParam(value="id") long topicmapId, @PathParam(value="topicIds") IdList topicIds, @PathParam(value="assocIds") IdList assocIds) {
        long id;
        this.logger.info("topicmapId=" + topicmapId + ", topicIds=" + topicIds + ", assocIds=" + assocIds);
        Iterator iterator = topicIds.iterator();
        while (iterator.hasNext()) {
            id = (Long)iterator.next();
            this.setTopicVisibility(topicmapId, id, false);
        }
        iterator = assocIds.iterator();
        while (iterator.hasNext()) {
            id = (Long)iterator.next();
            this.setAssocVisibility(topicmapId, id, false);
        }
    }

    @Override
    @PUT
    @Path(value="/{id}/pan/{x}/{y}/zoom/{zoom}")
    @Transactional
    public void setTopicmapViewport(@PathParam(value="id") long topicmapId, @PathParam(value="x") int panX, @PathParam(value="y") int panY, @PathParam(value="zoom") double zoom) {
        try {
            this.mf.newViewProps().put("dmx.topicmaps.pan_x", (Object)panX).put("dmx.topicmaps.pan_y", (Object)panY).put("dmx.topicmaps.zoom", (Object)zoom).store((DMXObject)this.dmx.getTopic(topicmapId));
        }
        catch (Exception e) {
            throw new RuntimeException("Setting viewport of topicmap " + topicmapId + " failed, panX=" + panX + ", panY=" + panY + ", zoom=" + zoom, e);
        }
    }

    @Override
    public void registerTopicmapType(TopicmapType topicmapType) {
        this.logger.info("### Registering topicmap type \"" + topicmapType.getClass().getName() + "\"");
        this.topicmapTypes.put(topicmapType.getUri(), topicmapType);
    }

    @Override
    public void registerViewmodelCustomizer(ViewmodelCustomizer customizer) {
        this.logger.info("### Registering viewmodel customizer \"" + customizer.getClass().getName() + "\"");
        this.viewmodelCustomizers.add(customizer);
    }

    @Override
    public void unregisterViewmodelCustomizer(ViewmodelCustomizer customizer) {
        this.logger.info("### Unregistering viewmodel customizer \"" + customizer.getClass().getName() + "\"");
        if (!this.viewmodelCustomizers.remove(customizer)) {
            throw new RuntimeException("Unregistering viewmodel customizer failed, customizer=" + customizer);
        }
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"text/html"})
    public InputStream getTopicmapInWebclient() {
        return this.invokeWebclient();
    }

    @GET
    @Path(value="/{id}/topic/{topic_id}")
    @Produces(value={"text/html"})
    public InputStream getTopicmapAndTopicInWebclient() {
        return this.invokeWebclient();
    }

    @Override
    public CoreService getCoreService() {
        return this.dmx;
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.request;
    }

    private Map<Long, ViewTopic> fetchTopics(Topic topicmapTopic, boolean includeChildren) {
        HashMap<Long, ViewTopic> topics = new HashMap<Long, ViewTopic>();
        List relTopics = topicmapTopic.getRelatedTopics("dmx.topicmaps.topicmap_context", "dmx.core.default", "dmx.topicmaps.topicmap_content", null);
        if (includeChildren) {
            DMXUtils.loadChildTopics((List)relTopics);
        }
        for (RelatedTopic topic : relTopics) {
            topics.put(topic.getId(), this.buildViewTopic(topic));
        }
        return topics;
    }

    private Map<Long, ViewAssoc> fetchAssocs(Topic topicmapTopic) {
        HashMap<Long, ViewAssoc> assocs = new HashMap<Long, ViewAssoc>();
        List relAssocs = topicmapTopic.getRelatedAssocs("dmx.topicmaps.topicmap_context", "dmx.core.default", "dmx.topicmaps.topicmap_content", null);
        for (RelatedAssoc assoc : relAssocs) {
            assocs.put(assoc.getId(), this.buildViewAssoc(assoc));
        }
        return assocs;
    }

    private ViewTopic buildViewTopic(RelatedTopic topic) {
        try {
            ViewProps viewProps = this.fetchTopicViewProps(topic.getRelatingAssoc());
            this.invokeViewmodelCustomizers(topic, viewProps);
            return this.mf.newViewTopic((TopicModel)topic.getModel(), viewProps);
        }
        catch (Exception e) {
            throw new RuntimeException("Building ViewTopic " + topic.getId() + " failed", e);
        }
    }

    private ViewAssoc buildViewAssoc(RelatedAssoc assoc) {
        try {
            ViewProps viewProps = this.fetchAssocViewProps(assoc.getRelatingAssoc());
            return this.mf.newViewAssoc((AssocModel)assoc.getModel(), viewProps);
        }
        catch (Exception e) {
            throw new RuntimeException("Building ViewAssoc " + assoc.getId() + " failed", e);
        }
    }

    private ViewProps fetchTopicmapViewProps(Topic topicmapTopic) {
        return this.mf.newViewProps().put("dmx.topicmaps.pan_x", topicmapTopic.getProperty("dmx.topicmaps.pan_x")).put("dmx.topicmaps.pan_y", topicmapTopic.getProperty("dmx.topicmaps.pan_y")).put("dmx.topicmaps.zoom", topicmapTopic.getProperty("dmx.topicmaps.zoom"));
    }

    private ViewProps fetchTopicViewProps(Assoc topicmapContext) {
        return this.mf.newViewProps(((Integer)topicmapContext.getProperty("dmx.topicmaps.x")).intValue(), ((Integer)topicmapContext.getProperty("dmx.topicmaps.y")).intValue(), this.visibility(topicmapContext), this.pinned(topicmapContext));
    }

    private ViewProps fetchAssocViewProps(Assoc topicmapContext) {
        return this.mf.newViewProps(this.visibility(topicmapContext), this.pinned(topicmapContext));
    }

    private boolean visibility(Assoc topicmapContext) {
        return (Boolean)topicmapContext.getProperty("dmx.topicmaps.visibility");
    }

    private boolean pinned(Assoc topicmapContext) {
        return (Boolean)topicmapContext.getProperty("dmx.topicmaps.pinned");
    }

    private void _setTopicVisibility(long topicmapId, long topicId, boolean visibility, Assoc topicmapContext) {
        Topic topic = this.dmx.getTopic(topicId);
        ViewProps viewProps = this.mf.newViewProps(visibility);
        if (visibility) {
            this.autoRevealAssocs((DMXObject)topic, topicmapId);
        } else {
            this.autoHideAssocs((DMXObject)topic, topicmapId);
            viewProps.put("dmx.topicmaps.pinned", (Object)false);
        }
        viewProps.store((DMXObject)topicmapContext);
        this.me.setTopicVisibility(topicmapId, topicId, visibility);
    }

    private void _setAssocVisibility(long topicmapId, long assocId, boolean visibility, Assoc topicmapContext) {
        Assoc assoc = this.dmx.getAssoc(assocId);
        if (visibility) {
            this.autoRevealAssocs((DMXObject)assoc, topicmapId);
            this.mf.newViewProps(visibility).store((DMXObject)topicmapContext);
        } else {
            this.deleteAllAssocMapcontexts(assoc, topicmapId);
            this.deleteAssocMapcontext(topicmapContext);
        }
        this.me.setAssocVisibility(topicmapId, assocId, visibility);
    }

    private void autoRevealAssocs(DMXObject object, long topicmapId) {
        for (RelatedTopic topic : object.getRelatedTopics()) {
            this._autoRevealAssocs((RelatedObject)topic, this.getTopicMapcontext(topicmapId, topic.getId()), topicmapId);
        }
        for (RelatedAssoc assoc : object.getRelatedAssocs()) {
            this._autoRevealAssocs((RelatedObject)assoc, this.getAssocMapcontext(topicmapId, assoc.getId()), topicmapId);
        }
    }

    private void _autoRevealAssocs(RelatedObject object, Assoc topicmapContext, long topicmapId) {
        Assoc assoc;
        Assoc assocMapcontext;
        if (topicmapContext != null && this.visibility(topicmapContext) && (assocMapcontext = this.getAssocMapcontext(topicmapId, (assoc = object.getRelatingAssoc()).getId())) != null && !this.visibility(assocMapcontext)) {
            this.mf.newViewProps(true).store((DMXObject)assocMapcontext);
            this.autoRevealAssocs((DMXObject)assoc, topicmapId);
        }
    }

    private void autoHideAssocs(DMXObject object, long topicmapId) {
        for (Assoc assoc : object.getAssocs()) {
            Assoc topicmapContext = this.getAssocMapcontext(topicmapId, assoc.getId());
            if (topicmapContext == null) continue;
            this.mf.newViewProps(false, false).store((DMXObject)topicmapContext);
            this.autoHideAssocs((DMXObject)assoc, topicmapId);
        }
    }

    private void deleteAllAssocMapcontexts(Assoc object, long topicmapId) {
        for (Assoc assoc : object.getAssocs()) {
            Assoc assocMapcontext = this.getAssocMapcontext(topicmapId, assoc.getId());
            if (assocMapcontext == null) continue;
            this.deleteAssocMapcontext(assocMapcontext);
            this.deleteAllAssocMapcontexts(assoc, topicmapId);
        }
    }

    private void deleteAssocMapcontext(Assoc assocMapcontext) {
        this.dmx.getPrivilegedAccess().deleteAssocMapcontext(assocMapcontext);
    }

    private void storeTopicViewProps(long topicmapId, long topicId, ViewProps viewProps) {
        try {
            viewProps.store((DMXObject)this.fetchTopicMapcontext(topicmapId, topicId));
        }
        catch (Exception e) {
            throw new RuntimeException("Storing view props of topic " + topicId + " failed, viewProps=" + viewProps, e);
        }
    }

    private void storeAssocViewProps(long topicmapId, long assocId, ViewProps viewProps) {
        try {
            viewProps.store((DMXObject)this.fetchAssocMapcontext(topicmapId, assocId));
        }
        catch (Exception e) {
            throw new RuntimeException("Storing view props of assoc " + assocId + " failed, viewProps=" + viewProps, e);
        }
    }

    private Assoc fetchTopicMapcontext(long topicmapId, long topicId) {
        Assoc topicmapContext = this.getTopicMapcontext(topicmapId, topicId);
        if (topicmapContext == null) {
            throw new RuntimeException("Topic " + topicId + " not contained in topicmap " + topicmapId);
        }
        return topicmapContext;
    }

    private Assoc fetchAssocMapcontext(long topicmapId, long assocId) {
        Assoc topicmapContext = this.getAssocMapcontext(topicmapId, assocId);
        if (topicmapContext == null) {
            throw new RuntimeException("Assoc " + assocId + " not contained in topicmap " + topicmapId);
        }
        return topicmapContext;
    }

    private void createTopicMapcontext(long topicmapId, long topicId, ViewProps viewProps) {
        Assoc topicMapcontext = this.dmx.createAssoc(this.mf.newAssocModel("dmx.topicmaps.topicmap_context", (PlayerModel)this.mf.newTopicPlayerModel(topicmapId, "dmx.core.default"), (PlayerModel)this.mf.newTopicPlayerModel(topicId, "dmx.topicmaps.topicmap_content")));
        viewProps.store((DMXObject)topicMapcontext);
        ViewTopic topic = this.mf.newViewTopic(this.dmx.getTopic(topicId).getModel(), viewProps);
        this.me.addTopicToTopicmap(topicmapId, topic);
    }

    private void createAssocMapcontext(long topicmapId, long assocId, ViewProps viewProps) {
        Assoc assocMapcontext = this.dmx.createAssoc(this.mf.newAssocModel("dmx.topicmaps.topicmap_context", (PlayerModel)this.mf.newTopicPlayerModel(topicmapId, "dmx.core.default"), (PlayerModel)this.mf.newAssocPlayerModel(assocId, "dmx.topicmaps.topicmap_content")));
        viewProps.store((DMXObject)assocMapcontext);
        ViewAssoc assoc = this.mf.newViewAssoc(this.dmx.getAssoc(assocId).getModel(), viewProps);
        this.me.addAssocToTopicmap(topicmapId, assoc);
    }

    private void invokeViewmodelCustomizers(RelatedTopic topic, ViewProps viewProps) {
        for (ViewmodelCustomizer customizer : this.viewmodelCustomizers) {
            this.invokeViewmodelCustomizer(customizer, topic, viewProps);
        }
    }

    private void invokeViewmodelCustomizer(ViewmodelCustomizer customizer, RelatedTopic topic, ViewProps viewProps) {
        try {
            customizer.enrichViewProps(topic, viewProps);
        }
        catch (Exception e) {
            throw new RuntimeException("Invoking viewmodel customizer for topic " + topic.getId() + " failed, customizer=\"" + customizer.getClass().getName() + "\"", e);
        }
    }

    private TopicmapType getTopicmapType(String topicmapTypeUri) {
        TopicmapType topicmapType = this.topicmapTypes.get(topicmapTypeUri);
        if (topicmapType == null) {
            throw new RuntimeException("Topicmap type \"" + topicmapTypeUri + "\" is unknown");
        }
        return topicmapType;
    }

    private InputStream invokeWebclient() {
        return this.dmx.getPlugin("systems.dmx.webclient").getStaticResource("/web/index.html");
    }
}

