/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import systems.dmx.core.ChildTopics;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.impl.AccessLayer;
import systems.dmx.core.impl.ChildTopicsModelImpl;
import systems.dmx.core.impl.DMXObjectModelImpl;
import systems.dmx.core.impl.RelatedTopicImpl;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.RelatedTopicModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.service.ModelFactory;

class ChildTopicsImpl
implements ChildTopics {
    private ChildTopicsModelImpl model;
    private DMXObjectModelImpl parent;
    private AccessLayer al;
    private ModelFactory mf;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    ChildTopicsImpl(ChildTopicsModelImpl model, DMXObjectModelImpl parent, AccessLayer al) {
        this.model = model;
        this.parent = parent;
        this.al = al;
        this.mf = al.mf;
    }

    @Override
    public RelatedTopic getTopic(String compDefUri) {
        this.loadChildTopics(compDefUri);
        return this._getTopic(compDefUri);
    }

    @Override
    public RelatedTopic getTopicOrNull(String compDefUri) {
        this.loadChildTopics(compDefUri);
        return this._getTopicOrNull(compDefUri);
    }

    @Override
    public List<RelatedTopic> getTopics(String compDefUri) {
        this.loadChildTopics(compDefUri);
        return this._getTopics(compDefUri);
    }

    @Override
    public List<RelatedTopic> getTopicsOrNull(String compDefUri) {
        this.loadChildTopics(compDefUri);
        return this._getTopicsOrNull(compDefUri);
    }

    @Override
    public Object get(String compDefUri) {
        Object value = this.model.get(compDefUri);
        if (value == null) {
            return null;
        }
        if (value instanceof RelatedTopicModel) {
            return this.instantiate((RelatedTopicModel)value);
        }
        if (value instanceof List) {
            return this.instantiate((List)value);
        }
        throw new RuntimeException("Unexpected value in a ChildTopicsModel: " + value);
    }

    @Override
    public ChildTopicsModel getModel() {
        return this.model;
    }

    @Override
    public String getString(String compDefUri) {
        this.loadChildTopics(compDefUri);
        return this.model.getString(compDefUri);
    }

    @Override
    public String getString(String compDefUri, String defaultValue) {
        this.loadChildTopics(compDefUri);
        return this.model.getString(compDefUri, defaultValue);
    }

    @Override
    public int getInt(String compDefUri) {
        this.loadChildTopics(compDefUri);
        return this.model.getInt(compDefUri);
    }

    @Override
    public int getInt(String compDefUri, int defaultValue) {
        this.loadChildTopics(compDefUri);
        return this.model.getInt(compDefUri, defaultValue);
    }

    @Override
    public long getLong(String compDefUri) {
        this.loadChildTopics(compDefUri);
        return this.model.getLong(compDefUri);
    }

    @Override
    public long getLong(String compDefUri, long defaultValue) {
        this.loadChildTopics(compDefUri);
        return this.model.getLong(compDefUri, defaultValue);
    }

    @Override
    public double getDouble(String compDefUri) {
        this.loadChildTopics(compDefUri);
        return this.model.getDouble(compDefUri);
    }

    @Override
    public double getDouble(String compDefUri, double defaultValue) {
        this.loadChildTopics(compDefUri);
        return this.model.getDouble(compDefUri, defaultValue);
    }

    @Override
    public boolean getBoolean(String compDefUri) {
        this.loadChildTopics(compDefUri);
        return this.model.getBoolean(compDefUri);
    }

    @Override
    public boolean getBoolean(String compDefUri, boolean defaultValue) {
        this.loadChildTopics(compDefUri);
        return this.model.getBoolean(compDefUri, defaultValue);
    }

    @Override
    public Object getValue(String compDefUri) {
        this.loadChildTopics(compDefUri);
        return this.model.getValue(compDefUri);
    }

    @Override
    public Object getValue(String compDefUri, Object defaultValue) {
        this.loadChildTopics(compDefUri);
        return this.model.getValue(compDefUri, defaultValue);
    }

    @Override
    public ChildTopics getChildTopics(String compDefUri) {
        this.loadChildTopics(compDefUri);
        RelatedTopicModelImpl topic = this.model.getTopic(compDefUri);
        return new ChildTopicsImpl(topic.childTopics, topic, this.al);
    }

    @Override
    public ChildTopics set(String compDefUri, TopicModel value) {
        return this._updateOne(compDefUri, this.mf.newRelatedTopicModel(value));
    }

    @Override
    public ChildTopics set(String compDefUri, Object value) {
        return this._updateOne(compDefUri, this.mf.newRelatedTopicModel(this.mf.childTypeUri(compDefUri), new SimpleValue(value)));
    }

    @Override
    public ChildTopics set(String compDefUri, ChildTopicsModel value) {
        return this._updateOne(compDefUri, this.mf.newRelatedTopicModel(this.mf.childTypeUri(compDefUri), value));
    }

    @Override
    public ChildTopics setRef(String compDefUri, long refTopicId) {
        return this._updateOne(compDefUri, this.mf.newTopicReferenceModel(refTopicId));
    }

    @Override
    public ChildTopics setRef(String compDefUri, long refTopicId, ChildTopicsModel relatingAssocChildTopics) {
        return this._updateOne(compDefUri, this.mf.newTopicReferenceModel(refTopicId, relatingAssocChildTopics));
    }

    @Override
    public ChildTopics setRef(String compDefUri, String refTopicUri) {
        return this._updateOne(compDefUri, this.mf.newTopicReferenceModel(refTopicUri));
    }

    @Override
    public ChildTopics setRef(String compDefUri, String refTopicUri, ChildTopicsModel relatingAssocChildTopics) {
        return this._updateOne(compDefUri, this.mf.newTopicReferenceModel(refTopicUri, relatingAssocChildTopics));
    }

    @Override
    public ChildTopics setDeletionRef(String compDefUri, long refTopicId) {
        return this._updateOne(compDefUri, this.mf.newTopicDeletionModel(refTopicId));
    }

    @Override
    public ChildTopics setDeletionRef(String compDefUri, String refTopicUri) {
        return this._updateOne(compDefUri, this.mf.newTopicDeletionModel(refTopicUri));
    }

    @Override
    public ChildTopics add(String compDefUri, TopicModel value) {
        return this._updateMany(compDefUri, this.mf.newRelatedTopicModel(value));
    }

    @Override
    public ChildTopics add(String compDefUri, Object value) {
        return this._updateMany(compDefUri, this.mf.newRelatedTopicModel(this.mf.childTypeUri(compDefUri), new SimpleValue(value)));
    }

    @Override
    public ChildTopics add(String compDefUri, ChildTopicsModel value) {
        return this._updateMany(compDefUri, this.mf.newRelatedTopicModel(this.mf.childTypeUri(compDefUri), value));
    }

    @Override
    public ChildTopics addRef(String compDefUri, long refTopicId) {
        return this._updateMany(compDefUri, this.mf.newTopicReferenceModel(refTopicId));
    }

    @Override
    public ChildTopics addRef(String compDefUri, long refTopicId, ChildTopicsModel relatingAssocChildTopics) {
        return this._updateMany(compDefUri, this.mf.newTopicReferenceModel(refTopicId, relatingAssocChildTopics));
    }

    @Override
    public ChildTopics addRef(String compDefUri, String refTopicUri) {
        return this._updateMany(compDefUri, this.mf.newTopicReferenceModel(refTopicUri));
    }

    @Override
    public ChildTopics addRef(String compDefUri, String refTopicUri, ChildTopicsModel relatingAssocChildTopics) {
        return this._updateMany(compDefUri, this.mf.newTopicReferenceModel(refTopicUri, relatingAssocChildTopics));
    }

    @Override
    public ChildTopics addDeletionRef(String compDefUri, long refTopicId) {
        return this._updateMany(compDefUri, this.mf.newTopicDeletionModel(refTopicId));
    }

    @Override
    public ChildTopics addDeletionRef(String compDefUri, String refTopicUri) {
        return this._updateMany(compDefUri, this.mf.newTopicDeletionModel(refTopicUri));
    }

    @Override
    public Iterator<String> iterator() {
        return this.model.iterator();
    }

    boolean has(String compDefUri) {
        return this.model.has(compDefUri);
    }

    int size() {
        return this.model.size();
    }

    private ChildTopics _updateOne(String compDefUri, RelatedTopicModel newChildTopic) {
        this.parent.updateChildTopics(this.mf.newChildTopicsModel().set(compDefUri, newChildTopic));
        return this;
    }

    private ChildTopics _updateMany(String compDefUri, RelatedTopicModel newChildTopic) {
        this.parent.updateChildTopics(this.mf.newChildTopicsModel().add(compDefUri, newChildTopic));
        return this;
    }

    private void loadChildTopics(String compDefUri) {
        this.parent.loadChildTopics(compDefUri, false);
    }

    private RelatedTopic _getTopic(String compDefUri) {
        return this.instantiate(this.model.getTopic(compDefUri));
    }

    private RelatedTopic _getTopicOrNull(String compDefUri) {
        RelatedTopicModelImpl topic = this.model.getTopicOrNull(compDefUri);
        return topic != null ? this.instantiate(topic) : null;
    }

    private List<RelatedTopic> _getTopics(String compDefUri) {
        return this.instantiate(this.model.getTopics(compDefUri));
    }

    private List<RelatedTopic> _getTopicsOrNull(String compDefUri) {
        List<RelatedTopicModelImpl> topics = this.model.getTopicsOrNull(compDefUri);
        return topics != null ? this.instantiate(topics) : null;
    }

    private List<RelatedTopic> instantiate(List<? extends RelatedTopicModel> models) {
        ArrayList<RelatedTopic> topics = new ArrayList<RelatedTopic>();
        for (RelatedTopicModel relatedTopicModel : models) {
            topics.add(this.instantiate(relatedTopicModel));
        }
        return topics;
    }

    private RelatedTopic instantiate(RelatedTopicModel model) {
        try {
            return new RelatedTopicImpl((RelatedTopicModelImpl)model, this.al);
        }
        catch (Exception e) {
            throw new RuntimeException("Instantiating a RelatedTopic failed (" + model + ")", e);
        }
    }
}

