/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.List;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.CompDef;
import systems.dmx.core.DMXObject;
import systems.dmx.core.DMXType;
import systems.dmx.core.RelatedAssoc;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.impl.AccessLayer;
import systems.dmx.core.impl.ChildTopicsImpl;
import systems.dmx.core.impl.DMXObjectModelImpl;
import systems.dmx.core.impl.ModelFactoryImpl;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.SimpleValue;

abstract class DMXObjectImpl
implements DMXObject {
    DMXObjectModelImpl model;
    AccessLayer al;
    ModelFactoryImpl mf;

    DMXObjectImpl(DMXObjectModelImpl model, AccessLayer al) {
        this.model = model;
        this.al = al;
        this.mf = al.mf;
    }

    @Override
    public final long getId() {
        return this.model.getId();
    }

    @Override
    public final String getUri() {
        return this.model.getUri();
    }

    @Override
    public final void setUri(String uri) {
        this.model.updateUri(uri);
    }

    @Override
    public final String getTypeUri() {
        return this.model.getTypeUri();
    }

    @Override
    public final void setTypeUri(String typeUri) {
        this.model.updateTypeUri(typeUri);
    }

    @Override
    public final SimpleValue getSimpleValue() {
        return this.model.getSimpleValue();
    }

    @Override
    public final void setSimpleValue(String value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    @Override
    public final void setSimpleValue(int value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    @Override
    public final void setSimpleValue(long value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    @Override
    public final void setSimpleValue(boolean value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    @Override
    public final void setSimpleValue(SimpleValue value) {
        this.model.updateSimpleValue(value);
    }

    @Override
    public final ChildTopicsImpl getChildTopics() {
        return new ChildTopicsImpl(this.model.childTopics, this.model, this.al);
    }

    @Override
    public final void setChildTopics(ChildTopicsModel childTopics) {
        this.model.updateChildTopics(childTopics);
    }

    @Override
    public <O extends DMXObject> O loadChildTopics() {
        this.model.loadChildTopics(true);
        return (O)this;
    }

    @Override
    public <O extends DMXObject> O loadChildTopics(String compDefUri) {
        this.model.loadChildTopics(compDefUri, true);
        return (O)this;
    }

    @Override
    public final DMXType getType() {
        return this.model.getType().instantiate();
    }

    @Override
    public DMXObjectModelImpl getModel() {
        return this.model;
    }

    @Override
    public final void updateChildTopics(ChildTopicsModel updateModel, CompDef compDef) {
        this.model.updateChildTopics(updateModel, compDef.getModel());
    }

    @Override
    public final RelatedTopic getRelatedTopic(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        RelatedTopicModelImpl topic = this.model.getRelatedTopic(assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
        return topic != null ? (RelatedTopic)((DMXObjectModelImpl)topic.checkReadAccess()).instantiate() : null;
    }

    @Override
    public final List<RelatedTopic> getRelatedTopics() {
        return this.getRelatedTopics(null, null, null, null);
    }

    @Override
    public final List<RelatedTopic> getRelatedTopics(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        List<RelatedTopicModelImpl> topics = this.model.getRelatedTopics(assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
        return this.al.instantiate(this.al.filterReadables(topics));
    }

    @Override
    public final List<RelatedAssoc> getRelatedAssocs() {
        return this.getRelatedAssocs(null, null, null, null);
    }

    @Override
    public final Object getProperty(String propUri) {
        return this.al.db.fetchProperty(this.getId(), propUri);
    }

    @Override
    public final boolean hasProperty(String propUri) {
        return this.al.db.hasProperty(this.getId(), propUri);
    }

    @Override
    public final void setProperty(String propUri, Object propValue, boolean addToIndex) {
        this.model.storeProperty(propUri, propValue, addToIndex);
    }

    @Override
    public final void removeProperty(String propUri) {
        this.model.removeProperty(propUri);
    }

    @Override
    public void checkWriteAccess() {
        this.model.checkWriteAccess();
    }

    @Override
    public final Object getDatabaseVendorObject() {
        return this.al.db.getDatabaseVendorObject(this.getId());
    }

    @Override
    public final JSONObject toJSON() {
        return this.model.toJSON();
    }

    public final boolean equals(Object o) {
        return ((DMXObjectImpl)o).model.equals(this.model);
    }

    public final int hashCode() {
        return this.model.hashCode();
    }

    public final String toString() {
        return this.model.toString();
    }

    final String className() {
        return this.model.className();
    }
}

