/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.storage.neo4j;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.lucene.QueryContext;
import org.neo4j.index.lucene.ValueContext;
import systems.dmx.core.impl.AssocModelImpl;
import systems.dmx.core.impl.DMXObjectModelImpl;
import systems.dmx.core.impl.ModelFactoryImpl;
import systems.dmx.core.impl.PlayerModelImpl;
import systems.dmx.core.impl.RelatedAssocModelImpl;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.model.AssocModel;
import systems.dmx.core.model.AssocPlayerModel;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.model.TopicPlayerModel;
import systems.dmx.core.service.ModelFactory;
import systems.dmx.core.storage.spi.DMXStorage;
import systems.dmx.core.storage.spi.DMXTransaction;
import systems.dmx.core.util.JavaUtils;
import systems.dmx.storage.neo4j.AssocModelIterable;
import systems.dmx.storage.neo4j.Neo4jTransactionAdapter;
import systems.dmx.storage.neo4j.NodeType;
import systems.dmx.storage.neo4j.RelationtypeCache;
import systems.dmx.storage.neo4j.TopicModelIterable;

public class Neo4jStorage
implements DMXStorage {
    private static final String KEY_NODE_TYPE = "nodeType";
    private static final String KEY_VALUE = "value";
    private static final String KEY_URI = "uri";
    private static final String KEY_TPYE_URI = "typeUri";
    private static final String KEY_FULLTEXT = "fulltext";
    private static final String KEY_ASSOC_ID = "assocId";
    private static final String KEY_ASSOC_TPYE_URI = "assocTypeUri";
    private static final String KEY_ROLE_TPYE_URI = "roleTypeUri";
    private static final String KEY_PLAYER_TPYE = "playerType";
    private static final String KEY_PLAYER_ID = "playerId";
    private static final String KEY_PLAYER_TYPE_URI = "playerTypeUri";
    GraphDatabaseService neo4j = null;
    private RelationtypeCache relTypeCache;
    private Index<Node> topicContentExact;
    private Index<Node> topicContentFulltext;
    private Index<Node> assocContentExact;
    private Index<Node> assocContentFulltext;
    private Index<Node> assocMetadata;
    private ModelFactoryImpl mf;
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    Neo4jStorage(String databasePath, ModelFactoryImpl mf) {
        try {
            this.neo4j = new GraphDatabaseFactory().newEmbeddedDatabase(databasePath);
            this.relTypeCache = new RelationtypeCache(this.neo4j);
            this.topicContentExact = this.createExactIndex("topic-content-exact");
            this.topicContentFulltext = this.createFulltextIndex("topic-content-fulltext");
            this.assocContentExact = this.createExactIndex("assoc-content-exact");
            this.assocContentFulltext = this.createFulltextIndex("assoc-content-fulltext");
            this.assocMetadata = this.createExactIndex("assoc-metadata");
            this.mf = mf;
        }
        catch (Exception e) {
            if (this.neo4j != null) {
                this.shutdown();
            }
            throw new RuntimeException("Creating the Neo4j instance and indexes failed", e);
        }
    }

    public TopicModelImpl fetchTopic(long topicId) {
        return this.buildTopic(this.fetchTopicNode(topicId));
    }

    public TopicModelImpl fetchTopic(String key, Object value) {
        try {
            Node node = (Node)this.topicContentExact.get(key, value).getSingle();
            return node != null ? this.buildTopic(node) : null;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching topic failed, key=\"" + key + "\", value=" + value, e);
        }
    }

    public List<TopicModelImpl> fetchTopics(String key, Object value) {
        return this.buildTopics((Iterable<Node>)this.topicContentExact.get(key, value));
    }

    public List<TopicModelImpl> queryTopics(String key, Object value) {
        return this.buildTopics((Iterable<Node>)this.topicContentExact.query(key, value));
    }

    public List<TopicModelImpl> queryTopicsFulltext(String key, Object value) {
        if (key == null) {
            key = KEY_FULLTEXT;
        }
        if (value == null) {
            throw new IllegalArgumentException("Tried to call queryTopicsFulltext() with a null value Object (key=\"" + key + "\")");
        }
        return this.buildTopics((Iterable<Node>)this.topicContentFulltext.query(key, value));
    }

    public Iterable<TopicModelImpl> fetchAllTopics() {
        return new TopicModelIterable(this);
    }

    public void storeTopic(TopicModelImpl topicModel) {
        this.setDefaults((DMXObjectModelImpl)topicModel);
        Node topicNode = this.neo4j.createNode();
        topicNode.setProperty(KEY_NODE_TYPE, (Object)"topic");
        this.storeAndIndexTopicUri(topicNode, topicModel.getUri());
        this.storeAndIndexTopicTypeUri(topicNode, topicModel.getTypeUri());
        topicModel.setId(topicNode.getId());
    }

    public void storeTopicUri(long topicId, String uri) {
        this.storeAndIndexTopicUri(this.fetchTopicNode(topicId), uri);
    }

    public void storeTopicTypeUri(long topicId, String topicTypeUri) {
        Node topicNode = this.fetchTopicNode(topicId);
        this.storeAndIndexTopicTypeUri(topicNode, topicTypeUri);
        this.reindexTypeUri(topicNode, topicTypeUri);
    }

    public void storeTopicValue(long topicId, SimpleValue value, String indexKey, boolean isHtmlValue) {
        if (indexKey == null) {
            throw new IllegalArgumentException("indexKey must be not null (value=\"" + value + "\")");
        }
        Node topicNode = this.fetchTopicNode(topicId);
        topicNode.setProperty(KEY_VALUE, value.value());
        this.indexTopicNodeValue(topicNode, indexKey, value.value(), isHtmlValue);
    }

    public void deleteTopic(long topicId) {
        Node topicNode = this.fetchTopicNode(topicId);
        topicNode.delete();
        this.removeTopicFromIndex(topicNode);
    }

    public AssocModelImpl fetchAssoc(long assocId) {
        return this.buildAssoc(this.fetchAssocNode(assocId));
    }

    public AssocModelImpl fetchAssoc(String key, Object value) {
        Node node = (Node)this.assocContentExact.get(key, value).getSingle();
        return node != null ? this.buildAssoc(node) : null;
    }

    public List<AssocModelImpl> queryAssocs(String key, Object value) {
        return this.buildAssocs((Iterable<Node>)this.assocContentExact.query(key, value));
    }

    public List<AssocModelImpl> fetchAssocs(String assocTypeUri, long topicId1, long topicId2, String roleTypeUri1, String roleTypeUri2) {
        return this.queryAssocIndex(assocTypeUri, roleTypeUri1, NodeType.TOPIC, topicId1, null, roleTypeUri2, NodeType.TOPIC, topicId2, null);
    }

    public List<AssocModelImpl> fetchAssocsBetweenTopicAndAssoc(String assocTypeUri, long topicId, long assocId, String topicRoleTypeUri, String assocRoleTypeUri) {
        return this.queryAssocIndex(assocTypeUri, topicRoleTypeUri, NodeType.TOPIC, topicId, null, assocRoleTypeUri, NodeType.ASSOC, assocId, null);
    }

    public Iterable<AssocModelImpl> fetchAllAssocs() {
        return new AssocModelIterable(this);
    }

    public List<PlayerModel> fetchPlayerModels(long assocId) {
        return this.buildPlayerModels(this.fetchAssocNode(assocId));
    }

    public void storeAssoc(AssocModelImpl assocModel) {
        this.setDefaults((DMXObjectModelImpl)assocModel);
        Node assocNode = this.neo4j.createNode();
        assocNode.setProperty(KEY_NODE_TYPE, (Object)"assoc");
        this.storeAndIndexAssocUri(assocNode, assocModel.getUri());
        this.storeAndIndexAssocTypeUri(assocNode, assocModel.getTypeUri());
        PlayerModelImpl player1 = assocModel.getPlayer1();
        PlayerModelImpl player2 = assocModel.getPlayer2();
        Node playerNode1 = this.storePlayerRelationship(assocNode, (PlayerModel)player1);
        Node playerNode2 = this.storePlayerRelationship(assocNode, (PlayerModel)player2);
        this.indexAssoc(assocNode, player1.getRoleTypeUri(), playerNode1, player2.getRoleTypeUri(), playerNode2);
        assocModel.setId(assocNode.getId());
    }

    public void storeAssocUri(long assocId, String uri) {
        this.storeAndIndexAssocUri(this.fetchAssocNode(assocId), uri);
    }

    public void storeAssocTypeUri(long assocId, String assocTypeUri) {
        Node assocNode = this.fetchAssocNode(assocId);
        this.storeAndIndexAssocTypeUri(assocNode, assocTypeUri);
        this.indexAssocType(assocNode, assocTypeUri);
        this.reindexTypeUri(assocNode, assocTypeUri);
    }

    public void storeAssocValue(long assocId, SimpleValue value, String indexKey, boolean isHtmlValue) {
        if (indexKey == null) {
            throw new IllegalArgumentException("indexKey must be not null (value=\"" + value + "\")");
        }
        Node assocNode = this.fetchAssocNode(assocId);
        assocNode.setProperty(KEY_VALUE, value.value());
        this.indexAssocNodeValue(assocNode, indexKey, value.value(), isHtmlValue);
    }

    public void storeRoleTypeUri(long assocId, long playerId, String roleTypeUri) {
        Node assocNode = this.fetchAssocNode(assocId);
        this.fetchRelationship(assocNode, playerId).delete();
        assocNode.createRelationshipTo(this.fetchNode(playerId), this.getRelationshipType(roleTypeUri));
        this.indexAssocRoleType(assocNode, playerId, roleTypeUri);
    }

    public void deleteAssoc(long assocId) {
        Node assocNode = this.fetchAssocNode(assocId);
        for (Relationship rel : this.fetchRelationships(assocNode)) {
            rel.delete();
        }
        assocNode.delete();
        this.removeAssocFromIndex(assocNode);
    }

    public DMXObjectModelImpl fetchObject(long id) {
        Node node = this.fetchNode(id);
        NodeType nodeType = NodeType.of(node);
        switch (nodeType) {
            case TOPIC: {
                return this.buildTopic(node);
            }
            case ASSOC: {
                return this.buildAssoc(node);
            }
        }
        throw new RuntimeException("Unexpected node type: " + (Object)((Object)nodeType));
    }

    public List<AssocModelImpl> fetchTopicAssocs(long topicId) {
        return this.fetchAssocs(this.fetchTopicNode(topicId));
    }

    public List<AssocModelImpl> fetchAssocAssocs(long assocId) {
        return this.fetchAssocs(this.fetchAssocNode(assocId));
    }

    public List<RelatedTopicModelImpl> fetchTopicRelatedTopics(long topicId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.buildRelatedTopics(this.queryAssocIndex(assocTypeUri, myRoleTypeUri, NodeType.TOPIC, topicId, null, othersRoleTypeUri, NodeType.TOPIC, -1L, othersTopicTypeUri), topicId);
    }

    public List<RelatedAssocModelImpl> fetchTopicRelatedAssocs(long topicId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        return this.buildRelatedAssocs(this.queryAssocIndex(assocTypeUri, myRoleTypeUri, NodeType.TOPIC, topicId, null, othersRoleTypeUri, NodeType.ASSOC, -1L, othersAssocTypeUri), topicId);
    }

    public List<RelatedTopicModelImpl> fetchAssocRelatedTopics(long assocId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.buildRelatedTopics(this.queryAssocIndex(assocTypeUri, myRoleTypeUri, NodeType.ASSOC, assocId, null, othersRoleTypeUri, NodeType.TOPIC, -1L, othersTopicTypeUri), assocId);
    }

    public List<RelatedAssocModelImpl> fetchAssocRelatedAssocs(long assocId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        return this.buildRelatedAssocs(this.queryAssocIndex(assocTypeUri, myRoleTypeUri, NodeType.ASSOC, assocId, null, othersRoleTypeUri, NodeType.ASSOC, -1L, othersAssocTypeUri), assocId);
    }

    public List<RelatedTopicModelImpl> fetchRelatedTopics(long id, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.buildRelatedTopics(this.queryAssocIndex(assocTypeUri, myRoleTypeUri, null, id, null, othersRoleTypeUri, NodeType.TOPIC, -1L, othersTopicTypeUri), id);
    }

    public List<RelatedAssocModelImpl> fetchRelatedAssocs(long id, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        return this.buildRelatedAssocs(this.queryAssocIndex(assocTypeUri, myRoleTypeUri, null, id, null, othersRoleTypeUri, NodeType.ASSOC, -1L, othersAssocTypeUri), id);
    }

    public Object fetchProperty(long id, String propUri) {
        return this.fetchNode(id).getProperty(propUri);
    }

    public boolean hasProperty(long id, String propUri) {
        return this.fetchNode(id).hasProperty(propUri);
    }

    public List<TopicModelImpl> fetchTopicsByProperty(String propUri, Object propValue) {
        return this.buildTopics((Iterable<Node>)this.queryIndexByProperty(this.topicContentExact, propUri, propValue));
    }

    public List<TopicModelImpl> fetchTopicsByPropertyRange(String propUri, Number from, Number to) {
        return this.buildTopics((Iterable<Node>)this.queryIndexByPropertyRange(this.topicContentExact, propUri, from, to));
    }

    public List<AssocModelImpl> fetchAssocsByProperty(String propUri, Object propValue) {
        return this.buildAssocs((Iterable<Node>)this.queryIndexByProperty(this.assocContentExact, propUri, propValue));
    }

    public List<AssocModelImpl> fetchAssocsByPropertyRange(String propUri, Number from, Number to) {
        return this.buildAssocs((Iterable<Node>)this.queryIndexByPropertyRange(this.assocContentExact, propUri, from, to));
    }

    public void storeTopicProperty(long topicId, String propUri, Object propValue, boolean addToIndex) {
        Index<Node> exactIndex = addToIndex ? this.topicContentExact : null;
        this.storeAndIndexExactValue(this.fetchTopicNode(topicId), propUri, propValue, exactIndex);
    }

    public void storeAssocProperty(long assocId, String propUri, Object propValue, boolean addToIndex) {
        Index<Node> exactIndex = addToIndex ? this.assocContentExact : null;
        this.storeAndIndexExactValue(this.fetchAssocNode(assocId), propUri, propValue, exactIndex);
    }

    public void indexTopicProperty(long topicId, String propUri, Object propValue) {
        this.indexExactValue(this.fetchTopicNode(topicId), propUri, propValue, this.topicContentExact);
    }

    public void indexAssocProperty(long assocId, String propUri, Object propValue) {
        this.indexExactValue(this.fetchAssocNode(assocId), propUri, propValue, this.assocContentExact);
    }

    public void deleteTopicProperty(long topicId, String propUri) {
        Node topicNode = this.fetchTopicNode(topicId);
        topicNode.removeProperty(propUri);
        this.removeTopicPropertyFromIndex(topicNode, propUri);
    }

    public void deleteAssocProperty(long assocId, String propUri) {
        Node assocNode = this.fetchAssocNode(assocId);
        assocNode.removeProperty(propUri);
        this.removeAssocPropertyFromIndex(assocNode, propUri);
    }

    public DMXTransaction beginTx() {
        return new Neo4jTransactionAdapter(this.neo4j);
    }

    public boolean setupRootNode() {
        try {
            Node rootNode = this.fetchNode(0L);
            if (rootNode.getProperty(KEY_NODE_TYPE, null) != null) {
                return false;
            }
            rootNode.setProperty(KEY_NODE_TYPE, (Object)"topic");
            rootNode.setProperty(KEY_VALUE, (Object)"Meta Type");
            this.storeAndIndexTopicUri(rootNode, "dmx.core.meta_type");
            this.storeAndIndexTopicTypeUri(rootNode, "dmx.core.meta_meta_type");
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException("Setting up the root node (0) failed", e);
        }
    }

    public void shutdown() {
        this.neo4j.shutdown();
    }

    public Object getDatabaseVendorObject() {
        return this.neo4j;
    }

    public Object getDatabaseVendorObject(long objectId) {
        return this.fetchNode(objectId);
    }

    public ModelFactoryImpl getModelFactory() {
        return this.mf;
    }

    private void storeAndIndexTopicUri(Node topicNode, String uri) {
        this.checkUriUniqueness(uri);
        this.storeAndIndexExactValue(topicNode, KEY_URI, uri, this.topicContentExact);
    }

    private void storeAndIndexAssocUri(Node assocNode, String uri) {
        this.checkUriUniqueness(uri);
        this.storeAndIndexExactValue(assocNode, KEY_URI, uri, this.assocContentExact);
    }

    private void storeAndIndexTopicTypeUri(Node topicNode, String topicTypeUri) {
        this.storeAndIndexExactValue(topicNode, KEY_TPYE_URI, topicTypeUri, this.topicContentExact);
    }

    private void storeAndIndexAssocTypeUri(Node assocNode, String assocTypeUri) {
        this.storeAndIndexExactValue(assocNode, KEY_TPYE_URI, assocTypeUri, this.assocContentExact);
    }

    private void storeAndIndexExactValue(Node node, String key, Object value, Index<Node> exactIndex) {
        node.setProperty(key, value);
        if (exactIndex != null) {
            this.indexExactValue(node, key, value, exactIndex);
        }
    }

    private void indexExactValue(Node node, String key, Object value, Index<Node> exactIndex) {
        if (value instanceof Number) {
            value = ValueContext.numeric((Number)((Number)value));
        }
        this.indexNodeValue(node, value, IndexMode.KEY, key, exactIndex, null);
    }

    private void indexTopicNodeValue(Node topicNode, String indexKey, Object value, boolean isHtmlValue) {
        this.indexNodeValue(topicNode, value, IndexMode.KEY, indexKey, this.topicContentExact, this.topicContentFulltext);
        value = this.getIndexValue(value, isHtmlValue);
        this.indexNodeValue(topicNode, value, IndexMode.FULLTEXT, indexKey, this.topicContentExact, this.topicContentFulltext);
        this.indexNodeValue(topicNode, value, IndexMode.FULLTEXT_KEY, indexKey, this.topicContentExact, this.topicContentFulltext);
    }

    private void indexAssocNodeValue(Node assocNode, String indexKey, Object value, boolean isHtmlValue) {
        this.indexNodeValue(assocNode, value, IndexMode.KEY, indexKey, this.assocContentExact, this.assocContentFulltext);
        value = this.getIndexValue(value, isHtmlValue);
        this.indexNodeValue(assocNode, value, IndexMode.FULLTEXT, indexKey, this.assocContentExact, this.assocContentFulltext);
        this.indexNodeValue(assocNode, value, IndexMode.FULLTEXT_KEY, indexKey, this.assocContentExact, this.assocContentFulltext);
    }

    private Object getIndexValue(Object value, boolean isHtmlValue) {
        return isHtmlValue ? JavaUtils.stripHTML((String)((String)value)) : value;
    }

    private void indexNodeValue(Node node, Object value, IndexMode indexMode, String indexKey, Index<Node> exactIndex, Index<Node> fulltextIndex) {
        if (indexMode == IndexMode.KEY) {
            exactIndex.remove((PropertyContainer)node, indexKey);
            exactIndex.add((PropertyContainer)node, indexKey, value);
        } else if (indexMode == IndexMode.FULLTEXT) {
            fulltextIndex.remove((PropertyContainer)node, KEY_FULLTEXT);
            fulltextIndex.add((PropertyContainer)node, KEY_FULLTEXT, value);
        } else if (indexMode == IndexMode.FULLTEXT_KEY) {
            fulltextIndex.remove((PropertyContainer)node, indexKey);
            fulltextIndex.add((PropertyContainer)node, indexKey, value);
        } else {
            throw new RuntimeException("Unexpected index mode: \"" + (Object)((Object)indexMode) + "\"");
        }
    }

    private void indexAssoc(Node assocNode, String roleTypeUri1, Node playerNode1, String roleTypeUri2, Node playerNode2) {
        this.indexAssocId(assocNode);
        this.indexAssocType(assocNode, this.typeUri(assocNode));
        this.indexAssocRole(assocNode, 1, roleTypeUri1, playerNode1);
        this.indexAssocRole(assocNode, 2, roleTypeUri2, playerNode2);
    }

    private void indexAssocId(Node assocNode) {
        this.assocMetadata.add((PropertyContainer)assocNode, KEY_ASSOC_ID, (Object)assocNode.getId());
    }

    private void indexAssocType(Node assocNode, String assocTypeUri) {
        this.reindexValue(assocNode, KEY_ASSOC_TPYE_URI, assocTypeUri);
    }

    private void indexAssocRole(Node assocNode, int pos, String roleTypeUri, Node playerNode) {
        this.assocMetadata.add((PropertyContainer)assocNode, KEY_ROLE_TPYE_URI + pos, (Object)roleTypeUri);
        this.assocMetadata.add((PropertyContainer)assocNode, KEY_PLAYER_TPYE + pos, (Object)NodeType.of(playerNode).stringify());
        this.assocMetadata.add((PropertyContainer)assocNode, KEY_PLAYER_ID + pos, (Object)playerNode.getId());
        this.assocMetadata.add((PropertyContainer)assocNode, KEY_PLAYER_TYPE_URI + pos, (Object)this.typeUri(playerNode));
    }

    private void indexAssocRoleType(Node assocNode, long playerId, String roleTypeUri) {
        int pos = this.lookupPlayerPosition(assocNode.getId(), playerId);
        this.reindexValue(assocNode, KEY_ROLE_TPYE_URI, pos, roleTypeUri);
    }

    private int lookupPlayerPosition(long assocId, long playerId) {
        boolean pos1 = this.isPlayerAtPosition(1, assocId, playerId);
        boolean pos2 = this.isPlayerAtPosition(2, assocId, playerId);
        if (pos1 && pos2) {
            throw new RuntimeException("Ambiguity: both players have ID " + playerId + " in association " + assocId);
        }
        if (pos1) {
            return 1;
        }
        if (pos2) {
            return 2;
        }
        throw new IllegalArgumentException("ID " + playerId + " is not a player in association " + assocId);
    }

    private boolean isPlayerAtPosition(int pos, long assocId, long playerId) {
        BooleanQuery query = new BooleanQuery();
        this.addTermQuery(KEY_ASSOC_ID, assocId, query);
        this.addTermQuery(KEY_PLAYER_ID + pos, playerId, query);
        return this.assocMetadata.query((Object)query).getSingle() != null;
    }

    private void reindexTypeUri(Node playerNode, String typeUri) {
        this.reindexTypeUri(1, playerNode, typeUri);
        this.reindexTypeUri(2, playerNode, typeUri);
    }

    private void reindexTypeUri(int pos, Node playerNode, String typeUri) {
        for (Node assocNode : this.lookupAssocs(pos, playerNode)) {
            this.reindexValue(assocNode, KEY_PLAYER_TYPE_URI, pos, typeUri);
        }
    }

    private IndexHits<Node> lookupAssocs(int pos, Node playerNode) {
        return this.assocMetadata.get(KEY_PLAYER_ID + pos, (Object)playerNode.getId());
    }

    private void reindexValue(Node assocNode, String key, int pos, String value) {
        this.reindexValue(assocNode, key + pos, value);
    }

    private void reindexValue(Node assocNode, String key, String value) {
        this.assocMetadata.remove((PropertyContainer)assocNode, key);
        this.assocMetadata.add((PropertyContainer)assocNode, key, (Object)value);
    }

    private IndexHits<Node> queryIndexByProperty(Index<Node> index, String propUri, Object propValue) {
        if (propValue instanceof Number) {
            propValue = ValueContext.numeric((Number)((Number)propValue));
        }
        return index.get(propUri, propValue);
    }

    private IndexHits<Node> queryIndexByPropertyRange(Index<Node> index, String propUri, Number from, Number to) {
        return index.query((Object)this.buildNumericRangeQuery(propUri, from, to));
    }

    private List<AssocModelImpl> queryAssocIndex(String assocTypeUri, String roleTypeUri1, NodeType playerType1, long playerId1, String playerTypeUri1, String roleTypeUri2, NodeType playerType2, long playerId2, String playerTypeUri2) {
        return this.buildAssocs((Iterable<Node>)this.assocMetadata.query((Object)this.buildAssocQuery(assocTypeUri, roleTypeUri1, playerType1, playerId1, playerTypeUri1, roleTypeUri2, playerType2, playerId2, playerTypeUri2)));
    }

    private QueryContext buildNumericRangeQuery(String propUri, Number from, Number to) {
        return QueryContext.numericRange((String)propUri, (Number)from, (Number)to);
    }

    private Query buildAssocQuery(String assocTypeUri, String roleTypeUri1, NodeType playerType1, long playerId1, String playerTypeUri1, String roleTypeUri2, NodeType playerType2, long playerId2, String playerTypeUri2) {
        BooleanQuery direction1 = new BooleanQuery();
        this.addRole(direction1, 1, roleTypeUri1, playerType1, playerId1, playerTypeUri1);
        this.addRole(direction1, 2, roleTypeUri2, playerType2, playerId2, playerTypeUri2);
        BooleanQuery direction2 = new BooleanQuery();
        this.addRole(direction2, 1, roleTypeUri2, playerType2, playerId2, playerTypeUri2);
        this.addRole(direction2, 2, roleTypeUri1, playerType1, playerId1, playerTypeUri1);
        BooleanQuery roleQuery = new BooleanQuery();
        roleQuery.add((Query)direction1, BooleanClause.Occur.SHOULD);
        roleQuery.add((Query)direction2, BooleanClause.Occur.SHOULD);
        BooleanQuery query = new BooleanQuery();
        if (assocTypeUri != null) {
            this.addTermQuery(KEY_ASSOC_TPYE_URI, assocTypeUri, query);
        }
        query.add((Query)roleQuery, BooleanClause.Occur.MUST);
        return query;
    }

    private void addRole(BooleanQuery query, int pos, String roleTypeUri, NodeType playerType, long playerId, String playerTypeUri) {
        if (roleTypeUri != null) {
            this.addTermQuery(KEY_ROLE_TPYE_URI + pos, roleTypeUri, query);
        }
        if (playerType != null) {
            this.addTermQuery(KEY_PLAYER_TPYE + pos, playerType, query);
        }
        if (playerId != -1L) {
            this.addTermQuery(KEY_PLAYER_ID + pos, playerId, query);
        }
        if (playerTypeUri != null) {
            this.addTermQuery(KEY_PLAYER_TYPE_URI + pos, playerTypeUri, query);
        }
    }

    private void addTermQuery(String key, long value, BooleanQuery query) {
        this.addTermQuery(key, Long.toString(value), query);
    }

    private void addTermQuery(String key, NodeType nodeType, BooleanQuery query) {
        this.addTermQuery(key, nodeType.stringify(), query);
    }

    private void addTermQuery(String key, String value, BooleanQuery query) {
        query.add((Query)new TermQuery(new Term(key, value)), BooleanClause.Occur.MUST);
    }

    private void removeTopicFromIndex(Node topicNode) {
        this.topicContentExact.remove((PropertyContainer)topicNode);
        this.topicContentFulltext.remove((PropertyContainer)topicNode);
    }

    private void removeAssocFromIndex(Node assocNode) {
        this.assocContentExact.remove((PropertyContainer)assocNode);
        this.assocContentFulltext.remove((PropertyContainer)assocNode);
        this.assocMetadata.remove((PropertyContainer)assocNode);
    }

    private void removeTopicPropertyFromIndex(Node topicNode, String propUri) {
        this.topicContentExact.remove((PropertyContainer)topicNode, propUri);
    }

    private void removeAssocPropertyFromIndex(Node assocNode, String propUri) {
        this.assocContentExact.remove((PropertyContainer)assocNode, propUri);
    }

    private Index<Node> createExactIndex(String name) {
        return this.neo4j.index().forNodes(name);
    }

    private Index<Node> createFulltextIndex(String name) {
        if (this.neo4j.index().existsForNodes(name)) {
            return this.neo4j.index().forNodes(name);
        }
        Map configuration = MapUtil.stringMap((String[])new String[]{"provider", "lucene", "type", KEY_FULLTEXT});
        return this.neo4j.index().forNodes(name, configuration);
    }

    TopicModelImpl buildTopic(Node topicNode) {
        try {
            return this.mf.newTopicModel(topicNode.getId(), this.uri(topicNode), this.typeUri(topicNode), this.simpleValue(topicNode), null);
        }
        catch (Exception e) {
            throw new RuntimeException("Building a TopicModel failed, id=" + topicNode.getId() + ", typeUri=" + this.typeUri(topicNode), e);
        }
    }

    private List<TopicModelImpl> buildTopics(Iterable<Node> topicNodes) {
        ArrayList<TopicModelImpl> topics = new ArrayList<TopicModelImpl>();
        for (Node topicNode : topicNodes) {
            topics.add(this.buildTopic(topicNode));
        }
        return topics;
    }

    AssocModelImpl buildAssoc(Node assocNode) {
        try {
            List<PlayerModel> playerModels = this.buildPlayerModels(assocNode);
            return this.mf.newAssocModel(assocNode.getId(), this.uri(assocNode), this.typeUri(assocNode), playerModels.get(0), playerModels.get(1), this.simpleValue(assocNode), null);
        }
        catch (Exception e) {
            throw new RuntimeException("Building an AssocModel failed, id=" + assocNode.getId() + ", typeUri=" + this.typeUri(assocNode), e);
        }
    }

    private List<AssocModelImpl> buildAssocs(Iterable<Node> assocNodes) {
        ArrayList<AssocModelImpl> assocs = new ArrayList<AssocModelImpl>();
        for (Node assocNode : assocNodes) {
            assocs.add(this.buildAssoc(assocNode));
        }
        return assocs;
    }

    private List<PlayerModel> buildPlayerModels(Node assocNode) {
        ArrayList<PlayerModel> playerModels = new ArrayList<PlayerModel>();
        for (Relationship rel : this.fetchRelationships(assocNode)) {
            Node node = rel.getEndNode();
            String roleTypeUri = rel.getType().name();
            PlayerModel playerModel = NodeType.of(node).createPlayerModel(node, roleTypeUri, (ModelFactory)this.mf);
            playerModels.add(playerModel);
        }
        return playerModels;
    }

    private Node storePlayerRelationship(Node assocNode, PlayerModel playerModel) {
        Node playerNode = this.fetchPlayerNode(playerModel);
        assocNode.createRelationshipTo(playerNode, this.getRelationshipType(playerModel.getRoleTypeUri()));
        return playerNode;
    }

    private Node fetchPlayerNode(PlayerModel playerModel) {
        if (playerModel instanceof TopicPlayerModel) {
            return this.fetchTopicPlayerNode((TopicPlayerModel)playerModel);
        }
        if (playerModel instanceof AssocPlayerModel) {
            return this.fetchAssocNode(playerModel.getId());
        }
        throw new RuntimeException("Unexpected player model: " + playerModel);
    }

    private Node fetchTopicPlayerNode(TopicPlayerModel playerModel) {
        if (playerModel.topicIdentifiedByUri()) {
            return this.fetchTopicNodeByUri(playerModel.getTopicUri());
        }
        return this.fetchTopicNode(playerModel.getId());
    }

    private Relationship fetchRelationship(Node assocNode, long playerId) {
        boolean match2;
        List<Relationship> rels = this.fetchRelationships(assocNode);
        boolean match1 = this.playerId(rels.get(0)) == playerId;
        boolean bl = match2 = this.playerId(rels.get(1)) == playerId;
        if (match1 && match2) {
            throw new RuntimeException("Ambiguity: both players have ID " + playerId + " in association " + assocNode.getId());
        }
        if (match1) {
            return rels.get(0);
        }
        if (match2) {
            return rels.get(1);
        }
        throw new IllegalArgumentException("ID " + playerId + " is not a player in association " + assocNode.getId());
    }

    private List<Relationship> fetchRelationships(Node assocNode) {
        ArrayList<Relationship> rels = new ArrayList<Relationship>();
        for (Relationship rel : assocNode.getRelationships(Direction.OUTGOING)) {
            rels.add(rel);
        }
        if (rels.size() != 2) {
            throw new RuntimeException("Assoc " + assocNode.getId() + " connects " + rels.size() + " player instead of 2");
        }
        return rels;
    }

    private long playerId(Relationship rel) {
        return rel.getEndNode().getId();
    }

    private List<AssocModelImpl> fetchAssocs(Node node) {
        ArrayList<AssocModelImpl> assocs = new ArrayList<AssocModelImpl>();
        for (Relationship rel : node.getRelationships(Direction.INCOMING)) {
            Node assocNode = rel.getStartNode();
            if (!assocNode.hasProperty(KEY_NODE_TYPE)) continue;
            assocs.add(this.buildAssoc(assocNode));
        }
        return assocs;
    }

    private Node fetchTopicNode(long topicId) {
        return this.checkNodeType(this.fetchNode(topicId), NodeType.TOPIC);
    }

    private Node fetchAssocNode(long assocId) {
        return this.checkNodeType(this.fetchNode(assocId), NodeType.ASSOC);
    }

    private Node fetchNode(long id) {
        return this.neo4j.getNodeById(id);
    }

    private Node fetchTopicNodeByUri(String uri) {
        Node node = (Node)this.topicContentExact.get(KEY_URI, (Object)uri).getSingle();
        if (node == null) {
            throw new RuntimeException("Topic with URI \"" + uri + "\" not found in DB");
        }
        return this.checkNodeType(node, NodeType.TOPIC);
    }

    private Node checkNodeType(Node node, NodeType type) {
        if (NodeType.of(node) != type) {
            throw new IllegalArgumentException(type.error(node));
        }
        return node;
    }

    private RelationshipType getRelationshipType(String typeName) {
        return this.relTypeCache.get(typeName);
    }

    private String uri(Node node) {
        return (String)node.getProperty(KEY_URI);
    }

    private String typeUri(Node node) {
        return (String)node.getProperty(KEY_TPYE_URI);
    }

    private SimpleValue simpleValue(Node node) {
        return new SimpleValue(node.getProperty(KEY_VALUE));
    }

    private List<RelatedTopicModelImpl> buildRelatedTopics(List<AssocModelImpl> assocs, long playerId) {
        ArrayList<RelatedTopicModelImpl> relTopics = new ArrayList<RelatedTopicModelImpl>();
        for (AssocModelImpl assoc : assocs) {
            relTopics.add(this.mf.newRelatedTopicModel((TopicModel)this.fetchTopic(assoc.getOtherPlayerId(playerId)), (AssocModel)assoc));
        }
        return relTopics;
    }

    private List<RelatedAssocModelImpl> buildRelatedAssocs(List<AssocModelImpl> assocs, long playerId) {
        ArrayList<RelatedAssocModelImpl> relAssocs = new ArrayList<RelatedAssocModelImpl>();
        for (AssocModelImpl assoc : assocs) {
            relAssocs.add(this.mf.newRelatedAssocModel((AssocModel)this.fetchAssoc(assoc.getOtherPlayerId(playerId)), (AssocModel)assoc));
        }
        return relAssocs;
    }

    private void setDefaults(DMXObjectModelImpl model) {
        if (model.getUri() == null) {
            model.setUri("");
        }
        if (model.getSimpleValue() == null) {
            model.setSimpleValue("");
        }
    }

    private void checkUriUniqueness(String uri) {
        if (uri.equals("")) {
            return;
        }
        Node n1 = (Node)this.topicContentExact.get(KEY_URI, (Object)uri).getSingle();
        Node n2 = (Node)this.assocContentExact.get(KEY_URI, (Object)uri).getSingle();
        if (n1 != null || n2 != null) {
            throw new RuntimeException("URI \"" + uri + "\" is not unique");
        }
    }

    private static enum IndexMode {
        KEY,
        FULLTEXT,
        FULLTEXT_KEY;

    }
}

