/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.accesscontrol;

import com.sun.jersey.spi.container.ContainerRequest;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.accesscontrol.AnonymousAccessFilter;
import systems.dmx.accesscontrol.AuthorizationMethod;
import systems.dmx.accesscontrol.event.PostLoginUser;
import systems.dmx.accesscontrol.event.PostLogoutUser;
import systems.dmx.config.ConfigCustomizer;
import systems.dmx.config.ConfigDefinition;
import systems.dmx.config.ConfigModificationRole;
import systems.dmx.config.ConfigService;
import systems.dmx.config.ConfigTarget;
import systems.dmx.core.Assoc;
import systems.dmx.core.AssocType;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.model.AssocModel;
import systems.dmx.core.model.AssocPlayerModel;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.DMXEvent;
import systems.dmx.core.service.EventListener;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.service.accesscontrol.AccessControlException;
import systems.dmx.core.service.accesscontrol.Credentials;
import systems.dmx.core.service.accesscontrol.Operation;
import systems.dmx.core.service.accesscontrol.Permissions;
import systems.dmx.core.service.accesscontrol.PrivilegedAccess;
import systems.dmx.core.service.accesscontrol.SharingMode;
import systems.dmx.core.service.event.CheckAssocReadAccess;
import systems.dmx.core.service.event.CheckAssocWriteAccess;
import systems.dmx.core.service.event.CheckTopicReadAccess;
import systems.dmx.core.service.event.CheckTopicWriteAccess;
import systems.dmx.core.service.event.PostCreateAssoc;
import systems.dmx.core.service.event.PostCreateTopic;
import systems.dmx.core.service.event.PostUpdateAssoc;
import systems.dmx.core.service.event.PostUpdateTopic;
import systems.dmx.core.service.event.PreUpdateTopic;
import systems.dmx.core.service.event.ServiceRequestFilter;
import systems.dmx.core.service.event.StaticResourceFilter;
import systems.dmx.core.util.JavaUtils;
import systems.dmx.files.FilesService;
import systems.dmx.files.event.CheckDiskQuota;
import systems.dmx.workspaces.WorkspacesService;

@Path(value="/accesscontrol")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AccessControlPlugin
extends PluginActivator
implements AccessControlService,
ConfigCustomizer,
CheckTopicReadAccess,
CheckTopicWriteAccess,
CheckAssocReadAccess,
CheckAssocWriteAccess,
PreUpdateTopic,
PostCreateTopic,
PostCreateAssoc,
PostUpdateTopic,
PostUpdateAssoc,
ServiceRequestFilter,
StaticResourceFilter,
CheckDiskQuota {
    private static final String ANONYMOUS_READ_ALLOWED = System.getProperty("dmx.security.anonymous_read_allowed", "ALL");
    private static final String ANONYMOUS_WRITE_ALLOWED = System.getProperty("dmx.security.anonymous_write_allowed", "NONE");
    private static final AnonymousAccessFilter accessFilter = new AnonymousAccessFilter(ANONYMOUS_READ_ALLOWED, ANONYMOUS_WRITE_ALLOWED);
    private static final String SUBNET_FILTER = System.getProperty("dmx.security.subnet_filter", "127.0.0.1/32");
    private static final boolean NEW_ACCOUNTS_ARE_ENABLED = Boolean.parseBoolean(System.getProperty("dmx.security.new_accounts_are_enabled", "true"));
    private static final boolean IS_PUBLIC_INSTALLATION = ANONYMOUS_READ_ALLOWED.equals("ALL");
    private static final String AUTHENTICATION_REALM = "DMX";
    private static final String ENCODED_PASSWORD_PREFIX = "-SHA256-";
    private static final String PROP_CREATOR = "dmx.accesscontrol.creator";
    private static final String PROP_OWNER = "dmx.accesscontrol.owner";
    private static final String PROP_MODIFIER = "dmx.accesscontrol.modifier";
    private static DMXEvent POST_LOGIN_USER = new DMXEvent(PostLoginUser.class){

        public void dispatch(EventListener listener, Object ... params) {
            ((PostLoginUser)listener).postLoginUser((String)params[0]);
        }
    };
    private static DMXEvent POST_LOGOUT_USER = new DMXEvent(PostLogoutUser.class){

        public void dispatch(EventListener listener, Object ... params) {
            ((PostLogoutUser)listener).postLogoutUser((String)params[0]);
        }
    };
    @Inject
    private WorkspacesService wsService;
    @Inject
    private FilesService filesService;
    @Inject
    private ConfigService configService;
    @Context
    private HttpServletRequest request;
    private Map<String, AuthorizationMethod> authorizationMethods = new HashMap<String, AuthorizationMethod>();
    private static Logger logger = Logger.getLogger(AccessControlPlugin.class.getName());

    @Override
    @POST
    @Path(value="/login")
    public void login() {
    }

    @Override
    @POST
    @Path(value="/logout")
    public void logout() {
        this._logout(this.request);
        if (!IS_PUBLIC_INSTALLATION) {
            this.throw401Unauthorized(true);
        }
    }

    @Override
    @GET
    @Path(value="/user")
    @Produces(value={"text/plain"})
    public String getUsername() {
        return this.dmx.getPrivilegedAccess().getUsername(this.request);
    }

    @Override
    @GET
    @Path(value="/username")
    public Topic getUsernameTopic() {
        return this.dmx.getPrivilegedAccess().getUsernameTopic(this.request);
    }

    @Override
    @GET
    @Path(value="/user/workspace")
    public Topic getPrivateWorkspace() {
        String username = this.getUsername();
        if (username == null) {
            throw new IllegalStateException("No user is logged in");
        }
        return this.dmx.getPrivilegedAccess().getPrivateWorkspace(username);
    }

    @Override
    public boolean isAdmin() {
        return this.hasPermission(this.getUsername(), Operation.WRITE, this.getAdminWorkspaceId());
    }

    @Override
    @POST
    @Path(value="/user_account")
    @Transactional
    public Topic createUserAccount(Credentials cred) {
        return this._createUserAccount(cred);
    }

    @Override
    public Topic _createUserAccount(final Credentials cred) {
        try {
            String username = cred.username;
            PrivilegedAccess pa = this.dmx.getPrivilegedAccess();
            logger.info("Creating user account \"" + username + "\"");
            final Topic usernameTopic = this.createUsername(username);
            Topic userAccount = (Topic)pa.runWithoutWorkspaceAssignment((Callable)new Callable<Topic>(){

                @Override
                public Topic call() {
                    return AccessControlPlugin.this.dmx.createTopic(AccessControlPlugin.this.mf.newTopicModel("dmx.accesscontrol.user_account", AccessControlPlugin.this.mf.newChildTopicsModel().setRef("dmx.accesscontrol.username", usernameTopic.getId()).set("dmx.accesscontrol.password", (Object)cred.password)));
                }
            });
            RelatedTopic passwordTopic = userAccount.getChildTopics().getTopic("dmx.accesscontrol.password");
            long privateWorkspaceId = pa.getPrivateWorkspace(username).getId();
            pa.assignToWorkspace((DMXObject)userAccount, privateWorkspaceId);
            pa.assignToWorkspace((DMXObject)passwordTopic, privateWorkspaceId);
            return usernameTopic;
        }
        catch (Exception e) {
            throw new RuntimeException("Creating user account \"" + cred.username + "\" failed", e);
        }
    }

    @Override
    public Topic createUsername(final String username) {
        try {
            logger.info("Creating username topic \"" + username + "\"");
            PrivilegedAccess pa = this.dmx.getPrivilegedAccess();
            Topic usernameTopic = this.getUsernameTopic(username);
            if (usernameTopic != null) {
                throw new RuntimeException("Username \"" + username + "\" exists already");
            }
            usernameTopic = (Topic)pa.runWithoutWorkspaceAssignment((Callable)new Callable<Topic>(){

                @Override
                public Topic call() {
                    return AccessControlPlugin.this.dmx.createTopic(AccessControlPlugin.this.mf.newTopicModel("dmx.accesscontrol.username", new SimpleValue(username)));
                }
            });
            this.setWorkspaceOwner(this.wsService.createWorkspace("Private Workspace", null, SharingMode.PRIVATE), username);
            pa.assignToWorkspace((DMXObject)usernameTopic, pa.getSystemWorkspaceId());
            return usernameTopic;
        }
        catch (Exception e) {
            throw new RuntimeException("Creating username topic \"" + username + "\" failed", e);
        }
    }

    @Override
    @GET
    @Path(value="/username/{username}")
    public Topic getUsernameTopic(@PathParam(value="username") String username) {
        return this.dmx.getPrivilegedAccess().getUsernameTopic(username);
    }

    @Override
    @GET
    @Path(value="/workspace/{workspace_id}/owner")
    @Produces(value={"text/plain"})
    public String getWorkspaceOwner(@PathParam(value="workspace_id") long workspaceId) {
        return this.dmx.hasProperty(workspaceId, PROP_OWNER) ? (String)this.dmx.getProperty(workspaceId, PROP_OWNER) : null;
    }

    @Override
    public void setWorkspaceOwner(Topic workspace, String username) {
        try {
            workspace.setProperty(PROP_OWNER, (Object)username, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Setting the workspace owner of " + this.info((DMXObject)workspace) + " failed (username=" + username + ")", e);
        }
    }

    @Override
    @POST
    @Path(value="/user/{username}/workspace/{workspace_id}")
    @Transactional
    public void createMembership(@PathParam(value="username") String username, @PathParam(value="workspace_id") long workspaceId) {
        try {
            Assoc assoc = this.dmx.createAssoc(this.mf.newAssocModel("dmx.accesscontrol.membership", (PlayerModel)this.mf.newTopicPlayerModel(this.getUsernameTopicOrThrow(username).getId(), "dmx.core.default"), (PlayerModel)this.mf.newTopicPlayerModel(workspaceId, "dmx.core.default")));
            this.assignMembershipToWorkspace(assoc);
        }
        catch (Exception e) {
            throw new RuntimeException("Creating membership for user \"" + username + "\" and workspace " + workspaceId + " failed", e);
        }
    }

    @Override
    public boolean isMember(String username, long workspaceId) {
        return this.dmx.getPrivilegedAccess().isMember(username, workspaceId);
    }

    @Override
    @GET
    @Path(value="/workspace/admin/id")
    public long getAdminWorkspaceId() {
        return this.dmx.getPrivilegedAccess().getAdministrationWorkspaceId();
    }

    @Override
    @GET
    @Path(value="/object/{id}")
    public Permissions getPermissions(@PathParam(value="id") long objectId) {
        return new Permissions().add(Operation.WRITE, this.hasPermission(this.getUsername(), Operation.WRITE, objectId));
    }

    @Override
    @GET
    @Path(value="/object/{id}/creator")
    @Produces(value={"text/plain"})
    public String getCreator(@PathParam(value="id") long objectId) {
        return this.dmx.getPrivilegedAccess().getCreator(objectId);
    }

    @Override
    @GET
    @Path(value="/object/{id}/modifier")
    @Produces(value={"text/plain"})
    public String getModifier(@PathParam(value="id") long objectId) {
        return this.dmx.hasProperty(objectId, PROP_MODIFIER) ? (String)this.dmx.getProperty(objectId, PROP_MODIFIER) : null;
    }

    @Override
    @GET
    @Path(value="/creator/{username}/topics")
    public Collection<Topic> getTopicsByCreator(@PathParam(value="username") String username) {
        return this.dmx.getTopicsByProperty(PROP_CREATOR, (Object)username);
    }

    @Override
    @GET
    @Path(value="/owner/{username}/topics")
    public Collection<Topic> getTopicsByOwner(@PathParam(value="username") String username) {
        return this.dmx.getTopicsByProperty(PROP_OWNER, (Object)username);
    }

    @Override
    @GET
    @Path(value="/creator/{username}/assocs")
    public Collection<Assoc> getAssocsByCreator(@PathParam(value="username") String username) {
        return this.dmx.getAssocsByProperty(PROP_CREATOR, (Object)username);
    }

    @Override
    @GET
    @Path(value="/owner/{username}/assocs")
    public Collection<Assoc> getAssocsByOwner(@PathParam(value="username") String username) {
        return this.dmx.getAssocsByProperty(PROP_OWNER, (Object)username);
    }

    @Override
    @GET
    @Path(value="/methods")
    public Set<String> getAuthorizationMethods() {
        return this.authorizationMethods.keySet();
    }

    @Override
    public void registerAuthorizationMethod(String name, AuthorizationMethod am) {
        if (this.authorizationMethods.containsKey(name)) {
            throw new RuntimeException("Authorization method \"" + name + "\" already registered");
        }
        logger.info("Registering authorization method \"" + name + "\"");
        this.authorizationMethods.put(name, am);
    }

    @Override
    public void unregisterAuthorizationMethod(String name) {
        logger.info("Unregistering authorization method \"" + name + "\"");
        this.authorizationMethods.remove(name);
    }

    public void preInstall() {
        this.configService.registerConfigDefinition(new ConfigDefinition(ConfigTarget.TYPE_INSTANCES, "dmx.accesscontrol.username", this.mf.newTopicModel("dmx.accesscontrol.login_enabled", new SimpleValue(NEW_ACCOUNTS_ARE_ENABLED)), ConfigModificationRole.ADMIN, (ConfigCustomizer)this));
    }

    public void shutdown() {
        if (this.configService != null) {
            this.configService.unregisterConfigDefinition("dmx.accesscontrol.login_enabled");
        } else {
            logger.warning("Config service is already gone");
        }
    }

    public TopicModel getConfigValue(Topic topic) {
        if (!topic.getTypeUri().equals("dmx.accesscontrol.username")) {
            throw new RuntimeException("Unexpected configurable topic: " + topic);
        }
        if (topic.getSimpleValue().toString().equals("admin")) {
            return this.mf.newTopicModel("dmx.accesscontrol.login_enabled", new SimpleValue(true));
        }
        return null;
    }

    public void checkTopicReadAccess(long topicId) {
        this.checkReadAccess(topicId);
    }

    public void checkTopicWriteAccess(long topicId) {
        this.checkWriteAccess(topicId);
    }

    public void checkAssocReadAccess(long assocId) {
        this.checkReadAccess(assocId);
        List players = this.dmx.getPlayerModels(assocId);
        this.checkReadAccess((PlayerModel)players.get(0));
        this.checkReadAccess((PlayerModel)players.get(1));
    }

    public void checkAssocWriteAccess(long assocId) {
        this.checkWriteAccess(assocId);
    }

    public void postCreateTopic(Topic topic) {
        if (topic.getTypeUri().equals("dmx.workspaces.workspace")) {
            this.setWorkspaceOwner(topic);
        }
        this.setCreatorAndModifier((DMXObject)topic);
    }

    public void postCreateAssoc(Assoc assoc) {
        this.setCreatorAndModifier((DMXObject)assoc);
    }

    public void preUpdateTopic(Topic topic, TopicModel updateModel) {
        if (topic.getTypeUri().equals("dmx.accesscontrol.username")) {
            SimpleValue newUsername = updateModel.getSimpleValue();
            String oldUsername = topic.getSimpleValue().toString();
            if (newUsername != null && !newUsername.toString().equals(oldUsername)) {
                throw new RuntimeException("A Username can't be changed (tried \"" + oldUsername + "\" -> \"" + newUsername + "\")");
            }
        }
    }

    public void postUpdateTopic(Topic topic, TopicModel updateModel, TopicModel oldTopic) {
        if (topic.getTypeUri().equals("dmx.accesscontrol.user_account")) {
            RelatedTopic passwordTopic = topic.getChildTopics().getTopic("dmx.accesscontrol.password");
            String password = passwordTopic.getSimpleValue().toString();
            passwordTopic.setSimpleValue(this.encodePassword(password));
            long workspaceId = this.getPrivateWorkspace().getId();
            this.wsService.assignToWorkspace((DMXObject)passwordTopic, workspaceId);
            this.wsService.assignToWorkspace((DMXObject)passwordTopic.getRelatingAssoc(), workspaceId);
        }
        this.setModifier((DMXObject)topic);
    }

    public void postUpdateAssoc(Assoc assoc, AssocModel updateModel, AssocModel oldAssoc) {
        if (this.isMembership(assoc.getModel()) && !this.isMembership(oldAssoc)) {
            this.assignMembershipToWorkspace(assoc);
        }
        this.setModifier((DMXObject)assoc);
    }

    public void serviceRequestFilter(ContainerRequest containerRequest) {
        this.requestFilter(this.request);
    }

    public void staticResourceFilter(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        this.requestFilter(servletRequest);
    }

    public void checkDiskQuota(String username, long fileSize, long diskQuota) {
        if (diskQuota < 0L) {
            logger.info("### Checking disk quota of " + this.userInfo(username) + " SKIPPED -- disk quota is disabled");
            return;
        }
        long occupiedSpace = this.getOccupiedSpace(username);
        boolean quotaOK = occupiedSpace + fileSize <= diskQuota;
        logger.info("### File size: " + fileSize + " bytes, " + this.userInfo(username) + " occupies " + occupiedSpace + " bytes, disk quota: " + diskQuota + " bytes => QUOTA " + (quotaOK ? "OK" : "EXCEEDED"));
        if (!quotaOK) {
            throw new RuntimeException("Disk quota of " + this.userInfo(username) + " exceeded. Disk quota: " + diskQuota + " bytes. Currently occupied: " + occupiedSpace + " bytes.");
        }
    }

    private Topic getUsernameTopicOrThrow(String username) {
        Topic usernameTopic = this.getUsernameTopic(username);
        if (usernameTopic == null) {
            throw new RuntimeException("User \"" + username + "\" does not exist");
        }
        return usernameTopic;
    }

    private String encodePassword(String password) {
        return ENCODED_PASSWORD_PREFIX + JavaUtils.encodeSHA256((String)password);
    }

    private boolean isMembership(AssocModel assoc) {
        return assoc.getTypeUri().equals("dmx.accesscontrol.membership");
    }

    private void assignMembershipToWorkspace(Assoc assoc) {
        try {
            DMXObject workspace = assoc.getDMXObjectByType("dmx.workspaces.workspace");
            if (workspace == null) {
                throw new RuntimeException("Assoc " + assoc.getId() + " has no workspace player");
            }
            this.wsService.assignToWorkspace((DMXObject)assoc, workspace.getId());
        }
        catch (Exception e) {
            throw new RuntimeException("Assigning membership " + assoc.getId() + " to a workspace failed", e);
        }
    }

    private long getOccupiedSpace(String username) {
        long occupiedSpace = 0L;
        for (Topic fileTopic : this.dmx.getTopicsByType("dmx.files.file")) {
            long fileTopicId = fileTopic.getId();
            if (!this.getCreator(fileTopicId).equals(username)) continue;
            occupiedSpace += this.filesService.getFile(fileTopicId).length();
        }
        return occupiedSpace;
    }

    private void requestFilter(HttpServletRequest request) {
        logger.fine("##### " + request.getMethod() + " " + request.getRequestURL() + "\n      ##### \"Authorization\"=\"" + request.getHeader("Authorization") + "\"\n      ##### " + this.info(request.getSession(false)));
        this.checkRequestOrigin(request);
        HttpSession session = request.getSession();
        if (this.username(session) == null) {
            this.checkAuthorization(request);
        }
    }

    private void checkRequestOrigin(HttpServletRequest request) {
        String remoteAddr = request.getRemoteAddr();
        boolean allowed = JavaUtils.isInRange((String)remoteAddr, (String)SUBNET_FILTER);
        logger.fine("Remote address=\"" + remoteAddr + "\", dmx.security.subnet_filter=\"" + SUBNET_FILTER + "\" => " + (allowed ? "ALLOWED" : "FORBIDDEN"));
        if (!allowed) {
            this.throw403Forbidden();
        }
    }

    private void checkAuthorization(HttpServletRequest request) {
        boolean authorized;
        String authHeader = request.getHeader("Authorization");
        if (authHeader != null) {
            Credentials cred = new Credentials(authHeader);
            AuthorizationMethod am = this.getAuthorizationMethod(cred);
            authorized = this.tryLogin(cred, am, request);
        } else {
            authorized = accessFilter.isAnonymousAccessAllowed(request);
        }
        if (!authorized) {
            this.throw401Unauthorized(!IS_PUBLIC_INSTALLATION);
        }
    }

    private AuthorizationMethod getAuthorizationMethod(Credentials cred) {
        AuthorizationMethod am = null;
        if (!cred.methodName.equals("Basic")) {
            logger.info("authMethodName: \"" + cred.methodName + "\"");
            am = this.getAuthorizationMethod(cred.methodName);
        }
        return am;
    }

    private AuthorizationMethod getAuthorizationMethod(String name) {
        AuthorizationMethod am = this.authorizationMethods.get(name);
        if (am == null) {
            throw new RuntimeException("Authorization method \"" + name + "\" is unknown");
        }
        return am;
    }

    private boolean tryLogin(Credentials cred, AuthorizationMethod am, HttpServletRequest request) {
        String username = cred.username;
        Topic usernameTopic = this.checkCredentials(cred, am);
        if (usernameTopic != null && this.getLoginEnabled(usernameTopic)) {
            logger.info("##### Logging in as \"" + username + "\" => SUCCESSFUL!");
            this._login(username, request);
            return true;
        }
        logger.info("##### Logging in as \"" + username + "\" => FAILED!");
        return false;
    }

    private Topic checkCredentials(Credentials cred, AuthorizationMethod am) {
        if (am == null) {
            return this.dmx.getPrivilegedAccess().checkCredentials(cred);
        }
        return am.checkCredentials(cred);
    }

    private boolean getLoginEnabled(Topic usernameTopic) {
        RelatedTopic loginEnabled = this.dmx.getPrivilegedAccess().getConfigTopic("dmx.accesscontrol.login_enabled", usernameTopic.getId());
        return loginEnabled.getSimpleValue().booleanValue();
    }

    private void _login(String username, HttpServletRequest request) {
        request.getSession(false).setAttribute("username", (Object)username);
        this.dmx.fireEvent(POST_LOGIN_USER, new Object[]{username});
    }

    private void _logout(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        String username = this.username(session);
        logger.info("##### Logging out from " + this.info(session));
        session.removeAttribute("username");
        this.dmx.fireEvent(POST_LOGOUT_USER, new Object[]{username});
    }

    private String username(HttpSession session) {
        return this.dmx.getPrivilegedAccess().username(session);
    }

    private void throw401Unauthorized(boolean showBrowserLoginDialog) {
        String authScheme = showBrowserLoginDialog ? "Basic" : "xBasic";
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)(authScheme + " realm=" + AUTHENTICATION_REALM)).header("Content-Type", (Object)"text/html").entity((Object)"You're not authorized. Sorry.").build());
    }

    private void throw403Forbidden() {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).header("Content-Type", (Object)"text/html").entity((Object)"Access is forbidden. Sorry.").build());
    }

    private void setCreatorAndModifier(DMXObject object) {
        try {
            String username = this.getUsername();
            if (username == null) {
                logger.fine("Setting the creator/modifier of " + this.info(object) + " SKIPPED -- no user is logged in");
                return;
            }
            this.setCreatorAndModifier(object, username);
        }
        catch (Exception e) {
            throw new RuntimeException("Setting the creator/modifier of " + this.info(object) + " failed", e);
        }
    }

    private void setCreatorAndModifier(DMXObject object, String username) {
        this.setCreator(object, username);
        this.setModifier(object, username);
    }

    private void setCreator(DMXObject object, String username) {
        try {
            object.setProperty(PROP_CREATOR, (Object)username, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Setting the creator of " + this.info(object) + " failed (username=" + username + ")", e);
        }
    }

    private void setModifier(DMXObject object) {
        String username = this.getUsername();
        if (username == null) {
            return;
        }
        this.setModifier(object, username);
    }

    private void setModifier(DMXObject object, String username) {
        object.setProperty(PROP_MODIFIER, (Object)username, false);
    }

    private void setWorkspaceOwner(Topic workspace) {
        String username = this.getUsername();
        if (username == null) {
            return;
        }
        this.setWorkspaceOwner(workspace, username);
    }

    private void checkReadAccess(PlayerModel player) {
        long id = player.getId();
        if (player instanceof AssocPlayerModel) {
            this.checkAssocReadAccess(id);
        } else {
            this.checkReadAccess(id);
        }
    }

    private void checkReadAccess(long objectId) {
        this.checkAccess(Operation.READ, objectId);
    }

    private void checkWriteAccess(long objectId) {
        this.checkAccess(Operation.WRITE, objectId);
    }

    private void checkAccess(Operation operation, long objectId) {
        if (!this.inRequestScope()) {
            logger.fine("### Object " + objectId + " is accessed by \"System\" -- " + operation + " permission is granted");
            return;
        }
        String username = this.getUsername();
        if (!this.hasPermission(username, operation, objectId)) {
            throw new AccessControlException(this.userInfo(username) + " has no " + operation + " permission for object " + objectId);
        }
    }

    private boolean hasPermission(String username, Operation operation, long objectId) {
        return this.dmx.getPrivilegedAccess().hasPermission(username, operation, objectId);
    }

    private boolean inRequestScope() {
        try {
            this.request.getMethod();
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    private String info(DMXObject object) {
        if (object instanceof TopicType) {
            return "topic type \"" + object.getUri() + "\" (id=" + object.getId() + ")";
        }
        if (object instanceof AssocType) {
            return "association type \"" + object.getUri() + "\" (id=" + object.getId() + ")";
        }
        if (object instanceof Topic) {
            return "topic " + object.getId() + " (typeUri=\"" + object.getTypeUri() + "\", uri=\"" + object.getUri() + "\")";
        }
        if (object instanceof Assoc) {
            return "association " + object.getId() + " (typeUri=\"" + object.getTypeUri() + "\")";
        }
        throw new RuntimeException("Unexpected object: " + object);
    }

    private String userInfo(String username) {
        return "user " + (username != null ? "\"" + username + "\"" : "<anonymous>");
    }

    private String info(HttpSession session) {
        return "session" + (session != null ? " " + session.getId() + " (username=" + this.username(session) + ")" : ": null");
    }

    private String info(HttpServletRequest request) {
        StringBuilder info = new StringBuilder();
        info.append("    " + request.getMethod() + " " + request.getRequestURI() + "\n");
        Enumeration e1 = request.getHeaderNames();
        while (e1.hasMoreElements()) {
            String name = (String)e1.nextElement();
            info.append("\n    " + name + ":");
            Enumeration e2 = request.getHeaders(name);
            while (e2.hasMoreElements()) {
                String header = (String)e2.nextElement();
                info.append(" " + header);
            }
        }
        return info.toString();
    }

    static {
        logger.info("Security settings:\n  dmx.security.anonymous_read_allowed = " + accessFilter.dumpReadSetting() + "\n  dmx.security.anonymous_write_allowed = " + accessFilter.dumpWriteSetting() + "\n  dmx.security.subnet_filter = " + SUBNET_FILTER + "\n  dmx.security.new_accounts_are_enabled = " + NEW_ACCOUNTS_ARE_ENABLED);
    }
}

