/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketHandler;
import systems.dmx.core.impl.WebSocketConnection;
import systems.dmx.core.impl.WebSocketConnectionPool;
import systems.dmx.core.service.Cookies;
import systems.dmx.core.service.CoreService;
import systems.dmx.core.service.websocket.WebSocketService;
import systems.dmx.core.util.JavaUtils;

public class WebSocketServiceImpl
implements WebSocketService {
    private static final int WEBSOCKETS_PORT = Integer.getInteger("dmx.websockets.port", 8081);
    private static final String WEBSOCKETS_URL = System.getProperty("dmx.websockets.url", "ws://localhost:8081");
    private WebSocketsServer server;
    private WebSocketConnectionPool pool;
    private SendMessageWorker worker;
    private CoreService dmx;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    WebSocketServiceImpl(CoreService dmx) {
        this.dmx = dmx;
    }

    @Override
    public void messageToAll(String pluginUri, String message) {
        this.broadcast(pluginUri, message, null);
    }

    @Override
    public void messageToAllButOne(HttpServletRequest request, String pluginUri, String message) {
        if (request == null) {
            throw new IllegalArgumentException("request is null");
        }
        this.broadcast(pluginUri, message, this.getConnection(pluginUri));
    }

    @Override
    public void messageToOne(HttpServletRequest request, String pluginUri, String message) {
        if (request == null) {
            throw new IllegalArgumentException("request is null");
        }
        WebSocketConnection connection = this.getConnection(pluginUri);
        if (connection != null) {
            this.queueMessage(connection, message);
        }
    }

    @Override
    public String getWebSocketURL() {
        return WEBSOCKETS_URL;
    }

    public void start() {
        try {
            this.logger.info("##### Starting Jetty WebSocket server");
            this.server = new WebSocketsServer(WEBSOCKETS_PORT);
            this.pool = new WebSocketConnectionPool();
            this.worker = new SendMessageWorker();
            this.worker.start();
            this.server.start();
            this.logger.info("Jetty WebSocket server started successfully");
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Starting Jetty WebSocket server failed", e);
        }
    }

    void stop() {
        try {
            if (this.server != null) {
                this.logger.info("### Stopping Jetty WebSocket server");
                this.worker.interrupt();
                this.server.stop();
            } else {
                this.logger.info("Stopping Jetty WebSocket server SKIPPED -- not yet started");
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Stopping Jetty WebSocket server failed", e);
        }
    }

    private WebSocketConnection getConnection(String pluginUri) {
        String clientId = this.clientId();
        return clientId != null ? this.pool.getConnection(pluginUri, clientId) : null;
    }

    private void broadcast(String pluginUri, String message, WebSocketConnection exclude) {
        Collection<WebSocketConnection> connections = this.pool.getConnections(pluginUri);
        if (connections != null) {
            for (WebSocketConnection connection : connections) {
                if (connection == exclude) continue;
                this.queueMessage(connection, message);
            }
        }
    }

    private void queueMessage(WebSocketConnection connection, String message) {
        this.worker.queueMessage(connection, message);
    }

    private String clientId() {
        Cookies cookies = Cookies.get();
        return cookies.has("dmx_client_id") ? cookies.get("dmx_client_id") : null;
    }

    private static class QueuedMessage {
        private WebSocketConnection connection;
        private String message;

        private QueuedMessage(WebSocketConnection connection, String message) {
            this.connection = connection;
            this.message = message;
        }
    }

    private class SendMessageWorker
    extends Thread {
        private BlockingQueue<QueuedMessage> messages = new LinkedBlockingQueue<QueuedMessage>();

        private SendMessageWorker() {
            this.setPriority(1);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    QueuedMessage message = this.messages.take();
                    SendMessageWorker.yield();
                    message.connection.sendMessage(message.message);
                }
            }
            catch (InterruptedException e) {
                WebSocketServiceImpl.this.logger.info("### Terminating SendMessageWorker thread");
            }
            catch (Exception e) {
                WebSocketServiceImpl.this.logger.log(Level.WARNING, "An exception occurred in the SendMessageWorker thread -- terminating:", e);
            }
        }

        private void queueMessage(WebSocketConnection connection, String message) {
            try {
                this.messages.put(new QueuedMessage(connection, message));
            }
            catch (InterruptedException e) {
                WebSocketServiceImpl.this.logger.log(Level.WARNING, "Queueing a message failed:", e);
            }
        }
    }

    private class WebSocketsServer
    extends Server {
        private WebSocketsServer(int port) {
            SelectChannelConnector connector = new SelectChannelConnector();
            connector.setPort(port);
            this.addConnector((Connector)connector);
            this.setHandler((Handler)new WebSocketHandler(){

                public WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
                    try {
                        WebSocketsServer.this.checkProtocol(protocol);
                        return new WebSocketConnection(protocol, WebSocketsServer.this.clientId(request), WebSocketServiceImpl.this.pool, WebSocketServiceImpl.this.dmx);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Opening a WebSocket connection " + (protocol != null ? "for plugin \"" + protocol + "\" " : "") + "failed", e);
                    }
                }
            });
        }

        private void checkProtocol(String pluginUri) {
            if (pluginUri == null) {
                throw new RuntimeException("A plugin URI is missing in the WebSocket handshake -- Add your plugin's URI as the 2nd argument to the JavaScript WebSocket constructor");
            }
            WebSocketServiceImpl.this.dmx.getPlugin(pluginUri);
        }

        private String clientId(HttpServletRequest request) {
            String clientId = JavaUtils.cookieValue(request, "dmx_client_id");
            if (clientId == null) {
                throw new RuntimeException("Missing \"dmx_client_id\" cookie");
            }
            return clientId;
        }
    }
}

