/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import systems.dmx.core.impl.CoreEvent;
import systems.dmx.core.impl.CoreServiceImpl;
import systems.dmx.core.impl.PluginImpl;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.PluginInfo;

class PluginManager {
    private Map<String, PluginImpl> activatedPlugins = new HashMap<String, PluginImpl>();
    private CoreServiceImpl dmx;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    PluginManager(CoreServiceImpl dmx) {
        this.dmx = dmx;
    }

    synchronized void activatePlugin(PluginImpl plugin) {
        if (!this._isPluginActivated(plugin.getUri())) {
            plugin.activate();
            this.addToActivatedPlugins(plugin);
            if (this.checkAllPluginsActivated()) {
                this.logger.info("########## All DMX plugins active ##########");
                this.dmx.fireEvent(CoreEvent.ALL_PLUGINS_ACTIVE, new Object[0]);
            }
        } else {
            this.logger.info("Activating " + plugin + " SKIPPED -- already activated");
        }
    }

    synchronized void deactivatePlugin(PluginImpl plugin) {
        String pluginUri = plugin.getUri();
        if (this._isPluginActivated(pluginUri)) {
            plugin.deactivate();
            this.removeFromActivatedPlugins(pluginUri);
        } else {
            this.logger.info("Deactivation of " + plugin + " SKIPPED -- it was not successfully activated");
        }
    }

    synchronized boolean isPluginActivated(String pluginUri) {
        return this._isPluginActivated(pluginUri);
    }

    synchronized PluginImpl getPlugin(String pluginUri) {
        PluginImpl plugin = this.activatedPlugins.get(pluginUri);
        if (plugin == null) {
            throw new RuntimeException("Plugin \"" + pluginUri + "\" is not installed/activated");
        }
        return plugin;
    }

    synchronized List<PluginInfo> getPluginInfo() {
        ArrayList<PluginInfo> info = new ArrayList<PluginInfo>();
        for (PluginImpl plugin : this.activatedPlugins.values()) {
            info.add(plugin.getInfo());
        }
        return info;
    }

    private boolean checkAllPluginsActivated() {
        Bundle[] bundles = this.dmx.bundleContext.getBundles();
        int plugins = 0;
        int activated = 0;
        for (Bundle bundle : bundles) {
            if (!this.isDMXPlugin(bundle)) continue;
            ++plugins;
            if (!this._isPluginActivated(bundle.getSymbolicName())) continue;
            ++activated;
        }
        this.logger.info("### Bundles total: " + bundles.length + ", DMX plugins: " + plugins + ", Activated: " + activated);
        return plugins == activated;
    }

    private boolean isDMXPlugin(Bundle bundle) {
        try {
            String activatorClassName = (String)bundle.getHeaders().get("Bundle-Activator");
            if (activatorClassName != null) {
                Class activatorClass = bundle.loadClass(activatorClassName);
                return PluginActivator.class.isAssignableFrom(activatorClass);
            }
            return false;
        }
        catch (Throwable e) {
            throw new RuntimeException("DMX plugin detection failed for bundle " + bundle, e);
        }
    }

    private void addToActivatedPlugins(PluginImpl plugin) {
        this.activatedPlugins.put(plugin.getUri(), plugin);
    }

    private void removeFromActivatedPlugins(String pluginUri) {
        if (this.activatedPlugins.remove(pluginUri) == null) {
            throw new RuntimeException("Removing plugin \"" + pluginUri + "\" from pool of activated plugins failed: not found in " + this.activatedPlugins);
        }
    }

    private boolean _isPluginActivated(String pluginUri) {
        return this.activatedPlugins.get(pluginUri) != null;
    }
}

