/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.workspaces;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.config.ConfigDefinition;
import systems.dmx.config.ConfigModificationRole;
import systems.dmx.config.ConfigService;
import systems.dmx.config.ConfigTarget;
import systems.dmx.core.Assoc;
import systems.dmx.core.AssocType;
import systems.dmx.core.CompDef;
import systems.dmx.core.DMXObject;
import systems.dmx.core.DMXType;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Cookies;
import systems.dmx.core.service.DirectivesResponse;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.service.accesscontrol.SharingMode;
import systems.dmx.core.service.event.IntroduceAssocType;
import systems.dmx.core.service.event.IntroduceTopicType;
import systems.dmx.core.service.event.PostCreateAssoc;
import systems.dmx.core.service.event.PostCreateTopic;
import systems.dmx.core.service.event.PreDeleteTopic;
import systems.dmx.facets.FacetsService;
import systems.dmx.topicmaps.TopicmapsService;
import systems.dmx.workspaces.WorkspacesService;

@Path(value="/workspaces")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class WorkspacesPlugin
extends PluginActivator
implements WorkspacesService,
IntroduceTopicType,
IntroduceAssocType,
PostCreateTopic,
PostCreateAssoc,
PreDeleteTopic {
    private static final boolean SHARING_MODE_PRIVATE_ENABLED = Boolean.parseBoolean(System.getProperty("dmx.workspaces.private.enabled", "true"));
    private static final boolean SHARING_MODE_CONFIDENTIAL_ENABLED = Boolean.parseBoolean(System.getProperty("dmx.workspaces.confidential.enabled", "true"));
    private static final boolean SHARING_MODE_COLLABORATIVE_ENABLED = Boolean.parseBoolean(System.getProperty("dmx.workspaces.collaborative.enabled", "true"));
    private static final boolean SHARING_MODE_PUBLIC_ENABLED = Boolean.parseBoolean(System.getProperty("dmx.workspaces.public.enabled", "true"));
    private static final boolean SHARING_MODE_COMMON_ENABLED = Boolean.parseBoolean(System.getProperty("dmx.workspaces.common.enabled", "true"));
    @Inject
    private FacetsService facetsService;
    @Inject
    private TopicmapsService topicmapsService;
    @Inject
    private ConfigService configService;
    @Context
    private HttpServletRequest request;
    private Messenger me = new Messenger("systems.dmx.webclient");
    private Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    @POST
    @Transactional
    public Topic createWorkspace(final @QueryParam(value="name") String name, final @QueryParam(value="uri") String uri, final @QueryParam(value="sharing_mode_uri") SharingMode sharingMode) {
        final String operation = "Creating workspace \"" + name + "\" ";
        final String info = "(uri=" + uri + ", sharingMode=" + sharingMode + ")";
        try {
            Topic workspace = (Topic)this.dmx.getPrivilegedAccess().runWithoutWorkspaceAssignment((Callable)new Callable<Topic>(){

                @Override
                public Topic call() {
                    WorkspacesPlugin.this.logger.info(operation + info);
                    Topic workspace = WorkspacesPlugin.this.dmx.createTopic(WorkspacesPlugin.this.mf.newTopicModel(uri, "dmx.workspaces.workspace", WorkspacesPlugin.this.mf.newChildTopicsModel().set("dmx.workspaces.workspace_name", (Object)name).setRef("dmx.workspaces.sharing_mode", sharingMode.getUri())));
                    Topic topicmap = WorkspacesPlugin.this.topicmapsService.createTopicmap("untitled", "dmx.topicmaps.topicmap", null);
                    WorkspacesPlugin.this.dmx.getPrivilegedAccess().assignToWorkspace((DMXObject)topicmap, workspace.getId());
                    return workspace;
                }
            });
            this.me.newWorkspace(workspace);
            return workspace;
        }
        catch (Exception e) {
            throw new RuntimeException(operation + "failed " + info, e);
        }
    }

    @Override
    @GET
    @Path(value="/{uri}")
    public Topic getWorkspace(@PathParam(value="uri") String uri) {
        return this.dmx.getPrivilegedAccess().getWorkspace(uri);
    }

    @Override
    @GET
    @Path(value="/object/{id}")
    public Topic getAssignedWorkspace(@PathParam(value="id") long objectId) {
        long workspaceId = this.getAssignedWorkspaceId(objectId);
        if (workspaceId == -1L) {
            return null;
        }
        return this.dmx.getTopic(workspaceId);
    }

    @PUT
    @Path(value="/{workspace_id}/object/{object_id}")
    @Transactional
    public DirectivesResponse assignToWorkspace(@PathParam(value="object_id") long objectId, @PathParam(value="workspace_id") long workspaceId) {
        try {
            DMXObject object = this.dmx.getObject(objectId);
            this.checkAssignmentArgs(object, workspaceId);
            this.__assignToWorkspace(object, workspaceId);
            return new DirectivesResponse();
        }
        catch (Exception e) {
            throw new RuntimeException("Assigning object " + objectId + " to workspace " + workspaceId + " failed", e);
        }
    }

    @Override
    public void assignToWorkspace(DMXObject object, long workspaceId) {
        try {
            this.checkAssignmentArgs(object, workspaceId);
            this.__assignToWorkspace(object, workspaceId);
        }
        catch (Exception e) {
            throw new RuntimeException("Assigning " + this.info(object) + " to workspace " + workspaceId + " failed", e);
        }
    }

    @Override
    public void assignTypeToWorkspace(DMXType type, long workspaceId) {
        try {
            this.checkAssignmentArgs((DMXObject)type, workspaceId);
            this.__assignToWorkspace((DMXObject)type, workspaceId);
            for (Topic configTopic : type.getViewConfig().getConfigTopics()) {
                this.__assignToWorkspace((DMXObject)configTopic, workspaceId);
            }
            for (CompDef compDef : type.getCompDefs()) {
                this.__assignToWorkspace((DMXObject)compDef, workspaceId);
                for (Topic configTopic : compDef.getViewConfig().getConfigTopics()) {
                    this.__assignToWorkspace((DMXObject)configTopic, workspaceId);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Assigning " + this.info((DMXObject)type) + " to workspace " + workspaceId + " failed", e);
        }
    }

    @Override
    @GET
    @Path(value="/{id}/topics")
    public List<Topic> getAssignedTopics(@PathParam(value="id") long workspaceId) {
        return this.dmx.getTopicsByProperty("dmx.workspaces.workspace_id", (Object)workspaceId);
    }

    @Override
    @GET
    @Path(value="/{id}/assocs")
    public List<Assoc> getAssignedAssocs(@PathParam(value="id") long workspaceId) {
        return this.dmx.getAssocsByProperty("dmx.workspaces.workspace_id", (Object)workspaceId);
    }

    @Override
    @GET
    @Path(value="/{id}/topics/{topic_type_uri}")
    public List<Topic> getAssignedTopics(@PathParam(value="id") long workspaceId, @PathParam(value="topic_type_uri") String topicTypeUri) {
        List topics = this.dmx.getTopicsByType(topicTypeUri);
        this.applyWorkspaceFilter(topics.iterator(), workspaceId);
        return topics;
    }

    @Override
    @GET
    @Path(value="/{id}/assocs/{assoc_type_uri}")
    public List<Assoc> getAssignedAssocs(@PathParam(value="id") long workspaceId, @PathParam(value="assoc_type_uri") String assocTypeUri) {
        List assocs = this.dmx.getAssocsByType(assocTypeUri);
        this.applyWorkspaceFilter(assocs.iterator(), workspaceId);
        return assocs;
    }

    public void preInstall() {
        this.configService.registerConfigDefinition(new ConfigDefinition(ConfigTarget.TYPE_INSTANCES, "dmx.accesscontrol.username", this.mf.newTopicModel("dmx.workspaces.enabled_sharing_modes", this.mf.newChildTopicsModel().set("dmx.workspaces.private.enabled", (Object)SHARING_MODE_PRIVATE_ENABLED).set("dmx.workspaces.confidential.enabled", (Object)SHARING_MODE_CONFIDENTIAL_ENABLED).set("dmx.workspaces.collaborative.enabled", (Object)SHARING_MODE_COLLABORATIVE_ENABLED).set("dmx.workspaces.public.enabled", (Object)SHARING_MODE_PUBLIC_ENABLED).set("dmx.workspaces.common.enabled", (Object)SHARING_MODE_COMMON_ENABLED)), ConfigModificationRole.ADMIN));
    }

    public void shutdown() {
        if (this.configService != null) {
            this.configService.unregisterConfigDefinition("dmx.workspaces.enabled_sharing_modes");
        }
    }

    public void introduceTopicType(TopicType topicType) {
        long workspaceId = this.workspaceIdForType((DMXType)topicType);
        if (workspaceId == -1L) {
            return;
        }
        this.assignTypeToWorkspace((DMXType)topicType, workspaceId);
    }

    public void introduceAssocType(AssocType assocType) {
        long workspaceId = this.workspaceIdForType((DMXType)assocType);
        if (workspaceId == -1L) {
            return;
        }
        this.assignTypeToWorkspace((DMXType)assocType, workspaceId);
    }

    public void postCreateTopic(Topic topic) {
        if (this.workspaceAssignmentIsSuppressed((DMXObject)topic)) {
            return;
        }
        if (this.isWorkspacePart(topic)) {
            return;
        }
        long workspaceId = this.workspaceId();
        if (workspaceId == -1L) {
            return;
        }
        this._assignToWorkspace((DMXObject)topic, workspaceId, false);
    }

    public void postCreateAssoc(Assoc assoc) {
        if (this.workspaceAssignmentIsSuppressed((DMXObject)assoc)) {
            return;
        }
        if (this.isWorkspaceAssignment(assoc)) {
            return;
        }
        long workspaceId = this.workspaceId();
        if (workspaceId == -1L) {
            return;
        }
        this._assignToWorkspace((DMXObject)assoc, workspaceId, false);
    }

    public void preDeleteTopic(Topic topic) {
        if (topic.getTypeUri().equals("dmx.workspaces.workspace")) {
            long workspaceId = topic.getId();
            this.deleteWorkspaceContent(workspaceId);
        }
    }

    private long workspaceId() {
        Cookies cookies = Cookies.get();
        if (!cookies.has("dmx_workspace_id")) {
            return -1L;
        }
        return cookies.getLong("dmx_workspace_id");
    }

    private long workspaceIdForType(DMXType type) {
        return this.workspaceId() == -1L && this.isDMXStandardType(type) ? this.getDMXWorkspaceId() : -1L;
    }

    private long getAssignedWorkspaceId(long objectId) {
        return this.dmx.getPrivilegedAccess().getAssignedWorkspaceId(objectId);
    }

    private void _assignToWorkspace(DMXObject object, long workspaceId, boolean checkObject) {
        try {
            this.checkAssignmentArgs((DMXObject)(checkObject ? object : null), workspaceId);
            this.__assignToWorkspace(object, workspaceId);
        }
        catch (Exception e) {
            throw new RuntimeException("Assigning " + this.info(object) + " to workspace " + workspaceId + " failed", e);
        }
    }

    private void __assignToWorkspace(DMXObject object, long workspaceId) {
        this.facetsService.updateFacet(object, "dmx.workspaces.workspace_facet", this.mf.newFacetValueModel("dmx.workspaces.workspace#dmx.workspaces.workspace_assignment").setRef(workspaceId));
        object.setProperty("dmx.workspaces.workspace_id", (Object)workspaceId, true);
    }

    private void checkAssignmentArgs(DMXObject object, long workspaceId) {
        Topic workspace = this.dmx.getTopic(workspaceId);
        String typeUri = workspace.getTypeUri();
        if (!typeUri.equals("dmx.workspaces.workspace")) {
            throw new IllegalArgumentException("Topic " + workspaceId + " is not a workspace (but a \"" + typeUri + "\")");
        }
        workspace.checkWriteAccess();
        if (object != null) {
            object.checkWriteAccess();
        }
    }

    private void deleteWorkspaceContent(long workspaceId) {
        try {
            String typeUri;
            for (Topic topicType : this.getAssignedTopics(workspaceId, "dmx.core.topic_type")) {
                typeUri = topicType.getUri();
                for (Topic topic : this.dmx.getTopicsByType(typeUri)) {
                    topic.delete();
                }
                this.dmx.getTopicType(typeUri).delete();
            }
            for (Topic assocType : this.getAssignedTopics(workspaceId, "dmx.core.assoc_type")) {
                typeUri = assocType.getUri();
                for (Assoc assoc : this.dmx.getAssocsByType(typeUri)) {
                    assoc.delete();
                }
                this.dmx.getAssocType(typeUri).delete();
            }
            for (Topic topic : this.getAssignedTopics(workspaceId)) {
                topic.delete();
            }
            for (Assoc assoc : this.getAssignedAssocs(workspaceId)) {
                assoc.delete();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Deleting content of workspace " + workspaceId + " failed", e);
        }
    }

    private boolean isDMXStandardType(DMXType type) {
        return type.getUri().startsWith("dmx.");
    }

    private boolean isWorkspacePart(Topic topic) {
        String typeUri = topic.getTypeUri();
        return typeUri.equals("dmx.workspaces.workspace_name") || typeUri.equals("dmx.workspaces.workspace_description");
    }

    private boolean isWorkspaceAssignment(Assoc assoc) {
        return assoc.getTypeUri().equals("dmx.workspaces.workspace_assignment");
    }

    private long getDMXWorkspaceId() {
        return this.dmx.getPrivilegedAccess().getDMXWorkspaceId();
    }

    private void applyWorkspaceFilter(Iterator<? extends DMXObject> objects, long workspaceId) {
        while (objects.hasNext()) {
            DMXObject object = objects.next();
            if (this.getAssignedWorkspaceId(object.getId()) == workspaceId) continue;
            objects.remove();
        }
    }

    private boolean workspaceAssignmentIsSuppressed(DMXObject object) {
        boolean suppressed = this.dmx.getPrivilegedAccess().workspaceAssignmentIsSuppressed();
        if (suppressed) {
            this.logger.fine("Standard workspace assignment for " + this.info(object) + " SUPPRESSED");
        }
        return suppressed;
    }

    private String info(DMXObject object) {
        if (object instanceof TopicType) {
            return "topic type \"" + object.getUri() + "\" (id=" + object.getId() + ")";
        }
        if (object instanceof AssocType) {
            return "association type \"" + object.getUri() + "\" (id=" + object.getId() + ")";
        }
        if (object instanceof Topic) {
            return "topic " + object.getId() + " (typeUri=\"" + object.getTypeUri() + "\", uri=\"" + object.getUri() + "\")";
        }
        if (object instanceof Assoc) {
            return "association " + object.getId() + " (typeUri=\"" + object.getTypeUri() + "\")";
        }
        throw new RuntimeException("Unexpected object: " + object);
    }

    private class Messenger {
        private String pluginUri;

        private Messenger(String pluginUri) {
            this.pluginUri = pluginUri;
        }

        private void newWorkspace(Topic workspace) {
            try {
                this.messageToAllButOne(new JSONObject().put("type", (Object)"newWorkspace").put("args", (Object)new JSONObject().put("workspace", (Object)workspace.toJSON())));
            }
            catch (Exception e) {
                WorkspacesPlugin.this.logger.log(Level.WARNING, "Error while sending a \"newWorkspace\" message:", e);
            }
        }

        private void messageToAllButOne(JSONObject message) {
            WorkspacesPlugin.this.dmx.getWebSocketService().messageToAllButOne(WorkspacesPlugin.this.request, this.pluginUri, message.toString());
        }
    }
}

