/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.impl.WebSocketConnectionImpl;
import systems.dmx.core.impl.WebSocketConnectionPool;
import systems.dmx.core.impl.WebSocketServlet;
import systems.dmx.core.osgi.CoreActivator;
import systems.dmx.core.service.Cookies;
import systems.dmx.core.service.CoreService;
import systems.dmx.core.service.accesscontrol.Operation;
import systems.dmx.core.service.websocket.WebSocketConnection;
import systems.dmx.core.service.websocket.WebSocketService;

public class WebSocketServiceImpl
implements WebSocketService {
    private static final String WEBSOCKETS_URL = System.getProperty("dmx.websockets.url", "ws://localhost:8081");
    private WebSocketConnectionPool pool;
    private SendMessageWorker worker;
    private CoreService dmx;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    WebSocketServiceImpl(CoreService dmx) {
        this.dmx = dmx;
    }

    @Override
    public void sendToOrigin(String message) {
        WebSocketConnectionImpl connection = this.getConnection();
        if (connection != null) {
            this.queueMessage(message, connection);
        }
    }

    @Override
    public void sendToAll(String message) {
        this.queueMessage(message, (WebSocketConnection conn) -> true);
    }

    @Override
    public void sendToAllButOrigin(String message) {
        this.queueMessage(message, this.isOrigin().negate());
    }

    @Override
    public void sendToReadAllowed(String message, long objectId) {
        this.queueMessage(message, this.isOrigin().negate().and(this.isReadAllowed(objectId)));
    }

    @Override
    public void sendToSome(String message, Predicate<WebSocketConnection> connectionFilter) {
        this.queueMessage(message, connectionFilter);
    }

    @Override
    public String getWebSocketURL() {
        return WEBSOCKETS_URL;
    }

    public void start() {
        try {
            this.logger.info("##### Starting WebSocket service");
            this.pool = new WebSocketConnectionPool();
            this.worker = new SendMessageWorker();
            this.worker.start();
            CoreActivator.getHttpService().registerServlet("/websocket", (Servlet)new WebSocketServlet(this.pool, this.dmx), null, null);
            this.logger.info("WebSocket service started successfully");
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Starting WebSocket service failed", e);
        }
    }

    void stop() {
        try {
            if (this.pool != null) {
                this.logger.info("### Stopping WebSocket service (httpService=" + CoreActivator.getHttpService() + ")");
                this.worker.interrupt();
                this.pool.close();
            } else {
                this.logger.info("Stopping WebSocket service SKIPPED -- it was not successfully started");
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Stopping WebSocket service failed", e);
        }
    }

    private void queueMessage(String message, WebSocketConnectionImpl connection) {
        this.worker.queueMessage(message, connection);
    }

    private void queueMessage(String message, Predicate<WebSocketConnection> connectionFilter) {
        this.worker.queueMessage(message, connectionFilter);
    }

    private Predicate<WebSocketConnection> isOrigin() {
        String clientId = this.clientId();
        return conn -> {
            boolean isOrigin = conn.getClientId().equals(clientId);
            this.logger.info(conn.getClientId() + " " + conn.getUsername() + " (isOrigin) -> " + isOrigin);
            return isOrigin;
        };
    }

    private Predicate<WebSocketConnection> isReadAllowed(long objectId) {
        return conn -> {
            boolean isReadAllowed = this.dmx.getPrivilegedAccess().hasPermission(conn.getUsername(), Operation.READ, objectId);
            this.logger.info(conn.getClientId() + " " + conn.getUsername() + " (isReadAllowed) -> " + isReadAllowed);
            return isReadAllowed;
        };
    }

    private WebSocketConnectionImpl getConnection() {
        String clientId = this.clientId();
        return clientId != null ? this.pool.getConnection(clientId) : null;
    }

    private String clientId() {
        Cookies cookies = Cookies.get();
        return cookies.has("dmx_client_id") ? cookies.get("dmx_client_id") : null;
    }

    private class MessageTask {
        private String message;
        private WebSocketConnectionImpl connection;
        private Predicate<WebSocketConnection> connectionFilter;

        private MessageTask(String message, WebSocketConnectionImpl connection) {
            this.message = message;
            this.connection = connection;
        }

        private MessageTask(String message, Predicate<WebSocketConnection> connectionFilter) {
            this.message = message;
            this.connectionFilter = connectionFilter;
        }

        private void sendMessage() {
            if (this.connection != null) {
                this._sendMessage(this.connection);
            } else {
                WebSocketServiceImpl.this.pool.getAllConnections().stream().filter(this.connectionFilter).forEach(conn -> this._sendMessage((WebSocketConnectionImpl)conn));
            }
        }

        private void _sendMessage(WebSocketConnectionImpl conn) {
            conn.sendMessage(this.message);
        }

        private String getMessageType() {
            try {
                return new JSONObject(this.message).getString("type");
            }
            catch (Exception e) {
                throw new RuntimeException("JSON parsing error", e);
            }
        }
    }

    private class SendMessageWorker
    extends Thread {
        private BlockingQueue<MessageTask> messageQueue = new LinkedBlockingQueue<MessageTask>();

        private SendMessageWorker() {
            this.setPriority(1);
        }

        @Override
        public void run() {
            boolean stopped = false;
            while (!stopped) {
                MessageTask task = null;
                try {
                    task = this.messageQueue.take();
                    task.sendMessage();
                    SendMessageWorker.yield();
                }
                catch (InterruptedException e) {
                    stopped = true;
                }
                catch (Exception e) {
                    WebSocketServiceImpl.this.logger.log(Level.SEVERE, "An error occurred in the SendMessageWorker while processing a \"" + task.getMessageType() + "\" task (aborting this task):", e);
                }
            }
            WebSocketServiceImpl.this.logger.info("### Terminating SendMessageWorker");
        }

        private void queueMessage(String message, WebSocketConnectionImpl connection) {
            try {
                this.messageQueue.put(new MessageTask(message, connection));
            }
            catch (InterruptedException e) {
                WebSocketServiceImpl.this.logger.log(Level.WARNING, "Queueing a message failed:", e);
            }
        }

        private void queueMessage(String message, Predicate<WebSocketConnection> connectionFilter) {
            try {
                this.messageQueue.put(new MessageTask(message, connectionFilter));
            }
            catch (InterruptedException e) {
                WebSocketServiceImpl.this.logger.log(Level.WARNING, "Queueing a message failed:", e);
            }
        }
    }
}

