/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.config.ConfigDefinition;
import systems.dmx.config.ConfigDefinitions;
import systems.dmx.config.ConfigModificationRole;
import systems.dmx.config.ConfigService;
import systems.dmx.config.ConfigTarget;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.accesscontrol.PrivilegedAccess;
import systems.dmx.core.service.event.PostCreateTopic;

@Path(value="/config")
@Produces(value={"application/json"})
public class ConfigPlugin
extends PluginActivator
implements ConfigService,
PostCreateTopic {
    private static String ASSOC_TYPE_CONFIGURATION = "dmx.config.configuration";
    private static String ROLE_TYPE_CONFIGURABLE = "dmx.config.configurable";
    private Map<String, List<ConfigDefinition>> registry = new HashMap<String, List<ConfigDefinition>>();
    @Context
    private HttpServletRequest request;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    @GET
    @Path(value="/{config_type_uri}/topic/{topic_id}")
    public RelatedTopic getConfigTopic(@PathParam(value="config_type_uri") String configTypeUri, @PathParam(value="topic_id") long topicId) {
        return this._getConfigTopic(configTypeUri, topicId);
    }

    @Override
    public void createConfigTopic(String configTypeUri, Topic topic) {
        this._createConfigTopic(this.getApplicableConfigDefinition(topic, configTypeUri), topic);
    }

    @Override
    public void registerConfigDefinition(ConfigDefinition configDef) {
        try {
            if (this.isRegistered(configDef)) {
                throw new RuntimeException("A definition for config type \"" + configDef.getConfigTypeUri() + "\" is already registered");
            }
            String hashKey = configDef.getHashKey();
            List<ConfigDefinition> configDefs = this.lookupConfigDefinitions(hashKey);
            if (configDefs == null) {
                configDefs = new ArrayList<ConfigDefinition>();
                this.registry.put(hashKey, configDefs);
            }
            configDefs.add(configDef);
        }
        catch (Exception e) {
            throw new RuntimeException("Registering a config definition failed", e);
        }
    }

    @Override
    public void unregisterConfigDefinition(String configTypeUri) {
        try {
            for (List<ConfigDefinition> configDefs : this.registry.values()) {
                ConfigDefinition configDef = this.findByConfigTypeUri(configDefs, configTypeUri);
                if (configDef == null) continue;
                if (!configDefs.remove(configDef)) {
                    throw new RuntimeException("Config definition could not be removed from registry");
                }
                return;
            }
            throw new RuntimeException("No such config definition registered");
        }
        catch (Exception e) {
            throw new RuntimeException("Unregistering definition for config type \"" + configTypeUri + "\" failed", e);
        }
    }

    @GET
    public ConfigDefinitions getConfigDefinitions() {
        try {
            JSONObject json = new JSONObject();
            PrivilegedAccess pa = this.dmx.getPrivilegedAccess();
            for (String configurableUri : this.registry.keySet()) {
                JSONArray array = new JSONArray();
                for (ConfigDefinition configDef : this.lookupConfigDefinitions(configurableUri)) {
                    long workspaceId;
                    String username = pa.getUsername(this.request);
                    if (!pa.hasReadPermission(username, workspaceId = this.workspaceId(configDef.getConfigModificationRole()))) continue;
                    array.put((Object)configDef.getConfigTypeUri());
                }
                json.put(configurableUri, (Object)array);
            }
            return new ConfigDefinitions(json);
        }
        catch (Exception e) {
            throw new RuntimeException("Retrieving the registered config definitions failed", e);
        }
    }

    public void postCreateTopic(Topic topic) {
        for (ConfigDefinition configDef : this.getApplicableConfigDefinitions(topic)) {
            this._createConfigTopic(configDef, topic);
        }
    }

    private RelatedTopic _getConfigTopic(String configTypeUri, long topicId) {
        return this.dmx.getPrivilegedAccess().getConfigTopic(configTypeUri, topicId);
    }

    private RelatedTopic _createConfigTopic(final ConfigDefinition configDef, final Topic topic) {
        final String configTypeUri = configDef.getConfigTypeUri();
        try {
            this.logger.info("### Creating config topic of type \"" + configTypeUri + "\" for topic " + topic.getId());
            final PrivilegedAccess pa = this.dmx.getPrivilegedAccess();
            return (RelatedTopic)pa.runWithoutWorkspaceAssignment((Callable)new Callable<RelatedTopic>(){

                @Override
                public RelatedTopic call() {
                    Topic configTopic = ConfigPlugin.this.dmx.createTopic(configDef.getConfigValue(topic));
                    ConfigPlugin.this.dmx.createAssoc(ConfigPlugin.this.mf.newAssocModel(ASSOC_TYPE_CONFIGURATION, (PlayerModel)ConfigPlugin.this.mf.newTopicPlayerModel(topic.getId(), ROLE_TYPE_CONFIGURABLE), (PlayerModel)ConfigPlugin.this.mf.newTopicPlayerModel(configTopic.getId(), "dmx.core.default")));
                    pa.assignToWorkspace((DMXObject)configTopic, ConfigPlugin.this.workspaceId(configDef.getConfigModificationRole()));
                    return ConfigPlugin.this._getConfigTopic(configTypeUri, topic.getId());
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Creating config topic of type \"" + configTypeUri + "\" for topic " + topic.getId() + " failed", e);
        }
    }

    private long workspaceId(ConfigModificationRole role) {
        PrivilegedAccess pa = this.dmx.getPrivilegedAccess();
        switch (role) {
            case ADMIN: {
                return pa.getAdminWorkspaceId();
            }
            case SYSTEM: {
                return pa.getSystemWorkspaceId();
            }
        }
        throw new RuntimeException("Modification role \"" + (Object)((Object)role) + "\" not yet implemented");
    }

    private List<ConfigDefinition> getApplicableConfigDefinitions(Topic topic) {
        ArrayList configDefs1 = this.lookupConfigDefinitions(ConfigTarget.SINGLETON.hashKey(topic));
        List<ConfigDefinition> configDefs2 = this.lookupConfigDefinitions(ConfigTarget.TYPE_INSTANCES.hashKey(topic));
        if (configDefs1 != null && configDefs2 != null) {
            ArrayList<ConfigDefinition> configDefs = new ArrayList<ConfigDefinition>();
            configDefs.addAll(configDefs1);
            configDefs.addAll(configDefs2);
            return configDefs;
        }
        return configDefs1 != null ? configDefs1 : (configDefs2 != null ? configDefs2 : new ArrayList());
    }

    private ConfigDefinition getApplicableConfigDefinition(Topic topic, String configTypeUri) {
        List<ConfigDefinition> configDefs = this.getApplicableConfigDefinitions(topic);
        if (configDefs.size() == 0) {
            throw new RuntimeException("None of the registered config definitions are applicable to " + this.info(topic));
        }
        ConfigDefinition configDef = this.findByConfigTypeUri(configDefs, configTypeUri);
        if (configDef == null) {
            throw new RuntimeException("For " + this.info(topic) + " no config definition for type \"" + configTypeUri + "\" registered");
        }
        return configDef;
    }

    private boolean isRegistered(ConfigDefinition configDef) {
        for (List<ConfigDefinition> configDefs : this.registry.values()) {
            if (!configDefs.contains(configDef)) continue;
            return true;
        }
        return false;
    }

    private ConfigDefinition findByConfigTypeUri(List<ConfigDefinition> configDefs, String configTypeUri) {
        for (ConfigDefinition configDef : configDefs) {
            if (!configDef.getConfigTypeUri().equals(configTypeUri)) continue;
            return configDef;
        }
        return null;
    }

    private List<ConfigDefinition> lookupConfigDefinitions(String hashKey) {
        return this.registry.get(hashKey);
    }

    private String info(Topic topic) {
        return "topic " + topic.getId() + " (value=\"" + topic.getSimpleValue() + "\", typeUri=\"" + topic.getTypeUri() + "\", uri=\"" + topic.getUri() + "\")";
    }
}

